# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreOauth2CredentialProviderArgs', 'AgentcoreOauth2CredentialProvider']

@pulumi.input_type
class AgentcoreOauth2CredentialProviderArgs:
    def __init__(__self__, *,
                 credential_provider_vendor: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_provider_config: Optional[pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AgentcoreOauth2CredentialProvider resource.
        :param pulumi.Input[_builtins.str] credential_provider_vendor: Vendor of the OAuth2 credential provider. Valid values: `CustomOauth2`, `GithubOauth2`, `GoogleOauth2`, `Microsoft`, `SalesforceOauth2`, `SlackOauth2`.
        :param pulumi.Input[_builtins.str] name: Name of the OAuth2 credential provider.
        :param pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs'] oauth2_provider_config: OAuth2 provider configuration. Must contain exactly one provider type. See `oauth2_provider_config` below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "credential_provider_vendor", credential_provider_vendor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_provider_config is not None:
            pulumi.set(__self__, "oauth2_provider_config", oauth2_provider_config)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="credentialProviderVendor")
    def credential_provider_vendor(self) -> pulumi.Input[_builtins.str]:
        """
        Vendor of the OAuth2 credential provider. Valid values: `CustomOauth2`, `GithubOauth2`, `GoogleOauth2`, `Microsoft`, `SalesforceOauth2`, `SlackOauth2`.
        """
        return pulumi.get(self, "credential_provider_vendor")

    @credential_provider_vendor.setter
    def credential_provider_vendor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "credential_provider_vendor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the OAuth2 credential provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oauth2ProviderConfig")
    def oauth2_provider_config(self) -> Optional[pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs']]:
        """
        OAuth2 provider configuration. Must contain exactly one provider type. See `oauth2_provider_config` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "oauth2_provider_config")

    @oauth2_provider_config.setter
    def oauth2_provider_config(self, value: Optional[pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs']]):
        pulumi.set(self, "oauth2_provider_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AgentcoreOauth2CredentialProviderState:
    def __init__(__self__, *,
                 client_secret_arns: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreOauth2CredentialProviderClientSecretArnArgs']]]] = None,
                 credential_provider_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_provider_vendor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_provider_config: Optional[pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentcoreOauth2CredentialProvider resources.
        :param pulumi.Input[Sequence[pulumi.Input['AgentcoreOauth2CredentialProviderClientSecretArnArgs']]] client_secret_arns: ARN of the AWS Secrets Manager secret containing the client secret.
        :param pulumi.Input[_builtins.str] credential_provider_arn: ARN of the OAuth2 credential provider.
        :param pulumi.Input[_builtins.str] credential_provider_vendor: Vendor of the OAuth2 credential provider. Valid values: `CustomOauth2`, `GithubOauth2`, `GoogleOauth2`, `Microsoft`, `SalesforceOauth2`, `SlackOauth2`.
        :param pulumi.Input[_builtins.str] name: Name of the OAuth2 credential provider.
        :param pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs'] oauth2_provider_config: OAuth2 provider configuration. Must contain exactly one provider type. See `oauth2_provider_config` below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if client_secret_arns is not None:
            pulumi.set(__self__, "client_secret_arns", client_secret_arns)
        if credential_provider_arn is not None:
            pulumi.set(__self__, "credential_provider_arn", credential_provider_arn)
        if credential_provider_vendor is not None:
            pulumi.set(__self__, "credential_provider_vendor", credential_provider_vendor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_provider_config is not None:
            pulumi.set(__self__, "oauth2_provider_config", oauth2_provider_config)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="clientSecretArns")
    def client_secret_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreOauth2CredentialProviderClientSecretArnArgs']]]]:
        """
        ARN of the AWS Secrets Manager secret containing the client secret.
        """
        return pulumi.get(self, "client_secret_arns")

    @client_secret_arns.setter
    def client_secret_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreOauth2CredentialProviderClientSecretArnArgs']]]]):
        pulumi.set(self, "client_secret_arns", value)

    @_builtins.property
    @pulumi.getter(name="credentialProviderArn")
    def credential_provider_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the OAuth2 credential provider.
        """
        return pulumi.get(self, "credential_provider_arn")

    @credential_provider_arn.setter
    def credential_provider_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_provider_arn", value)

    @_builtins.property
    @pulumi.getter(name="credentialProviderVendor")
    def credential_provider_vendor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vendor of the OAuth2 credential provider. Valid values: `CustomOauth2`, `GithubOauth2`, `GoogleOauth2`, `Microsoft`, `SalesforceOauth2`, `SlackOauth2`.
        """
        return pulumi.get(self, "credential_provider_vendor")

    @credential_provider_vendor.setter
    def credential_provider_vendor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_provider_vendor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the OAuth2 credential provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oauth2ProviderConfig")
    def oauth2_provider_config(self) -> Optional[pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs']]:
        """
        OAuth2 provider configuration. Must contain exactly one provider type. See `oauth2_provider_config` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "oauth2_provider_config")

    @oauth2_provider_config.setter
    def oauth2_provider_config(self, value: Optional[pulumi.Input['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs']]):
        pulumi.set(self, "oauth2_provider_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:bedrock/agentcoreOauth2CredentialProvider:AgentcoreOauth2CredentialProvider")
class AgentcoreOauth2CredentialProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_provider_vendor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_provider_config: Optional[pulumi.Input[Union['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs', 'AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### GitHub OAuth Provider

        ```python
        import pulumi
        import pulumi_aws as aws

        github = aws.bedrock.AgentcoreOauth2CredentialProvider("github",
            name="github-oauth-provider",
            credential_provider_vendor="GithubOauth2",
            oauth2_provider_config={
                "github_oauth2_provider_config": {
                    "client_id": "your-github-client-id",
                    "client_secret": "your-github-client-secret",
                },
            })
        ```

        ### Custom OAuth Provider with Discovery URL

        ### Custom OAuth Provider with Authorization Server Metadata

        ```python
        import pulumi
        import pulumi_aws as aws

        keycloak = aws.bedrock.AgentcoreOauth2CredentialProvider("keycloak",
            name="keycloak-oauth-provider",
            credential_provider_vendor="CustomOauth2",
            oauth2_provider_config={
                "custom_oauth2_provider_config": {
                    "client_id_wo": "keycloak-client-id",
                    "client_secret_wo": "keycloak-client-secret",
                    "client_credentials_wo_version": 1,
                    "oauth_discovery": {
                        "authorization_server_metadata": {
                            "issuer": "https://auth.company.com/realms/production",
                            "authorization_endpoint": "https://auth.company.com/realms/production/protocol/openid-connect/auth",
                            "token_endpoint": "https://auth.company.com/realms/production/protocol/openid-connect/token",
                            "response_types": [
                                "code",
                                "id_token",
                            ],
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore OAuth2 Credential Provider using the provider name. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreOauth2CredentialProvider:AgentcoreOauth2CredentialProvider example oauth2-provider-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credential_provider_vendor: Vendor of the OAuth2 credential provider. Valid values: `CustomOauth2`, `GithubOauth2`, `GoogleOauth2`, `Microsoft`, `SalesforceOauth2`, `SlackOauth2`.
        :param pulumi.Input[_builtins.str] name: Name of the OAuth2 credential provider.
        :param pulumi.Input[Union['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs', 'AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgsDict']] oauth2_provider_config: OAuth2 provider configuration. Must contain exactly one provider type. See `oauth2_provider_config` below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentcoreOauth2CredentialProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### GitHub OAuth Provider

        ```python
        import pulumi
        import pulumi_aws as aws

        github = aws.bedrock.AgentcoreOauth2CredentialProvider("github",
            name="github-oauth-provider",
            credential_provider_vendor="GithubOauth2",
            oauth2_provider_config={
                "github_oauth2_provider_config": {
                    "client_id": "your-github-client-id",
                    "client_secret": "your-github-client-secret",
                },
            })
        ```

        ### Custom OAuth Provider with Discovery URL

        ### Custom OAuth Provider with Authorization Server Metadata

        ```python
        import pulumi
        import pulumi_aws as aws

        keycloak = aws.bedrock.AgentcoreOauth2CredentialProvider("keycloak",
            name="keycloak-oauth-provider",
            credential_provider_vendor="CustomOauth2",
            oauth2_provider_config={
                "custom_oauth2_provider_config": {
                    "client_id_wo": "keycloak-client-id",
                    "client_secret_wo": "keycloak-client-secret",
                    "client_credentials_wo_version": 1,
                    "oauth_discovery": {
                        "authorization_server_metadata": {
                            "issuer": "https://auth.company.com/realms/production",
                            "authorization_endpoint": "https://auth.company.com/realms/production/protocol/openid-connect/auth",
                            "token_endpoint": "https://auth.company.com/realms/production/protocol/openid-connect/token",
                            "response_types": [
                                "code",
                                "id_token",
                            ],
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore OAuth2 Credential Provider using the provider name. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreOauth2CredentialProvider:AgentcoreOauth2CredentialProvider example oauth2-provider-name
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreOauth2CredentialProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreOauth2CredentialProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_provider_vendor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_provider_config: Optional[pulumi.Input[Union['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs', 'AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreOauth2CredentialProviderArgs.__new__(AgentcoreOauth2CredentialProviderArgs)

            if credential_provider_vendor is None and not opts.urn:
                raise TypeError("Missing required property 'credential_provider_vendor'")
            __props__.__dict__["credential_provider_vendor"] = credential_provider_vendor
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth2_provider_config"] = oauth2_provider_config
            __props__.__dict__["region"] = region
            __props__.__dict__["client_secret_arns"] = None
            __props__.__dict__["credential_provider_arn"] = None
        super(AgentcoreOauth2CredentialProvider, __self__).__init__(
            'aws:bedrock/agentcoreOauth2CredentialProvider:AgentcoreOauth2CredentialProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_secret_arns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreOauth2CredentialProviderClientSecretArnArgs', 'AgentcoreOauth2CredentialProviderClientSecretArnArgsDict']]]]] = None,
            credential_provider_arn: Optional[pulumi.Input[_builtins.str]] = None,
            credential_provider_vendor: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oauth2_provider_config: Optional[pulumi.Input[Union['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs', 'AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentcoreOauth2CredentialProvider':
        """
        Get an existing AgentcoreOauth2CredentialProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreOauth2CredentialProviderClientSecretArnArgs', 'AgentcoreOauth2CredentialProviderClientSecretArnArgsDict']]]] client_secret_arns: ARN of the AWS Secrets Manager secret containing the client secret.
        :param pulumi.Input[_builtins.str] credential_provider_arn: ARN of the OAuth2 credential provider.
        :param pulumi.Input[_builtins.str] credential_provider_vendor: Vendor of the OAuth2 credential provider. Valid values: `CustomOauth2`, `GithubOauth2`, `GoogleOauth2`, `Microsoft`, `SalesforceOauth2`, `SlackOauth2`.
        :param pulumi.Input[_builtins.str] name: Name of the OAuth2 credential provider.
        :param pulumi.Input[Union['AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgs', 'AgentcoreOauth2CredentialProviderOauth2ProviderConfigArgsDict']] oauth2_provider_config: OAuth2 provider configuration. Must contain exactly one provider type. See `oauth2_provider_config` below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreOauth2CredentialProviderState.__new__(_AgentcoreOauth2CredentialProviderState)

        __props__.__dict__["client_secret_arns"] = client_secret_arns
        __props__.__dict__["credential_provider_arn"] = credential_provider_arn
        __props__.__dict__["credential_provider_vendor"] = credential_provider_vendor
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth2_provider_config"] = oauth2_provider_config
        __props__.__dict__["region"] = region
        return AgentcoreOauth2CredentialProvider(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientSecretArns")
    def client_secret_arns(self) -> pulumi.Output[Sequence['outputs.AgentcoreOauth2CredentialProviderClientSecretArn']]:
        """
        ARN of the AWS Secrets Manager secret containing the client secret.
        """
        return pulumi.get(self, "client_secret_arns")

    @_builtins.property
    @pulumi.getter(name="credentialProviderArn")
    def credential_provider_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the OAuth2 credential provider.
        """
        return pulumi.get(self, "credential_provider_arn")

    @_builtins.property
    @pulumi.getter(name="credentialProviderVendor")
    def credential_provider_vendor(self) -> pulumi.Output[_builtins.str]:
        """
        Vendor of the OAuth2 credential provider. Valid values: `CustomOauth2`, `GithubOauth2`, `GoogleOauth2`, `Microsoft`, `SalesforceOauth2`, `SlackOauth2`.
        """
        return pulumi.get(self, "credential_provider_vendor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the OAuth2 credential provider.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oauth2ProviderConfig")
    def oauth2_provider_config(self) -> pulumi.Output[Optional['outputs.AgentcoreOauth2CredentialProviderOauth2ProviderConfig']]:
        """
        OAuth2 provider configuration. Must contain exactly one provider type. See `oauth2_provider_config` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "oauth2_provider_config")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

