# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreTokenVaultCmkArgs', 'AgentcoreTokenVaultCmk']

@pulumi.input_type
class AgentcoreTokenVaultCmkArgs:
    def __init__(__self__, *,
                 kms_configuration: Optional[pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 token_vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AgentcoreTokenVaultCmk resource.
        :param pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs'] kms_configuration: KMS configuration for the token vault. See `kms_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] token_vault_id: Token vault ID. Defaults to `default`.
        """
        if kms_configuration is not None:
            pulumi.set(__self__, "kms_configuration", kms_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token_vault_id is not None:
            pulumi.set(__self__, "token_vault_id", token_vault_id)

    @_builtins.property
    @pulumi.getter(name="kmsConfiguration")
    def kms_configuration(self) -> Optional[pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs']]:
        """
        KMS configuration for the token vault. See `kms_configuration` below.
        """
        return pulumi.get(self, "kms_configuration")

    @kms_configuration.setter
    def kms_configuration(self, value: Optional[pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs']]):
        pulumi.set(self, "kms_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tokenVaultId")
    def token_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token vault ID. Defaults to `default`.
        """
        return pulumi.get(self, "token_vault_id")

    @token_vault_id.setter
    def token_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_vault_id", value)


@pulumi.input_type
class _AgentcoreTokenVaultCmkState:
    def __init__(__self__, *,
                 kms_configuration: Optional[pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 token_vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentcoreTokenVaultCmk resources.
        :param pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs'] kms_configuration: KMS configuration for the token vault. See `kms_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] token_vault_id: Token vault ID. Defaults to `default`.
        """
        if kms_configuration is not None:
            pulumi.set(__self__, "kms_configuration", kms_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token_vault_id is not None:
            pulumi.set(__self__, "token_vault_id", token_vault_id)

    @_builtins.property
    @pulumi.getter(name="kmsConfiguration")
    def kms_configuration(self) -> Optional[pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs']]:
        """
        KMS configuration for the token vault. See `kms_configuration` below.
        """
        return pulumi.get(self, "kms_configuration")

    @kms_configuration.setter
    def kms_configuration(self, value: Optional[pulumi.Input['AgentcoreTokenVaultCmkKmsConfigurationArgs']]):
        pulumi.set(self, "kms_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tokenVaultId")
    def token_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token vault ID. Defaults to `default`.
        """
        return pulumi.get(self, "token_vault_id")

    @token_vault_id.setter
    def token_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_vault_id", value)


@pulumi.type_token("aws:bedrock/agentcoreTokenVaultCmk:AgentcoreTokenVaultCmk")
class AgentcoreTokenVaultCmk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kms_configuration: Optional[pulumi.Input[Union['AgentcoreTokenVaultCmkKmsConfigurationArgs', 'AgentcoreTokenVaultCmkKmsConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 token_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the AWS KMS customer master key (CMK) for a token vault.

        > Deletion of this resource will not modify the CMK, only remove the resource from state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreTokenVaultCmk("example", kms_configuration={
            "key_type": "CustomerManagedKey",
            "kms_key_arn": example_aws_kms_key["arn"],
        })
        ```

        ## Import

        Using `pulumi import`, import token vault CMKs using the token vault ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreTokenVaultCmk:AgentcoreTokenVaultCmk example "default"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreTokenVaultCmkKmsConfigurationArgs', 'AgentcoreTokenVaultCmkKmsConfigurationArgsDict']] kms_configuration: KMS configuration for the token vault. See `kms_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] token_vault_id: Token vault ID. Defaults to `default`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgentcoreTokenVaultCmkArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the AWS KMS customer master key (CMK) for a token vault.

        > Deletion of this resource will not modify the CMK, only remove the resource from state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreTokenVaultCmk("example", kms_configuration={
            "key_type": "CustomerManagedKey",
            "kms_key_arn": example_aws_kms_key["arn"],
        })
        ```

        ## Import

        Using `pulumi import`, import token vault CMKs using the token vault ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreTokenVaultCmk:AgentcoreTokenVaultCmk example "default"
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreTokenVaultCmkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreTokenVaultCmkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kms_configuration: Optional[pulumi.Input[Union['AgentcoreTokenVaultCmkKmsConfigurationArgs', 'AgentcoreTokenVaultCmkKmsConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 token_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreTokenVaultCmkArgs.__new__(AgentcoreTokenVaultCmkArgs)

            __props__.__dict__["kms_configuration"] = kms_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["token_vault_id"] = token_vault_id
        super(AgentcoreTokenVaultCmk, __self__).__init__(
            'aws:bedrock/agentcoreTokenVaultCmk:AgentcoreTokenVaultCmk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            kms_configuration: Optional[pulumi.Input[Union['AgentcoreTokenVaultCmkKmsConfigurationArgs', 'AgentcoreTokenVaultCmkKmsConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            token_vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentcoreTokenVaultCmk':
        """
        Get an existing AgentcoreTokenVaultCmk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreTokenVaultCmkKmsConfigurationArgs', 'AgentcoreTokenVaultCmkKmsConfigurationArgsDict']] kms_configuration: KMS configuration for the token vault. See `kms_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] token_vault_id: Token vault ID. Defaults to `default`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreTokenVaultCmkState.__new__(_AgentcoreTokenVaultCmkState)

        __props__.__dict__["kms_configuration"] = kms_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["token_vault_id"] = token_vault_id
        return AgentcoreTokenVaultCmk(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="kmsConfiguration")
    def kms_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreTokenVaultCmkKmsConfiguration']]:
        """
        KMS configuration for the token vault. See `kms_configuration` below.
        """
        return pulumi.get(self, "kms_configuration")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tokenVaultId")
    def token_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        Token vault ID. Defaults to `default`.
        """
        return pulumi.get(self, "token_vault_id")

