# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AgentcoreWorkloadIdentityArgs', 'AgentcoreWorkloadIdentity']

@pulumi.input_type
class AgentcoreWorkloadIdentityArgs:
    def __init__(__self__, *,
                 allowed_resource_oauth2_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AgentcoreWorkloadIdentity resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_resource_oauth2_return_urls: Set of allowed OAuth2 return URLs for resources associated with this workload identity. These URLs are used as valid redirect targets during OAuth2 authentication flows.
        :param pulumi.Input[_builtins.str] name: Name of the workload identity. Must be 3-255 characters and contain only alphanumeric characters, hyphens, periods, and underscores.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if allowed_resource_oauth2_return_urls is not None:
            pulumi.set(__self__, "allowed_resource_oauth2_return_urls", allowed_resource_oauth2_return_urls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="allowedResourceOauth2ReturnUrls")
    def allowed_resource_oauth2_return_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of allowed OAuth2 return URLs for resources associated with this workload identity. These URLs are used as valid redirect targets during OAuth2 authentication flows.
        """
        return pulumi.get(self, "allowed_resource_oauth2_return_urls")

    @allowed_resource_oauth2_return_urls.setter
    def allowed_resource_oauth2_return_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_resource_oauth2_return_urls", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the workload identity. Must be 3-255 characters and contain only alphanumeric characters, hyphens, periods, and underscores.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AgentcoreWorkloadIdentityState:
    def __init__(__self__, *,
                 allowed_resource_oauth2_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentcoreWorkloadIdentity resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_resource_oauth2_return_urls: Set of allowed OAuth2 return URLs for resources associated with this workload identity. These URLs are used as valid redirect targets during OAuth2 authentication flows.
        :param pulumi.Input[_builtins.str] name: Name of the workload identity. Must be 3-255 characters and contain only alphanumeric characters, hyphens, periods, and underscores.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] workload_identity_arn: ARN of the Workload Identity.
        """
        if allowed_resource_oauth2_return_urls is not None:
            pulumi.set(__self__, "allowed_resource_oauth2_return_urls", allowed_resource_oauth2_return_urls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if workload_identity_arn is not None:
            pulumi.set(__self__, "workload_identity_arn", workload_identity_arn)

    @_builtins.property
    @pulumi.getter(name="allowedResourceOauth2ReturnUrls")
    def allowed_resource_oauth2_return_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of allowed OAuth2 return URLs for resources associated with this workload identity. These URLs are used as valid redirect targets during OAuth2 authentication flows.
        """
        return pulumi.get(self, "allowed_resource_oauth2_return_urls")

    @allowed_resource_oauth2_return_urls.setter
    def allowed_resource_oauth2_return_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_resource_oauth2_return_urls", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the workload identity. Must be 3-255 characters and contain only alphanumeric characters, hyphens, periods, and underscores.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityArn")
    def workload_identity_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Workload Identity.
        """
        return pulumi.get(self, "workload_identity_arn")

    @workload_identity_arn.setter
    def workload_identity_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_arn", value)


@pulumi.type_token("aws:bedrock/agentcoreWorkloadIdentity:AgentcoreWorkloadIdentity")
class AgentcoreWorkloadIdentity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_resource_oauth2_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Bedrock AgentCore Workload Identity. Workload Identity provides OAuth2-based authentication and authorization for AI agents to access external resources securely.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreWorkloadIdentity("example",
            name="example-workload-identity",
            allowed_resource_oauth2_return_urls=["https://example.com/callback"])
        ```

        ### Workload Identity with Multiple Return URLs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreWorkloadIdentity("example",
            name="example-workload-identity",
            allowed_resource_oauth2_return_urls=[
                "https://app.example.com/oauth/callback",
                "https://api.example.com/auth/return",
                "https://example.com/callback",
            ])
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Workload Identity using the workload identity name. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreWorkloadIdentity:AgentcoreWorkloadIdentity example example-workload-identity
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_resource_oauth2_return_urls: Set of allowed OAuth2 return URLs for resources associated with this workload identity. These URLs are used as valid redirect targets during OAuth2 authentication flows.
        :param pulumi.Input[_builtins.str] name: Name of the workload identity. Must be 3-255 characters and contain only alphanumeric characters, hyphens, periods, and underscores.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgentcoreWorkloadIdentityArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Bedrock AgentCore Workload Identity. Workload Identity provides OAuth2-based authentication and authorization for AI agents to access external resources securely.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreWorkloadIdentity("example",
            name="example-workload-identity",
            allowed_resource_oauth2_return_urls=["https://example.com/callback"])
        ```

        ### Workload Identity with Multiple Return URLs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreWorkloadIdentity("example",
            name="example-workload-identity",
            allowed_resource_oauth2_return_urls=[
                "https://app.example.com/oauth/callback",
                "https://api.example.com/auth/return",
                "https://example.com/callback",
            ])
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Workload Identity using the workload identity name. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreWorkloadIdentity:AgentcoreWorkloadIdentity example example-workload-identity
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreWorkloadIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreWorkloadIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_resource_oauth2_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreWorkloadIdentityArgs.__new__(AgentcoreWorkloadIdentityArgs)

            __props__.__dict__["allowed_resource_oauth2_return_urls"] = allowed_resource_oauth2_return_urls
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["workload_identity_arn"] = None
        super(AgentcoreWorkloadIdentity, __self__).__init__(
            'aws:bedrock/agentcoreWorkloadIdentity:AgentcoreWorkloadIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_resource_oauth2_return_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            workload_identity_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentcoreWorkloadIdentity':
        """
        Get an existing AgentcoreWorkloadIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_resource_oauth2_return_urls: Set of allowed OAuth2 return URLs for resources associated with this workload identity. These URLs are used as valid redirect targets during OAuth2 authentication flows.
        :param pulumi.Input[_builtins.str] name: Name of the workload identity. Must be 3-255 characters and contain only alphanumeric characters, hyphens, periods, and underscores.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] workload_identity_arn: ARN of the Workload Identity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreWorkloadIdentityState.__new__(_AgentcoreWorkloadIdentityState)

        __props__.__dict__["allowed_resource_oauth2_return_urls"] = allowed_resource_oauth2_return_urls
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["workload_identity_arn"] = workload_identity_arn
        return AgentcoreWorkloadIdentity(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedResourceOauth2ReturnUrls")
    def allowed_resource_oauth2_return_urls(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of allowed OAuth2 return URLs for resources associated with this workload identity. These URLs are used as valid redirect targets during OAuth2 authentication flows.
        """
        return pulumi.get(self, "allowed_resource_oauth2_return_urls")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the workload identity. Must be 3-255 characters and contain only alphanumeric characters, hyphens, periods, and underscores.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityArn")
    def workload_identity_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Workload Identity.
        """
        return pulumi.get(self, "workload_identity_arn")

