# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInferenceProfilesResult',
    'AwaitableGetInferenceProfilesResult',
    'get_inference_profiles',
    'get_inference_profiles_output',
]

@pulumi.output_type
class GetInferenceProfilesResult:
    """
    A collection of values returned by getInferenceProfiles.
    """
    def __init__(__self__, id=None, inference_profile_summaries=None, region=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inference_profile_summaries and not isinstance(inference_profile_summaries, list):
            raise TypeError("Expected argument 'inference_profile_summaries' to be a list")
        pulumi.set(__self__, "inference_profile_summaries", inference_profile_summaries)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inferenceProfileSummaries")
    def inference_profile_summaries(self) -> Sequence['outputs.GetInferenceProfilesInferenceProfileSummaryResult']:
        """
        List of inference profile summary objects. See `inference_profile_summaries`.
        """
        return pulumi.get(self, "inference_profile_summaries")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the inference profile. `SYSTEM_DEFINED` means that the inference profile is defined by Amazon Bedrock. `APPLICATION` means the inference profile was created by a user.
        """
        return pulumi.get(self, "type")


class AwaitableGetInferenceProfilesResult(GetInferenceProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInferenceProfilesResult(
            id=self.id,
            inference_profile_summaries=self.inference_profile_summaries,
            region=self.region,
            type=self.type)


def get_inference_profiles(region: Optional[_builtins.str] = None,
                           type: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInferenceProfilesResult:
    """
    Data source for managing AWS Bedrock Inference Profiles.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.bedrock.get_inference_profiles()
    ```

    ### Filter by Type

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.bedrock.get_inference_profiles(type="APPLICATION")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str type: Filters for inference profiles that match the type you specify. Valid values are: `SYSTEM_DEFINED`, `APPLICATION`.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:bedrock/getInferenceProfiles:getInferenceProfiles', __args__, opts=opts, typ=GetInferenceProfilesResult).value

    return AwaitableGetInferenceProfilesResult(
        id=pulumi.get(__ret__, 'id'),
        inference_profile_summaries=pulumi.get(__ret__, 'inference_profile_summaries'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'))
def get_inference_profiles_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInferenceProfilesResult]:
    """
    Data source for managing AWS Bedrock Inference Profiles.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.bedrock.get_inference_profiles()
    ```

    ### Filter by Type

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.bedrock.get_inference_profiles(type="APPLICATION")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str type: Filters for inference profiles that match the type you specify. Valid values are: `SYSTEM_DEFINED`, `APPLICATION`.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:bedrock/getInferenceProfiles:getInferenceProfiles', __args__, opts=opts, typ=GetInferenceProfilesResult)
    return __ret__.apply(lambda __response__: GetInferenceProfilesResult(
        id=pulumi.get(__response__, 'id'),
        inference_profile_summaries=pulumi.get(__response__, 'inference_profile_summaries'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type')))
