# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InvocationLoggingConfigurationArgs', 'InvocationLoggingConfiguration']

@pulumi.input_type
class InvocationLoggingConfigurationArgs:
    def __init__(__self__, *,
                 logging_config: Optional[pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InvocationLoggingConfiguration resource.
        :param pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs'] logging_config: The logging configuration values to set. See `logging_config` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs']]:
        """
        The logging configuration values to set. See `logging_config` Block for details.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _InvocationLoggingConfigurationState:
    def __init__(__self__, *,
                 logging_config: Optional[pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InvocationLoggingConfiguration resources.
        :param pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs'] logging_config: The logging configuration values to set. See `logging_config` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs']]:
        """
        The logging configuration values to set. See `logging_config` Block for details.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['InvocationLoggingConfigurationLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:bedrockmodel/invocationLoggingConfiguration:InvocationLoggingConfiguration")
class InvocationLoggingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logging_config: Optional[pulumi.Input[Union['InvocationLoggingConfigurationLoggingConfigArgs', 'InvocationLoggingConfigurationLoggingConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Bedrock model invocation logging configuration.

        > Model invocation logging is configured per AWS region. To avoid overwriting settings, this resource should not be defined in multiple configurations.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.s3.Bucket("example",
            bucket="example",
            force_destroy=True)
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example.bucket,
            policy=example.arn.apply(lambda arn: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Effect": "Allow",
              "Principal": {{
                "Service": "bedrock.amazonaws.com"
              }},
              "Action": [
                "s3:*"
              ],
              "Resource": [
                "{arn}/*"
              ],
              "Condition": {{
                "StringEquals": {{
                  "aws:SourceAccount": "{current.account_id}"
                }},
                "ArnLike": {{
                  "aws:SourceArn": "arn:aws:bedrock:us-east-1:{current.account_id}:*"
                }}
              }}
            }}
          ]
        }}
        \"\"\"))
        example_invocation_logging_configuration = aws.bedrockmodel.InvocationLoggingConfiguration("example", logging_config={
            "embedding_data_delivery_enabled": True,
            "image_data_delivery_enabled": True,
            "text_data_delivery_enabled": True,
            "video_data_delivery_enabled": True,
            "s3_config": {
                "bucket_name": example.id,
                "key_prefix": "bedrock",
            },
        },
        opts = pulumi.ResourceOptions(depends_on=[example_bucket_policy]))
        ```

        ## Import

        Using `pulumi import`, import Bedrock custom model using the `id` set to the AWS Region. For example:

        ```sh
        $ pulumi import aws:bedrockmodel/invocationLoggingConfiguration:InvocationLoggingConfiguration my_config us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InvocationLoggingConfigurationLoggingConfigArgs', 'InvocationLoggingConfigurationLoggingConfigArgsDict']] logging_config: The logging configuration values to set. See `logging_config` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InvocationLoggingConfigurationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Bedrock model invocation logging configuration.

        > Model invocation logging is configured per AWS region. To avoid overwriting settings, this resource should not be defined in multiple configurations.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.s3.Bucket("example",
            bucket="example",
            force_destroy=True)
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example.bucket,
            policy=example.arn.apply(lambda arn: f\"\"\"{{
          "Version": "2012-10-17",
          "Statement": [
            {{
              "Effect": "Allow",
              "Principal": {{
                "Service": "bedrock.amazonaws.com"
              }},
              "Action": [
                "s3:*"
              ],
              "Resource": [
                "{arn}/*"
              ],
              "Condition": {{
                "StringEquals": {{
                  "aws:SourceAccount": "{current.account_id}"
                }},
                "ArnLike": {{
                  "aws:SourceArn": "arn:aws:bedrock:us-east-1:{current.account_id}:*"
                }}
              }}
            }}
          ]
        }}
        \"\"\"))
        example_invocation_logging_configuration = aws.bedrockmodel.InvocationLoggingConfiguration("example", logging_config={
            "embedding_data_delivery_enabled": True,
            "image_data_delivery_enabled": True,
            "text_data_delivery_enabled": True,
            "video_data_delivery_enabled": True,
            "s3_config": {
                "bucket_name": example.id,
                "key_prefix": "bedrock",
            },
        },
        opts = pulumi.ResourceOptions(depends_on=[example_bucket_policy]))
        ```

        ## Import

        Using `pulumi import`, import Bedrock custom model using the `id` set to the AWS Region. For example:

        ```sh
        $ pulumi import aws:bedrockmodel/invocationLoggingConfiguration:InvocationLoggingConfiguration my_config us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param InvocationLoggingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvocationLoggingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logging_config: Optional[pulumi.Input[Union['InvocationLoggingConfigurationLoggingConfigArgs', 'InvocationLoggingConfigurationLoggingConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvocationLoggingConfigurationArgs.__new__(InvocationLoggingConfigurationArgs)

            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["region"] = region
        super(InvocationLoggingConfiguration, __self__).__init__(
            'aws:bedrockmodel/invocationLoggingConfiguration:InvocationLoggingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            logging_config: Optional[pulumi.Input[Union['InvocationLoggingConfigurationLoggingConfigArgs', 'InvocationLoggingConfigurationLoggingConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'InvocationLoggingConfiguration':
        """
        Get an existing InvocationLoggingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InvocationLoggingConfigurationLoggingConfigArgs', 'InvocationLoggingConfigurationLoggingConfigArgsDict']] logging_config: The logging configuration values to set. See `logging_config` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InvocationLoggingConfigurationState.__new__(_InvocationLoggingConfigurationState)

        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["region"] = region
        return InvocationLoggingConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.InvocationLoggingConfigurationLoggingConfig']]:
        """
        The logging configuration values to set. See `logging_config` Block for details.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

