# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetViewsResult',
    'AwaitableGetViewsResult',
    'get_views',
    'get_views_output',
]

@pulumi.output_type
class GetViewsResult:
    """
    A collection of values returned by getViews.
    """
    def __init__(__self__, billing_view_types=None, billing_views=None, id=None):
        if billing_view_types and not isinstance(billing_view_types, list):
            raise TypeError("Expected argument 'billing_view_types' to be a list")
        pulumi.set(__self__, "billing_view_types", billing_view_types)
        if billing_views and not isinstance(billing_views, list):
            raise TypeError("Expected argument 'billing_views' to be a list")
        pulumi.set(__self__, "billing_views", billing_views)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="billingViewTypes")
    def billing_view_types(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "billing_view_types")

    @_builtins.property
    @pulumi.getter(name="billingViews")
    def billing_views(self) -> Sequence['outputs.GetViewsBillingViewResult']:
        """
        List of billing view objects with the following attributes:
        """
        return pulumi.get(self, "billing_views")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetViewsResult(GetViewsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetViewsResult(
            billing_view_types=self.billing_view_types,
            billing_views=self.billing_views,
            id=self.id)


def get_views(billing_view_types: Optional[Sequence[_builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetViewsResult:
    """
    Provides details about an AWS Billing Views.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.billing.get_views(billing_view_types=["PRIMARY"])
    pulumi.export("primaryViewArnByTypes", example.billing_views[0].arn)
    ```

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.billing.get_views()
    pulumi.export("viewArns", [view.arn for view in example.billing_views])
    pulumi.export("primaryViewArnByName", [view.arn for view in example.billing_views if view.name == "Primary View"][0])
    ```


    :param Sequence[_builtins.str] billing_view_types: List of billing view types to retrieve. Valid values are `PRIMARY`, `BILLING_GROUP`, `CUSTOM`.
    """
    __args__ = dict()
    __args__['billingViewTypes'] = billing_view_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:billing/getViews:getViews', __args__, opts=opts, typ=GetViewsResult).value

    return AwaitableGetViewsResult(
        billing_view_types=pulumi.get(__ret__, 'billing_view_types'),
        billing_views=pulumi.get(__ret__, 'billing_views'),
        id=pulumi.get(__ret__, 'id'))
def get_views_output(billing_view_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetViewsResult]:
    """
    Provides details about an AWS Billing Views.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.billing.get_views(billing_view_types=["PRIMARY"])
    pulumi.export("primaryViewArnByTypes", example.billing_views[0].arn)
    ```

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.billing.get_views()
    pulumi.export("viewArns", [view.arn for view in example.billing_views])
    pulumi.export("primaryViewArnByName", [view.arn for view in example.billing_views if view.name == "Primary View"][0])
    ```


    :param Sequence[_builtins.str] billing_view_types: List of billing view types to retrieve. Valid values are `PRIMARY`, `BILLING_GROUP`, `CUSTOM`.
    """
    __args__ = dict()
    __args__['billingViewTypes'] = billing_view_types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:billing/getViews:getViews', __args__, opts=opts, typ=GetViewsResult)
    return __ret__.apply(lambda __response__: GetViewsResult(
        billing_view_types=pulumi.get(__response__, 'billing_view_types'),
        billing_views=pulumi.get(__response__, 'billing_views'),
        id=pulumi.get(__response__, 'id')))
