# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OrganizationCustomPolicyRuleArgs', 'OrganizationCustomPolicyRule']

@pulumi.input_type
class OrganizationCustomPolicyRuleArgs:
    def __init__(__self__, *,
                 policy_runtime: pulumi.Input[_builtins.str],
                 policy_text: pulumi.Input[_builtins.str],
                 trigger_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 debug_log_delivery_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 excluded_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 input_parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationCustomPolicyRule resource.
        :param pulumi.Input[_builtins.str] policy_runtime: Runtime system for policy rules.
        :param pulumi.Input[_builtins.str] policy_text: Policy definition containing the rule logic.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trigger_types: List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] debug_log_delivery_accounts: List of accounts that you can enable debug logging for. The list is null when debug logging is enabled for all accounts.
        :param pulumi.Input[_builtins.str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_accounts: List of AWS account identifiers to exclude from the rule.
        :param pulumi.Input[_builtins.str] input_parameters: A string in JSON format that is passed to the AWS Config Rule Lambda Function.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
        :param pulumi.Input[_builtins.str] name: Name of the rule.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_id_scope: Identifier of the AWS resource to evaluate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: List of types of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_key_scope: Tag key of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_value_scope: Tag value of AWS resources to evaluate.
        """
        pulumi.set(__self__, "policy_runtime", policy_runtime)
        pulumi.set(__self__, "policy_text", policy_text)
        pulumi.set(__self__, "trigger_types", trigger_types)
        if debug_log_delivery_accounts is not None:
            pulumi.set(__self__, "debug_log_delivery_accounts", debug_log_delivery_accounts)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excluded_accounts is not None:
            pulumi.set(__self__, "excluded_accounts", excluded_accounts)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id_scope is not None:
            pulumi.set(__self__, "resource_id_scope", resource_id_scope)
        if resource_types_scopes is not None:
            pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        if tag_key_scope is not None:
            pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        if tag_value_scope is not None:
            pulumi.set(__self__, "tag_value_scope", tag_value_scope)

    @_builtins.property
    @pulumi.getter(name="policyRuntime")
    def policy_runtime(self) -> pulumi.Input[_builtins.str]:
        """
        Runtime system for policy rules.
        """
        return pulumi.get(self, "policy_runtime")

    @policy_runtime.setter
    def policy_runtime(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_runtime", value)

    @_builtins.property
    @pulumi.getter(name="policyText")
    def policy_text(self) -> pulumi.Input[_builtins.str]:
        """
        Policy definition containing the rule logic.
        """
        return pulumi.get(self, "policy_text")

    @policy_text.setter
    def policy_text(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_text", value)

    @_builtins.property
    @pulumi.getter(name="triggerTypes")
    def trigger_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`.

        The following arguments are optional:
        """
        return pulumi.get(self, "trigger_types")

    @trigger_types.setter
    def trigger_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "trigger_types", value)

    @_builtins.property
    @pulumi.getter(name="debugLogDeliveryAccounts")
    def debug_log_delivery_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of accounts that you can enable debug logging for. The list is null when debug logging is enabled for all accounts.
        """
        return pulumi.get(self, "debug_log_delivery_accounts")

    @debug_log_delivery_accounts.setter
    def debug_log_delivery_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "debug_log_delivery_accounts", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludedAccounts")
    def excluded_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of AWS account identifiers to exclude from the rule.
        """
        return pulumi.get(self, "excluded_accounts")

    @excluded_accounts.setter
    def excluded_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_accounts", value)

    @_builtins.property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string in JSON format that is passed to the AWS Config Rule Lambda Function.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_parameters", value)

    @_builtins.property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceIdScope")
    def resource_id_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the AWS resource to evaluate.
        """
        return pulumi.get(self, "resource_id_scope")

    @resource_id_scope.setter
    def resource_id_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of types of AWS resources to evaluate.
        """
        return pulumi.get(self, "resource_types_scopes")

    @resource_types_scopes.setter
    def resource_types_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_types_scopes", value)

    @_builtins.property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tag key of AWS resources to evaluate.
        """
        return pulumi.get(self, "tag_key_scope")

    @tag_key_scope.setter
    def tag_key_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_key_scope", value)

    @_builtins.property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tag value of AWS resources to evaluate.
        """
        return pulumi.get(self, "tag_value_scope")

    @tag_value_scope.setter
    def tag_value_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_value_scope", value)


@pulumi.input_type
class _OrganizationCustomPolicyRuleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 debug_log_delivery_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 excluded_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 input_parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_text: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OrganizationCustomPolicyRule resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] debug_log_delivery_accounts: List of accounts that you can enable debug logging for. The list is null when debug logging is enabled for all accounts.
        :param pulumi.Input[_builtins.str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_accounts: List of AWS account identifiers to exclude from the rule.
        :param pulumi.Input[_builtins.str] input_parameters: A string in JSON format that is passed to the AWS Config Rule Lambda Function.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
        :param pulumi.Input[_builtins.str] name: Name of the rule.
        :param pulumi.Input[_builtins.str] policy_runtime: Runtime system for policy rules.
        :param pulumi.Input[_builtins.str] policy_text: Policy definition containing the rule logic.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_id_scope: Identifier of the AWS resource to evaluate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: List of types of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_key_scope: Tag key of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_value_scope: Tag value of AWS resources to evaluate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trigger_types: List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if debug_log_delivery_accounts is not None:
            pulumi.set(__self__, "debug_log_delivery_accounts", debug_log_delivery_accounts)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excluded_accounts is not None:
            pulumi.set(__self__, "excluded_accounts", excluded_accounts)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_runtime is not None:
            pulumi.set(__self__, "policy_runtime", policy_runtime)
        if policy_text is not None:
            pulumi.set(__self__, "policy_text", policy_text)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id_scope is not None:
            pulumi.set(__self__, "resource_id_scope", resource_id_scope)
        if resource_types_scopes is not None:
            pulumi.set(__self__, "resource_types_scopes", resource_types_scopes)
        if tag_key_scope is not None:
            pulumi.set(__self__, "tag_key_scope", tag_key_scope)
        if tag_value_scope is not None:
            pulumi.set(__self__, "tag_value_scope", tag_value_scope)
        if trigger_types is not None:
            pulumi.set(__self__, "trigger_types", trigger_types)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the rule.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="debugLogDeliveryAccounts")
    def debug_log_delivery_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of accounts that you can enable debug logging for. The list is null when debug logging is enabled for all accounts.
        """
        return pulumi.get(self, "debug_log_delivery_accounts")

    @debug_log_delivery_accounts.setter
    def debug_log_delivery_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "debug_log_delivery_accounts", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludedAccounts")
    def excluded_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of AWS account identifiers to exclude from the rule.
        """
        return pulumi.get(self, "excluded_accounts")

    @excluded_accounts.setter
    def excluded_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_accounts", value)

    @_builtins.property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string in JSON format that is passed to the AWS Config Rule Lambda Function.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_parameters", value)

    @_builtins.property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyRuntime")
    def policy_runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Runtime system for policy rules.
        """
        return pulumi.get(self, "policy_runtime")

    @policy_runtime.setter
    def policy_runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_runtime", value)

    @_builtins.property
    @pulumi.getter(name="policyText")
    def policy_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy definition containing the rule logic.
        """
        return pulumi.get(self, "policy_text")

    @policy_text.setter
    def policy_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_text", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceIdScope")
    def resource_id_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the AWS resource to evaluate.
        """
        return pulumi.get(self, "resource_id_scope")

    @resource_id_scope.setter
    def resource_id_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of types of AWS resources to evaluate.
        """
        return pulumi.get(self, "resource_types_scopes")

    @resource_types_scopes.setter
    def resource_types_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_types_scopes", value)

    @_builtins.property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tag key of AWS resources to evaluate.
        """
        return pulumi.get(self, "tag_key_scope")

    @tag_key_scope.setter
    def tag_key_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_key_scope", value)

    @_builtins.property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tag value of AWS resources to evaluate.
        """
        return pulumi.get(self, "tag_value_scope")

    @tag_value_scope.setter
    def tag_value_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_value_scope", value)

    @_builtins.property
    @pulumi.getter(name="triggerTypes")
    def trigger_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`.

        The following arguments are optional:
        """
        return pulumi.get(self, "trigger_types")

    @trigger_types.setter
    def trigger_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trigger_types", value)


@pulumi.type_token("aws:cfg/organizationCustomPolicyRule:OrganizationCustomPolicyRule")
class OrganizationCustomPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 debug_log_delivery_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 excluded_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 input_parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_text: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Config Organization Custom Policy Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs.aws.amazon.com/config/latest/developerguide/config-rule-multi-account-deployment.html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Managed Rules (those invoking an AWS managed rule), see the `aws_config_organization_managed__rule` resource.

        > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.OrganizationCustomPolicyRule("example",
            name="example_rule_name",
            policy_runtime="guard-2.x.x",
            policy_text=\"\"\"let status = ['ACTIVE']

        rule tableisactive when
            resourceType == "AWS::DynamoDB::Table" {
            configuration.tableStatus == %status
        }

        rule checkcompliance when
            resourceType == "AWS::DynamoDB::Table"
            tableisactive {
                let pitr = supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus
                %pitr == "ENABLED"
            }
        \"\"\",
            resource_types_scopes=["AWS::DynamoDB::Table"])
        ```

        ## Import

        Using `pulumi import`, import a Config Organization Custom Policy Rule using the `name` argument. For example:

        ```sh
        $ pulumi import aws:cfg/organizationCustomPolicyRule:OrganizationCustomPolicyRule example example_rule_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] debug_log_delivery_accounts: List of accounts that you can enable debug logging for. The list is null when debug logging is enabled for all accounts.
        :param pulumi.Input[_builtins.str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_accounts: List of AWS account identifiers to exclude from the rule.
        :param pulumi.Input[_builtins.str] input_parameters: A string in JSON format that is passed to the AWS Config Rule Lambda Function.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
        :param pulumi.Input[_builtins.str] name: Name of the rule.
        :param pulumi.Input[_builtins.str] policy_runtime: Runtime system for policy rules.
        :param pulumi.Input[_builtins.str] policy_text: Policy definition containing the rule logic.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_id_scope: Identifier of the AWS resource to evaluate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: List of types of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_key_scope: Tag key of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_value_scope: Tag value of AWS resources to evaluate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trigger_types: List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationCustomPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Config Organization Custom Policy Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs.aws.amazon.com/config/latest/developerguide/config-rule-multi-account-deployment.html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Managed Rules (those invoking an AWS managed rule), see the `aws_config_organization_managed__rule` resource.

        > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.OrganizationCustomPolicyRule("example",
            name="example_rule_name",
            policy_runtime="guard-2.x.x",
            policy_text=\"\"\"let status = ['ACTIVE']

        rule tableisactive when
            resourceType == "AWS::DynamoDB::Table" {
            configuration.tableStatus == %status
        }

        rule checkcompliance when
            resourceType == "AWS::DynamoDB::Table"
            tableisactive {
                let pitr = supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus
                %pitr == "ENABLED"
            }
        \"\"\",
            resource_types_scopes=["AWS::DynamoDB::Table"])
        ```

        ## Import

        Using `pulumi import`, import a Config Organization Custom Policy Rule using the `name` argument. For example:

        ```sh
        $ pulumi import aws:cfg/organizationCustomPolicyRule:OrganizationCustomPolicyRule example example_rule_name
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationCustomPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationCustomPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 debug_log_delivery_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 excluded_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 input_parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_text: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationCustomPolicyRuleArgs.__new__(OrganizationCustomPolicyRuleArgs)

            __props__.__dict__["debug_log_delivery_accounts"] = debug_log_delivery_accounts
            __props__.__dict__["description"] = description
            __props__.__dict__["excluded_accounts"] = excluded_accounts
            __props__.__dict__["input_parameters"] = input_parameters
            __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
            __props__.__dict__["name"] = name
            if policy_runtime is None and not opts.urn:
                raise TypeError("Missing required property 'policy_runtime'")
            __props__.__dict__["policy_runtime"] = policy_runtime
            if policy_text is None and not opts.urn:
                raise TypeError("Missing required property 'policy_text'")
            __props__.__dict__["policy_text"] = policy_text
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_id_scope"] = resource_id_scope
            __props__.__dict__["resource_types_scopes"] = resource_types_scopes
            __props__.__dict__["tag_key_scope"] = tag_key_scope
            __props__.__dict__["tag_value_scope"] = tag_value_scope
            if trigger_types is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_types'")
            __props__.__dict__["trigger_types"] = trigger_types
            __props__.__dict__["arn"] = None
        super(OrganizationCustomPolicyRule, __self__).__init__(
            'aws:cfg/organizationCustomPolicyRule:OrganizationCustomPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            debug_log_delivery_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            excluded_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            input_parameters: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_execution_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_runtime: Optional[pulumi.Input[_builtins.str]] = None,
            policy_text: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id_scope: Optional[pulumi.Input[_builtins.str]] = None,
            resource_types_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tag_key_scope: Optional[pulumi.Input[_builtins.str]] = None,
            tag_value_scope: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'OrganizationCustomPolicyRule':
        """
        Get an existing OrganizationCustomPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] debug_log_delivery_accounts: List of accounts that you can enable debug logging for. The list is null when debug logging is enabled for all accounts.
        :param pulumi.Input[_builtins.str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_accounts: List of AWS account identifiers to exclude from the rule.
        :param pulumi.Input[_builtins.str] input_parameters: A string in JSON format that is passed to the AWS Config Rule Lambda Function.
        :param pulumi.Input[_builtins.str] maximum_execution_frequency: Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
        :param pulumi.Input[_builtins.str] name: Name of the rule.
        :param pulumi.Input[_builtins.str] policy_runtime: Runtime system for policy rules.
        :param pulumi.Input[_builtins.str] policy_text: Policy definition containing the rule logic.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_id_scope: Identifier of the AWS resource to evaluate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types_scopes: List of types of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_key_scope: Tag key of AWS resources to evaluate.
        :param pulumi.Input[_builtins.str] tag_value_scope: Tag value of AWS resources to evaluate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trigger_types: List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationCustomPolicyRuleState.__new__(_OrganizationCustomPolicyRuleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["debug_log_delivery_accounts"] = debug_log_delivery_accounts
        __props__.__dict__["description"] = description
        __props__.__dict__["excluded_accounts"] = excluded_accounts
        __props__.__dict__["input_parameters"] = input_parameters
        __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_runtime"] = policy_runtime
        __props__.__dict__["policy_text"] = policy_text
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_id_scope"] = resource_id_scope
        __props__.__dict__["resource_types_scopes"] = resource_types_scopes
        __props__.__dict__["tag_key_scope"] = tag_key_scope
        __props__.__dict__["tag_value_scope"] = tag_value_scope
        __props__.__dict__["trigger_types"] = trigger_types
        return OrganizationCustomPolicyRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the rule.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="debugLogDeliveryAccounts")
    def debug_log_delivery_accounts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of accounts that you can enable debug logging for. The list is null when debug logging is enabled for all accounts.
        """
        return pulumi.get(self, "debug_log_delivery_accounts")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="excludedAccounts")
    def excluded_accounts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of AWS account identifiers to exclude from the rule.
        """
        return pulumi.get(self, "excluded_accounts")

    @_builtins.property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A string in JSON format that is passed to the AWS Config Rule Lambda Function.
        """
        return pulumi.get(self, "input_parameters")

    @_builtins.property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyRuntime")
    def policy_runtime(self) -> pulumi.Output[_builtins.str]:
        """
        Runtime system for policy rules.
        """
        return pulumi.get(self, "policy_runtime")

    @_builtins.property
    @pulumi.getter(name="policyText")
    def policy_text(self) -> pulumi.Output[_builtins.str]:
        """
        Policy definition containing the rule logic.
        """
        return pulumi.get(self, "policy_text")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceIdScope")
    def resource_id_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifier of the AWS resource to evaluate.
        """
        return pulumi.get(self, "resource_id_scope")

    @_builtins.property
    @pulumi.getter(name="resourceTypesScopes")
    def resource_types_scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of types of AWS resources to evaluate.
        """
        return pulumi.get(self, "resource_types_scopes")

    @_builtins.property
    @pulumi.getter(name="tagKeyScope")
    def tag_key_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Tag key of AWS resources to evaluate.
        """
        return pulumi.get(self, "tag_key_scope")

    @_builtins.property
    @pulumi.getter(name="tagValueScope")
    def tag_value_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Tag value of AWS resources to evaluate.
        """
        return pulumi.get(self, "tag_value_scope")

    @_builtins.property
    @pulumi.getter(name="triggerTypes")
    def trigger_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`.

        The following arguments are optional:
        """
        return pulumi.get(self, "trigger_types")

