# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigurationAggregatorAccountAggregationSource',
    'ConfigurationAggregatorOrganizationAggregationSource',
    'ConformancePackInputParameter',
    'DeliveryChannelSnapshotDeliveryProperties',
    'OrganizationConformancePackInputParameter',
    'RecorderRecordingGroup',
    'RecorderRecordingGroupExclusionByResourceType',
    'RecorderRecordingGroupRecordingStrategy',
    'RecorderRecordingMode',
    'RecorderRecordingModeRecordingModeOverride',
    'RemediationConfigurationExecutionControls',
    'RemediationConfigurationExecutionControlsSsmControls',
    'RemediationConfigurationParameter',
    'RuleEvaluationMode',
    'RuleScope',
    'RuleSource',
    'RuleSourceCustomPolicyDetails',
    'RuleSourceSourceDetail',
]

@pulumi.output_type
class ConfigurationAggregatorAccountAggregationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountIds":
            suggest = "account_ids"
        elif key == "allRegions":
            suggest = "all_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationAggregatorAccountAggregationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationAggregatorAccountAggregationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationAggregatorAccountAggregationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_ids: Sequence[_builtins.str],
                 all_regions: Optional[_builtins.bool] = None,
                 regions: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] account_ids: List of 12-digit account IDs of the account(s) being aggregated.
        :param _builtins.bool all_regions: If true, aggregate existing AWS Config regions and future regions.
        :param Sequence[_builtins.str] regions: List of source regions being aggregated.
               
               Either `regions` or `all_regions` (as true) must be specified.
        """
        pulumi.set(__self__, "account_ids", account_ids)
        if all_regions is not None:
            pulumi.set(__self__, "all_regions", all_regions)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Sequence[_builtins.str]:
        """
        List of 12-digit account IDs of the account(s) being aggregated.
        """
        return pulumi.get(self, "account_ids")

    @_builtins.property
    @pulumi.getter(name="allRegions")
    def all_regions(self) -> Optional[_builtins.bool]:
        """
        If true, aggregate existing AWS Config regions and future regions.
        """
        return pulumi.get(self, "all_regions")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of source regions being aggregated.

        Either `regions` or `all_regions` (as true) must be specified.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class ConfigurationAggregatorOrganizationAggregationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "allRegions":
            suggest = "all_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationAggregatorOrganizationAggregationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationAggregatorOrganizationAggregationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationAggregatorOrganizationAggregationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: _builtins.str,
                 all_regions: Optional[_builtins.bool] = None,
                 regions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str role_arn: ARN of the IAM role used to retrieve AWS Organization details associated with the aggregator account.
               
               Either `regions` or `all_regions` (as true) must be specified.
        :param _builtins.bool all_regions: If true, aggregate existing AWS Config regions and future regions.
        :param Sequence[_builtins.str] regions: List of source regions being aggregated.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if all_regions is not None:
            pulumi.set(__self__, "all_regions", all_regions)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        ARN of the IAM role used to retrieve AWS Organization details associated with the aggregator account.

        Either `regions` or `all_regions` (as true) must be specified.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="allRegions")
    def all_regions(self) -> Optional[_builtins.bool]:
        """
        If true, aggregate existing AWS Config regions and future regions.
        """
        return pulumi.get(self, "all_regions")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of source regions being aggregated.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class ConformancePackInputParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConformancePackInputParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConformancePackInputParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConformancePackInputParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_name: The input key.
        :param _builtins.str parameter_value: The input value.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> _builtins.str:
        """
        The input key.
        """
        return pulumi.get(self, "parameter_name")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The input value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class DeliveryChannelSnapshotDeliveryProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryFrequency":
            suggest = "delivery_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryChannelSnapshotDeliveryProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryChannelSnapshotDeliveryProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryChannelSnapshotDeliveryProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_frequency: Optional[_builtins.str] = None):
        """
        :param _builtins.str delivery_frequency: The frequency with which AWS Config recurringly delivers configuration snapshotsE.g., `One_Hour` or `Three_Hours`. Valid values are listed [here](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html#API_ConfigSnapshotDeliveryProperties_Contents).
        """
        if delivery_frequency is not None:
            pulumi.set(__self__, "delivery_frequency", delivery_frequency)

    @_builtins.property
    @pulumi.getter(name="deliveryFrequency")
    def delivery_frequency(self) -> Optional[_builtins.str]:
        """
        The frequency with which AWS Config recurringly delivers configuration snapshotsE.g., `One_Hour` or `Three_Hours`. Valid values are listed [here](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html#API_ConfigSnapshotDeliveryProperties_Contents).
        """
        return pulumi.get(self, "delivery_frequency")


@pulumi.output_type
class OrganizationConformancePackInputParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationConformancePackInputParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationConformancePackInputParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationConformancePackInputParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: _builtins.str,
                 parameter_value: _builtins.str):
        """
        :param _builtins.str parameter_name: The input key.
        :param _builtins.str parameter_value: The input value.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @_builtins.property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> _builtins.str:
        """
        The input key.
        """
        return pulumi.get(self, "parameter_name")

    @_builtins.property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> _builtins.str:
        """
        The input value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class RecorderRecordingGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allSupported":
            suggest = "all_supported"
        elif key == "exclusionByResourceTypes":
            suggest = "exclusion_by_resource_types"
        elif key == "includeGlobalResourceTypes":
            suggest = "include_global_resource_types"
        elif key == "recordingStrategies":
            suggest = "recording_strategies"
        elif key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecorderRecordingGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecorderRecordingGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecorderRecordingGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_supported: Optional[_builtins.bool] = None,
                 exclusion_by_resource_types: Optional[Sequence['outputs.RecorderRecordingGroupExclusionByResourceType']] = None,
                 include_global_resource_types: Optional[_builtins.bool] = None,
                 recording_strategies: Optional[Sequence['outputs.RecorderRecordingGroupRecordingStrategy']] = None,
                 resource_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool all_supported: Specifies whether AWS Config records configuration changes for every supported type of regional resource (which includes any new type that will become supported in the future). Conflicts with `resource_types`. Defaults to `true`.
        :param Sequence['RecorderRecordingGroupExclusionByResourceTypeArgs'] exclusion_by_resource_types: An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
        :param _builtins.bool include_global_resource_types: Specifies whether AWS Config includes all supported types of _global resources_ with the resources that it records. Requires `all_supported = true`. Conflicts with `resource_types`.
        :param Sequence['RecorderRecordingGroupRecordingStrategyArgs'] recording_strategies: Recording Strategy. Detailed below.
        :param Sequence[_builtins.str] resource_types: A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
        """
        if all_supported is not None:
            pulumi.set(__self__, "all_supported", all_supported)
        if exclusion_by_resource_types is not None:
            pulumi.set(__self__, "exclusion_by_resource_types", exclusion_by_resource_types)
        if include_global_resource_types is not None:
            pulumi.set(__self__, "include_global_resource_types", include_global_resource_types)
        if recording_strategies is not None:
            pulumi.set(__self__, "recording_strategies", recording_strategies)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @_builtins.property
    @pulumi.getter(name="allSupported")
    def all_supported(self) -> Optional[_builtins.bool]:
        """
        Specifies whether AWS Config records configuration changes for every supported type of regional resource (which includes any new type that will become supported in the future). Conflicts with `resource_types`. Defaults to `true`.
        """
        return pulumi.get(self, "all_supported")

    @_builtins.property
    @pulumi.getter(name="exclusionByResourceTypes")
    def exclusion_by_resource_types(self) -> Optional[Sequence['outputs.RecorderRecordingGroupExclusionByResourceType']]:
        """
        An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
        """
        return pulumi.get(self, "exclusion_by_resource_types")

    @_builtins.property
    @pulumi.getter(name="includeGlobalResourceTypes")
    def include_global_resource_types(self) -> Optional[_builtins.bool]:
        """
        Specifies whether AWS Config includes all supported types of _global resources_ with the resources that it records. Requires `all_supported = true`. Conflicts with `resource_types`.
        """
        return pulumi.get(self, "include_global_resource_types")

    @_builtins.property
    @pulumi.getter(name="recordingStrategies")
    def recording_strategies(self) -> Optional[Sequence['outputs.RecorderRecordingGroupRecordingStrategy']]:
        """
        Recording Strategy. Detailed below.
        """
        return pulumi.get(self, "recording_strategies")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class RecorderRecordingGroupExclusionByResourceType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecorderRecordingGroupExclusionByResourceType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecorderRecordingGroupExclusionByResourceType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecorderRecordingGroupExclusionByResourceType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] resource_types: A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
        """
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class RecorderRecordingGroupRecordingStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useOnly":
            suggest = "use_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecorderRecordingGroupRecordingStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecorderRecordingGroupRecordingStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecorderRecordingGroupRecordingStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_only: Optional[_builtins.str] = None):
        if use_only is not None:
            pulumi.set(__self__, "use_only", use_only)

    @_builtins.property
    @pulumi.getter(name="useOnly")
    def use_only(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "use_only")


@pulumi.output_type
class RecorderRecordingMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordingFrequency":
            suggest = "recording_frequency"
        elif key == "recordingModeOverride":
            suggest = "recording_mode_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecorderRecordingMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecorderRecordingMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecorderRecordingMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recording_frequency: Optional[_builtins.str] = None,
                 recording_mode_override: Optional['outputs.RecorderRecordingModeRecordingModeOverride'] = None):
        """
        :param _builtins.str recording_frequency: Default recording frequency. `CONTINUOUS` or `DAILY`.
        :param 'RecorderRecordingModeRecordingModeOverrideArgs' recording_mode_override: Recording mode overrides. Detailed below.
        """
        if recording_frequency is not None:
            pulumi.set(__self__, "recording_frequency", recording_frequency)
        if recording_mode_override is not None:
            pulumi.set(__self__, "recording_mode_override", recording_mode_override)

    @_builtins.property
    @pulumi.getter(name="recordingFrequency")
    def recording_frequency(self) -> Optional[_builtins.str]:
        """
        Default recording frequency. `CONTINUOUS` or `DAILY`.
        """
        return pulumi.get(self, "recording_frequency")

    @_builtins.property
    @pulumi.getter(name="recordingModeOverride")
    def recording_mode_override(self) -> Optional['outputs.RecorderRecordingModeRecordingModeOverride']:
        """
        Recording mode overrides. Detailed below.
        """
        return pulumi.get(self, "recording_mode_override")


@pulumi.output_type
class RecorderRecordingModeRecordingModeOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordingFrequency":
            suggest = "recording_frequency"
        elif key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecorderRecordingModeRecordingModeOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecorderRecordingModeRecordingModeOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecorderRecordingModeRecordingModeOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recording_frequency: _builtins.str,
                 resource_types: Sequence[_builtins.str],
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str recording_frequency: The recording frequency for the resources in the override block. `CONTINUOUS` or `DAILY`.
        :param Sequence[_builtins.str] resource_types: A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
        :param _builtins.str description: A description you provide of the override.
        """
        pulumi.set(__self__, "recording_frequency", recording_frequency)
        pulumi.set(__self__, "resource_types", resource_types)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="recordingFrequency")
    def recording_frequency(self) -> _builtins.str:
        """
        The recording frequency for the resources in the override block. `CONTINUOUS` or `DAILY`.
        """
        return pulumi.get(self, "recording_frequency")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Sequence[_builtins.str]:
        """
        A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
        """
        return pulumi.get(self, "resource_types")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description you provide of the override.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class RemediationConfigurationExecutionControls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ssmControls":
            suggest = "ssm_controls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationConfigurationExecutionControls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationConfigurationExecutionControls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationConfigurationExecutionControls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssm_controls: Optional['outputs.RemediationConfigurationExecutionControlsSsmControls'] = None):
        """
        :param 'RemediationConfigurationExecutionControlsSsmControlsArgs' ssm_controls: Configuration block for SSM controls. See below.
        """
        if ssm_controls is not None:
            pulumi.set(__self__, "ssm_controls", ssm_controls)

    @_builtins.property
    @pulumi.getter(name="ssmControls")
    def ssm_controls(self) -> Optional['outputs.RemediationConfigurationExecutionControlsSsmControls']:
        """
        Configuration block for SSM controls. See below.
        """
        return pulumi.get(self, "ssm_controls")


@pulumi.output_type
class RemediationConfigurationExecutionControlsSsmControls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentExecutionRatePercentage":
            suggest = "concurrent_execution_rate_percentage"
        elif key == "errorPercentage":
            suggest = "error_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationConfigurationExecutionControlsSsmControls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationConfigurationExecutionControlsSsmControls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationConfigurationExecutionControlsSsmControls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_execution_rate_percentage: Optional[_builtins.int] = None,
                 error_percentage: Optional[_builtins.int] = None):
        """
        :param _builtins.int concurrent_execution_rate_percentage: Maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. The default value is 10%.
        :param _builtins.int error_percentage: Percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. The default is 50%.
        """
        if concurrent_execution_rate_percentage is not None:
            pulumi.set(__self__, "concurrent_execution_rate_percentage", concurrent_execution_rate_percentage)
        if error_percentage is not None:
            pulumi.set(__self__, "error_percentage", error_percentage)

    @_builtins.property
    @pulumi.getter(name="concurrentExecutionRatePercentage")
    def concurrent_execution_rate_percentage(self) -> Optional[_builtins.int]:
        """
        Maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. The default value is 10%.
        """
        return pulumi.get(self, "concurrent_execution_rate_percentage")

    @_builtins.property
    @pulumi.getter(name="errorPercentage")
    def error_percentage(self) -> Optional[_builtins.int]:
        """
        Percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. The default is 50%.
        """
        return pulumi.get(self, "error_percentage")


@pulumi.output_type
class RemediationConfigurationParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceValue":
            suggest = "resource_value"
        elif key == "staticValue":
            suggest = "static_value"
        elif key == "staticValues":
            suggest = "static_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationConfigurationParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationConfigurationParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationConfigurationParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 resource_value: Optional[_builtins.str] = None,
                 static_value: Optional[_builtins.str] = None,
                 static_values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: Name of the attribute.
        :param _builtins.str resource_value: Value is dynamic and changes at run-time.
        :param _builtins.str static_value: Value is static and does not change at run-time.
        :param Sequence[_builtins.str] static_values: List of static values.
        """
        pulumi.set(__self__, "name", name)
        if resource_value is not None:
            pulumi.set(__self__, "resource_value", resource_value)
        if static_value is not None:
            pulumi.set(__self__, "static_value", static_value)
        if static_values is not None:
            pulumi.set(__self__, "static_values", static_values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the attribute.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceValue")
    def resource_value(self) -> Optional[_builtins.str]:
        """
        Value is dynamic and changes at run-time.
        """
        return pulumi.get(self, "resource_value")

    @_builtins.property
    @pulumi.getter(name="staticValue")
    def static_value(self) -> Optional[_builtins.str]:
        """
        Value is static and does not change at run-time.
        """
        return pulumi.get(self, "static_value")

    @_builtins.property
    @pulumi.getter(name="staticValues")
    def static_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of static values.
        """
        return pulumi.get(self, "static_values")


@pulumi.output_type
class RuleEvaluationMode(dict):
    def __init__(__self__, *,
                 mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode: The mode of an evaluation.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The mode of an evaluation.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class RuleScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "complianceResourceId":
            suggest = "compliance_resource_id"
        elif key == "complianceResourceTypes":
            suggest = "compliance_resource_types"
        elif key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValue":
            suggest = "tag_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compliance_resource_id: Optional[_builtins.str] = None,
                 compliance_resource_types: Optional[Sequence[_builtins.str]] = None,
                 tag_key: Optional[_builtins.str] = None,
                 tag_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str compliance_resource_id: The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for `compliance_resource_types`.
        :param Sequence[_builtins.str] compliance_resource_types: A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
        :param _builtins.str tag_key: The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for the rule.
        :param _builtins.str tag_value: The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
        """
        if compliance_resource_id is not None:
            pulumi.set(__self__, "compliance_resource_id", compliance_resource_id)
        if compliance_resource_types is not None:
            pulumi.set(__self__, "compliance_resource_types", compliance_resource_types)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @_builtins.property
    @pulumi.getter(name="complianceResourceId")
    def compliance_resource_id(self) -> Optional[_builtins.str]:
        """
        The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for `compliance_resource_types`.
        """
        return pulumi.get(self, "compliance_resource_id")

    @_builtins.property
    @pulumi.getter(name="complianceResourceTypes")
    def compliance_resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
        """
        return pulumi.get(self, "compliance_resource_types")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[_builtins.str]:
        """
        The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for the rule.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[_builtins.str]:
        """
        The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
        """
        return pulumi.get(self, "tag_value")


@pulumi.output_type
class RuleSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customPolicyDetails":
            suggest = "custom_policy_details"
        elif key == "sourceDetails":
            suggest = "source_details"
        elif key == "sourceIdentifier":
            suggest = "source_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner: _builtins.str,
                 custom_policy_details: Optional['outputs.RuleSourceCustomPolicyDetails'] = None,
                 source_details: Optional[Sequence['outputs.RuleSourceSourceDetail']] = None,
                 source_identifier: Optional[_builtins.str] = None):
        """
        :param _builtins.str owner: Indicates whether AWS or the customer owns and manages the AWS Config rule. Valid values are `AWS`, `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. For more information about managed rules, see the [AWS Config Managed Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html). For more information about custom rules, see the [AWS Config Custom Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html). Custom Lambda Functions require permissions to allow the AWS Config service to invoke them, e.g., via the `lambda.Permission` resource.
        :param 'RuleSourceCustomPolicyDetailsArgs' custom_policy_details: Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to `CUSTOM_POLICY`. See Custom Policy Details Below.
        :param Sequence['RuleSourceSourceDetailArgs'] source_details: Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
        :param _builtins.str source_identifier: For AWS Config managed rules, a predefined identifier, e.g `IAM_PASSWORD_POLICY`. For custom Lambda rules, the identifier is the ARN of the Lambda Function, such as `arn:aws:lambda:us-east-1:123456789012:function:custom_rule_name` or the `arn` attribute of the `lambda.Function` resource.
        """
        pulumi.set(__self__, "owner", owner)
        if custom_policy_details is not None:
            pulumi.set(__self__, "custom_policy_details", custom_policy_details)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if source_identifier is not None:
            pulumi.set(__self__, "source_identifier", source_identifier)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Indicates whether AWS or the customer owns and manages the AWS Config rule. Valid values are `AWS`, `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. For more information about managed rules, see the [AWS Config Managed Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html). For more information about custom rules, see the [AWS Config Custom Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html). Custom Lambda Functions require permissions to allow the AWS Config service to invoke them, e.g., via the `lambda.Permission` resource.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="customPolicyDetails")
    def custom_policy_details(self) -> Optional['outputs.RuleSourceCustomPolicyDetails']:
        """
        Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to `CUSTOM_POLICY`. See Custom Policy Details Below.
        """
        return pulumi.get(self, "custom_policy_details")

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[Sequence['outputs.RuleSourceSourceDetail']]:
        """
        Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
        """
        return pulumi.get(self, "source_details")

    @_builtins.property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> Optional[_builtins.str]:
        """
        For AWS Config managed rules, a predefined identifier, e.g `IAM_PASSWORD_POLICY`. For custom Lambda rules, the identifier is the ARN of the Lambda Function, such as `arn:aws:lambda:us-east-1:123456789012:function:custom_rule_name` or the `arn` attribute of the `lambda.Function` resource.
        """
        return pulumi.get(self, "source_identifier")


@pulumi.output_type
class RuleSourceCustomPolicyDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyRuntime":
            suggest = "policy_runtime"
        elif key == "policyText":
            suggest = "policy_text"
        elif key == "enableDebugLogDelivery":
            suggest = "enable_debug_log_delivery"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSourceCustomPolicyDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSourceCustomPolicyDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSourceCustomPolicyDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_runtime: _builtins.str,
                 policy_text: _builtins.str,
                 enable_debug_log_delivery: Optional[_builtins.bool] = None):
        """
        :param _builtins.str policy_runtime: The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://github.com/aws-cloudformation/cloudformation-guard).
        :param _builtins.str policy_text: The policy definition containing the logic for your Config Custom Policy rule.
        :param _builtins.bool enable_debug_log_delivery: The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is `false`.
        """
        pulumi.set(__self__, "policy_runtime", policy_runtime)
        pulumi.set(__self__, "policy_text", policy_text)
        if enable_debug_log_delivery is not None:
            pulumi.set(__self__, "enable_debug_log_delivery", enable_debug_log_delivery)

    @_builtins.property
    @pulumi.getter(name="policyRuntime")
    def policy_runtime(self) -> _builtins.str:
        """
        The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://github.com/aws-cloudformation/cloudformation-guard).
        """
        return pulumi.get(self, "policy_runtime")

    @_builtins.property
    @pulumi.getter(name="policyText")
    def policy_text(self) -> _builtins.str:
        """
        The policy definition containing the logic for your Config Custom Policy rule.
        """
        return pulumi.get(self, "policy_text")

    @_builtins.property
    @pulumi.getter(name="enableDebugLogDelivery")
    def enable_debug_log_delivery(self) -> Optional[_builtins.bool]:
        """
        The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is `false`.
        """
        return pulumi.get(self, "enable_debug_log_delivery")


@pulumi.output_type
class RuleSourceSourceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventSource":
            suggest = "event_source"
        elif key == "maximumExecutionFrequency":
            suggest = "maximum_execution_frequency"
        elif key == "messageType":
            suggest = "message_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSourceSourceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSourceSourceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSourceSourceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_source: Optional[_builtins.str] = None,
                 maximum_execution_frequency: Optional[_builtins.str] = None,
                 message_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str event_source: The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWSresources. This defaults to `aws.config` and is the only valid value.
        :param _builtins.str maximum_execution_frequency: The frequency that you want AWS Config to run evaluations for a rule that istriggered periodically. If specified, requires `message_type` to be `ScheduledNotification`.
        :param _builtins.str message_type: The type of notification that triggers AWS Config to run an evaluation for a rule. You canspecify the following notification types:
               * `ConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.
               * `OversizedConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
               * `ScheduledNotification` - Triggers a periodic evaluation at the frequency specified for `maximum_execution_frequency`.
               * `ConfigurationSnapshotDeliveryCompleted` - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.
        """
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)

    @_builtins.property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[_builtins.str]:
        """
        The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWSresources. This defaults to `aws.config` and is the only valid value.
        """
        return pulumi.get(self, "event_source")

    @_builtins.property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[_builtins.str]:
        """
        The frequency that you want AWS Config to run evaluations for a rule that istriggered periodically. If specified, requires `message_type` to be `ScheduledNotification`.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[_builtins.str]:
        """
        The type of notification that triggers AWS Config to run an evaluation for a rule. You canspecify the following notification types:
        * `ConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.
        * `OversizedConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
        * `ScheduledNotification` - Triggers a periodic evaluation at the frequency specified for `maximum_execution_frequency`.
        * `ConfigurationSnapshotDeliveryCompleted` - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.
        """
        return pulumi.get(self, "message_type")


