# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CollaborationArgs', 'Collaboration']

@pulumi.input_type
class CollaborationArgs:
    def __init__(__self__, *,
                 creator_display_name: pulumi.Input[_builtins.str],
                 creator_member_abilities: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: pulumi.Input[_builtins.str],
                 query_log_status: pulumi.Input[_builtins.str],
                 analytics_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 data_encryption_metadata: Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Collaboration resource.
        :param pulumi.Input[_builtins.str] creator_display_name: The name for the member record for the collaboration creator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_member_abilities: The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input[_builtins.str] description: A description for a collaboration.
        :param pulumi.Input[_builtins.str] query_log_status: Determines if members of the collaboration can enable query logs within their own.
               emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] analytics_engine: Analytics engine used by the collaboration. Valid values are `CLEAN_ROOMS_SQL` (deprecated) and `SPARK`.
        :param pulumi.Input['CollaborationDataEncryptionMetadataArgs'] data_encryption_metadata: a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
               * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
               field.
               * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
               boolean field.
               * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
               n any other Fingerprint column with a different name. This is a boolean field.
               * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
               or cryptographically processed (false).
        :param pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]] members: Additional members of the collaboration which will be invited to join the collaboration.
               * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
               * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
               * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input[_builtins.str] name: The name of the collaboration.  Collaboration names do not need to be unique.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key value pairs which tag the collaboration.
        """
        pulumi.set(__self__, "creator_display_name", creator_display_name)
        pulumi.set(__self__, "creator_member_abilities", creator_member_abilities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "query_log_status", query_log_status)
        if analytics_engine is not None:
            pulumi.set(__self__, "analytics_engine", analytics_engine)
        if data_encryption_metadata is not None:
            pulumi.set(__self__, "data_encryption_metadata", data_encryption_metadata)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="creatorDisplayName")
    def creator_display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name for the member record for the collaboration creator.
        """
        return pulumi.get(self, "creator_display_name")

    @creator_display_name.setter
    def creator_display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "creator_display_name", value)

    @_builtins.property
    @pulumi.getter(name="creatorMemberAbilities")
    def creator_member_abilities(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        """
        return pulumi.get(self, "creator_member_abilities")

    @creator_member_abilities.setter
    def creator_member_abilities(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "creator_member_abilities", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        A description for a collaboration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> pulumi.Input[_builtins.str]:
        """
        Determines if members of the collaboration can enable query logs within their own.
        emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).

        The following arguments are optional:
        """
        return pulumi.get(self, "query_log_status")

    @query_log_status.setter
    def query_log_status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query_log_status", value)

    @_builtins.property
    @pulumi.getter(name="analyticsEngine")
    def analytics_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Analytics engine used by the collaboration. Valid values are `CLEAN_ROOMS_SQL` (deprecated) and `SPARK`.
        """
        return pulumi.get(self, "analytics_engine")

    @analytics_engine.setter
    def analytics_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "analytics_engine", value)

    @_builtins.property
    @pulumi.getter(name="dataEncryptionMetadata")
    def data_encryption_metadata(self) -> Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']]:
        """
        a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
        * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
        field.
        * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
        boolean field.
        * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
        n any other Fingerprint column with a different name. This is a boolean field.
        * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
        or cryptographically processed (false).
        """
        return pulumi.get(self, "data_encryption_metadata")

    @data_encryption_metadata.setter
    def data_encryption_metadata(self, value: Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']]):
        pulumi.set(self, "data_encryption_metadata", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]]]:
        """
        Additional members of the collaboration which will be invited to join the collaboration.
        * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
        * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
        * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the collaboration.  Collaboration names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key value pairs which tag the collaboration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CollaborationState:
    def __init__(__self__, *,
                 analytics_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creator_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 creator_member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_encryption_metadata: Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Collaboration resources.
        :param pulumi.Input[_builtins.str] analytics_engine: Analytics engine used by the collaboration. Valid values are `CLEAN_ROOMS_SQL` (deprecated) and `SPARK`.
        :param pulumi.Input[_builtins.str] arn: ARN of the collaboration.
        :param pulumi.Input[_builtins.str] create_time: Date and time the collaboration was created.
               * `member status` - For each member included in the collaboration an additional computed attribute of status is added. These values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_MemberSummary.html#API-Type-MemberSummary-status).
        :param pulumi.Input[_builtins.str] creator_display_name: The name for the member record for the collaboration creator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_member_abilities: The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input['CollaborationDataEncryptionMetadataArgs'] data_encryption_metadata: a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
               * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
               field.
               * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
               boolean field.
               * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
               n any other Fingerprint column with a different name. This is a boolean field.
               * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
               or cryptographically processed (false).
        :param pulumi.Input[_builtins.str] description: A description for a collaboration.
        :param pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]] members: Additional members of the collaboration which will be invited to join the collaboration.
               * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
               * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
               * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input[_builtins.str] name: The name of the collaboration.  Collaboration names do not need to be unique.
        :param pulumi.Input[_builtins.str] query_log_status: Determines if members of the collaboration can enable query logs within their own.
               emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key value pairs which tag the collaboration.
        """
        if analytics_engine is not None:
            pulumi.set(__self__, "analytics_engine", analytics_engine)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator_display_name is not None:
            pulumi.set(__self__, "creator_display_name", creator_display_name)
        if creator_member_abilities is not None:
            pulumi.set(__self__, "creator_member_abilities", creator_member_abilities)
        if data_encryption_metadata is not None:
            pulumi.set(__self__, "data_encryption_metadata", data_encryption_metadata)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_log_status is not None:
            pulumi.set(__self__, "query_log_status", query_log_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="analyticsEngine")
    def analytics_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Analytics engine used by the collaboration. Valid values are `CLEAN_ROOMS_SQL` (deprecated) and `SPARK`.
        """
        return pulumi.get(self, "analytics_engine")

    @analytics_engine.setter
    def analytics_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "analytics_engine", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the collaboration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time the collaboration was created.
        * `member status` - For each member included in the collaboration an additional computed attribute of status is added. These values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_MemberSummary.html#API-Type-MemberSummary-status).
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="creatorDisplayName")
    def creator_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the member record for the collaboration creator.
        """
        return pulumi.get(self, "creator_display_name")

    @creator_display_name.setter
    def creator_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator_display_name", value)

    @_builtins.property
    @pulumi.getter(name="creatorMemberAbilities")
    def creator_member_abilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        """
        return pulumi.get(self, "creator_member_abilities")

    @creator_member_abilities.setter
    def creator_member_abilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "creator_member_abilities", value)

    @_builtins.property
    @pulumi.getter(name="dataEncryptionMetadata")
    def data_encryption_metadata(self) -> Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']]:
        """
        a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
        * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
        field.
        * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
        boolean field.
        * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
        n any other Fingerprint column with a different name. This is a boolean field.
        * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
        or cryptographically processed (false).
        """
        return pulumi.get(self, "data_encryption_metadata")

    @data_encryption_metadata.setter
    def data_encryption_metadata(self, value: Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']]):
        pulumi.set(self, "data_encryption_metadata", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for a collaboration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]]]:
        """
        Additional members of the collaboration which will be invited to join the collaboration.
        * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
        * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
        * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the collaboration.  Collaboration names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines if members of the collaboration can enable query logs within their own.
        emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).

        The following arguments are optional:
        """
        return pulumi.get(self, "query_log_status")

    @query_log_status.setter
    def query_log_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_log_status", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key value pairs which tag the collaboration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("aws:cleanrooms/collaboration:Collaboration")
class Collaboration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 creator_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 creator_member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_encryption_metadata: Optional[pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberArgs', 'CollaborationMemberArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a AWS Clean Rooms collaboration.
        All members included in the definition will be invited to join the collaboration and can create memberships.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_collaboration = aws.cleanrooms.Collaboration("test_collaboration",
            name="pulumi-example-collaboration",
            creator_member_abilities=[
                "CAN_QUERY",
                "CAN_RECEIVE_RESULTS",
            ],
            creator_display_name="Creator ",
            description="I made this collaboration with Pulumi!",
            query_log_status="DISABLED",
            analytics_engine="SPARK",
            data_encryption_metadata={
                "allow_clear_text": True,
                "allow_duplicates": True,
                "allow_joins_on_columns_with_different_names": True,
                "preserve_nulls": False,
            },
            members=[{
                "account_id": "123456789012",
                "display_name": "Other member",
                "member_abilities": [],
            }],
            tags={
                "Project": "Pulumi",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_cleanrooms_collaboration` using the `id`. For example:

        ```sh
        $ pulumi import aws:cleanrooms/collaboration:Collaboration collaboration 1234abcd-12ab-34cd-56ef-1234567890ab
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] analytics_engine: Analytics engine used by the collaboration. Valid values are `CLEAN_ROOMS_SQL` (deprecated) and `SPARK`.
        :param pulumi.Input[_builtins.str] creator_display_name: The name for the member record for the collaboration creator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_member_abilities: The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']] data_encryption_metadata: a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
               * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
               field.
               * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
               boolean field.
               * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
               n any other Fingerprint column with a different name. This is a boolean field.
               * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
               or cryptographically processed (false).
        :param pulumi.Input[_builtins.str] description: A description for a collaboration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberArgs', 'CollaborationMemberArgsDict']]]] members: Additional members of the collaboration which will be invited to join the collaboration.
               * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
               * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
               * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input[_builtins.str] name: The name of the collaboration.  Collaboration names do not need to be unique.
        :param pulumi.Input[_builtins.str] query_log_status: Determines if members of the collaboration can enable query logs within their own.
               emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key value pairs which tag the collaboration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CollaborationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AWS Clean Rooms collaboration.
        All members included in the definition will be invited to join the collaboration and can create memberships.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_collaboration = aws.cleanrooms.Collaboration("test_collaboration",
            name="pulumi-example-collaboration",
            creator_member_abilities=[
                "CAN_QUERY",
                "CAN_RECEIVE_RESULTS",
            ],
            creator_display_name="Creator ",
            description="I made this collaboration with Pulumi!",
            query_log_status="DISABLED",
            analytics_engine="SPARK",
            data_encryption_metadata={
                "allow_clear_text": True,
                "allow_duplicates": True,
                "allow_joins_on_columns_with_different_names": True,
                "preserve_nulls": False,
            },
            members=[{
                "account_id": "123456789012",
                "display_name": "Other member",
                "member_abilities": [],
            }],
            tags={
                "Project": "Pulumi",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_cleanrooms_collaboration` using the `id`. For example:

        ```sh
        $ pulumi import aws:cleanrooms/collaboration:Collaboration collaboration 1234abcd-12ab-34cd-56ef-1234567890ab
        ```

        :param str resource_name: The name of the resource.
        :param CollaborationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CollaborationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_engine: Optional[pulumi.Input[_builtins.str]] = None,
                 creator_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 creator_member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_encryption_metadata: Optional[pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberArgs', 'CollaborationMemberArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CollaborationArgs.__new__(CollaborationArgs)

            __props__.__dict__["analytics_engine"] = analytics_engine
            if creator_display_name is None and not opts.urn:
                raise TypeError("Missing required property 'creator_display_name'")
            __props__.__dict__["creator_display_name"] = creator_display_name
            if creator_member_abilities is None and not opts.urn:
                raise TypeError("Missing required property 'creator_member_abilities'")
            __props__.__dict__["creator_member_abilities"] = creator_member_abilities
            __props__.__dict__["data_encryption_metadata"] = data_encryption_metadata
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["members"] = members
            __props__.__dict__["name"] = name
            if query_log_status is None and not opts.urn:
                raise TypeError("Missing required property 'query_log_status'")
            __props__.__dict__["query_log_status"] = query_log_status
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["update_time"] = None
        super(Collaboration, __self__).__init__(
            'aws:cleanrooms/collaboration:Collaboration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analytics_engine: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            creator_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            creator_member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_encryption_metadata: Optional[pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberArgs', 'CollaborationMemberArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query_log_status: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Collaboration':
        """
        Get an existing Collaboration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] analytics_engine: Analytics engine used by the collaboration. Valid values are `CLEAN_ROOMS_SQL` (deprecated) and `SPARK`.
        :param pulumi.Input[_builtins.str] arn: ARN of the collaboration.
        :param pulumi.Input[_builtins.str] create_time: Date and time the collaboration was created.
               * `member status` - For each member included in the collaboration an additional computed attribute of status is added. These values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_MemberSummary.html#API-Type-MemberSummary-status).
        :param pulumi.Input[_builtins.str] creator_display_name: The name for the member record for the collaboration creator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_member_abilities: The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']] data_encryption_metadata: a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
               * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
               field.
               * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
               boolean field.
               * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
               n any other Fingerprint column with a different name. This is a boolean field.
               * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
               or cryptographically processed (false).
        :param pulumi.Input[_builtins.str] description: A description for a collaboration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberArgs', 'CollaborationMemberArgsDict']]]] members: Additional members of the collaboration which will be invited to join the collaboration.
               * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
               * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
               * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        :param pulumi.Input[_builtins.str] name: The name of the collaboration.  Collaboration names do not need to be unique.
        :param pulumi.Input[_builtins.str] query_log_status: Determines if members of the collaboration can enable query logs within their own.
               emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key value pairs which tag the collaboration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CollaborationState.__new__(_CollaborationState)

        __props__.__dict__["analytics_engine"] = analytics_engine
        __props__.__dict__["arn"] = arn
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator_display_name"] = creator_display_name
        __props__.__dict__["creator_member_abilities"] = creator_member_abilities
        __props__.__dict__["data_encryption_metadata"] = data_encryption_metadata
        __props__.__dict__["description"] = description
        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        __props__.__dict__["query_log_status"] = query_log_status
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["update_time"] = update_time
        return Collaboration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="analyticsEngine")
    def analytics_engine(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Analytics engine used by the collaboration. Valid values are `CLEAN_ROOMS_SQL` (deprecated) and `SPARK`.
        """
        return pulumi.get(self, "analytics_engine")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the collaboration.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time the collaboration was created.
        * `member status` - For each member included in the collaboration an additional computed attribute of status is added. These values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_MemberSummary.html#API-Type-MemberSummary-status).
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="creatorDisplayName")
    def creator_display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the member record for the collaboration creator.
        """
        return pulumi.get(self, "creator_display_name")

    @_builtins.property
    @pulumi.getter(name="creatorMemberAbilities")
    def creator_member_abilities(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        """
        return pulumi.get(self, "creator_member_abilities")

    @_builtins.property
    @pulumi.getter(name="dataEncryptionMetadata")
    def data_encryption_metadata(self) -> pulumi.Output[Optional['outputs.CollaborationDataEncryptionMetadata']]:
        """
        a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
        * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
        field.
        * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
        boolean field.
        * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
        n any other Fingerprint column with a different name. This is a boolean field.
        * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
        or cryptographically processed (false).
        """
        return pulumi.get(self, "data_encryption_metadata")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description for a collaboration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[Sequence['outputs.CollaborationMember']]]:
        """
        Additional members of the collaboration which will be invited to join the collaboration.
        * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
        * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
        * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the collaboration.  Collaboration names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> pulumi.Output[_builtins.str]:
        """
        Determines if members of the collaboration can enable query logs within their own.
        emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).

        The following arguments are optional:
        """
        return pulumi.get(self, "query_log_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key value pairs which tag the collaboration.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "update_time")

