# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResourceArgs', 'Resource']

@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 desired_state: pulumi.Input[_builtins.str],
                 type_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 type_version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Resource resource.
        :param pulumi.Input[_builtins.str] desired_state: JSON string matching the CloudFormation resource type schema with desired configuration.
        :param pulumi.Input[_builtins.str] type_name: CloudFormation resource type name. For example, `AWS::EC2::VPC`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM Role to assume for operations.
        :param pulumi.Input[_builtins.str] schema: JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
        :param pulumi.Input[_builtins.str] type_version_id: Identifier of the CloudFormation resource type version.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "type_name", type_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if type_version_id is not None:
            pulumi.set(__self__, "type_version_id", type_version_id)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Input[_builtins.str]:
        """
        JSON string matching the CloudFormation resource type schema with desired configuration.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Input[_builtins.str]:
        """
        CloudFormation resource type name. For example, `AWS::EC2::VPC`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role to assume for operations.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="typeVersionId")
    def type_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the CloudFormation resource type version.
        """
        return pulumi.get(self, "type_version_id")

    @type_version_id.setter
    def type_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_version_id", value)


@pulumi.input_type
class _ResourceState:
    def __init__(__self__, *,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 type_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type_version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Resource resources.
        :param pulumi.Input[_builtins.str] desired_state: JSON string matching the CloudFormation resource type schema with desired configuration.
        :param pulumi.Input[_builtins.str] properties: JSON string matching the CloudFormation resource type schema with current configuration. Underlying attributes can be referenced via the `jsondecode()` function, for example, `jsondecode(data.aws_cloudcontrolapi_resource.example.properties)["example"]`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM Role to assume for operations.
        :param pulumi.Input[_builtins.str] schema: JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
        :param pulumi.Input[_builtins.str] type_name: CloudFormation resource type name. For example, `AWS::EC2::VPC`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] type_version_id: Identifier of the CloudFormation resource type version.
        """
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if type_version_id is not None:
            pulumi.set(__self__, "type_version_id", type_version_id)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string matching the CloudFormation resource type schema with desired configuration.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string matching the CloudFormation resource type schema with current configuration. Underlying attributes can be referenced via the `jsondecode()` function, for example, `jsondecode(data.aws_cloudcontrolapi_resource.example.properties)["example"]`.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role to assume for operations.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CloudFormation resource type name. For example, `AWS::EC2::VPC`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_name", value)

    @_builtins.property
    @pulumi.getter(name="typeVersionId")
    def type_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the CloudFormation resource type version.
        """
        return pulumi.get(self, "type_version_id")

    @type_version_id.setter
    def type_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_version_id", value)


@pulumi.type_token("aws:cloudcontrol/resource:Resource")
class Resource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 type_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cloud Control API Resource. The configuration and lifecycle handling of these resources is proxied through Cloud Control API handlers to the backend service.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.cloudcontrol.Resource("example",
            type_name="AWS::ECS::Cluster",
            desired_state=json.dumps({
                "ClusterName": "example",
                "Tags": [{
                    "Key": "CostCenter",
                    "Value": "IT",
                }],
            }))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] desired_state: JSON string matching the CloudFormation resource type schema with desired configuration.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM Role to assume for operations.
        :param pulumi.Input[_builtins.str] schema: JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
        :param pulumi.Input[_builtins.str] type_name: CloudFormation resource type name. For example, `AWS::EC2::VPC`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] type_version_id: Identifier of the CloudFormation resource type version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cloud Control API Resource. The configuration and lifecycle handling of these resources is proxied through Cloud Control API handlers to the backend service.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.cloudcontrol.Resource("example",
            type_name="AWS::ECS::Cluster",
            desired_state=json.dumps({
                "ClusterName": "example",
                "Tags": [{
                    "Key": "CostCenter",
                    "Value": "IT",
                }],
            }))
        ```

        :param str resource_name: The name of the resource.
        :param ResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 type_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceArgs.__new__(ResourceArgs)

            if desired_state is None and not opts.urn:
                raise TypeError("Missing required property 'desired_state'")
            __props__.__dict__["desired_state"] = desired_state
            __props__.__dict__["region"] = region
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["schema"] = None if schema is None else pulumi.Output.secret(schema)
            if type_name is None and not opts.urn:
                raise TypeError("Missing required property 'type_name'")
            __props__.__dict__["type_name"] = type_name
            __props__.__dict__["type_version_id"] = type_version_id
            __props__.__dict__["properties"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["schema"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Resource, __self__).__init__(
            'aws:cloudcontrol/resource:Resource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            desired_state: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            type_name: Optional[pulumi.Input[_builtins.str]] = None,
            type_version_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Resource':
        """
        Get an existing Resource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] desired_state: JSON string matching the CloudFormation resource type schema with desired configuration.
        :param pulumi.Input[_builtins.str] properties: JSON string matching the CloudFormation resource type schema with current configuration. Underlying attributes can be referenced via the `jsondecode()` function, for example, `jsondecode(data.aws_cloudcontrolapi_resource.example.properties)["example"]`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM Role to assume for operations.
        :param pulumi.Input[_builtins.str] schema: JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
        :param pulumi.Input[_builtins.str] type_name: CloudFormation resource type name. For example, `AWS::EC2::VPC`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] type_version_id: Identifier of the CloudFormation resource type version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceState.__new__(_ResourceState)

        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["properties"] = properties
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["schema"] = schema
        __props__.__dict__["type_name"] = type_name
        __props__.__dict__["type_version_id"] = type_version_id
        return Resource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[_builtins.str]:
        """
        JSON string matching the CloudFormation resource type schema with desired configuration.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[_builtins.str]:
        """
        JSON string matching the CloudFormation resource type schema with current configuration. Underlying attributes can be referenced via the `jsondecode()` function, for example, `jsondecode(data.aws_cloudcontrolapi_resource.example.properties)["example"]`.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role to assume for operations.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Output[_builtins.str]:
        """
        CloudFormation resource type name. For example, `AWS::EC2::VPC`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type_name")

    @_builtins.property
    @pulumi.getter(name="typeVersionId")
    def type_version_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifier of the CloudFormation resource type version.
        """
        return pulumi.get(self, "type_version_id")

