# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyvaluestoreKeysExclusiveArgs', 'KeyvaluestoreKeysExclusive']

@pulumi.input_type
class KeyvaluestoreKeysExclusiveArgs:
    def __init__(__self__, *,
                 key_value_store_arn: pulumi.Input[_builtins.str],
                 max_batch_size: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_key_value_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]]] = None):
        """
        The set of arguments for constructing a KeyvaluestoreKeysExclusive resource.
        :param pulumi.Input[_builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] max_batch_size: Maximum resource key values pairs that will update in a single API request. AWS has a default quota of 50 keys or a 3 MB payload, whichever is reached first. Defaults to `50`.
        :param pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]] resource_key_value_pairs: A list of all resource key value pairs associated with the KeyValueStore.
               See `resource_key_value_pair` below.
        """
        pulumi.set(__self__, "key_value_store_arn", key_value_store_arn)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if resource_key_value_pairs is not None:
            pulumi.set(__self__, "resource_key_value_pairs", resource_key_value_pairs)

    @_builtins.property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> pulumi.Input[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the Key Value Store.

        The following arguments are optional:
        """
        return pulumi.get(self, "key_value_store_arn")

    @key_value_store_arn.setter
    def key_value_store_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_value_store_arn", value)

    @_builtins.property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum resource key values pairs that will update in a single API request. AWS has a default quota of 50 keys or a 3 MB payload, whichever is reached first. Defaults to `50`.
        """
        return pulumi.get(self, "max_batch_size")

    @max_batch_size.setter
    def max_batch_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_batch_size", value)

    @_builtins.property
    @pulumi.getter(name="resourceKeyValuePairs")
    def resource_key_value_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]]]:
        """
        A list of all resource key value pairs associated with the KeyValueStore.
        See `resource_key_value_pair` below.
        """
        return pulumi.get(self, "resource_key_value_pairs")

    @resource_key_value_pairs.setter
    def resource_key_value_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]]]):
        pulumi.set(self, "resource_key_value_pairs", value)


@pulumi.input_type
class _KeyvaluestoreKeysExclusiveState:
    def __init__(__self__, *,
                 key_value_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_batch_size: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_key_value_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]]] = None,
                 total_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering KeyvaluestoreKeysExclusive resources.
        :param pulumi.Input[_builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] max_batch_size: Maximum resource key values pairs that will update in a single API request. AWS has a default quota of 50 keys or a 3 MB payload, whichever is reached first. Defaults to `50`.
        :param pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]] resource_key_value_pairs: A list of all resource key value pairs associated with the KeyValueStore.
               See `resource_key_value_pair` below.
        :param pulumi.Input[_builtins.int] total_size_in_bytes: Total size of the Key Value Store in bytes.
        """
        if key_value_store_arn is not None:
            pulumi.set(__self__, "key_value_store_arn", key_value_store_arn)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if resource_key_value_pairs is not None:
            pulumi.set(__self__, "resource_key_value_pairs", resource_key_value_pairs)
        if total_size_in_bytes is not None:
            pulumi.set(__self__, "total_size_in_bytes", total_size_in_bytes)

    @_builtins.property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the Key Value Store.

        The following arguments are optional:
        """
        return pulumi.get(self, "key_value_store_arn")

    @key_value_store_arn.setter
    def key_value_store_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_value_store_arn", value)

    @_builtins.property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum resource key values pairs that will update in a single API request. AWS has a default quota of 50 keys or a 3 MB payload, whichever is reached first. Defaults to `50`.
        """
        return pulumi.get(self, "max_batch_size")

    @max_batch_size.setter
    def max_batch_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_batch_size", value)

    @_builtins.property
    @pulumi.getter(name="resourceKeyValuePairs")
    def resource_key_value_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]]]:
        """
        A list of all resource key value pairs associated with the KeyValueStore.
        See `resource_key_value_pair` below.
        """
        return pulumi.get(self, "resource_key_value_pairs")

    @resource_key_value_pairs.setter
    def resource_key_value_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs']]]]):
        pulumi.set(self, "resource_key_value_pairs", value)

    @_builtins.property
    @pulumi.getter(name="totalSizeInBytes")
    def total_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total size of the Key Value Store in bytes.
        """
        return pulumi.get(self, "total_size_in_bytes")

    @total_size_in_bytes.setter
    def total_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_size_in_bytes", value)


@pulumi.type_token("aws:cloudfront/keyvaluestoreKeysExclusive:KeyvaluestoreKeysExclusive")
class KeyvaluestoreKeysExclusive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_value_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_batch_size: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_key_value_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs', 'KeyvaluestoreKeysExclusiveResourceKeyValuePairArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Import

        Using `pulumi import`, import AWS CloudFront KeyValueStore Key Value Pairs using the `key_value_store_arn`. For example:

        ```sh
        $ pulumi import aws:cloudfront/keyvaluestoreKeysExclusive:KeyvaluestoreKeysExclusive example arn:aws:cloudfront::111111111111:key-value-store/8562g61f-caba-2845-9d99-b97diwae5d3c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] max_batch_size: Maximum resource key values pairs that will update in a single API request. AWS has a default quota of 50 keys or a 3 MB payload, whichever is reached first. Defaults to `50`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs', 'KeyvaluestoreKeysExclusiveResourceKeyValuePairArgsDict']]]] resource_key_value_pairs: A list of all resource key value pairs associated with the KeyValueStore.
               See `resource_key_value_pair` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyvaluestoreKeysExclusiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Using `pulumi import`, import AWS CloudFront KeyValueStore Key Value Pairs using the `key_value_store_arn`. For example:

        ```sh
        $ pulumi import aws:cloudfront/keyvaluestoreKeysExclusive:KeyvaluestoreKeysExclusive example arn:aws:cloudfront::111111111111:key-value-store/8562g61f-caba-2845-9d99-b97diwae5d3c
        ```

        :param str resource_name: The name of the resource.
        :param KeyvaluestoreKeysExclusiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyvaluestoreKeysExclusiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_value_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 max_batch_size: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_key_value_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs', 'KeyvaluestoreKeysExclusiveResourceKeyValuePairArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyvaluestoreKeysExclusiveArgs.__new__(KeyvaluestoreKeysExclusiveArgs)

            if key_value_store_arn is None and not opts.urn:
                raise TypeError("Missing required property 'key_value_store_arn'")
            __props__.__dict__["key_value_store_arn"] = key_value_store_arn
            __props__.__dict__["max_batch_size"] = max_batch_size
            __props__.__dict__["resource_key_value_pairs"] = resource_key_value_pairs
            __props__.__dict__["total_size_in_bytes"] = None
        super(KeyvaluestoreKeysExclusive, __self__).__init__(
            'aws:cloudfront/keyvaluestoreKeysExclusive:KeyvaluestoreKeysExclusive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key_value_store_arn: Optional[pulumi.Input[_builtins.str]] = None,
            max_batch_size: Optional[pulumi.Input[_builtins.int]] = None,
            resource_key_value_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs', 'KeyvaluestoreKeysExclusiveResourceKeyValuePairArgsDict']]]]] = None,
            total_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None) -> 'KeyvaluestoreKeysExclusive':
        """
        Get an existing KeyvaluestoreKeysExclusive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] max_batch_size: Maximum resource key values pairs that will update in a single API request. AWS has a default quota of 50 keys or a 3 MB payload, whichever is reached first. Defaults to `50`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyvaluestoreKeysExclusiveResourceKeyValuePairArgs', 'KeyvaluestoreKeysExclusiveResourceKeyValuePairArgsDict']]]] resource_key_value_pairs: A list of all resource key value pairs associated with the KeyValueStore.
               See `resource_key_value_pair` below.
        :param pulumi.Input[_builtins.int] total_size_in_bytes: Total size of the Key Value Store in bytes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyvaluestoreKeysExclusiveState.__new__(_KeyvaluestoreKeysExclusiveState)

        __props__.__dict__["key_value_store_arn"] = key_value_store_arn
        __props__.__dict__["max_batch_size"] = max_batch_size
        __props__.__dict__["resource_key_value_pairs"] = resource_key_value_pairs
        __props__.__dict__["total_size_in_bytes"] = total_size_in_bytes
        return KeyvaluestoreKeysExclusive(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the Key Value Store.

        The following arguments are optional:
        """
        return pulumi.get(self, "key_value_store_arn")

    @_builtins.property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum resource key values pairs that will update in a single API request. AWS has a default quota of 50 keys or a 3 MB payload, whichever is reached first. Defaults to `50`.
        """
        return pulumi.get(self, "max_batch_size")

    @_builtins.property
    @pulumi.getter(name="resourceKeyValuePairs")
    def resource_key_value_pairs(self) -> pulumi.Output[Optional[Sequence['outputs.KeyvaluestoreKeysExclusiveResourceKeyValuePair']]]:
        """
        A list of all resource key value pairs associated with the KeyValueStore.
        See `resource_key_value_pair` below.
        """
        return pulumi.get(self, "resource_key_value_pairs")

    @_builtins.property
    @pulumi.getter(name="totalSizeInBytes")
    def total_size_in_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        Total size of the Key Value Store in bytes.
        """
        return pulumi.get(self, "total_size_in_bytes")

