# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, cluster_certificates=None, cluster_id=None, cluster_state=None, id=None, region=None, security_group_id=None, subnet_ids=None, vpc_id=None):
        if cluster_certificates and not isinstance(cluster_certificates, list):
            raise TypeError("Expected argument 'cluster_certificates' to be a list")
        pulumi.set(__self__, "cluster_certificates", cluster_certificates)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_state and not isinstance(cluster_state, str):
            raise TypeError("Expected argument 'cluster_state' to be a str")
        pulumi.set(__self__, "cluster_state", cluster_state)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="clusterCertificates")
    def cluster_certificates(self) -> Sequence['outputs.GetClusterClusterCertificateResult']:
        """
        The list of cluster certificates.
        """
        return pulumi.get(self, "cluster_certificates")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> _builtins.str:
        return pulumi.get(self, "cluster_state")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        ID of the security group associated with the CloudHSM cluster.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        IDs of subnets in which cluster operates.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC that the CloudHSM cluster resides in.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            cluster_certificates=self.cluster_certificates,
            cluster_id=self.cluster_id,
            cluster_state=self.cluster_state,
            id=self.id,
            region=self.region,
            security_group_id=self.security_group_id,
            subnet_ids=self.subnet_ids,
            vpc_id=self.vpc_id)


def get_cluster(cluster_id: Optional[_builtins.str] = None,
                cluster_state: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Use this data source to get information about a CloudHSM v2 cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    cluster = aws.cloudhsmv2.get_cluster(cluster_id="cluster-testclusterid")
    ```


    :param _builtins.str cluster_id: ID of Cloud HSM v2 cluster.
    :param _builtins.str cluster_state: State of the cluster to be found.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterState'] = cluster_state
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudhsmv2/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        cluster_certificates=pulumi.get(__ret__, 'cluster_certificates'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_state=pulumi.get(__ret__, 'cluster_state'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_cluster_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                       cluster_state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Use this data source to get information about a CloudHSM v2 cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    cluster = aws.cloudhsmv2.get_cluster(cluster_id="cluster-testclusterid")
    ```


    :param _builtins.str cluster_id: ID of Cloud HSM v2 cluster.
    :param _builtins.str cluster_state: State of the cluster to be found.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterState'] = cluster_state
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudhsmv2/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        cluster_certificates=pulumi.get(__response__, 'cluster_certificates'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_state=pulumi.get(__response__, 'cluster_state'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
