# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventEndpointArgs', 'EventEndpoint']

@pulumi.input_type
class EventEndpointArgs:
    def __init__(__self__, *,
                 event_buses: pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]],
                 routing_config: pulumi.Input['EventEndpointRoutingConfigArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_config: Optional[pulumi.Input['EventEndpointReplicationConfigArgs']] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EventEndpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]] event_buses: The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
        :param pulumi.Input['EventEndpointRoutingConfigArgs'] routing_config: Parameters used for routing, including the health check and secondary Region. Documented below.
        :param pulumi.Input[_builtins.str] description: A description of the global endpoint.
        :param pulumi.Input[_builtins.str] name: The name of the global endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['EventEndpointReplicationConfigArgs'] replication_config: Parameters used for replication. Documented below.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the IAM role used for replication between event buses.
        """
        pulumi.set(__self__, "event_buses", event_buses)
        pulumi.set(__self__, "routing_config", routing_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_config is not None:
            pulumi.set(__self__, "replication_config", replication_config)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter(name="eventBuses")
    def event_buses(self) -> pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]]:
        """
        The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
        """
        return pulumi.get(self, "event_buses")

    @event_buses.setter
    def event_buses(self, value: pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]]):
        pulumi.set(self, "event_buses", value)

    @_builtins.property
    @pulumi.getter(name="routingConfig")
    def routing_config(self) -> pulumi.Input['EventEndpointRoutingConfigArgs']:
        """
        Parameters used for routing, including the health check and secondary Region. Documented below.
        """
        return pulumi.get(self, "routing_config")

    @routing_config.setter
    def routing_config(self, value: pulumi.Input['EventEndpointRoutingConfigArgs']):
        pulumi.set(self, "routing_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the global endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the global endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> Optional[pulumi.Input['EventEndpointReplicationConfigArgs']]:
        """
        Parameters used for replication. Documented below.
        """
        return pulumi.get(self, "replication_config")

    @replication_config.setter
    def replication_config(self, value: Optional[pulumi.Input['EventEndpointReplicationConfigArgs']]):
        pulumi.set(self, "replication_config", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the IAM role used for replication between event buses.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class _EventEndpointState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
                 event_buses: Optional[pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_config: Optional[pulumi.Input['EventEndpointReplicationConfigArgs']] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_config: Optional[pulumi.Input['EventEndpointRoutingConfigArgs']] = None):
        """
        Input properties used for looking up and filtering EventEndpoint resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the endpoint that was created.
        :param pulumi.Input[_builtins.str] description: A description of the global endpoint.
        :param pulumi.Input[_builtins.str] endpoint_url: The URL of the endpoint that was created.
        :param pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]] event_buses: The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
        :param pulumi.Input[_builtins.str] name: The name of the global endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['EventEndpointReplicationConfigArgs'] replication_config: Parameters used for replication. Documented below.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the IAM role used for replication between event buses.
        :param pulumi.Input['EventEndpointRoutingConfigArgs'] routing_config: Parameters used for routing, including the health check and secondary Region. Documented below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if event_buses is not None:
            pulumi.set(__self__, "event_buses", event_buses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_config is not None:
            pulumi.set(__self__, "replication_config", replication_config)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if routing_config is not None:
            pulumi.set(__self__, "routing_config", routing_config)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the endpoint that was created.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the global endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the endpoint that was created.
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_url", value)

    @_builtins.property
    @pulumi.getter(name="eventBuses")
    def event_buses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]]]:
        """
        The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
        """
        return pulumi.get(self, "event_buses")

    @event_buses.setter
    def event_buses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventEndpointEventBusArgs']]]]):
        pulumi.set(self, "event_buses", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the global endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> Optional[pulumi.Input['EventEndpointReplicationConfigArgs']]:
        """
        Parameters used for replication. Documented below.
        """
        return pulumi.get(self, "replication_config")

    @replication_config.setter
    def replication_config(self, value: Optional[pulumi.Input['EventEndpointReplicationConfigArgs']]):
        pulumi.set(self, "replication_config", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the IAM role used for replication between event buses.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="routingConfig")
    def routing_config(self) -> Optional[pulumi.Input['EventEndpointRoutingConfigArgs']]:
        """
        Parameters used for routing, including the health check and secondary Region. Documented below.
        """
        return pulumi.get(self, "routing_config")

    @routing_config.setter
    def routing_config(self, value: Optional[pulumi.Input['EventEndpointRoutingConfigArgs']]):
        pulumi.set(self, "routing_config", value)


@pulumi.type_token("aws:cloudwatch/eventEndpoint:EventEndpoint")
class EventEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 event_buses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventEndpointEventBusArgs', 'EventEndpointEventBusArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_config: Optional[pulumi.Input[Union['EventEndpointReplicationConfigArgs', 'EventEndpointReplicationConfigArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_config: Optional[pulumi.Input[Union['EventEndpointRoutingConfigArgs', 'EventEndpointRoutingConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource to create an EventBridge Global Endpoint.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        this = aws.cloudwatch.EventEndpoint("this",
            name="global-endpoint",
            role_arn=replication["arn"],
            event_buses=[
                {
                    "event_bus_arn": primary["arn"],
                },
                {
                    "event_bus_arn": secondary["arn"],
                },
            ],
            replication_config={
                "state": "DISABLED",
            },
            routing_config={
                "failover_config": {
                    "primary": {
                        "health_check": primary_aws_route53_health_check["arn"],
                    },
                    "secondary": {
                        "route": "us-east-2",
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import EventBridge Global Endpoints using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventEndpoint:EventEndpoint imported_endpoint example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the global endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventEndpointEventBusArgs', 'EventEndpointEventBusArgsDict']]]] event_buses: The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
        :param pulumi.Input[_builtins.str] name: The name of the global endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['EventEndpointReplicationConfigArgs', 'EventEndpointReplicationConfigArgsDict']] replication_config: Parameters used for replication. Documented below.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the IAM role used for replication between event buses.
        :param pulumi.Input[Union['EventEndpointRoutingConfigArgs', 'EventEndpointRoutingConfigArgsDict']] routing_config: Parameters used for routing, including the health check and secondary Region. Documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create an EventBridge Global Endpoint.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        this = aws.cloudwatch.EventEndpoint("this",
            name="global-endpoint",
            role_arn=replication["arn"],
            event_buses=[
                {
                    "event_bus_arn": primary["arn"],
                },
                {
                    "event_bus_arn": secondary["arn"],
                },
            ],
            replication_config={
                "state": "DISABLED",
            },
            routing_config={
                "failover_config": {
                    "primary": {
                        "health_check": primary_aws_route53_health_check["arn"],
                    },
                    "secondary": {
                        "route": "us-east-2",
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import EventBridge Global Endpoints using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventEndpoint:EventEndpoint imported_endpoint example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param EventEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 event_buses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventEndpointEventBusArgs', 'EventEndpointEventBusArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_config: Optional[pulumi.Input[Union['EventEndpointReplicationConfigArgs', 'EventEndpointReplicationConfigArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_config: Optional[pulumi.Input[Union['EventEndpointRoutingConfigArgs', 'EventEndpointRoutingConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventEndpointArgs.__new__(EventEndpointArgs)

            __props__.__dict__["description"] = description
            if event_buses is None and not opts.urn:
                raise TypeError("Missing required property 'event_buses'")
            __props__.__dict__["event_buses"] = event_buses
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["replication_config"] = replication_config
            __props__.__dict__["role_arn"] = role_arn
            if routing_config is None and not opts.urn:
                raise TypeError("Missing required property 'routing_config'")
            __props__.__dict__["routing_config"] = routing_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint_url"] = None
        super(EventEndpoint, __self__).__init__(
            'aws:cloudwatch/eventEndpoint:EventEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_url: Optional[pulumi.Input[_builtins.str]] = None,
            event_buses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventEndpointEventBusArgs', 'EventEndpointEventBusArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication_config: Optional[pulumi.Input[Union['EventEndpointReplicationConfigArgs', 'EventEndpointReplicationConfigArgsDict']]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            routing_config: Optional[pulumi.Input[Union['EventEndpointRoutingConfigArgs', 'EventEndpointRoutingConfigArgsDict']]] = None) -> 'EventEndpoint':
        """
        Get an existing EventEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the endpoint that was created.
        :param pulumi.Input[_builtins.str] description: A description of the global endpoint.
        :param pulumi.Input[_builtins.str] endpoint_url: The URL of the endpoint that was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventEndpointEventBusArgs', 'EventEndpointEventBusArgsDict']]]] event_buses: The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
        :param pulumi.Input[_builtins.str] name: The name of the global endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['EventEndpointReplicationConfigArgs', 'EventEndpointReplicationConfigArgsDict']] replication_config: Parameters used for replication. Documented below.
        :param pulumi.Input[_builtins.str] role_arn: The ARN of the IAM role used for replication between event buses.
        :param pulumi.Input[Union['EventEndpointRoutingConfigArgs', 'EventEndpointRoutingConfigArgsDict']] routing_config: Parameters used for routing, including the health check and secondary Region. Documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventEndpointState.__new__(_EventEndpointState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint_url"] = endpoint_url
        __props__.__dict__["event_buses"] = event_buses
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_config"] = replication_config
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["routing_config"] = routing_config
        return EventEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the endpoint that was created.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the global endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the endpoint that was created.
        """
        return pulumi.get(self, "endpoint_url")

    @_builtins.property
    @pulumi.getter(name="eventBuses")
    def event_buses(self) -> pulumi.Output[Sequence['outputs.EventEndpointEventBus']]:
        """
        The event buses to use. The names of the event buses must be identical in each Region. Exactly two event buses are required. Documented below.
        """
        return pulumi.get(self, "event_buses")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the global endpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> pulumi.Output[Optional['outputs.EventEndpointReplicationConfig']]:
        """
        Parameters used for replication. Documented below.
        """
        return pulumi.get(self, "replication_config")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the IAM role used for replication between event buses.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="routingConfig")
    def routing_config(self) -> pulumi.Output['outputs.EventEndpointRoutingConfig']:
        """
        Parameters used for routing, including the health check and secondary Region. Documented below.
        """
        return pulumi.get(self, "routing_config")

