# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEventBusResult',
    'AwaitableGetEventBusResult',
    'get_event_bus',
    'get_event_bus_output',
]

@pulumi.output_type
class GetEventBusResult:
    """
    A collection of values returned by getEventBus.
    """
    def __init__(__self__, arn=None, dead_letter_configs=None, description=None, id=None, kms_key_identifier=None, log_configs=None, name=None, region=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if dead_letter_configs and not isinstance(dead_letter_configs, list):
            raise TypeError("Expected argument 'dead_letter_configs' to be a list")
        pulumi.set(__self__, "dead_letter_configs", dead_letter_configs)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_identifier and not isinstance(kms_key_identifier, str):
            raise TypeError("Expected argument 'kms_key_identifier' to be a str")
        pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if log_configs and not isinstance(log_configs, list):
            raise TypeError("Expected argument 'log_configs' to be a list")
        pulumi.set(__self__, "log_configs", log_configs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="deadLetterConfigs")
    def dead_letter_configs(self) -> Sequence['outputs.GetEventBusDeadLetterConfigResult']:
        """
        Configuration details of the Amazon SQS queue for EventBridge to use as a dead-letter queue (DLQ). This block has the following arguments:
        """
        return pulumi.get(self, "dead_letter_configs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Event bus description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> _builtins.str:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use to encrypt events on this event bus, if one has been specified.
        """
        return pulumi.get(self, "kms_key_identifier")

    @_builtins.property
    @pulumi.getter(name="logConfigs")
    def log_configs(self) -> Sequence['outputs.GetEventBusLogConfigResult']:
        """
        Block for logging configuration settings for the event bus.
        """
        return pulumi.get(self, "log_configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetEventBusResult(GetEventBusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventBusResult(
            arn=self.arn,
            dead_letter_configs=self.dead_letter_configs,
            description=self.description,
            id=self.id,
            kms_key_identifier=self.kms_key_identifier,
            log_configs=self.log_configs,
            name=self.name,
            region=self.region)


def get_event_bus(name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventBusResult:
    """
    This data source can be used to fetch information about a specific
    EventBridge event bus. Use this data source to compute the ARN of
    an event bus, given the name of the bus.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudwatch.get_event_bus(name="example-bus-name")
    ```


    :param _builtins.str name: Name of the event bus.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudwatch/getEventBus:getEventBus', __args__, opts=opts, typ=GetEventBusResult).value

    return AwaitableGetEventBusResult(
        arn=pulumi.get(__ret__, 'arn'),
        dead_letter_configs=pulumi.get(__ret__, 'dead_letter_configs'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_identifier=pulumi.get(__ret__, 'kms_key_identifier'),
        log_configs=pulumi.get(__ret__, 'log_configs'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_event_bus_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventBusResult]:
    """
    This data source can be used to fetch information about a specific
    EventBridge event bus. Use this data source to compute the ARN of
    an event bus, given the name of the bus.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudwatch.get_event_bus(name="example-bus-name")
    ```


    :param _builtins.str name: Name of the event bus.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudwatch/getEventBus:getEventBus', __args__, opts=opts, typ=GetEventBusResult)
    return __ret__.apply(lambda __response__: GetEventBusResult(
        arn=pulumi.get(__response__, 'arn'),
        dead_letter_configs=pulumi.get(__response__, 'dead_letter_configs'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        kms_key_identifier=pulumi.get(__response__, 'kms_key_identifier'),
        log_configs=pulumi.get(__response__, 'log_configs'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
