# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogDeliveryDestinationArgs', 'LogDeliveryDestination']

@pulumi.input_type
class LogDeliveryDestinationArgs:
    def __init__(__self__, *,
                 delivery_destination_configuration: Optional[pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LogDeliveryDestination resource.
        :param pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs'] delivery_destination_configuration: The AWS resource that will receive the logs.
        :param pulumi.Input[_builtins.str] name: The name for this delivery destination.
        :param pulumi.Input[_builtins.str] output_format: The format of the logs that are sent to this delivery destination. Valid values: `json`, `plain`, `w3c`, `raw`, `parquet`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if delivery_destination_configuration is not None:
            pulumi.set(__self__, "delivery_destination_configuration", delivery_destination_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="deliveryDestinationConfiguration")
    def delivery_destination_configuration(self) -> Optional[pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs']]:
        """
        The AWS resource that will receive the logs.
        """
        return pulumi.get(self, "delivery_destination_configuration")

    @delivery_destination_configuration.setter
    def delivery_destination_configuration(self, value: Optional[pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs']]):
        pulumi.set(self, "delivery_destination_configuration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for this delivery destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the logs that are sent to this delivery destination. Valid values: `json`, `plain`, `w3c`, `raw`, `parquet`.
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_format", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LogDeliveryDestinationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_destination_configuration: Optional[pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs']] = None,
                 delivery_destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LogDeliveryDestination resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the delivery destination.
        :param pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs'] delivery_destination_configuration: The AWS resource that will receive the logs.
        :param pulumi.Input[_builtins.str] delivery_destination_type: Whether this delivery destination is CloudWatch Logs, Amazon S3, or Firehose.
        :param pulumi.Input[_builtins.str] name: The name for this delivery destination.
        :param pulumi.Input[_builtins.str] output_format: The format of the logs that are sent to this delivery destination. Valid values: `json`, `plain`, `w3c`, `raw`, `parquet`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if delivery_destination_configuration is not None:
            pulumi.set(__self__, "delivery_destination_configuration", delivery_destination_configuration)
        if delivery_destination_type is not None:
            pulumi.set(__self__, "delivery_destination_type", delivery_destination_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the delivery destination.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="deliveryDestinationConfiguration")
    def delivery_destination_configuration(self) -> Optional[pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs']]:
        """
        The AWS resource that will receive the logs.
        """
        return pulumi.get(self, "delivery_destination_configuration")

    @delivery_destination_configuration.setter
    def delivery_destination_configuration(self, value: Optional[pulumi.Input['LogDeliveryDestinationDeliveryDestinationConfigurationArgs']]):
        pulumi.set(self, "delivery_destination_configuration", value)

    @_builtins.property
    @pulumi.getter(name="deliveryDestinationType")
    def delivery_destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether this delivery destination is CloudWatch Logs, Amazon S3, or Firehose.
        """
        return pulumi.get(self, "delivery_destination_type")

    @delivery_destination_type.setter
    def delivery_destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_destination_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for this delivery destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the logs that are sent to this delivery destination. Valid values: `json`, `plain`, `w3c`, `raw`, `parquet`.
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_format", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:cloudwatch/logDeliveryDestination:LogDeliveryDestination")
class LogDeliveryDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_configuration: Optional[pulumi.Input[Union['LogDeliveryDestinationDeliveryDestinationConfigurationArgs', 'LogDeliveryDestinationDeliveryDestinationConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudWatch Logs Delivery Destination.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogDeliveryDestination("example",
            name="example",
            delivery_destination_configuration={
                "destination_resource_arn": example_aws_cloudwatch_log_group["arn"],
            })
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Logs Delivery Destination using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logDeliveryDestination:LogDeliveryDestination example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LogDeliveryDestinationDeliveryDestinationConfigurationArgs', 'LogDeliveryDestinationDeliveryDestinationConfigurationArgsDict']] delivery_destination_configuration: The AWS resource that will receive the logs.
        :param pulumi.Input[_builtins.str] name: The name for this delivery destination.
        :param pulumi.Input[_builtins.str] output_format: The format of the logs that are sent to this delivery destination. Valid values: `json`, `plain`, `w3c`, `raw`, `parquet`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LogDeliveryDestinationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudWatch Logs Delivery Destination.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogDeliveryDestination("example",
            name="example",
            delivery_destination_configuration={
                "destination_resource_arn": example_aws_cloudwatch_log_group["arn"],
            })
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Logs Delivery Destination using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logDeliveryDestination:LogDeliveryDestination example example
        ```

        :param str resource_name: The name of the resource.
        :param LogDeliveryDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogDeliveryDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_configuration: Optional[pulumi.Input[Union['LogDeliveryDestinationDeliveryDestinationConfigurationArgs', 'LogDeliveryDestinationDeliveryDestinationConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_format: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogDeliveryDestinationArgs.__new__(LogDeliveryDestinationArgs)

            __props__.__dict__["delivery_destination_configuration"] = delivery_destination_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["output_format"] = output_format
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["delivery_destination_type"] = None
            __props__.__dict__["tags_all"] = None
        super(LogDeliveryDestination, __self__).__init__(
            'aws:cloudwatch/logDeliveryDestination:LogDeliveryDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_destination_configuration: Optional[pulumi.Input[Union['LogDeliveryDestinationDeliveryDestinationConfigurationArgs', 'LogDeliveryDestinationDeliveryDestinationConfigurationArgsDict']]] = None,
            delivery_destination_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_format: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'LogDeliveryDestination':
        """
        Get an existing LogDeliveryDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the delivery destination.
        :param pulumi.Input[Union['LogDeliveryDestinationDeliveryDestinationConfigurationArgs', 'LogDeliveryDestinationDeliveryDestinationConfigurationArgsDict']] delivery_destination_configuration: The AWS resource that will receive the logs.
        :param pulumi.Input[_builtins.str] delivery_destination_type: Whether this delivery destination is CloudWatch Logs, Amazon S3, or Firehose.
        :param pulumi.Input[_builtins.str] name: The name for this delivery destination.
        :param pulumi.Input[_builtins.str] output_format: The format of the logs that are sent to this delivery destination. Valid values: `json`, `plain`, `w3c`, `raw`, `parquet`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogDeliveryDestinationState.__new__(_LogDeliveryDestinationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["delivery_destination_configuration"] = delivery_destination_configuration
        __props__.__dict__["delivery_destination_type"] = delivery_destination_type
        __props__.__dict__["name"] = name
        __props__.__dict__["output_format"] = output_format
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return LogDeliveryDestination(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the delivery destination.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="deliveryDestinationConfiguration")
    def delivery_destination_configuration(self) -> pulumi.Output[Optional['outputs.LogDeliveryDestinationDeliveryDestinationConfiguration']]:
        """
        The AWS resource that will receive the logs.
        """
        return pulumi.get(self, "delivery_destination_configuration")

    @_builtins.property
    @pulumi.getter(name="deliveryDestinationType")
    def delivery_destination_type(self) -> pulumi.Output[_builtins.str]:
        """
        Whether this delivery destination is CloudWatch Logs, Amazon S3, or Firehose.
        """
        return pulumi.get(self, "delivery_destination_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for this delivery destination.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of the logs that are sent to this delivery destination. Valid values: `json`, `plain`, `w3c`, `raw`, `parquet`.
        """
        return pulumi.get(self, "output_format")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

