# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DevEnvironmentIdesArgs',
    'DevEnvironmentIdesArgsDict',
    'DevEnvironmentPersistentStorageArgs',
    'DevEnvironmentPersistentStorageArgsDict',
    'DevEnvironmentRepositoryArgs',
    'DevEnvironmentRepositoryArgsDict',
    'GetDevEnvironmentRepositoryArgs',
    'GetDevEnvironmentRepositoryArgsDict',
]

MYPY = False

if not MYPY:
    class DevEnvironmentIdesArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        """
        runtime: NotRequired[pulumi.Input[_builtins.str]]
        """
        A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
elif False:
    DevEnvironmentIdesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevEnvironmentIdesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        :param pulumi.Input[_builtins.str] runtime: A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)


if not MYPY:
    class DevEnvironmentPersistentStorageArgsDict(TypedDict):
        size: pulumi.Input[_builtins.int]
        """
        The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
elif False:
    DevEnvironmentPersistentStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevEnvironmentPersistentStorageArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] size: The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)


if not MYPY:
    class DevEnvironmentRepositoryArgsDict(TypedDict):
        repository_name: pulumi.Input[_builtins.str]
        """
        The name of the source repository.
        """
        branch_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the branch in a source repository.

        persistent storage (` persistent_storage`) supports the following:
        """
elif False:
    DevEnvironmentRepositoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevEnvironmentRepositoryArgs:
    def __init__(__self__, *,
                 repository_name: pulumi.Input[_builtins.str],
                 branch_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] repository_name: The name of the source repository.
        :param pulumi.Input[_builtins.str] branch_name: The name of the branch in a source repository.
               
               persistent storage (` persistent_storage`) supports the following:
        """
        pulumi.set(__self__, "repository_name", repository_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the source repository.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_name", value)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the branch in a source repository.

        persistent storage (` persistent_storage`) supports the following:
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch_name", value)


if not MYPY:
    class GetDevEnvironmentRepositoryArgsDict(TypedDict):
        branch_name: _builtins.str
        repository_name: _builtins.str
elif False:
    GetDevEnvironmentRepositoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDevEnvironmentRepositoryArgs:
    def __init__(__self__, *,
                 branch_name: _builtins.str,
                 repository_name: _builtins.str):
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "repository_name", repository_name)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> _builtins.str:
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: _builtins.str):
        pulumi.set(self, "branch_name", value)

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: _builtins.str):
        pulumi.set(self, "repository_name", value)


