# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DevEnvironmentIdes',
    'DevEnvironmentPersistentStorage',
    'DevEnvironmentRepository',
    'GetDevEnvironmentIdeResult',
    'GetDevEnvironmentPersistentStorageResult',
    'GetDevEnvironmentRepositoryResult',
]

@pulumi.output_type
class DevEnvironmentIdes(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 runtime: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        :param _builtins.str runtime: A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the IDE. Valid values include Cloud9, IntelliJ, PyCharm, GoLand, and VSCode.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[_builtins.str]:
        """
        A link to the IDE runtime image. This parameter is not required if the name is VSCode. Values of the runtime can be for example public.ecr.aws/jetbrains/py,public.ecr.aws/jetbrains/go
        """
        return pulumi.get(self, "runtime")


@pulumi.output_type
class DevEnvironmentPersistentStorage(dict):
    def __init__(__self__, *,
                 size: _builtins.int):
        """
        :param _builtins.int size: The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of the persistent storage in gigabytes (specifically GiB). Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class DevEnvironmentRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryName":
            suggest = "repository_name"
        elif key == "branchName":
            suggest = "branch_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DevEnvironmentRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DevEnvironmentRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DevEnvironmentRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_name: _builtins.str,
                 branch_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str repository_name: The name of the source repository.
        :param _builtins.str branch_name: The name of the branch in a source repository.
               
               persistent storage (` persistent_storage`) supports the following:
        """
        pulumi.set(__self__, "repository_name", repository_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        """
        The name of the source repository.
        """
        return pulumi.get(self, "repository_name")

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[_builtins.str]:
        """
        The name of the branch in a source repository.

        persistent storage (` persistent_storage`) supports the following:
        """
        return pulumi.get(self, "branch_name")


@pulumi.output_type
class GetDevEnvironmentIdeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 runtime: _builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime", runtime)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> _builtins.str:
        return pulumi.get(self, "runtime")


@pulumi.output_type
class GetDevEnvironmentPersistentStorageResult(dict):
    def __init__(__self__, *,
                 size: _builtins.int):
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


@pulumi.output_type
class GetDevEnvironmentRepositoryResult(dict):
    def __init__(__self__, *,
                 branch_name: _builtins.str,
                 repository_name: _builtins.str):
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "repository_name", repository_name)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> _builtins.str:
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        return pulumi.get(self, "repository_name")


