# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApprovalRuleTemplateAssociationArgs', 'ApprovalRuleTemplateAssociation']

@pulumi.input_type
class ApprovalRuleTemplateAssociationArgs:
    def __init__(__self__, *,
                 approval_rule_template_name: pulumi.Input[_builtins.str],
                 repository_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApprovalRuleTemplateAssociation resource.
        :param pulumi.Input[_builtins.str] approval_rule_template_name: The name for the approval rule template.
        :param pulumi.Input[_builtins.str] repository_name: The name of the repository that you want to associate with the template.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "approval_rule_template_name", approval_rule_template_name)
        pulumi.set(__self__, "repository_name", repository_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="approvalRuleTemplateName")
    def approval_rule_template_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name for the approval rule template.
        """
        return pulumi.get(self, "approval_rule_template_name")

    @approval_rule_template_name.setter
    def approval_rule_template_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "approval_rule_template_name", value)

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the repository that you want to associate with the template.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApprovalRuleTemplateAssociationState:
    def __init__(__self__, *,
                 approval_rule_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApprovalRuleTemplateAssociation resources.
        :param pulumi.Input[_builtins.str] approval_rule_template_name: The name for the approval rule template.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] repository_name: The name of the repository that you want to associate with the template.
        """
        if approval_rule_template_name is not None:
            pulumi.set(__self__, "approval_rule_template_name", approval_rule_template_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)

    @_builtins.property
    @pulumi.getter(name="approvalRuleTemplateName")
    def approval_rule_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the approval rule template.
        """
        return pulumi.get(self, "approval_rule_template_name")

    @approval_rule_template_name.setter
    def approval_rule_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approval_rule_template_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the repository that you want to associate with the template.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_name", value)


@pulumi.type_token("aws:codecommit/approvalRuleTemplateAssociation:ApprovalRuleTemplateAssociation")
class ApprovalRuleTemplateAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rule_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Associates a CodeCommit Approval Rule Template with a Repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codecommit.ApprovalRuleTemplateAssociation("example",
            approval_rule_template_name=example_aws_codecommit_approval_rule_template["name"],
            repository_name=example_aws_codecommit_repository["repositoryName"])
        ```

        ## Import

        Using `pulumi import`, import CodeCommit approval rule template associations using the `approval_rule_template_name` and `repository_name` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:codecommit/approvalRuleTemplateAssociation:ApprovalRuleTemplateAssociation example approver-rule-for-example,MyExampleRepo
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] approval_rule_template_name: The name for the approval rule template.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] repository_name: The name of the repository that you want to associate with the template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApprovalRuleTemplateAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates a CodeCommit Approval Rule Template with a Repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codecommit.ApprovalRuleTemplateAssociation("example",
            approval_rule_template_name=example_aws_codecommit_approval_rule_template["name"],
            repository_name=example_aws_codecommit_repository["repositoryName"])
        ```

        ## Import

        Using `pulumi import`, import CodeCommit approval rule template associations using the `approval_rule_template_name` and `repository_name` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:codecommit/approvalRuleTemplateAssociation:ApprovalRuleTemplateAssociation example approver-rule-for-example,MyExampleRepo
        ```

        :param str resource_name: The name of the resource.
        :param ApprovalRuleTemplateAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApprovalRuleTemplateAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rule_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApprovalRuleTemplateAssociationArgs.__new__(ApprovalRuleTemplateAssociationArgs)

            if approval_rule_template_name is None and not opts.urn:
                raise TypeError("Missing required property 'approval_rule_template_name'")
            __props__.__dict__["approval_rule_template_name"] = approval_rule_template_name
            __props__.__dict__["region"] = region
            if repository_name is None and not opts.urn:
                raise TypeError("Missing required property 'repository_name'")
            __props__.__dict__["repository_name"] = repository_name
        super(ApprovalRuleTemplateAssociation, __self__).__init__(
            'aws:codecommit/approvalRuleTemplateAssociation:ApprovalRuleTemplateAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_rule_template_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            repository_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApprovalRuleTemplateAssociation':
        """
        Get an existing ApprovalRuleTemplateAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] approval_rule_template_name: The name for the approval rule template.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] repository_name: The name of the repository that you want to associate with the template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApprovalRuleTemplateAssociationState.__new__(_ApprovalRuleTemplateAssociationState)

        __props__.__dict__["approval_rule_template_name"] = approval_rule_template_name
        __props__.__dict__["region"] = region
        __props__.__dict__["repository_name"] = repository_name
        return ApprovalRuleTemplateAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="approvalRuleTemplateName")
    def approval_rule_template_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the approval rule template.
        """
        return pulumi.get(self, "approval_rule_template_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the repository that you want to associate with the template.
        """
        return pulumi.get(self, "repository_name")

