# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRepositoryResult',
    'AwaitableGetRepositoryResult',
    'get_repository',
    'get_repository_output',
]

@pulumi.output_type
class GetRepositoryResult:
    """
    A collection of values returned by getRepository.
    """
    def __init__(__self__, arn=None, clone_url_http=None, clone_url_ssh=None, id=None, kms_key_id=None, region=None, repository_id=None, repository_name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if clone_url_http and not isinstance(clone_url_http, str):
            raise TypeError("Expected argument 'clone_url_http' to be a str")
        pulumi.set(__self__, "clone_url_http", clone_url_http)
        if clone_url_ssh and not isinstance(clone_url_ssh, str):
            raise TypeError("Expected argument 'clone_url_ssh' to be a str")
        pulumi.set(__self__, "clone_url_ssh", clone_url_ssh)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if repository_name and not isinstance(repository_name, str):
            raise TypeError("Expected argument 'repository_name' to be a str")
        pulumi.set(__self__, "repository_name", repository_name)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the repository.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="cloneUrlHttp")
    def clone_url_http(self) -> _builtins.str:
        """
        URL to use for cloning the repository over HTTPS.
        """
        return pulumi.get(self, "clone_url_http")

    @_builtins.property
    @pulumi.getter(name="cloneUrlSsh")
    def clone_url_ssh(self) -> _builtins.str:
        """
        URL to use for cloning the repository over SSH.
        """
        return pulumi.get(self, "clone_url_ssh")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The ID of the encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        """
        ID of the repository.
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> _builtins.str:
        return pulumi.get(self, "repository_name")


class AwaitableGetRepositoryResult(GetRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryResult(
            arn=self.arn,
            clone_url_http=self.clone_url_http,
            clone_url_ssh=self.clone_url_ssh,
            id=self.id,
            kms_key_id=self.kms_key_id,
            region=self.region,
            repository_id=self.repository_id,
            repository_name=self.repository_name)


def get_repository(region: Optional[_builtins.str] = None,
                   repository_name: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryResult:
    """
    The CodeCommit Repository data source allows the ARN, Repository ID, Repository URL for HTTP and Repository URL for SSH to be retrieved for an CodeCommit repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.codecommit.get_repository(repository_name="MyTestRepository")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str repository_name: Name for the repository. This needs to be less than 100 characters.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['repositoryName'] = repository_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:codecommit/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult).value

    return AwaitableGetRepositoryResult(
        arn=pulumi.get(__ret__, 'arn'),
        clone_url_http=pulumi.get(__ret__, 'clone_url_http'),
        clone_url_ssh=pulumi.get(__ret__, 'clone_url_ssh'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        region=pulumi.get(__ret__, 'region'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        repository_name=pulumi.get(__ret__, 'repository_name'))
def get_repository_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          repository_name: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryResult]:
    """
    The CodeCommit Repository data source allows the ARN, Repository ID, Repository URL for HTTP and Repository URL for SSH to be retrieved for an CodeCommit repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.codecommit.get_repository(repository_name="MyTestRepository")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str repository_name: Name for the repository. This needs to be less than 100 characters.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['repositoryName'] = repository_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:codecommit/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult)
    return __ret__.apply(lambda __response__: GetRepositoryResult(
        arn=pulumi.get(__response__, 'arn'),
        clone_url_http=pulumi.get(__response__, 'clone_url_http'),
        clone_url_ssh=pulumi.get(__response__, 'clone_url_ssh'),
        id=pulumi.get(__response__, 'id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        region=pulumi.get(__response__, 'region'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        repository_name=pulumi.get(__response__, 'repository_name')))
