# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'TriggerTrigger',
]

@pulumi.output_type
class TriggerTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"
        elif key == "customData":
            suggest = "custom_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: _builtins.str,
                 events: Sequence[_builtins.str],
                 name: _builtins.str,
                 branches: Optional[Sequence[_builtins.str]] = None,
                 custom_data: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination_arn: The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
        :param Sequence[_builtins.str] events: The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
        :param _builtins.str name: The name of the trigger.
        :param Sequence[_builtins.str] branches: The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
        :param _builtins.str custom_data: Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
        """
        pulumi.set(__self__, "destination_arn", destination_arn)
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "name", name)
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)

    @_builtins.property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> _builtins.str:
        """
        The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
        """
        return pulumi.get(self, "destination_arn")

    @_builtins.property
    @pulumi.getter
    def events(self) -> Sequence[_builtins.str]:
        """
        The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def branches(self) -> Optional[Sequence[_builtins.str]]:
        """
        The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
        """
        return pulumi.get(self, "branches")

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[_builtins.str]:
        """
        Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
        """
        return pulumi.get(self, "custom_data")


