# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserGroupResult',
    'AwaitableGetUserGroupResult',
    'get_user_group',
    'get_user_group_output',
]

@pulumi.output_type
class GetUserGroupResult:
    """
    A collection of values returned by getUserGroup.
    """
    def __init__(__self__, description=None, id=None, name=None, precedence=None, region=None, role_arn=None, user_pool_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if precedence and not isinstance(precedence, int):
            raise TypeError("Expected argument 'precedence' to be a int")
        pulumi.set(__self__, "precedence", precedence)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if user_pool_id and not isinstance(user_pool_id, str):
            raise TypeError("Expected argument 'user_pool_id' to be a str")
        pulumi.set(__self__, "user_pool_id", user_pool_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the user group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A comma-delimited string concatenating `name` and `user_pool_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def precedence(self) -> _builtins.int:
        """
        Precedence of the user group.
        """
        return pulumi.get(self, "precedence")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        ARN of the IAM role to be associated with the user group.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        return pulumi.get(self, "user_pool_id")


class AwaitableGetUserGroupResult(GetUserGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupResult(
            description=self.description,
            id=self.id,
            name=self.name,
            precedence=self.precedence,
            region=self.region,
            role_arn=self.role_arn,
            user_pool_id=self.user_pool_id)


def get_user_group(name: Optional[_builtins.str] = None,
                   region: Optional[_builtins.str] = None,
                   user_pool_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupResult:
    """
    Data source for managing an AWS Cognito IDP (Identity Provider) User Group.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cognito.get_user_group(user_pool_id="us-west-2_aaaaaaaaa",
        name="example")
    ```


    :param _builtins.str name: Name of the user group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str user_pool_id: User pool the client belongs to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cognito/getUserGroup:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult).value

    return AwaitableGetUserGroupResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        precedence=pulumi.get(__ret__, 'precedence'),
        region=pulumi.get(__ret__, 'region'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        user_pool_id=pulumi.get(__ret__, 'user_pool_id'))
def get_user_group_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserGroupResult]:
    """
    Data source for managing an AWS Cognito IDP (Identity Provider) User Group.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cognito.get_user_group(user_pool_id="us-west-2_aaaaaaaaa",
        name="example")
    ```


    :param _builtins.str name: Name of the user group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str user_pool_id: User pool the client belongs to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cognito/getUserGroup:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult)
    return __ret__.apply(lambda __response__: GetUserGroupResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        precedence=pulumi.get(__response__, 'precedence'),
        region=pulumi.get(__response__, 'region'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        user_pool_id=pulumi.get(__response__, 'user_pool_id')))
