# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserGroupsResult',
    'AwaitableGetUserGroupsResult',
    'get_user_groups',
    'get_user_groups_output',
]

@pulumi.output_type
class GetUserGroupsResult:
    """
    A collection of values returned by getUserGroups.
    """
    def __init__(__self__, groups=None, id=None, region=None, user_pool_id=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if user_pool_id and not isinstance(user_pool_id, str):
            raise TypeError("Expected argument 'user_pool_id' to be a str")
        pulumi.set(__self__, "user_pool_id", user_pool_id)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetUserGroupsGroupResult']:
        """
        List of groups. See `groups` below.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        User pool identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        return pulumi.get(self, "user_pool_id")


class AwaitableGetUserGroupsResult(GetUserGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupsResult(
            groups=self.groups,
            id=self.id,
            region=self.region,
            user_pool_id=self.user_pool_id)


def get_user_groups(region: Optional[_builtins.str] = None,
                    user_pool_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupsResult:
    """
    Data source for managing AWS Cognito IDP (Identity Provider) User Groups.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cognito.get_user_groups(user_pool_id="us-west-2_aaaaaaaaa")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str user_pool_id: User pool the client belongs to.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cognito/getUserGroups:getUserGroups', __args__, opts=opts, typ=GetUserGroupsResult).value

    return AwaitableGetUserGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        user_pool_id=pulumi.get(__ret__, 'user_pool_id'))
def get_user_groups_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserGroupsResult]:
    """
    Data source for managing AWS Cognito IDP (Identity Provider) User Groups.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cognito.get_user_groups(user_pool_id="us-west-2_aaaaaaaaa")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str user_pool_id: User pool the client belongs to.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cognito/getUserGroups:getUserGroups', __args__, opts=opts, typ=GetUserGroupsResult)
    return __ret__.apply(lambda __response__: GetUserGroupsResult(
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        user_pool_id=pulumi.get(__response__, 'user_pool_id')))
