# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserInGroupArgs', 'UserInGroup']

@pulumi.input_type
class UserInGroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[_builtins.str],
                 user_pool_id: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserInGroup resource.
        :param pulumi.Input[_builtins.str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[_builtins.str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[_builtins.str] username: The username of the user to be added to the group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        pulumi.set(__self__, "username", username)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the group to which the user is to be added.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The user pool ID of the user and group.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the user to be added to the group.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UserInGroupState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserInGroup resources.
        :param pulumi.Input[_builtins.str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[_builtins.str] username: The username of the user to be added to the group.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the group to which the user is to be added.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user pool ID of the user and group.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the user to be added to the group.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("aws:cognito/userInGroup:UserInGroup")
class UserInGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Adds the specified user to the specified group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example",
            name="example",
            password_policy={
                "temporary_password_validity_days": 7,
                "minimum_length": 6,
                "require_uppercase": False,
                "require_symbols": False,
                "require_numbers": False,
            })
        example_user = aws.cognito.User("example",
            user_pool_id=example.id,
            username="example")
        example_user_group = aws.cognito.UserGroup("example",
            user_pool_id=example.id,
            name="example")
        example_user_in_group = aws.cognito.UserInGroup("example",
            user_pool_id=example.id,
            group_name=example_user_group.name,
            username=example_user.username)
        ```

        ## Import

        Using `pulumi import`, import a Cognito Group User using a comma-delimited string concatenating the `user_pool_id`, `group_name`, and `username` arguments. For example:

        ```sh
        $ pulumi import aws:cognito/userInGroup:UserInGroup example us-east-1_vG78M4goG,example-group,example-user
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[_builtins.str] username: The username of the user to be added to the group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserInGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Adds the specified user to the specified group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example",
            name="example",
            password_policy={
                "temporary_password_validity_days": 7,
                "minimum_length": 6,
                "require_uppercase": False,
                "require_symbols": False,
                "require_numbers": False,
            })
        example_user = aws.cognito.User("example",
            user_pool_id=example.id,
            username="example")
        example_user_group = aws.cognito.UserGroup("example",
            user_pool_id=example.id,
            name="example")
        example_user_in_group = aws.cognito.UserInGroup("example",
            user_pool_id=example.id,
            group_name=example_user_group.name,
            username=example_user.username)
        ```

        ## Import

        Using `pulumi import`, import a Cognito Group User using a comma-delimited string concatenating the `user_pool_id`, `group_name`, and `username` arguments. For example:

        ```sh
        $ pulumi import aws:cognito/userInGroup:UserInGroup example us-east-1_vG78M4goG,example-group,example-user
        ```

        :param str resource_name: The name of the resource.
        :param UserInGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserInGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserInGroupArgs.__new__(UserInGroupArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["region"] = region
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(UserInGroup, __self__).__init__(
            'aws:cognito/userInGroup:UserInGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserInGroup':
        """
        Get an existing UserInGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[_builtins.str] username: The username of the user to be added to the group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserInGroupState.__new__(_UserInGroupState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["region"] = region
        __props__.__dict__["user_pool_id"] = user_pool_id
        __props__.__dict__["username"] = username
        return UserInGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the group to which the user is to be added.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The user pool ID of the user and group.
        """
        return pulumi.get(self, "user_pool_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the user to be added to the group.
        """
        return pulumi.get(self, "username")

