# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AssumeRoleWithWebIdentity',
    'AssumeRoles',
    'DefaultTags',
    'Endpoints',
    'IgnoreTags',
]

@pulumi.output_type
class AssumeRoleWithWebIdentity(dict):
    def __init__(__self__, *,
                 duration: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 policy_arns: Optional[Sequence[_builtins.str]] = None,
                 role_arn: Optional[_builtins.str] = None,
                 session_name: Optional[_builtins.str] = None,
                 web_identity_token: Optional[_builtins.str] = None,
                 web_identity_token_file: Optional[_builtins.str] = None):
        """
        :param _builtins.str duration: The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        :param _builtins.str policy: IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param Sequence[_builtins.str] policy_arns: Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        :param _builtins.str role_arn: Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        :param _builtins.str session_name: An identifier for the assumed role session.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if web_identity_token is not None:
            pulumi.set(__self__, "web_identity_token", web_identity_token)
        if web_identity_token_file is not None:
            pulumi.set(__self__, "web_identity_token_file", web_identity_token_file)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[Sequence[_builtins.str]]:
        """
        Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy_arns")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[_builtins.str]:
        """
        An identifier for the assumed role session.
        """
        return pulumi.get(self, "session_name")

    @_builtins.property
    @pulumi.getter(name="webIdentityToken")
    def web_identity_token(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "web_identity_token")

    @_builtins.property
    @pulumi.getter(name="webIdentityTokenFile")
    def web_identity_token_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "web_identity_token_file")


@pulumi.output_type
class AssumeRoles(dict):
    def __init__(__self__, *,
                 duration: Optional[_builtins.str] = None,
                 external_id: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 policy_arns: Optional[Sequence[_builtins.str]] = None,
                 role_arn: Optional[_builtins.str] = None,
                 session_name: Optional[_builtins.str] = None,
                 source_identity: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 transitive_tag_keys: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str duration: The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        :param _builtins.str external_id: A unique identifier that might be required when you assume a role in another account.
        :param _builtins.str policy: IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param Sequence[_builtins.str] policy_arns: Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        :param _builtins.str role_arn: Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        :param _builtins.str session_name: An identifier for the assumed role session.
        :param _builtins.str source_identity: Source identity specified by the principal assuming the role.
        :param Mapping[str, _builtins.str] tags: Assume role session tags.
        :param Sequence[_builtins.str] transitive_tag_keys: Assume role session tag keys to pass to any subsequent sessions.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if source_identity is not None:
            pulumi.set(__self__, "source_identity", source_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitive_tag_keys is not None:
            pulumi.set(__self__, "transitive_tag_keys", transitive_tag_keys)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[_builtins.str]:
        """
        A unique identifier that might be required when you assume a role in another account.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[Sequence[_builtins.str]]:
        """
        Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy_arns")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[_builtins.str]:
        """
        An identifier for the assumed role session.
        """
        return pulumi.get(self, "session_name")

    @_builtins.property
    @pulumi.getter(name="sourceIdentity")
    def source_identity(self) -> Optional[_builtins.str]:
        """
        Source identity specified by the principal assuming the role.
        """
        return pulumi.get(self, "source_identity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Assume role session tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitiveTagKeys")
    def transitive_tag_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        Assume role session tag keys to pass to any subsequent sessions.
        """
        return pulumi.get(self, "transitive_tag_keys")


@pulumi.output_type
class DefaultTags(dict):
    def __init__(__self__, *,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] tags: Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class Endpoints(dict):
    def __init__(__self__, *,
                 accessanalyzer: Optional[_builtins.str] = None,
                 account: Optional[_builtins.str] = None,
                 acm: Optional[_builtins.str] = None,
                 acmpca: Optional[_builtins.str] = None,
                 amg: Optional[_builtins.str] = None,
                 amp: Optional[_builtins.str] = None,
                 amplify: Optional[_builtins.str] = None,
                 apigateway: Optional[_builtins.str] = None,
                 apigatewayv2: Optional[_builtins.str] = None,
                 appautoscaling: Optional[_builtins.str] = None,
                 appconfig: Optional[_builtins.str] = None,
                 appfabric: Optional[_builtins.str] = None,
                 appflow: Optional[_builtins.str] = None,
                 appintegrations: Optional[_builtins.str] = None,
                 appintegrationsservice: Optional[_builtins.str] = None,
                 applicationautoscaling: Optional[_builtins.str] = None,
                 applicationinsights: Optional[_builtins.str] = None,
                 applicationsignals: Optional[_builtins.str] = None,
                 appmesh: Optional[_builtins.str] = None,
                 appregistry: Optional[_builtins.str] = None,
                 apprunner: Optional[_builtins.str] = None,
                 appstream: Optional[_builtins.str] = None,
                 appsync: Optional[_builtins.str] = None,
                 arcregionswitch: Optional[_builtins.str] = None,
                 athena: Optional[_builtins.str] = None,
                 auditmanager: Optional[_builtins.str] = None,
                 autoscaling: Optional[_builtins.str] = None,
                 autoscalingplans: Optional[_builtins.str] = None,
                 backup: Optional[_builtins.str] = None,
                 batch: Optional[_builtins.str] = None,
                 bcmdataexports: Optional[_builtins.str] = None,
                 beanstalk: Optional[_builtins.str] = None,
                 bedrock: Optional[_builtins.str] = None,
                 bedrockagent: Optional[_builtins.str] = None,
                 bedrockagentcore: Optional[_builtins.str] = None,
                 billing: Optional[_builtins.str] = None,
                 budgets: Optional[_builtins.str] = None,
                 ce: Optional[_builtins.str] = None,
                 chatbot: Optional[_builtins.str] = None,
                 chime: Optional[_builtins.str] = None,
                 chimesdkmediapipelines: Optional[_builtins.str] = None,
                 chimesdkvoice: Optional[_builtins.str] = None,
                 cleanrooms: Optional[_builtins.str] = None,
                 cloud9: Optional[_builtins.str] = None,
                 cloudcontrol: Optional[_builtins.str] = None,
                 cloudcontrolapi: Optional[_builtins.str] = None,
                 cloudformation: Optional[_builtins.str] = None,
                 cloudfront: Optional[_builtins.str] = None,
                 cloudfrontkeyvaluestore: Optional[_builtins.str] = None,
                 cloudhsm: Optional[_builtins.str] = None,
                 cloudhsmv2: Optional[_builtins.str] = None,
                 cloudsearch: Optional[_builtins.str] = None,
                 cloudtrail: Optional[_builtins.str] = None,
                 cloudwatch: Optional[_builtins.str] = None,
                 cloudwatchevents: Optional[_builtins.str] = None,
                 cloudwatchevidently: Optional[_builtins.str] = None,
                 cloudwatchlog: Optional[_builtins.str] = None,
                 cloudwatchlogs: Optional[_builtins.str] = None,
                 cloudwatchobservabilityaccessmanager: Optional[_builtins.str] = None,
                 cloudwatchrum: Optional[_builtins.str] = None,
                 codeartifact: Optional[_builtins.str] = None,
                 codebuild: Optional[_builtins.str] = None,
                 codecatalyst: Optional[_builtins.str] = None,
                 codecommit: Optional[_builtins.str] = None,
                 codeconnections: Optional[_builtins.str] = None,
                 codedeploy: Optional[_builtins.str] = None,
                 codeguruprofiler: Optional[_builtins.str] = None,
                 codegurureviewer: Optional[_builtins.str] = None,
                 codepipeline: Optional[_builtins.str] = None,
                 codestarconnections: Optional[_builtins.str] = None,
                 codestarnotifications: Optional[_builtins.str] = None,
                 cognitoidentity: Optional[_builtins.str] = None,
                 cognitoidentityprovider: Optional[_builtins.str] = None,
                 cognitoidp: Optional[_builtins.str] = None,
                 comprehend: Optional[_builtins.str] = None,
                 computeoptimizer: Optional[_builtins.str] = None,
                 config: Optional[_builtins.str] = None,
                 configservice: Optional[_builtins.str] = None,
                 connect: Optional[_builtins.str] = None,
                 connectcases: Optional[_builtins.str] = None,
                 controltower: Optional[_builtins.str] = None,
                 costandusagereportservice: Optional[_builtins.str] = None,
                 costexplorer: Optional[_builtins.str] = None,
                 costoptimizationhub: Optional[_builtins.str] = None,
                 cur: Optional[_builtins.str] = None,
                 customerprofiles: Optional[_builtins.str] = None,
                 databasemigration: Optional[_builtins.str] = None,
                 databasemigrationservice: Optional[_builtins.str] = None,
                 databrew: Optional[_builtins.str] = None,
                 dataexchange: Optional[_builtins.str] = None,
                 datapipeline: Optional[_builtins.str] = None,
                 datasync: Optional[_builtins.str] = None,
                 datazone: Optional[_builtins.str] = None,
                 dax: Optional[_builtins.str] = None,
                 deploy: Optional[_builtins.str] = None,
                 detective: Optional[_builtins.str] = None,
                 devicefarm: Optional[_builtins.str] = None,
                 devopsguru: Optional[_builtins.str] = None,
                 directconnect: Optional[_builtins.str] = None,
                 directoryservice: Optional[_builtins.str] = None,
                 dlm: Optional[_builtins.str] = None,
                 dms: Optional[_builtins.str] = None,
                 docdb: Optional[_builtins.str] = None,
                 docdbelastic: Optional[_builtins.str] = None,
                 drs: Optional[_builtins.str] = None,
                 ds: Optional[_builtins.str] = None,
                 dsql: Optional[_builtins.str] = None,
                 dynamodb: Optional[_builtins.str] = None,
                 ec2: Optional[_builtins.str] = None,
                 ecr: Optional[_builtins.str] = None,
                 ecrpublic: Optional[_builtins.str] = None,
                 ecs: Optional[_builtins.str] = None,
                 efs: Optional[_builtins.str] = None,
                 eks: Optional[_builtins.str] = None,
                 elasticache: Optional[_builtins.str] = None,
                 elasticbeanstalk: Optional[_builtins.str] = None,
                 elasticloadbalancing: Optional[_builtins.str] = None,
                 elasticloadbalancingv2: Optional[_builtins.str] = None,
                 elasticsearch: Optional[_builtins.str] = None,
                 elasticsearchservice: Optional[_builtins.str] = None,
                 elastictranscoder: Optional[_builtins.str] = None,
                 elb: Optional[_builtins.str] = None,
                 elbv2: Optional[_builtins.str] = None,
                 emr: Optional[_builtins.str] = None,
                 emrcontainers: Optional[_builtins.str] = None,
                 emrserverless: Optional[_builtins.str] = None,
                 es: Optional[_builtins.str] = None,
                 eventbridge: Optional[_builtins.str] = None,
                 events: Optional[_builtins.str] = None,
                 evidently: Optional[_builtins.str] = None,
                 evs: Optional[_builtins.str] = None,
                 finspace: Optional[_builtins.str] = None,
                 firehose: Optional[_builtins.str] = None,
                 fis: Optional[_builtins.str] = None,
                 fms: Optional[_builtins.str] = None,
                 fsx: Optional[_builtins.str] = None,
                 gamelift: Optional[_builtins.str] = None,
                 glacier: Optional[_builtins.str] = None,
                 globalaccelerator: Optional[_builtins.str] = None,
                 glue: Optional[_builtins.str] = None,
                 gluedatabrew: Optional[_builtins.str] = None,
                 grafana: Optional[_builtins.str] = None,
                 greengrass: Optional[_builtins.str] = None,
                 groundstation: Optional[_builtins.str] = None,
                 guardduty: Optional[_builtins.str] = None,
                 healthlake: Optional[_builtins.str] = None,
                 iam: Optional[_builtins.str] = None,
                 identitystore: Optional[_builtins.str] = None,
                 imagebuilder: Optional[_builtins.str] = None,
                 inspector: Optional[_builtins.str] = None,
                 inspector2: Optional[_builtins.str] = None,
                 inspectorv2: Optional[_builtins.str] = None,
                 internetmonitor: Optional[_builtins.str] = None,
                 invoicing: Optional[_builtins.str] = None,
                 iot: Optional[_builtins.str] = None,
                 ivs: Optional[_builtins.str] = None,
                 ivschat: Optional[_builtins.str] = None,
                 kafka: Optional[_builtins.str] = None,
                 kafkaconnect: Optional[_builtins.str] = None,
                 kendra: Optional[_builtins.str] = None,
                 keyspaces: Optional[_builtins.str] = None,
                 kinesis: Optional[_builtins.str] = None,
                 kinesisanalytics: Optional[_builtins.str] = None,
                 kinesisanalyticsv2: Optional[_builtins.str] = None,
                 kinesisvideo: Optional[_builtins.str] = None,
                 kms: Optional[_builtins.str] = None,
                 lakeformation: Optional[_builtins.str] = None,
                 lambda_: Optional[_builtins.str] = None,
                 launchwizard: Optional[_builtins.str] = None,
                 lex: Optional[_builtins.str] = None,
                 lexmodelbuilding: Optional[_builtins.str] = None,
                 lexmodelbuildingservice: Optional[_builtins.str] = None,
                 lexmodels: Optional[_builtins.str] = None,
                 lexmodelsv2: Optional[_builtins.str] = None,
                 lexv2models: Optional[_builtins.str] = None,
                 licensemanager: Optional[_builtins.str] = None,
                 lightsail: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 locationservice: Optional[_builtins.str] = None,
                 logs: Optional[_builtins.str] = None,
                 lookoutmetrics: Optional[_builtins.str] = None,
                 m2: Optional[_builtins.str] = None,
                 macie2: Optional[_builtins.str] = None,
                 managedgrafana: Optional[_builtins.str] = None,
                 mediaconnect: Optional[_builtins.str] = None,
                 mediaconvert: Optional[_builtins.str] = None,
                 medialive: Optional[_builtins.str] = None,
                 mediapackage: Optional[_builtins.str] = None,
                 mediapackagev2: Optional[_builtins.str] = None,
                 mediapackagevod: Optional[_builtins.str] = None,
                 mediastore: Optional[_builtins.str] = None,
                 memorydb: Optional[_builtins.str] = None,
                 mgn: Optional[_builtins.str] = None,
                 mq: Optional[_builtins.str] = None,
                 msk: Optional[_builtins.str] = None,
                 mwaa: Optional[_builtins.str] = None,
                 neptune: Optional[_builtins.str] = None,
                 neptunegraph: Optional[_builtins.str] = None,
                 networkfirewall: Optional[_builtins.str] = None,
                 networkflowmonitor: Optional[_builtins.str] = None,
                 networkmanager: Optional[_builtins.str] = None,
                 networkmonitor: Optional[_builtins.str] = None,
                 notifications: Optional[_builtins.str] = None,
                 notificationscontacts: Optional[_builtins.str] = None,
                 oam: Optional[_builtins.str] = None,
                 observabilityadmin: Optional[_builtins.str] = None,
                 odb: Optional[_builtins.str] = None,
                 opensearch: Optional[_builtins.str] = None,
                 opensearchingestion: Optional[_builtins.str] = None,
                 opensearchserverless: Optional[_builtins.str] = None,
                 opensearchservice: Optional[_builtins.str] = None,
                 organizations: Optional[_builtins.str] = None,
                 osis: Optional[_builtins.str] = None,
                 outposts: Optional[_builtins.str] = None,
                 paymentcryptography: Optional[_builtins.str] = None,
                 pcaconnectorad: Optional[_builtins.str] = None,
                 pcs: Optional[_builtins.str] = None,
                 pinpoint: Optional[_builtins.str] = None,
                 pinpointsmsvoicev2: Optional[_builtins.str] = None,
                 pipes: Optional[_builtins.str] = None,
                 polly: Optional[_builtins.str] = None,
                 pricing: Optional[_builtins.str] = None,
                 prometheus: Optional[_builtins.str] = None,
                 prometheusservice: Optional[_builtins.str] = None,
                 qbusiness: Optional[_builtins.str] = None,
                 qldb: Optional[_builtins.str] = None,
                 quicksight: Optional[_builtins.str] = None,
                 ram: Optional[_builtins.str] = None,
                 rbin: Optional[_builtins.str] = None,
                 rds: Optional[_builtins.str] = None,
                 recyclebin: Optional[_builtins.str] = None,
                 redshift: Optional[_builtins.str] = None,
                 redshiftdata: Optional[_builtins.str] = None,
                 redshiftdataapiservice: Optional[_builtins.str] = None,
                 redshiftserverless: Optional[_builtins.str] = None,
                 rekognition: Optional[_builtins.str] = None,
                 resiliencehub: Optional[_builtins.str] = None,
                 resourceexplorer2: Optional[_builtins.str] = None,
                 resourcegroups: Optional[_builtins.str] = None,
                 resourcegroupstagging: Optional[_builtins.str] = None,
                 resourcegroupstaggingapi: Optional[_builtins.str] = None,
                 rolesanywhere: Optional[_builtins.str] = None,
                 route53: Optional[_builtins.str] = None,
                 route53domains: Optional[_builtins.str] = None,
                 route53profiles: Optional[_builtins.str] = None,
                 route53recoverycontrolconfig: Optional[_builtins.str] = None,
                 route53recoveryreadiness: Optional[_builtins.str] = None,
                 route53resolver: Optional[_builtins.str] = None,
                 rum: Optional[_builtins.str] = None,
                 s3: Optional[_builtins.str] = None,
                 s3api: Optional[_builtins.str] = None,
                 s3control: Optional[_builtins.str] = None,
                 s3outposts: Optional[_builtins.str] = None,
                 s3tables: Optional[_builtins.str] = None,
                 s3vectors: Optional[_builtins.str] = None,
                 sagemaker: Optional[_builtins.str] = None,
                 scheduler: Optional[_builtins.str] = None,
                 schemas: Optional[_builtins.str] = None,
                 secretsmanager: Optional[_builtins.str] = None,
                 securityhub: Optional[_builtins.str] = None,
                 securitylake: Optional[_builtins.str] = None,
                 serverlessapplicationrepository: Optional[_builtins.str] = None,
                 serverlessapprepo: Optional[_builtins.str] = None,
                 serverlessrepo: Optional[_builtins.str] = None,
                 servicecatalog: Optional[_builtins.str] = None,
                 servicecatalogappregistry: Optional[_builtins.str] = None,
                 servicediscovery: Optional[_builtins.str] = None,
                 servicequotas: Optional[_builtins.str] = None,
                 ses: Optional[_builtins.str] = None,
                 sesv2: Optional[_builtins.str] = None,
                 sfn: Optional[_builtins.str] = None,
                 shield: Optional[_builtins.str] = None,
                 signer: Optional[_builtins.str] = None,
                 sns: Optional[_builtins.str] = None,
                 sqs: Optional[_builtins.str] = None,
                 ssm: Optional[_builtins.str] = None,
                 ssmcontacts: Optional[_builtins.str] = None,
                 ssmincidents: Optional[_builtins.str] = None,
                 ssmquicksetup: Optional[_builtins.str] = None,
                 ssmsap: Optional[_builtins.str] = None,
                 sso: Optional[_builtins.str] = None,
                 ssoadmin: Optional[_builtins.str] = None,
                 stepfunctions: Optional[_builtins.str] = None,
                 storagegateway: Optional[_builtins.str] = None,
                 sts: Optional[_builtins.str] = None,
                 swf: Optional[_builtins.str] = None,
                 synthetics: Optional[_builtins.str] = None,
                 taxsettings: Optional[_builtins.str] = None,
                 timestreaminfluxdb: Optional[_builtins.str] = None,
                 timestreamquery: Optional[_builtins.str] = None,
                 timestreamwrite: Optional[_builtins.str] = None,
                 transcribe: Optional[_builtins.str] = None,
                 transcribeservice: Optional[_builtins.str] = None,
                 transfer: Optional[_builtins.str] = None,
                 verifiedpermissions: Optional[_builtins.str] = None,
                 vpclattice: Optional[_builtins.str] = None,
                 waf: Optional[_builtins.str] = None,
                 wafregional: Optional[_builtins.str] = None,
                 wafv2: Optional[_builtins.str] = None,
                 wellarchitected: Optional[_builtins.str] = None,
                 workmail: Optional[_builtins.str] = None,
                 workspaces: Optional[_builtins.str] = None,
                 workspacesweb: Optional[_builtins.str] = None,
                 xray: Optional[_builtins.str] = None):
        """
        :param _builtins.str accessanalyzer: Use this to override the default service endpoint URL
        :param _builtins.str account: Use this to override the default service endpoint URL
        :param _builtins.str acm: Use this to override the default service endpoint URL
        :param _builtins.str acmpca: Use this to override the default service endpoint URL
        :param _builtins.str amg: Use this to override the default service endpoint URL
        :param _builtins.str amp: Use this to override the default service endpoint URL
        :param _builtins.str amplify: Use this to override the default service endpoint URL
        :param _builtins.str apigateway: Use this to override the default service endpoint URL
        :param _builtins.str apigatewayv2: Use this to override the default service endpoint URL
        :param _builtins.str appautoscaling: Use this to override the default service endpoint URL
        :param _builtins.str appconfig: Use this to override the default service endpoint URL
        :param _builtins.str appfabric: Use this to override the default service endpoint URL
        :param _builtins.str appflow: Use this to override the default service endpoint URL
        :param _builtins.str appintegrations: Use this to override the default service endpoint URL
        :param _builtins.str appintegrationsservice: Use this to override the default service endpoint URL
        :param _builtins.str applicationautoscaling: Use this to override the default service endpoint URL
        :param _builtins.str applicationinsights: Use this to override the default service endpoint URL
        :param _builtins.str applicationsignals: Use this to override the default service endpoint URL
        :param _builtins.str appmesh: Use this to override the default service endpoint URL
        :param _builtins.str appregistry: Use this to override the default service endpoint URL
        :param _builtins.str apprunner: Use this to override the default service endpoint URL
        :param _builtins.str appstream: Use this to override the default service endpoint URL
        :param _builtins.str appsync: Use this to override the default service endpoint URL
        :param _builtins.str arcregionswitch: Use this to override the default service endpoint URL
        :param _builtins.str athena: Use this to override the default service endpoint URL
        :param _builtins.str auditmanager: Use this to override the default service endpoint URL
        :param _builtins.str autoscaling: Use this to override the default service endpoint URL
        :param _builtins.str autoscalingplans: Use this to override the default service endpoint URL
        :param _builtins.str backup: Use this to override the default service endpoint URL
        :param _builtins.str batch: Use this to override the default service endpoint URL
        :param _builtins.str bcmdataexports: Use this to override the default service endpoint URL
        :param _builtins.str beanstalk: Use this to override the default service endpoint URL
        :param _builtins.str bedrock: Use this to override the default service endpoint URL
        :param _builtins.str bedrockagent: Use this to override the default service endpoint URL
        :param _builtins.str bedrockagentcore: Use this to override the default service endpoint URL
        :param _builtins.str billing: Use this to override the default service endpoint URL
        :param _builtins.str budgets: Use this to override the default service endpoint URL
        :param _builtins.str ce: Use this to override the default service endpoint URL
        :param _builtins.str chatbot: Use this to override the default service endpoint URL
        :param _builtins.str chime: Use this to override the default service endpoint URL
        :param _builtins.str chimesdkmediapipelines: Use this to override the default service endpoint URL
        :param _builtins.str chimesdkvoice: Use this to override the default service endpoint URL
        :param _builtins.str cleanrooms: Use this to override the default service endpoint URL
        :param _builtins.str cloud9: Use this to override the default service endpoint URL
        :param _builtins.str cloudcontrol: Use this to override the default service endpoint URL
        :param _builtins.str cloudcontrolapi: Use this to override the default service endpoint URL
        :param _builtins.str cloudformation: Use this to override the default service endpoint URL
        :param _builtins.str cloudfront: Use this to override the default service endpoint URL
        :param _builtins.str cloudfrontkeyvaluestore: Use this to override the default service endpoint URL
        :param _builtins.str cloudhsm: Use this to override the default service endpoint URL
        :param _builtins.str cloudhsmv2: Use this to override the default service endpoint URL
        :param _builtins.str cloudsearch: Use this to override the default service endpoint URL
        :param _builtins.str cloudtrail: Use this to override the default service endpoint URL
        :param _builtins.str cloudwatch: Use this to override the default service endpoint URL
        :param _builtins.str cloudwatchevents: Use this to override the default service endpoint URL
        :param _builtins.str cloudwatchevidently: Use this to override the default service endpoint URL
        :param _builtins.str cloudwatchlog: Use this to override the default service endpoint URL
        :param _builtins.str cloudwatchlogs: Use this to override the default service endpoint URL
        :param _builtins.str cloudwatchobservabilityaccessmanager: Use this to override the default service endpoint URL
        :param _builtins.str cloudwatchrum: Use this to override the default service endpoint URL
        :param _builtins.str codeartifact: Use this to override the default service endpoint URL
        :param _builtins.str codebuild: Use this to override the default service endpoint URL
        :param _builtins.str codecatalyst: Use this to override the default service endpoint URL
        :param _builtins.str codecommit: Use this to override the default service endpoint URL
        :param _builtins.str codeconnections: Use this to override the default service endpoint URL
        :param _builtins.str codedeploy: Use this to override the default service endpoint URL
        :param _builtins.str codeguruprofiler: Use this to override the default service endpoint URL
        :param _builtins.str codegurureviewer: Use this to override the default service endpoint URL
        :param _builtins.str codepipeline: Use this to override the default service endpoint URL
        :param _builtins.str codestarconnections: Use this to override the default service endpoint URL
        :param _builtins.str codestarnotifications: Use this to override the default service endpoint URL
        :param _builtins.str cognitoidentity: Use this to override the default service endpoint URL
        :param _builtins.str cognitoidentityprovider: Use this to override the default service endpoint URL
        :param _builtins.str cognitoidp: Use this to override the default service endpoint URL
        :param _builtins.str comprehend: Use this to override the default service endpoint URL
        :param _builtins.str computeoptimizer: Use this to override the default service endpoint URL
        :param _builtins.str config: Use this to override the default service endpoint URL
        :param _builtins.str configservice: Use this to override the default service endpoint URL
        :param _builtins.str connect: Use this to override the default service endpoint URL
        :param _builtins.str connectcases: Use this to override the default service endpoint URL
        :param _builtins.str controltower: Use this to override the default service endpoint URL
        :param _builtins.str costandusagereportservice: Use this to override the default service endpoint URL
        :param _builtins.str costexplorer: Use this to override the default service endpoint URL
        :param _builtins.str costoptimizationhub: Use this to override the default service endpoint URL
        :param _builtins.str cur: Use this to override the default service endpoint URL
        :param _builtins.str customerprofiles: Use this to override the default service endpoint URL
        :param _builtins.str databasemigration: Use this to override the default service endpoint URL
        :param _builtins.str databasemigrationservice: Use this to override the default service endpoint URL
        :param _builtins.str databrew: Use this to override the default service endpoint URL
        :param _builtins.str dataexchange: Use this to override the default service endpoint URL
        :param _builtins.str datapipeline: Use this to override the default service endpoint URL
        :param _builtins.str datasync: Use this to override the default service endpoint URL
        :param _builtins.str datazone: Use this to override the default service endpoint URL
        :param _builtins.str dax: Use this to override the default service endpoint URL
        :param _builtins.str deploy: Use this to override the default service endpoint URL
        :param _builtins.str detective: Use this to override the default service endpoint URL
        :param _builtins.str devicefarm: Use this to override the default service endpoint URL
        :param _builtins.str devopsguru: Use this to override the default service endpoint URL
        :param _builtins.str directconnect: Use this to override the default service endpoint URL
        :param _builtins.str directoryservice: Use this to override the default service endpoint URL
        :param _builtins.str dlm: Use this to override the default service endpoint URL
        :param _builtins.str dms: Use this to override the default service endpoint URL
        :param _builtins.str docdb: Use this to override the default service endpoint URL
        :param _builtins.str docdbelastic: Use this to override the default service endpoint URL
        :param _builtins.str drs: Use this to override the default service endpoint URL
        :param _builtins.str ds: Use this to override the default service endpoint URL
        :param _builtins.str dsql: Use this to override the default service endpoint URL
        :param _builtins.str dynamodb: Use this to override the default service endpoint URL
        :param _builtins.str ec2: Use this to override the default service endpoint URL
        :param _builtins.str ecr: Use this to override the default service endpoint URL
        :param _builtins.str ecrpublic: Use this to override the default service endpoint URL
        :param _builtins.str ecs: Use this to override the default service endpoint URL
        :param _builtins.str efs: Use this to override the default service endpoint URL
        :param _builtins.str eks: Use this to override the default service endpoint URL
        :param _builtins.str elasticache: Use this to override the default service endpoint URL
        :param _builtins.str elasticbeanstalk: Use this to override the default service endpoint URL
        :param _builtins.str elasticloadbalancing: Use this to override the default service endpoint URL
        :param _builtins.str elasticloadbalancingv2: Use this to override the default service endpoint URL
        :param _builtins.str elasticsearch: Use this to override the default service endpoint URL
        :param _builtins.str elasticsearchservice: Use this to override the default service endpoint URL
        :param _builtins.str elastictranscoder: Use this to override the default service endpoint URL
        :param _builtins.str elb: Use this to override the default service endpoint URL
        :param _builtins.str elbv2: Use this to override the default service endpoint URL
        :param _builtins.str emr: Use this to override the default service endpoint URL
        :param _builtins.str emrcontainers: Use this to override the default service endpoint URL
        :param _builtins.str emrserverless: Use this to override the default service endpoint URL
        :param _builtins.str es: Use this to override the default service endpoint URL
        :param _builtins.str eventbridge: Use this to override the default service endpoint URL
        :param _builtins.str events: Use this to override the default service endpoint URL
        :param _builtins.str evidently: Use this to override the default service endpoint URL
        :param _builtins.str evs: Use this to override the default service endpoint URL
        :param _builtins.str finspace: Use this to override the default service endpoint URL
        :param _builtins.str firehose: Use this to override the default service endpoint URL
        :param _builtins.str fis: Use this to override the default service endpoint URL
        :param _builtins.str fms: Use this to override the default service endpoint URL
        :param _builtins.str fsx: Use this to override the default service endpoint URL
        :param _builtins.str gamelift: Use this to override the default service endpoint URL
        :param _builtins.str glacier: Use this to override the default service endpoint URL
        :param _builtins.str globalaccelerator: Use this to override the default service endpoint URL
        :param _builtins.str glue: Use this to override the default service endpoint URL
        :param _builtins.str gluedatabrew: Use this to override the default service endpoint URL
        :param _builtins.str grafana: Use this to override the default service endpoint URL
        :param _builtins.str greengrass: Use this to override the default service endpoint URL
        :param _builtins.str groundstation: Use this to override the default service endpoint URL
        :param _builtins.str guardduty: Use this to override the default service endpoint URL
        :param _builtins.str healthlake: Use this to override the default service endpoint URL
        :param _builtins.str iam: Use this to override the default service endpoint URL
        :param _builtins.str identitystore: Use this to override the default service endpoint URL
        :param _builtins.str imagebuilder: Use this to override the default service endpoint URL
        :param _builtins.str inspector: Use this to override the default service endpoint URL
        :param _builtins.str inspector2: Use this to override the default service endpoint URL
        :param _builtins.str inspectorv2: Use this to override the default service endpoint URL
        :param _builtins.str internetmonitor: Use this to override the default service endpoint URL
        :param _builtins.str invoicing: Use this to override the default service endpoint URL
        :param _builtins.str iot: Use this to override the default service endpoint URL
        :param _builtins.str ivs: Use this to override the default service endpoint URL
        :param _builtins.str ivschat: Use this to override the default service endpoint URL
        :param _builtins.str kafka: Use this to override the default service endpoint URL
        :param _builtins.str kafkaconnect: Use this to override the default service endpoint URL
        :param _builtins.str kendra: Use this to override the default service endpoint URL
        :param _builtins.str keyspaces: Use this to override the default service endpoint URL
        :param _builtins.str kinesis: Use this to override the default service endpoint URL
        :param _builtins.str kinesisanalytics: Use this to override the default service endpoint URL
        :param _builtins.str kinesisanalyticsv2: Use this to override the default service endpoint URL
        :param _builtins.str kinesisvideo: Use this to override the default service endpoint URL
        :param _builtins.str kms: Use this to override the default service endpoint URL
        :param _builtins.str lakeformation: Use this to override the default service endpoint URL
        :param _builtins.str lambda_: Use this to override the default service endpoint URL
        :param _builtins.str launchwizard: Use this to override the default service endpoint URL
        :param _builtins.str lex: Use this to override the default service endpoint URL
        :param _builtins.str lexmodelbuilding: Use this to override the default service endpoint URL
        :param _builtins.str lexmodelbuildingservice: Use this to override the default service endpoint URL
        :param _builtins.str lexmodels: Use this to override the default service endpoint URL
        :param _builtins.str lexmodelsv2: Use this to override the default service endpoint URL
        :param _builtins.str lexv2models: Use this to override the default service endpoint URL
        :param _builtins.str licensemanager: Use this to override the default service endpoint URL
        :param _builtins.str lightsail: Use this to override the default service endpoint URL
        :param _builtins.str location: Use this to override the default service endpoint URL
        :param _builtins.str locationservice: Use this to override the default service endpoint URL
        :param _builtins.str logs: Use this to override the default service endpoint URL
        :param _builtins.str lookoutmetrics: Use this to override the default service endpoint URL
        :param _builtins.str m2: Use this to override the default service endpoint URL
        :param _builtins.str macie2: Use this to override the default service endpoint URL
        :param _builtins.str managedgrafana: Use this to override the default service endpoint URL
        :param _builtins.str mediaconnect: Use this to override the default service endpoint URL
        :param _builtins.str mediaconvert: Use this to override the default service endpoint URL
        :param _builtins.str medialive: Use this to override the default service endpoint URL
        :param _builtins.str mediapackage: Use this to override the default service endpoint URL
        :param _builtins.str mediapackagev2: Use this to override the default service endpoint URL
        :param _builtins.str mediapackagevod: Use this to override the default service endpoint URL
        :param _builtins.str mediastore: Use this to override the default service endpoint URL
        :param _builtins.str memorydb: Use this to override the default service endpoint URL
        :param _builtins.str mgn: Use this to override the default service endpoint URL
        :param _builtins.str mq: Use this to override the default service endpoint URL
        :param _builtins.str msk: Use this to override the default service endpoint URL
        :param _builtins.str mwaa: Use this to override the default service endpoint URL
        :param _builtins.str neptune: Use this to override the default service endpoint URL
        :param _builtins.str neptunegraph: Use this to override the default service endpoint URL
        :param _builtins.str networkfirewall: Use this to override the default service endpoint URL
        :param _builtins.str networkflowmonitor: Use this to override the default service endpoint URL
        :param _builtins.str networkmanager: Use this to override the default service endpoint URL
        :param _builtins.str networkmonitor: Use this to override the default service endpoint URL
        :param _builtins.str notifications: Use this to override the default service endpoint URL
        :param _builtins.str notificationscontacts: Use this to override the default service endpoint URL
        :param _builtins.str oam: Use this to override the default service endpoint URL
        :param _builtins.str observabilityadmin: Use this to override the default service endpoint URL
        :param _builtins.str odb: Use this to override the default service endpoint URL
        :param _builtins.str opensearch: Use this to override the default service endpoint URL
        :param _builtins.str opensearchingestion: Use this to override the default service endpoint URL
        :param _builtins.str opensearchserverless: Use this to override the default service endpoint URL
        :param _builtins.str opensearchservice: Use this to override the default service endpoint URL
        :param _builtins.str organizations: Use this to override the default service endpoint URL
        :param _builtins.str osis: Use this to override the default service endpoint URL
        :param _builtins.str outposts: Use this to override the default service endpoint URL
        :param _builtins.str paymentcryptography: Use this to override the default service endpoint URL
        :param _builtins.str pcaconnectorad: Use this to override the default service endpoint URL
        :param _builtins.str pcs: Use this to override the default service endpoint URL
        :param _builtins.str pinpoint: Use this to override the default service endpoint URL
        :param _builtins.str pinpointsmsvoicev2: Use this to override the default service endpoint URL
        :param _builtins.str pipes: Use this to override the default service endpoint URL
        :param _builtins.str polly: Use this to override the default service endpoint URL
        :param _builtins.str pricing: Use this to override the default service endpoint URL
        :param _builtins.str prometheus: Use this to override the default service endpoint URL
        :param _builtins.str prometheusservice: Use this to override the default service endpoint URL
        :param _builtins.str qbusiness: Use this to override the default service endpoint URL
        :param _builtins.str qldb: Use this to override the default service endpoint URL
        :param _builtins.str quicksight: Use this to override the default service endpoint URL
        :param _builtins.str ram: Use this to override the default service endpoint URL
        :param _builtins.str rbin: Use this to override the default service endpoint URL
        :param _builtins.str rds: Use this to override the default service endpoint URL
        :param _builtins.str recyclebin: Use this to override the default service endpoint URL
        :param _builtins.str redshift: Use this to override the default service endpoint URL
        :param _builtins.str redshiftdata: Use this to override the default service endpoint URL
        :param _builtins.str redshiftdataapiservice: Use this to override the default service endpoint URL
        :param _builtins.str redshiftserverless: Use this to override the default service endpoint URL
        :param _builtins.str rekognition: Use this to override the default service endpoint URL
        :param _builtins.str resiliencehub: Use this to override the default service endpoint URL
        :param _builtins.str resourceexplorer2: Use this to override the default service endpoint URL
        :param _builtins.str resourcegroups: Use this to override the default service endpoint URL
        :param _builtins.str resourcegroupstagging: Use this to override the default service endpoint URL
        :param _builtins.str resourcegroupstaggingapi: Use this to override the default service endpoint URL
        :param _builtins.str rolesanywhere: Use this to override the default service endpoint URL
        :param _builtins.str route53: Use this to override the default service endpoint URL
        :param _builtins.str route53domains: Use this to override the default service endpoint URL
        :param _builtins.str route53profiles: Use this to override the default service endpoint URL
        :param _builtins.str route53recoverycontrolconfig: Use this to override the default service endpoint URL
        :param _builtins.str route53recoveryreadiness: Use this to override the default service endpoint URL
        :param _builtins.str route53resolver: Use this to override the default service endpoint URL
        :param _builtins.str rum: Use this to override the default service endpoint URL
        :param _builtins.str s3: Use this to override the default service endpoint URL
        :param _builtins.str s3api: Use this to override the default service endpoint URL
        :param _builtins.str s3control: Use this to override the default service endpoint URL
        :param _builtins.str s3outposts: Use this to override the default service endpoint URL
        :param _builtins.str s3tables: Use this to override the default service endpoint URL
        :param _builtins.str s3vectors: Use this to override the default service endpoint URL
        :param _builtins.str sagemaker: Use this to override the default service endpoint URL
        :param _builtins.str scheduler: Use this to override the default service endpoint URL
        :param _builtins.str schemas: Use this to override the default service endpoint URL
        :param _builtins.str secretsmanager: Use this to override the default service endpoint URL
        :param _builtins.str securityhub: Use this to override the default service endpoint URL
        :param _builtins.str securitylake: Use this to override the default service endpoint URL
        :param _builtins.str serverlessapplicationrepository: Use this to override the default service endpoint URL
        :param _builtins.str serverlessapprepo: Use this to override the default service endpoint URL
        :param _builtins.str serverlessrepo: Use this to override the default service endpoint URL
        :param _builtins.str servicecatalog: Use this to override the default service endpoint URL
        :param _builtins.str servicecatalogappregistry: Use this to override the default service endpoint URL
        :param _builtins.str servicediscovery: Use this to override the default service endpoint URL
        :param _builtins.str servicequotas: Use this to override the default service endpoint URL
        :param _builtins.str ses: Use this to override the default service endpoint URL
        :param _builtins.str sesv2: Use this to override the default service endpoint URL
        :param _builtins.str sfn: Use this to override the default service endpoint URL
        :param _builtins.str shield: Use this to override the default service endpoint URL
        :param _builtins.str signer: Use this to override the default service endpoint URL
        :param _builtins.str sns: Use this to override the default service endpoint URL
        :param _builtins.str sqs: Use this to override the default service endpoint URL
        :param _builtins.str ssm: Use this to override the default service endpoint URL
        :param _builtins.str ssmcontacts: Use this to override the default service endpoint URL
        :param _builtins.str ssmincidents: Use this to override the default service endpoint URL
        :param _builtins.str ssmquicksetup: Use this to override the default service endpoint URL
        :param _builtins.str ssmsap: Use this to override the default service endpoint URL
        :param _builtins.str sso: Use this to override the default service endpoint URL
        :param _builtins.str ssoadmin: Use this to override the default service endpoint URL
        :param _builtins.str stepfunctions: Use this to override the default service endpoint URL
        :param _builtins.str storagegateway: Use this to override the default service endpoint URL
        :param _builtins.str sts: Use this to override the default service endpoint URL
        :param _builtins.str swf: Use this to override the default service endpoint URL
        :param _builtins.str synthetics: Use this to override the default service endpoint URL
        :param _builtins.str taxsettings: Use this to override the default service endpoint URL
        :param _builtins.str timestreaminfluxdb: Use this to override the default service endpoint URL
        :param _builtins.str timestreamquery: Use this to override the default service endpoint URL
        :param _builtins.str timestreamwrite: Use this to override the default service endpoint URL
        :param _builtins.str transcribe: Use this to override the default service endpoint URL
        :param _builtins.str transcribeservice: Use this to override the default service endpoint URL
        :param _builtins.str transfer: Use this to override the default service endpoint URL
        :param _builtins.str verifiedpermissions: Use this to override the default service endpoint URL
        :param _builtins.str vpclattice: Use this to override the default service endpoint URL
        :param _builtins.str waf: Use this to override the default service endpoint URL
        :param _builtins.str wafregional: Use this to override the default service endpoint URL
        :param _builtins.str wafv2: Use this to override the default service endpoint URL
        :param _builtins.str wellarchitected: Use this to override the default service endpoint URL
        :param _builtins.str workmail: Use this to override the default service endpoint URL
        :param _builtins.str workspaces: Use this to override the default service endpoint URL
        :param _builtins.str workspacesweb: Use this to override the default service endpoint URL
        :param _builtins.str xray: Use this to override the default service endpoint URL
        """
        if accessanalyzer is not None:
            pulumi.set(__self__, "accessanalyzer", accessanalyzer)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if acm is not None:
            pulumi.set(__self__, "acm", acm)
        if acmpca is not None:
            pulumi.set(__self__, "acmpca", acmpca)
        if amg is not None:
            pulumi.set(__self__, "amg", amg)
        if amp is not None:
            pulumi.set(__self__, "amp", amp)
        if amplify is not None:
            pulumi.set(__self__, "amplify", amplify)
        if apigateway is not None:
            pulumi.set(__self__, "apigateway", apigateway)
        if apigatewayv2 is not None:
            pulumi.set(__self__, "apigatewayv2", apigatewayv2)
        if appautoscaling is not None:
            pulumi.set(__self__, "appautoscaling", appautoscaling)
        if appconfig is not None:
            pulumi.set(__self__, "appconfig", appconfig)
        if appfabric is not None:
            pulumi.set(__self__, "appfabric", appfabric)
        if appflow is not None:
            pulumi.set(__self__, "appflow", appflow)
        if appintegrations is not None:
            pulumi.set(__self__, "appintegrations", appintegrations)
        if appintegrationsservice is not None:
            pulumi.set(__self__, "appintegrationsservice", appintegrationsservice)
        if applicationautoscaling is not None:
            pulumi.set(__self__, "applicationautoscaling", applicationautoscaling)
        if applicationinsights is not None:
            pulumi.set(__self__, "applicationinsights", applicationinsights)
        if applicationsignals is not None:
            pulumi.set(__self__, "applicationsignals", applicationsignals)
        if appmesh is not None:
            pulumi.set(__self__, "appmesh", appmesh)
        if appregistry is not None:
            pulumi.set(__self__, "appregistry", appregistry)
        if apprunner is not None:
            pulumi.set(__self__, "apprunner", apprunner)
        if appstream is not None:
            pulumi.set(__self__, "appstream", appstream)
        if appsync is not None:
            pulumi.set(__self__, "appsync", appsync)
        if arcregionswitch is not None:
            pulumi.set(__self__, "arcregionswitch", arcregionswitch)
        if athena is not None:
            pulumi.set(__self__, "athena", athena)
        if auditmanager is not None:
            pulumi.set(__self__, "auditmanager", auditmanager)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if autoscalingplans is not None:
            pulumi.set(__self__, "autoscalingplans", autoscalingplans)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if bcmdataexports is not None:
            pulumi.set(__self__, "bcmdataexports", bcmdataexports)
        if beanstalk is not None:
            pulumi.set(__self__, "beanstalk", beanstalk)
        if bedrock is not None:
            pulumi.set(__self__, "bedrock", bedrock)
        if bedrockagent is not None:
            pulumi.set(__self__, "bedrockagent", bedrockagent)
        if bedrockagentcore is not None:
            pulumi.set(__self__, "bedrockagentcore", bedrockagentcore)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if budgets is not None:
            pulumi.set(__self__, "budgets", budgets)
        if ce is not None:
            pulumi.set(__self__, "ce", ce)
        if chatbot is not None:
            pulumi.set(__self__, "chatbot", chatbot)
        if chime is not None:
            pulumi.set(__self__, "chime", chime)
        if chimesdkmediapipelines is not None:
            pulumi.set(__self__, "chimesdkmediapipelines", chimesdkmediapipelines)
        if chimesdkvoice is not None:
            pulumi.set(__self__, "chimesdkvoice", chimesdkvoice)
        if cleanrooms is not None:
            pulumi.set(__self__, "cleanrooms", cleanrooms)
        if cloud9 is not None:
            pulumi.set(__self__, "cloud9", cloud9)
        if cloudcontrol is not None:
            pulumi.set(__self__, "cloudcontrol", cloudcontrol)
        if cloudcontrolapi is not None:
            pulumi.set(__self__, "cloudcontrolapi", cloudcontrolapi)
        if cloudformation is not None:
            pulumi.set(__self__, "cloudformation", cloudformation)
        if cloudfront is not None:
            pulumi.set(__self__, "cloudfront", cloudfront)
        if cloudfrontkeyvaluestore is not None:
            pulumi.set(__self__, "cloudfrontkeyvaluestore", cloudfrontkeyvaluestore)
        if cloudhsm is not None:
            pulumi.set(__self__, "cloudhsm", cloudhsm)
        if cloudhsmv2 is not None:
            pulumi.set(__self__, "cloudhsmv2", cloudhsmv2)
        if cloudsearch is not None:
            pulumi.set(__self__, "cloudsearch", cloudsearch)
        if cloudtrail is not None:
            pulumi.set(__self__, "cloudtrail", cloudtrail)
        if cloudwatch is not None:
            pulumi.set(__self__, "cloudwatch", cloudwatch)
        if cloudwatchevents is not None:
            pulumi.set(__self__, "cloudwatchevents", cloudwatchevents)
        if cloudwatchevidently is not None:
            pulumi.set(__self__, "cloudwatchevidently", cloudwatchevidently)
        if cloudwatchlog is not None:
            pulumi.set(__self__, "cloudwatchlog", cloudwatchlog)
        if cloudwatchlogs is not None:
            pulumi.set(__self__, "cloudwatchlogs", cloudwatchlogs)
        if cloudwatchobservabilityaccessmanager is not None:
            pulumi.set(__self__, "cloudwatchobservabilityaccessmanager", cloudwatchobservabilityaccessmanager)
        if cloudwatchrum is not None:
            pulumi.set(__self__, "cloudwatchrum", cloudwatchrum)
        if codeartifact is not None:
            pulumi.set(__self__, "codeartifact", codeartifact)
        if codebuild is not None:
            pulumi.set(__self__, "codebuild", codebuild)
        if codecatalyst is not None:
            pulumi.set(__self__, "codecatalyst", codecatalyst)
        if codecommit is not None:
            pulumi.set(__self__, "codecommit", codecommit)
        if codeconnections is not None:
            pulumi.set(__self__, "codeconnections", codeconnections)
        if codedeploy is not None:
            pulumi.set(__self__, "codedeploy", codedeploy)
        if codeguruprofiler is not None:
            pulumi.set(__self__, "codeguruprofiler", codeguruprofiler)
        if codegurureviewer is not None:
            pulumi.set(__self__, "codegurureviewer", codegurureviewer)
        if codepipeline is not None:
            pulumi.set(__self__, "codepipeline", codepipeline)
        if codestarconnections is not None:
            pulumi.set(__self__, "codestarconnections", codestarconnections)
        if codestarnotifications is not None:
            pulumi.set(__self__, "codestarnotifications", codestarnotifications)
        if cognitoidentity is not None:
            pulumi.set(__self__, "cognitoidentity", cognitoidentity)
        if cognitoidentityprovider is not None:
            pulumi.set(__self__, "cognitoidentityprovider", cognitoidentityprovider)
        if cognitoidp is not None:
            pulumi.set(__self__, "cognitoidp", cognitoidp)
        if comprehend is not None:
            pulumi.set(__self__, "comprehend", comprehend)
        if computeoptimizer is not None:
            pulumi.set(__self__, "computeoptimizer", computeoptimizer)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if configservice is not None:
            pulumi.set(__self__, "configservice", configservice)
        if connect is not None:
            pulumi.set(__self__, "connect", connect)
        if connectcases is not None:
            pulumi.set(__self__, "connectcases", connectcases)
        if controltower is not None:
            pulumi.set(__self__, "controltower", controltower)
        if costandusagereportservice is not None:
            pulumi.set(__self__, "costandusagereportservice", costandusagereportservice)
        if costexplorer is not None:
            pulumi.set(__self__, "costexplorer", costexplorer)
        if costoptimizationhub is not None:
            pulumi.set(__self__, "costoptimizationhub", costoptimizationhub)
        if cur is not None:
            pulumi.set(__self__, "cur", cur)
        if customerprofiles is not None:
            pulumi.set(__self__, "customerprofiles", customerprofiles)
        if databasemigration is not None:
            pulumi.set(__self__, "databasemigration", databasemigration)
        if databasemigrationservice is not None:
            pulumi.set(__self__, "databasemigrationservice", databasemigrationservice)
        if databrew is not None:
            pulumi.set(__self__, "databrew", databrew)
        if dataexchange is not None:
            pulumi.set(__self__, "dataexchange", dataexchange)
        if datapipeline is not None:
            pulumi.set(__self__, "datapipeline", datapipeline)
        if datasync is not None:
            pulumi.set(__self__, "datasync", datasync)
        if datazone is not None:
            pulumi.set(__self__, "datazone", datazone)
        if dax is not None:
            pulumi.set(__self__, "dax", dax)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if detective is not None:
            pulumi.set(__self__, "detective", detective)
        if devicefarm is not None:
            pulumi.set(__self__, "devicefarm", devicefarm)
        if devopsguru is not None:
            pulumi.set(__self__, "devopsguru", devopsguru)
        if directconnect is not None:
            pulumi.set(__self__, "directconnect", directconnect)
        if directoryservice is not None:
            pulumi.set(__self__, "directoryservice", directoryservice)
        if dlm is not None:
            pulumi.set(__self__, "dlm", dlm)
        if dms is not None:
            pulumi.set(__self__, "dms", dms)
        if docdb is not None:
            pulumi.set(__self__, "docdb", docdb)
        if docdbelastic is not None:
            pulumi.set(__self__, "docdbelastic", docdbelastic)
        if drs is not None:
            pulumi.set(__self__, "drs", drs)
        if ds is not None:
            pulumi.set(__self__, "ds", ds)
        if dsql is not None:
            pulumi.set(__self__, "dsql", dsql)
        if dynamodb is not None:
            pulumi.set(__self__, "dynamodb", dynamodb)
        if ec2 is not None:
            pulumi.set(__self__, "ec2", ec2)
        if ecr is not None:
            pulumi.set(__self__, "ecr", ecr)
        if ecrpublic is not None:
            pulumi.set(__self__, "ecrpublic", ecrpublic)
        if ecs is not None:
            pulumi.set(__self__, "ecs", ecs)
        if efs is not None:
            pulumi.set(__self__, "efs", efs)
        if eks is not None:
            pulumi.set(__self__, "eks", eks)
        if elasticache is not None:
            pulumi.set(__self__, "elasticache", elasticache)
        if elasticbeanstalk is not None:
            pulumi.set(__self__, "elasticbeanstalk", elasticbeanstalk)
        if elasticloadbalancing is not None:
            pulumi.set(__self__, "elasticloadbalancing", elasticloadbalancing)
        if elasticloadbalancingv2 is not None:
            pulumi.set(__self__, "elasticloadbalancingv2", elasticloadbalancingv2)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if elasticsearchservice is not None:
            pulumi.set(__self__, "elasticsearchservice", elasticsearchservice)
        if elastictranscoder is not None:
            pulumi.set(__self__, "elastictranscoder", elastictranscoder)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if elbv2 is not None:
            pulumi.set(__self__, "elbv2", elbv2)
        if emr is not None:
            pulumi.set(__self__, "emr", emr)
        if emrcontainers is not None:
            pulumi.set(__self__, "emrcontainers", emrcontainers)
        if emrserverless is not None:
            pulumi.set(__self__, "emrserverless", emrserverless)
        if es is not None:
            pulumi.set(__self__, "es", es)
        if eventbridge is not None:
            pulumi.set(__self__, "eventbridge", eventbridge)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if evidently is not None:
            pulumi.set(__self__, "evidently", evidently)
        if evs is not None:
            pulumi.set(__self__, "evs", evs)
        if finspace is not None:
            pulumi.set(__self__, "finspace", finspace)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if fis is not None:
            pulumi.set(__self__, "fis", fis)
        if fms is not None:
            pulumi.set(__self__, "fms", fms)
        if fsx is not None:
            pulumi.set(__self__, "fsx", fsx)
        if gamelift is not None:
            pulumi.set(__self__, "gamelift", gamelift)
        if glacier is not None:
            pulumi.set(__self__, "glacier", glacier)
        if globalaccelerator is not None:
            pulumi.set(__self__, "globalaccelerator", globalaccelerator)
        if glue is not None:
            pulumi.set(__self__, "glue", glue)
        if gluedatabrew is not None:
            pulumi.set(__self__, "gluedatabrew", gluedatabrew)
        if grafana is not None:
            pulumi.set(__self__, "grafana", grafana)
        if greengrass is not None:
            pulumi.set(__self__, "greengrass", greengrass)
        if groundstation is not None:
            pulumi.set(__self__, "groundstation", groundstation)
        if guardduty is not None:
            pulumi.set(__self__, "guardduty", guardduty)
        if healthlake is not None:
            pulumi.set(__self__, "healthlake", healthlake)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if identitystore is not None:
            pulumi.set(__self__, "identitystore", identitystore)
        if imagebuilder is not None:
            pulumi.set(__self__, "imagebuilder", imagebuilder)
        if inspector is not None:
            pulumi.set(__self__, "inspector", inspector)
        if inspector2 is not None:
            pulumi.set(__self__, "inspector2", inspector2)
        if inspectorv2 is not None:
            pulumi.set(__self__, "inspectorv2", inspectorv2)
        if internetmonitor is not None:
            pulumi.set(__self__, "internetmonitor", internetmonitor)
        if invoicing is not None:
            pulumi.set(__self__, "invoicing", invoicing)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if ivs is not None:
            pulumi.set(__self__, "ivs", ivs)
        if ivschat is not None:
            pulumi.set(__self__, "ivschat", ivschat)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if kafkaconnect is not None:
            pulumi.set(__self__, "kafkaconnect", kafkaconnect)
        if kendra is not None:
            pulumi.set(__self__, "kendra", kendra)
        if keyspaces is not None:
            pulumi.set(__self__, "keyspaces", keyspaces)
        if kinesis is not None:
            pulumi.set(__self__, "kinesis", kinesis)
        if kinesisanalytics is not None:
            pulumi.set(__self__, "kinesisanalytics", kinesisanalytics)
        if kinesisanalyticsv2 is not None:
            pulumi.set(__self__, "kinesisanalyticsv2", kinesisanalyticsv2)
        if kinesisvideo is not None:
            pulumi.set(__self__, "kinesisvideo", kinesisvideo)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)
        if lakeformation is not None:
            pulumi.set(__self__, "lakeformation", lakeformation)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if launchwizard is not None:
            pulumi.set(__self__, "launchwizard", launchwizard)
        if lex is not None:
            pulumi.set(__self__, "lex", lex)
        if lexmodelbuilding is not None:
            pulumi.set(__self__, "lexmodelbuilding", lexmodelbuilding)
        if lexmodelbuildingservice is not None:
            pulumi.set(__self__, "lexmodelbuildingservice", lexmodelbuildingservice)
        if lexmodels is not None:
            pulumi.set(__self__, "lexmodels", lexmodels)
        if lexmodelsv2 is not None:
            pulumi.set(__self__, "lexmodelsv2", lexmodelsv2)
        if lexv2models is not None:
            pulumi.set(__self__, "lexv2models", lexv2models)
        if licensemanager is not None:
            pulumi.set(__self__, "licensemanager", licensemanager)
        if lightsail is not None:
            pulumi.set(__self__, "lightsail", lightsail)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if locationservice is not None:
            pulumi.set(__self__, "locationservice", locationservice)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if lookoutmetrics is not None:
            pulumi.set(__self__, "lookoutmetrics", lookoutmetrics)
        if m2 is not None:
            pulumi.set(__self__, "m2", m2)
        if macie2 is not None:
            pulumi.set(__self__, "macie2", macie2)
        if managedgrafana is not None:
            pulumi.set(__self__, "managedgrafana", managedgrafana)
        if mediaconnect is not None:
            pulumi.set(__self__, "mediaconnect", mediaconnect)
        if mediaconvert is not None:
            pulumi.set(__self__, "mediaconvert", mediaconvert)
        if medialive is not None:
            pulumi.set(__self__, "medialive", medialive)
        if mediapackage is not None:
            pulumi.set(__self__, "mediapackage", mediapackage)
        if mediapackagev2 is not None:
            pulumi.set(__self__, "mediapackagev2", mediapackagev2)
        if mediapackagevod is not None:
            pulumi.set(__self__, "mediapackagevod", mediapackagevod)
        if mediastore is not None:
            pulumi.set(__self__, "mediastore", mediastore)
        if memorydb is not None:
            pulumi.set(__self__, "memorydb", memorydb)
        if mgn is not None:
            pulumi.set(__self__, "mgn", mgn)
        if mq is not None:
            pulumi.set(__self__, "mq", mq)
        if msk is not None:
            pulumi.set(__self__, "msk", msk)
        if mwaa is not None:
            pulumi.set(__self__, "mwaa", mwaa)
        if neptune is not None:
            pulumi.set(__self__, "neptune", neptune)
        if neptunegraph is not None:
            pulumi.set(__self__, "neptunegraph", neptunegraph)
        if networkfirewall is not None:
            pulumi.set(__self__, "networkfirewall", networkfirewall)
        if networkflowmonitor is not None:
            pulumi.set(__self__, "networkflowmonitor", networkflowmonitor)
        if networkmanager is not None:
            pulumi.set(__self__, "networkmanager", networkmanager)
        if networkmonitor is not None:
            pulumi.set(__self__, "networkmonitor", networkmonitor)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if notificationscontacts is not None:
            pulumi.set(__self__, "notificationscontacts", notificationscontacts)
        if oam is not None:
            pulumi.set(__self__, "oam", oam)
        if observabilityadmin is not None:
            pulumi.set(__self__, "observabilityadmin", observabilityadmin)
        if odb is not None:
            pulumi.set(__self__, "odb", odb)
        if opensearch is not None:
            pulumi.set(__self__, "opensearch", opensearch)
        if opensearchingestion is not None:
            pulumi.set(__self__, "opensearchingestion", opensearchingestion)
        if opensearchserverless is not None:
            pulumi.set(__self__, "opensearchserverless", opensearchserverless)
        if opensearchservice is not None:
            pulumi.set(__self__, "opensearchservice", opensearchservice)
        if organizations is not None:
            pulumi.set(__self__, "organizations", organizations)
        if osis is not None:
            pulumi.set(__self__, "osis", osis)
        if outposts is not None:
            pulumi.set(__self__, "outposts", outposts)
        if paymentcryptography is not None:
            pulumi.set(__self__, "paymentcryptography", paymentcryptography)
        if pcaconnectorad is not None:
            pulumi.set(__self__, "pcaconnectorad", pcaconnectorad)
        if pcs is not None:
            pulumi.set(__self__, "pcs", pcs)
        if pinpoint is not None:
            pulumi.set(__self__, "pinpoint", pinpoint)
        if pinpointsmsvoicev2 is not None:
            pulumi.set(__self__, "pinpointsmsvoicev2", pinpointsmsvoicev2)
        if pipes is not None:
            pulumi.set(__self__, "pipes", pipes)
        if polly is not None:
            pulumi.set(__self__, "polly", polly)
        if pricing is not None:
            pulumi.set(__self__, "pricing", pricing)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)
        if prometheusservice is not None:
            pulumi.set(__self__, "prometheusservice", prometheusservice)
        if qbusiness is not None:
            pulumi.set(__self__, "qbusiness", qbusiness)
        if qldb is not None:
            pulumi.set(__self__, "qldb", qldb)
        if quicksight is not None:
            pulumi.set(__self__, "quicksight", quicksight)
        if ram is not None:
            pulumi.set(__self__, "ram", ram)
        if rbin is not None:
            pulumi.set(__self__, "rbin", rbin)
        if rds is not None:
            pulumi.set(__self__, "rds", rds)
        if recyclebin is not None:
            pulumi.set(__self__, "recyclebin", recyclebin)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if redshiftdata is not None:
            pulumi.set(__self__, "redshiftdata", redshiftdata)
        if redshiftdataapiservice is not None:
            pulumi.set(__self__, "redshiftdataapiservice", redshiftdataapiservice)
        if redshiftserverless is not None:
            pulumi.set(__self__, "redshiftserverless", redshiftserverless)
        if rekognition is not None:
            pulumi.set(__self__, "rekognition", rekognition)
        if resiliencehub is not None:
            pulumi.set(__self__, "resiliencehub", resiliencehub)
        if resourceexplorer2 is not None:
            pulumi.set(__self__, "resourceexplorer2", resourceexplorer2)
        if resourcegroups is not None:
            pulumi.set(__self__, "resourcegroups", resourcegroups)
        if resourcegroupstagging is not None:
            pulumi.set(__self__, "resourcegroupstagging", resourcegroupstagging)
        if resourcegroupstaggingapi is not None:
            pulumi.set(__self__, "resourcegroupstaggingapi", resourcegroupstaggingapi)
        if rolesanywhere is not None:
            pulumi.set(__self__, "rolesanywhere", rolesanywhere)
        if route53 is not None:
            pulumi.set(__self__, "route53", route53)
        if route53domains is not None:
            pulumi.set(__self__, "route53domains", route53domains)
        if route53profiles is not None:
            pulumi.set(__self__, "route53profiles", route53profiles)
        if route53recoverycontrolconfig is not None:
            pulumi.set(__self__, "route53recoverycontrolconfig", route53recoverycontrolconfig)
        if route53recoveryreadiness is not None:
            pulumi.set(__self__, "route53recoveryreadiness", route53recoveryreadiness)
        if route53resolver is not None:
            pulumi.set(__self__, "route53resolver", route53resolver)
        if rum is not None:
            pulumi.set(__self__, "rum", rum)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if s3api is not None:
            pulumi.set(__self__, "s3api", s3api)
        if s3control is not None:
            pulumi.set(__self__, "s3control", s3control)
        if s3outposts is not None:
            pulumi.set(__self__, "s3outposts", s3outposts)
        if s3tables is not None:
            pulumi.set(__self__, "s3tables", s3tables)
        if s3vectors is not None:
            pulumi.set(__self__, "s3vectors", s3vectors)
        if sagemaker is not None:
            pulumi.set(__self__, "sagemaker", sagemaker)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if secretsmanager is not None:
            pulumi.set(__self__, "secretsmanager", secretsmanager)
        if securityhub is not None:
            pulumi.set(__self__, "securityhub", securityhub)
        if securitylake is not None:
            pulumi.set(__self__, "securitylake", securitylake)
        if serverlessapplicationrepository is not None:
            pulumi.set(__self__, "serverlessapplicationrepository", serverlessapplicationrepository)
        if serverlessapprepo is not None:
            pulumi.set(__self__, "serverlessapprepo", serverlessapprepo)
        if serverlessrepo is not None:
            pulumi.set(__self__, "serverlessrepo", serverlessrepo)
        if servicecatalog is not None:
            pulumi.set(__self__, "servicecatalog", servicecatalog)
        if servicecatalogappregistry is not None:
            pulumi.set(__self__, "servicecatalogappregistry", servicecatalogappregistry)
        if servicediscovery is not None:
            pulumi.set(__self__, "servicediscovery", servicediscovery)
        if servicequotas is not None:
            pulumi.set(__self__, "servicequotas", servicequotas)
        if ses is not None:
            pulumi.set(__self__, "ses", ses)
        if sesv2 is not None:
            pulumi.set(__self__, "sesv2", sesv2)
        if sfn is not None:
            pulumi.set(__self__, "sfn", sfn)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if signer is not None:
            pulumi.set(__self__, "signer", signer)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)
        if ssm is not None:
            pulumi.set(__self__, "ssm", ssm)
        if ssmcontacts is not None:
            pulumi.set(__self__, "ssmcontacts", ssmcontacts)
        if ssmincidents is not None:
            pulumi.set(__self__, "ssmincidents", ssmincidents)
        if ssmquicksetup is not None:
            pulumi.set(__self__, "ssmquicksetup", ssmquicksetup)
        if ssmsap is not None:
            pulumi.set(__self__, "ssmsap", ssmsap)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if ssoadmin is not None:
            pulumi.set(__self__, "ssoadmin", ssoadmin)
        if stepfunctions is not None:
            pulumi.set(__self__, "stepfunctions", stepfunctions)
        if storagegateway is not None:
            pulumi.set(__self__, "storagegateway", storagegateway)
        if sts is not None:
            pulumi.set(__self__, "sts", sts)
        if swf is not None:
            pulumi.set(__self__, "swf", swf)
        if synthetics is not None:
            pulumi.set(__self__, "synthetics", synthetics)
        if taxsettings is not None:
            pulumi.set(__self__, "taxsettings", taxsettings)
        if timestreaminfluxdb is not None:
            pulumi.set(__self__, "timestreaminfluxdb", timestreaminfluxdb)
        if timestreamquery is not None:
            pulumi.set(__self__, "timestreamquery", timestreamquery)
        if timestreamwrite is not None:
            pulumi.set(__self__, "timestreamwrite", timestreamwrite)
        if transcribe is not None:
            pulumi.set(__self__, "transcribe", transcribe)
        if transcribeservice is not None:
            pulumi.set(__self__, "transcribeservice", transcribeservice)
        if transfer is not None:
            pulumi.set(__self__, "transfer", transfer)
        if verifiedpermissions is not None:
            pulumi.set(__self__, "verifiedpermissions", verifiedpermissions)
        if vpclattice is not None:
            pulumi.set(__self__, "vpclattice", vpclattice)
        if waf is not None:
            pulumi.set(__self__, "waf", waf)
        if wafregional is not None:
            pulumi.set(__self__, "wafregional", wafregional)
        if wafv2 is not None:
            pulumi.set(__self__, "wafv2", wafv2)
        if wellarchitected is not None:
            pulumi.set(__self__, "wellarchitected", wellarchitected)
        if workmail is not None:
            pulumi.set(__self__, "workmail", workmail)
        if workspaces is not None:
            pulumi.set(__self__, "workspaces", workspaces)
        if workspacesweb is not None:
            pulumi.set(__self__, "workspacesweb", workspacesweb)
        if xray is not None:
            pulumi.set(__self__, "xray", xray)

    @_builtins.property
    @pulumi.getter
    def accessanalyzer(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "accessanalyzer")

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def acm(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "acm")

    @_builtins.property
    @pulumi.getter
    def acmpca(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "acmpca")

    @_builtins.property
    @pulumi.getter
    def amg(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "amg")

    @_builtins.property
    @pulumi.getter
    def amp(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "amp")

    @_builtins.property
    @pulumi.getter
    def amplify(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "amplify")

    @_builtins.property
    @pulumi.getter
    def apigateway(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "apigateway")

    @_builtins.property
    @pulumi.getter
    def apigatewayv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "apigatewayv2")

    @_builtins.property
    @pulumi.getter
    def appautoscaling(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appautoscaling")

    @_builtins.property
    @pulumi.getter
    def appconfig(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appconfig")

    @_builtins.property
    @pulumi.getter
    def appfabric(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appfabric")

    @_builtins.property
    @pulumi.getter
    def appflow(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appflow")

    @_builtins.property
    @pulumi.getter
    def appintegrations(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appintegrations")

    @_builtins.property
    @pulumi.getter
    def appintegrationsservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appintegrationsservice")

    @_builtins.property
    @pulumi.getter
    def applicationautoscaling(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "applicationautoscaling")

    @_builtins.property
    @pulumi.getter
    def applicationinsights(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "applicationinsights")

    @_builtins.property
    @pulumi.getter
    def applicationsignals(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "applicationsignals")

    @_builtins.property
    @pulumi.getter
    def appmesh(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appmesh")

    @_builtins.property
    @pulumi.getter
    def appregistry(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appregistry")

    @_builtins.property
    @pulumi.getter
    def apprunner(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "apprunner")

    @_builtins.property
    @pulumi.getter
    def appstream(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appstream")

    @_builtins.property
    @pulumi.getter
    def appsync(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appsync")

    @_builtins.property
    @pulumi.getter
    def arcregionswitch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "arcregionswitch")

    @_builtins.property
    @pulumi.getter
    def athena(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "athena")

    @_builtins.property
    @pulumi.getter
    def auditmanager(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "auditmanager")

    @_builtins.property
    @pulumi.getter
    def autoscaling(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "autoscaling")

    @_builtins.property
    @pulumi.getter
    def autoscalingplans(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "autoscalingplans")

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "backup")

    @_builtins.property
    @pulumi.getter
    def batch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "batch")

    @_builtins.property
    @pulumi.getter
    def bcmdataexports(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "bcmdataexports")

    @_builtins.property
    @pulumi.getter
    def beanstalk(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "beanstalk")

    @_builtins.property
    @pulumi.getter
    def bedrock(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "bedrock")

    @_builtins.property
    @pulumi.getter
    def bedrockagent(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "bedrockagent")

    @_builtins.property
    @pulumi.getter
    def bedrockagentcore(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "bedrockagentcore")

    @_builtins.property
    @pulumi.getter
    def billing(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "billing")

    @_builtins.property
    @pulumi.getter
    def budgets(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "budgets")

    @_builtins.property
    @pulumi.getter
    def ce(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ce")

    @_builtins.property
    @pulumi.getter
    def chatbot(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chatbot")

    @_builtins.property
    @pulumi.getter
    def chime(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chime")

    @_builtins.property
    @pulumi.getter
    def chimesdkmediapipelines(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chimesdkmediapipelines")

    @_builtins.property
    @pulumi.getter
    def chimesdkvoice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chimesdkvoice")

    @_builtins.property
    @pulumi.getter
    def cleanrooms(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cleanrooms")

    @_builtins.property
    @pulumi.getter
    def cloud9(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloud9")

    @_builtins.property
    @pulumi.getter
    def cloudcontrol(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudcontrol")

    @_builtins.property
    @pulumi.getter
    def cloudcontrolapi(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudcontrolapi")

    @_builtins.property
    @pulumi.getter
    def cloudformation(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudformation")

    @_builtins.property
    @pulumi.getter
    def cloudfront(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudfront")

    @_builtins.property
    @pulumi.getter
    def cloudfrontkeyvaluestore(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudfrontkeyvaluestore")

    @_builtins.property
    @pulumi.getter
    def cloudhsm(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudhsm")

    @_builtins.property
    @pulumi.getter
    def cloudhsmv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudhsmv2")

    @_builtins.property
    @pulumi.getter
    def cloudsearch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudsearch")

    @_builtins.property
    @pulumi.getter
    def cloudtrail(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudtrail")

    @_builtins.property
    @pulumi.getter
    def cloudwatch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatch")

    @_builtins.property
    @pulumi.getter
    def cloudwatchevents(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchevents")

    @_builtins.property
    @pulumi.getter
    def cloudwatchevidently(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchevidently")

    @_builtins.property
    @pulumi.getter
    def cloudwatchlog(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchlog")

    @_builtins.property
    @pulumi.getter
    def cloudwatchlogs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchlogs")

    @_builtins.property
    @pulumi.getter
    def cloudwatchobservabilityaccessmanager(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchobservabilityaccessmanager")

    @_builtins.property
    @pulumi.getter
    def cloudwatchrum(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchrum")

    @_builtins.property
    @pulumi.getter
    def codeartifact(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codeartifact")

    @_builtins.property
    @pulumi.getter
    def codebuild(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codebuild")

    @_builtins.property
    @pulumi.getter
    def codecatalyst(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codecatalyst")

    @_builtins.property
    @pulumi.getter
    def codecommit(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codecommit")

    @_builtins.property
    @pulumi.getter
    def codeconnections(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codeconnections")

    @_builtins.property
    @pulumi.getter
    def codedeploy(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codedeploy")

    @_builtins.property
    @pulumi.getter
    def codeguruprofiler(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codeguruprofiler")

    @_builtins.property
    @pulumi.getter
    def codegurureviewer(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codegurureviewer")

    @_builtins.property
    @pulumi.getter
    def codepipeline(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codepipeline")

    @_builtins.property
    @pulumi.getter
    def codestarconnections(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codestarconnections")

    @_builtins.property
    @pulumi.getter
    def codestarnotifications(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codestarnotifications")

    @_builtins.property
    @pulumi.getter
    def cognitoidentity(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cognitoidentity")

    @_builtins.property
    @pulumi.getter
    def cognitoidentityprovider(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cognitoidentityprovider")

    @_builtins.property
    @pulumi.getter
    def cognitoidp(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cognitoidp")

    @_builtins.property
    @pulumi.getter
    def comprehend(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "comprehend")

    @_builtins.property
    @pulumi.getter
    def computeoptimizer(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "computeoptimizer")

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def configservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "configservice")

    @_builtins.property
    @pulumi.getter
    def connect(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "connect")

    @_builtins.property
    @pulumi.getter
    def connectcases(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "connectcases")

    @_builtins.property
    @pulumi.getter
    def controltower(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "controltower")

    @_builtins.property
    @pulumi.getter
    def costandusagereportservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "costandusagereportservice")

    @_builtins.property
    @pulumi.getter
    def costexplorer(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "costexplorer")

    @_builtins.property
    @pulumi.getter
    def costoptimizationhub(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "costoptimizationhub")

    @_builtins.property
    @pulumi.getter
    def cur(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cur")

    @_builtins.property
    @pulumi.getter
    def customerprofiles(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "customerprofiles")

    @_builtins.property
    @pulumi.getter
    def databasemigration(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "databasemigration")

    @_builtins.property
    @pulumi.getter
    def databasemigrationservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "databasemigrationservice")

    @_builtins.property
    @pulumi.getter
    def databrew(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "databrew")

    @_builtins.property
    @pulumi.getter
    def dataexchange(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dataexchange")

    @_builtins.property
    @pulumi.getter
    def datapipeline(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "datapipeline")

    @_builtins.property
    @pulumi.getter
    def datasync(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "datasync")

    @_builtins.property
    @pulumi.getter
    def datazone(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "datazone")

    @_builtins.property
    @pulumi.getter
    def dax(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dax")

    @_builtins.property
    @pulumi.getter
    def deploy(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "deploy")

    @_builtins.property
    @pulumi.getter
    def detective(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "detective")

    @_builtins.property
    @pulumi.getter
    def devicefarm(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "devicefarm")

    @_builtins.property
    @pulumi.getter
    def devopsguru(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "devopsguru")

    @_builtins.property
    @pulumi.getter
    def directconnect(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "directconnect")

    @_builtins.property
    @pulumi.getter
    def directoryservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "directoryservice")

    @_builtins.property
    @pulumi.getter
    def dlm(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dlm")

    @_builtins.property
    @pulumi.getter
    def dms(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dms")

    @_builtins.property
    @pulumi.getter
    def docdb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "docdb")

    @_builtins.property
    @pulumi.getter
    def docdbelastic(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "docdbelastic")

    @_builtins.property
    @pulumi.getter
    def drs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "drs")

    @_builtins.property
    @pulumi.getter
    def ds(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ds")

    @_builtins.property
    @pulumi.getter
    def dsql(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dsql")

    @_builtins.property
    @pulumi.getter
    def dynamodb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dynamodb")

    @_builtins.property
    @pulumi.getter
    def ec2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ec2")

    @_builtins.property
    @pulumi.getter
    def ecr(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ecr")

    @_builtins.property
    @pulumi.getter
    def ecrpublic(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ecrpublic")

    @_builtins.property
    @pulumi.getter
    def ecs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ecs")

    @_builtins.property
    @pulumi.getter
    def efs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "efs")

    @_builtins.property
    @pulumi.getter
    def eks(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "eks")

    @_builtins.property
    @pulumi.getter
    def elasticache(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticache")

    @_builtins.property
    @pulumi.getter
    def elasticbeanstalk(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticbeanstalk")

    @_builtins.property
    @pulumi.getter
    def elasticloadbalancing(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticloadbalancing")

    @_builtins.property
    @pulumi.getter
    def elasticloadbalancingv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticloadbalancingv2")

    @_builtins.property
    @pulumi.getter
    def elasticsearch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticsearch")

    @_builtins.property
    @pulumi.getter
    def elasticsearchservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticsearchservice")

    @_builtins.property
    @pulumi.getter
    def elastictranscoder(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elastictranscoder")

    @_builtins.property
    @pulumi.getter
    def elb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elb")

    @_builtins.property
    @pulumi.getter
    def elbv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elbv2")

    @_builtins.property
    @pulumi.getter
    def emr(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "emr")

    @_builtins.property
    @pulumi.getter
    def emrcontainers(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "emrcontainers")

    @_builtins.property
    @pulumi.getter
    def emrserverless(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "emrserverless")

    @_builtins.property
    @pulumi.getter
    def es(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "es")

    @_builtins.property
    @pulumi.getter
    def eventbridge(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "eventbridge")

    @_builtins.property
    @pulumi.getter
    def events(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter
    def evidently(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "evidently")

    @_builtins.property
    @pulumi.getter
    def evs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "evs")

    @_builtins.property
    @pulumi.getter
    def finspace(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "finspace")

    @_builtins.property
    @pulumi.getter
    def firehose(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "firehose")

    @_builtins.property
    @pulumi.getter
    def fis(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "fis")

    @_builtins.property
    @pulumi.getter
    def fms(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "fms")

    @_builtins.property
    @pulumi.getter
    def fsx(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "fsx")

    @_builtins.property
    @pulumi.getter
    def gamelift(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "gamelift")

    @_builtins.property
    @pulumi.getter
    def glacier(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "glacier")

    @_builtins.property
    @pulumi.getter
    def globalaccelerator(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "globalaccelerator")

    @_builtins.property
    @pulumi.getter
    def glue(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "glue")

    @_builtins.property
    @pulumi.getter
    def gluedatabrew(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "gluedatabrew")

    @_builtins.property
    @pulumi.getter
    def grafana(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "grafana")

    @_builtins.property
    @pulumi.getter
    def greengrass(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "greengrass")

    @_builtins.property
    @pulumi.getter
    def groundstation(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "groundstation")

    @_builtins.property
    @pulumi.getter
    def guardduty(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "guardduty")

    @_builtins.property
    @pulumi.getter
    def healthlake(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "healthlake")

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def identitystore(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "identitystore")

    @_builtins.property
    @pulumi.getter
    def imagebuilder(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "imagebuilder")

    @_builtins.property
    @pulumi.getter
    def inspector(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "inspector")

    @_builtins.property
    @pulumi.getter
    def inspector2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "inspector2")

    @_builtins.property
    @pulumi.getter
    def inspectorv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "inspectorv2")

    @_builtins.property
    @pulumi.getter
    def internetmonitor(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "internetmonitor")

    @_builtins.property
    @pulumi.getter
    def invoicing(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "invoicing")

    @_builtins.property
    @pulumi.getter
    def iot(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "iot")

    @_builtins.property
    @pulumi.getter
    def ivs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ivs")

    @_builtins.property
    @pulumi.getter
    def ivschat(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ivschat")

    @_builtins.property
    @pulumi.getter
    def kafka(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kafka")

    @_builtins.property
    @pulumi.getter
    def kafkaconnect(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kafkaconnect")

    @_builtins.property
    @pulumi.getter
    def kendra(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kendra")

    @_builtins.property
    @pulumi.getter
    def keyspaces(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "keyspaces")

    @_builtins.property
    @pulumi.getter
    def kinesis(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesis")

    @_builtins.property
    @pulumi.getter
    def kinesisanalytics(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesisanalytics")

    @_builtins.property
    @pulumi.getter
    def kinesisanalyticsv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesisanalyticsv2")

    @_builtins.property
    @pulumi.getter
    def kinesisvideo(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesisvideo")

    @_builtins.property
    @pulumi.getter
    def kms(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kms")

    @_builtins.property
    @pulumi.getter
    def lakeformation(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lakeformation")

    @_builtins.property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lambda_")

    @_builtins.property
    @pulumi.getter
    def launchwizard(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "launchwizard")

    @_builtins.property
    @pulumi.getter
    def lex(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lex")

    @_builtins.property
    @pulumi.getter
    def lexmodelbuilding(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodelbuilding")

    @_builtins.property
    @pulumi.getter
    def lexmodelbuildingservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodelbuildingservice")

    @_builtins.property
    @pulumi.getter
    def lexmodels(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodels")

    @_builtins.property
    @pulumi.getter
    def lexmodelsv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodelsv2")

    @_builtins.property
    @pulumi.getter
    def lexv2models(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexv2models")

    @_builtins.property
    @pulumi.getter
    def licensemanager(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "licensemanager")

    @_builtins.property
    @pulumi.getter
    def lightsail(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lightsail")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def locationservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "locationservice")

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter
    def lookoutmetrics(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lookoutmetrics")

    @_builtins.property
    @pulumi.getter
    def m2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "m2")

    @_builtins.property
    @pulumi.getter
    def macie2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "macie2")

    @_builtins.property
    @pulumi.getter
    def managedgrafana(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "managedgrafana")

    @_builtins.property
    @pulumi.getter
    def mediaconnect(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediaconnect")

    @_builtins.property
    @pulumi.getter
    def mediaconvert(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediaconvert")

    @_builtins.property
    @pulumi.getter
    def medialive(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "medialive")

    @_builtins.property
    @pulumi.getter
    def mediapackage(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediapackage")

    @_builtins.property
    @pulumi.getter
    def mediapackagev2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediapackagev2")

    @_builtins.property
    @pulumi.getter
    def mediapackagevod(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediapackagevod")

    @_builtins.property
    @pulumi.getter
    def mediastore(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediastore")

    @_builtins.property
    @pulumi.getter
    def memorydb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "memorydb")

    @_builtins.property
    @pulumi.getter
    def mgn(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mgn")

    @_builtins.property
    @pulumi.getter
    def mq(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mq")

    @_builtins.property
    @pulumi.getter
    def msk(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "msk")

    @_builtins.property
    @pulumi.getter
    def mwaa(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mwaa")

    @_builtins.property
    @pulumi.getter
    def neptune(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "neptune")

    @_builtins.property
    @pulumi.getter
    def neptunegraph(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "neptunegraph")

    @_builtins.property
    @pulumi.getter
    def networkfirewall(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "networkfirewall")

    @_builtins.property
    @pulumi.getter
    def networkflowmonitor(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "networkflowmonitor")

    @_builtins.property
    @pulumi.getter
    def networkmanager(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "networkmanager")

    @_builtins.property
    @pulumi.getter
    def networkmonitor(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "networkmonitor")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter
    def notificationscontacts(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "notificationscontacts")

    @_builtins.property
    @pulumi.getter
    def oam(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "oam")

    @_builtins.property
    @pulumi.getter
    def observabilityadmin(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "observabilityadmin")

    @_builtins.property
    @pulumi.getter
    def odb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "odb")

    @_builtins.property
    @pulumi.getter
    def opensearch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearch")

    @_builtins.property
    @pulumi.getter
    def opensearchingestion(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearchingestion")

    @_builtins.property
    @pulumi.getter
    def opensearchserverless(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearchserverless")

    @_builtins.property
    @pulumi.getter
    def opensearchservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearchservice")

    @_builtins.property
    @pulumi.getter
    def organizations(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "organizations")

    @_builtins.property
    @pulumi.getter
    def osis(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "osis")

    @_builtins.property
    @pulumi.getter
    def outposts(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "outposts")

    @_builtins.property
    @pulumi.getter
    def paymentcryptography(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "paymentcryptography")

    @_builtins.property
    @pulumi.getter
    def pcaconnectorad(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pcaconnectorad")

    @_builtins.property
    @pulumi.getter
    def pcs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pcs")

    @_builtins.property
    @pulumi.getter
    def pinpoint(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pinpoint")

    @_builtins.property
    @pulumi.getter
    def pinpointsmsvoicev2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pinpointsmsvoicev2")

    @_builtins.property
    @pulumi.getter
    def pipes(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pipes")

    @_builtins.property
    @pulumi.getter
    def polly(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "polly")

    @_builtins.property
    @pulumi.getter
    def pricing(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pricing")

    @_builtins.property
    @pulumi.getter
    def prometheus(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "prometheus")

    @_builtins.property
    @pulumi.getter
    def prometheusservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "prometheusservice")

    @_builtins.property
    @pulumi.getter
    def qbusiness(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "qbusiness")

    @_builtins.property
    @pulumi.getter
    def qldb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "qldb")

    @_builtins.property
    @pulumi.getter
    def quicksight(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "quicksight")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def rbin(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rbin")

    @_builtins.property
    @pulumi.getter
    def rds(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rds")

    @_builtins.property
    @pulumi.getter
    def recyclebin(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "recyclebin")

    @_builtins.property
    @pulumi.getter
    def redshift(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshift")

    @_builtins.property
    @pulumi.getter
    def redshiftdata(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshiftdata")

    @_builtins.property
    @pulumi.getter
    def redshiftdataapiservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshiftdataapiservice")

    @_builtins.property
    @pulumi.getter
    def redshiftserverless(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshiftserverless")

    @_builtins.property
    @pulumi.getter
    def rekognition(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rekognition")

    @_builtins.property
    @pulumi.getter
    def resiliencehub(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resiliencehub")

    @_builtins.property
    @pulumi.getter
    def resourceexplorer2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourceexplorer2")

    @_builtins.property
    @pulumi.getter
    def resourcegroups(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourcegroups")

    @_builtins.property
    @pulumi.getter
    def resourcegroupstagging(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourcegroupstagging")

    @_builtins.property
    @pulumi.getter
    def resourcegroupstaggingapi(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourcegroupstaggingapi")

    @_builtins.property
    @pulumi.getter
    def rolesanywhere(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rolesanywhere")

    @_builtins.property
    @pulumi.getter
    def route53(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53")

    @_builtins.property
    @pulumi.getter
    def route53domains(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53domains")

    @_builtins.property
    @pulumi.getter
    def route53profiles(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53profiles")

    @_builtins.property
    @pulumi.getter
    def route53recoverycontrolconfig(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53recoverycontrolconfig")

    @_builtins.property
    @pulumi.getter
    def route53recoveryreadiness(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53recoveryreadiness")

    @_builtins.property
    @pulumi.getter
    def route53resolver(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53resolver")

    @_builtins.property
    @pulumi.getter
    def rum(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rum")

    @_builtins.property
    @pulumi.getter
    def s3(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3")

    @_builtins.property
    @pulumi.getter
    def s3api(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3api")

    @_builtins.property
    @pulumi.getter
    def s3control(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3control")

    @_builtins.property
    @pulumi.getter
    def s3outposts(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3outposts")

    @_builtins.property
    @pulumi.getter
    def s3tables(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3tables")

    @_builtins.property
    @pulumi.getter
    def s3vectors(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3vectors")

    @_builtins.property
    @pulumi.getter
    def sagemaker(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sagemaker")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter
    def schemas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "schemas")

    @_builtins.property
    @pulumi.getter
    def secretsmanager(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "secretsmanager")

    @_builtins.property
    @pulumi.getter
    def securityhub(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "securityhub")

    @_builtins.property
    @pulumi.getter
    def securitylake(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "securitylake")

    @_builtins.property
    @pulumi.getter
    def serverlessapplicationrepository(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "serverlessapplicationrepository")

    @_builtins.property
    @pulumi.getter
    def serverlessapprepo(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "serverlessapprepo")

    @_builtins.property
    @pulumi.getter
    def serverlessrepo(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "serverlessrepo")

    @_builtins.property
    @pulumi.getter
    def servicecatalog(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicecatalog")

    @_builtins.property
    @pulumi.getter
    def servicecatalogappregistry(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicecatalogappregistry")

    @_builtins.property
    @pulumi.getter
    def servicediscovery(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicediscovery")

    @_builtins.property
    @pulumi.getter
    def servicequotas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicequotas")

    @_builtins.property
    @pulumi.getter
    def ses(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ses")

    @_builtins.property
    @pulumi.getter
    def sesv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sesv2")

    @_builtins.property
    @pulumi.getter
    def sfn(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sfn")

    @_builtins.property
    @pulumi.getter
    def shield(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "shield")

    @_builtins.property
    @pulumi.getter
    def signer(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "signer")

    @_builtins.property
    @pulumi.getter
    def sns(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sns")

    @_builtins.property
    @pulumi.getter
    def sqs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sqs")

    @_builtins.property
    @pulumi.getter
    def ssm(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssm")

    @_builtins.property
    @pulumi.getter
    def ssmcontacts(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmcontacts")

    @_builtins.property
    @pulumi.getter
    def ssmincidents(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmincidents")

    @_builtins.property
    @pulumi.getter
    def ssmquicksetup(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmquicksetup")

    @_builtins.property
    @pulumi.getter
    def ssmsap(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmsap")

    @_builtins.property
    @pulumi.getter
    def sso(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sso")

    @_builtins.property
    @pulumi.getter
    def ssoadmin(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssoadmin")

    @_builtins.property
    @pulumi.getter
    def stepfunctions(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "stepfunctions")

    @_builtins.property
    @pulumi.getter
    def storagegateway(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "storagegateway")

    @_builtins.property
    @pulumi.getter
    def sts(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sts")

    @_builtins.property
    @pulumi.getter
    def swf(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "swf")

    @_builtins.property
    @pulumi.getter
    def synthetics(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "synthetics")

    @_builtins.property
    @pulumi.getter
    def taxsettings(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "taxsettings")

    @_builtins.property
    @pulumi.getter
    def timestreaminfluxdb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "timestreaminfluxdb")

    @_builtins.property
    @pulumi.getter
    def timestreamquery(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "timestreamquery")

    @_builtins.property
    @pulumi.getter
    def timestreamwrite(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "timestreamwrite")

    @_builtins.property
    @pulumi.getter
    def transcribe(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "transcribe")

    @_builtins.property
    @pulumi.getter
    def transcribeservice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "transcribeservice")

    @_builtins.property
    @pulumi.getter
    def transfer(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "transfer")

    @_builtins.property
    @pulumi.getter
    def verifiedpermissions(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "verifiedpermissions")

    @_builtins.property
    @pulumi.getter
    def vpclattice(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "vpclattice")

    @_builtins.property
    @pulumi.getter
    def waf(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "waf")

    @_builtins.property
    @pulumi.getter
    def wafregional(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "wafregional")

    @_builtins.property
    @pulumi.getter
    def wafv2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "wafv2")

    @_builtins.property
    @pulumi.getter
    def wellarchitected(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "wellarchitected")

    @_builtins.property
    @pulumi.getter
    def workmail(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "workmail")

    @_builtins.property
    @pulumi.getter
    def workspaces(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "workspaces")

    @_builtins.property
    @pulumi.getter
    def workspacesweb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "workspacesweb")

    @_builtins.property
    @pulumi.getter
    def xray(self) -> Optional[_builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "xray")


@pulumi.output_type
class IgnoreTags(dict):
    def __init__(__self__, *,
                 key_prefixes: Optional[Sequence[_builtins.str]] = None,
                 keys: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] key_prefixes: Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
        :param Sequence[_builtins.str] keys: Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
        """
        if key_prefixes is not None:
            pulumi.set(__self__, "key_prefixes", key_prefixes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @_builtins.property
    @pulumi.getter(name="keyPrefixes")
    def key_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
        """
        return pulumi.get(self, "key_prefixes")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
        """
        return pulumi.get(self, "keys")


