# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetContactFlowResult',
    'AwaitableGetContactFlowResult',
    'get_contact_flow',
    'get_contact_flow_output',
]

@pulumi.output_type
class GetContactFlowResult:
    """
    A collection of values returned by getContactFlow.
    """
    def __init__(__self__, arn=None, contact_flow_id=None, content=None, description=None, id=None, instance_id=None, name=None, region=None, tags=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if contact_flow_id and not isinstance(contact_flow_id, str):
            raise TypeError("Expected argument 'contact_flow_id' to be a str")
        pulumi.set(__self__, "contact_flow_id", contact_flow_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Contact Flow.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="contactFlowId")
    def contact_flow_id(self) -> _builtins.str:
        return pulumi.get(self, "contact_flow_id")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Logic of the Contact Flow.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Contact Flow.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags to assign to the Contact Flow.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of Contact Flow.
        """
        return pulumi.get(self, "type")


class AwaitableGetContactFlowResult(GetContactFlowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactFlowResult(
            arn=self.arn,
            contact_flow_id=self.contact_flow_id,
            content=self.content,
            description=self.description,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            region=self.region,
            tags=self.tags,
            type=self.type)


def get_contact_flow(contact_flow_id: Optional[_builtins.str] = None,
                     instance_id: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     type: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactFlowResult:
    """
    Provides details about a specific Amazon Connect Contact Flow.

    ## Example Usage

    By name

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.connect.get_contact_flow(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Test")
    ```

    By contact_flow_id

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.connect.get_contact_flow(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        contact_flow_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str contact_flow_id: Returns information on a specific Contact Flow by contact flow id
    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Contact Flow by name
           
           > **NOTE:** `instance_id` and one of either `name` or `contact_flow_id` is required.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Tags to assign to the Contact Flow.
    :param _builtins.str type: Type of Contact Flow.
    """
    __args__ = dict()
    __args__['contactFlowId'] = contact_flow_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getContactFlow:getContactFlow', __args__, opts=opts, typ=GetContactFlowResult).value

    return AwaitableGetContactFlowResult(
        arn=pulumi.get(__ret__, 'arn'),
        contact_flow_id=pulumi.get(__ret__, 'contact_flow_id'),
        content=pulumi.get(__ret__, 'content'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_contact_flow_output(contact_flow_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContactFlowResult]:
    """
    Provides details about a specific Amazon Connect Contact Flow.

    ## Example Usage

    By name

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.connect.get_contact_flow(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Test")
    ```

    By contact_flow_id

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.connect.get_contact_flow(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        contact_flow_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param _builtins.str contact_flow_id: Returns information on a specific Contact Flow by contact flow id
    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Contact Flow by name
           
           > **NOTE:** `instance_id` and one of either `name` or `contact_flow_id` is required.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Tags to assign to the Contact Flow.
    :param _builtins.str type: Type of Contact Flow.
    """
    __args__ = dict()
    __args__['contactFlowId'] = contact_flow_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getContactFlow:getContactFlow', __args__, opts=opts, typ=GetContactFlowResult)
    return __ret__.apply(lambda __response__: GetContactFlowResult(
        arn=pulumi.get(__response__, 'arn'),
        contact_flow_id=pulumi.get(__response__, 'contact_flow_id'),
        content=pulumi.get(__response__, 'content'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
