# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPromptResult',
    'AwaitableGetPromptResult',
    'get_prompt',
    'get_prompt_output',
]

@pulumi.output_type
class GetPromptResult:
    """
    A collection of values returned by getPrompt.
    """
    def __init__(__self__, arn=None, id=None, instance_id=None, name=None, prompt_id=None, region=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if prompt_id and not isinstance(prompt_id, str):
            raise TypeError("Expected argument 'prompt_id' to be a str")
        pulumi.set(__self__, "prompt_id", prompt_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Prompt.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="promptId")
    def prompt_id(self) -> _builtins.str:
        """
        Identifier for the prompt.
        """
        return pulumi.get(self, "prompt_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetPromptResult(GetPromptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPromptResult(
            arn=self.arn,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            prompt_id=self.prompt_id,
            region=self.region)


def get_prompt(instance_id: Optional[_builtins.str] = None,
               name: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPromptResult:
    """
    Provides details about a specific Amazon Connect Prompt.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_prompt(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Beep.wav")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Prompt by name
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getPrompt:getPrompt', __args__, opts=opts, typ=GetPromptResult).value

    return AwaitableGetPromptResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        prompt_id=pulumi.get(__ret__, 'prompt_id'),
        region=pulumi.get(__ret__, 'region'))
def get_prompt_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                      name: Optional[pulumi.Input[_builtins.str]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPromptResult]:
    """
    Provides details about a specific Amazon Connect Prompt.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_prompt(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Beep.wav")
    ```


    :param _builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param _builtins.str name: Returns information on a specific Prompt by name
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getPrompt:getPrompt', __args__, opts=opts, typ=GetPromptResult)
    return __ret__.apply(lambda __response__: GetPromptResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        prompt_id=pulumi.get(__response__, 'prompt_id'),
        region=pulumi.get(__response__, 'region')))
