# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[_builtins.str],
                 profile_identifier: pulumi.Input[_builtins.str],
                 project_identifier: pulumi.Input[_builtins.str],
                 account_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 account_region: Optional[pulumi.Input[_builtins.str]] = None,
                 blueprint_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['EnvironmentTimeoutsArgs']] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[_builtins.str] domain_identifier: The ID of the domain where the environment exists.
        :param pulumi.Input[_builtins.str] profile_identifier: The ID of the profile with which the environment is created.
        :param pulumi.Input[_builtins.str] project_identifier: The ID of the project where the environment exists.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] account_identifier: The ID of the Amazon Web Services account where the environment exists
        :param pulumi.Input[_builtins.str] account_region: The Amazon Web Services region where the environment exists.
        :param pulumi.Input[_builtins.str] blueprint_identifier: The blueprint with which the environment is created.
        :param pulumi.Input[_builtins.str] description: The description of the environment.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] glossary_terms: The business glossary terms that can be used in this environment.
        :param pulumi.Input[_builtins.str] name: The name of the environment.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]] user_parameters: The user parameters that are used in the environment.
               See User Parameters for more information.
               Changing these values recreates the resource.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "profile_identifier", profile_identifier)
        pulumi.set(__self__, "project_identifier", project_identifier)
        if account_identifier is not None:
            pulumi.set(__self__, "account_identifier", account_identifier)
        if account_region is not None:
            pulumi.set(__self__, "account_region", account_region)
        if blueprint_identifier is not None:
            pulumi.set(__self__, "blueprint_identifier", blueprint_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if glossary_terms is not None:
            pulumi.set(__self__, "glossary_terms", glossary_terms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_parameters is not None:
            pulumi.set(__self__, "user_parameters", user_parameters)

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the domain where the environment exists.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @_builtins.property
    @pulumi.getter(name="profileIdentifier")
    def profile_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the profile with which the environment is created.
        """
        return pulumi.get(self, "profile_identifier")

    @profile_identifier.setter
    def profile_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "profile_identifier", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project where the environment exists.

        The following arguments are optional:
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_identifier", value)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Amazon Web Services account where the environment exists
        """
        return pulumi.get(self, "account_identifier")

    @account_identifier.setter
    def account_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_identifier", value)

    @_builtins.property
    @pulumi.getter(name="accountRegion")
    def account_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Web Services region where the environment exists.
        """
        return pulumi.get(self, "account_region")

    @account_region.setter
    def account_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_region", value)

    @_builtins.property
    @pulumi.getter(name="blueprintIdentifier")
    def blueprint_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The blueprint with which the environment is created.
        """
        return pulumi.get(self, "blueprint_identifier")

    @blueprint_identifier.setter
    def blueprint_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blueprint_identifier", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The business glossary terms that can be used in this environment.
        """
        return pulumi.get(self, "glossary_terms")

    @glossary_terms.setter
    def glossary_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "glossary_terms", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EnvironmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EnvironmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]]]:
        """
        The user parameters that are used in the environment.
        See User Parameters for more information.
        Changing these values recreates the resource.
        """
        return pulumi.get(self, "user_parameters")

    @user_parameters.setter
    def user_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]]]):
        pulumi.set(self, "user_parameters", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 account_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 account_region: Optional[pulumi.Input[_builtins.str]] = None,
                 blueprint_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_deployments: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentLastDeploymentArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_environment: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_resources: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentProvisionedResourceArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['EnvironmentTimeoutsArgs']] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[_builtins.str] account_identifier: The ID of the Amazon Web Services account where the environment exists
        :param pulumi.Input[_builtins.str] account_region: The Amazon Web Services region where the environment exists.
        :param pulumi.Input[_builtins.str] blueprint_identifier: The blueprint with which the environment is created.
        :param pulumi.Input[_builtins.str] created_at: The time the environment was created.
        :param pulumi.Input[_builtins.str] created_by: The user who created the environment.
        :param pulumi.Input[_builtins.str] description: The description of the environment.
        :param pulumi.Input[_builtins.str] domain_identifier: The ID of the domain where the environment exists.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] glossary_terms: The business glossary terms that can be used in this environment.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentLastDeploymentArgs']]] last_deployments: The details of the last deployment of the environment.
        :param pulumi.Input[_builtins.str] name: The name of the environment.
        :param pulumi.Input[_builtins.str] profile_identifier: The ID of the profile with which the environment is created.
        :param pulumi.Input[_builtins.str] project_identifier: The ID of the project where the environment exists.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] provider_environment: The provider of the environment.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]] user_parameters: The user parameters that are used in the environment.
               See User Parameters for more information.
               Changing these values recreates the resource.
        """
        if account_identifier is not None:
            pulumi.set(__self__, "account_identifier", account_identifier)
        if account_region is not None:
            pulumi.set(__self__, "account_region", account_region)
        if blueprint_identifier is not None:
            pulumi.set(__self__, "blueprint_identifier", blueprint_identifier)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if glossary_terms is not None:
            pulumi.set(__self__, "glossary_terms", glossary_terms)
        if last_deployments is not None:
            pulumi.set(__self__, "last_deployments", last_deployments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile_identifier is not None:
            pulumi.set(__self__, "profile_identifier", profile_identifier)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)
        if provider_environment is not None:
            pulumi.set(__self__, "provider_environment", provider_environment)
        if provisioned_resources is not None:
            pulumi.set(__self__, "provisioned_resources", provisioned_resources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_parameters is not None:
            pulumi.set(__self__, "user_parameters", user_parameters)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Amazon Web Services account where the environment exists
        """
        return pulumi.get(self, "account_identifier")

    @account_identifier.setter
    def account_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_identifier", value)

    @_builtins.property
    @pulumi.getter(name="accountRegion")
    def account_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Web Services region where the environment exists.
        """
        return pulumi.get(self, "account_region")

    @account_region.setter
    def account_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_region", value)

    @_builtins.property
    @pulumi.getter(name="blueprintIdentifier")
    def blueprint_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The blueprint with which the environment is created.
        """
        return pulumi.get(self, "blueprint_identifier")

    @blueprint_identifier.setter
    def blueprint_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blueprint_identifier", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the environment was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user who created the environment.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the domain where the environment exists.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @_builtins.property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The business glossary terms that can be used in this environment.
        """
        return pulumi.get(self, "glossary_terms")

    @glossary_terms.setter
    def glossary_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "glossary_terms", value)

    @_builtins.property
    @pulumi.getter(name="lastDeployments")
    def last_deployments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentLastDeploymentArgs']]]]:
        """
        The details of the last deployment of the environment.
        """
        return pulumi.get(self, "last_deployments")

    @last_deployments.setter
    def last_deployments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentLastDeploymentArgs']]]]):
        pulumi.set(self, "last_deployments", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="profileIdentifier")
    def profile_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the profile with which the environment is created.
        """
        return pulumi.get(self, "profile_identifier")

    @profile_identifier.setter
    def profile_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_identifier", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project where the environment exists.

        The following arguments are optional:
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_identifier", value)

    @_builtins.property
    @pulumi.getter(name="providerEnvironment")
    def provider_environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The provider of the environment.
        """
        return pulumi.get(self, "provider_environment")

    @provider_environment.setter
    def provider_environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_environment", value)

    @_builtins.property
    @pulumi.getter(name="provisionedResources")
    def provisioned_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentProvisionedResourceArgs']]]]:
        return pulumi.get(self, "provisioned_resources")

    @provisioned_resources.setter
    def provisioned_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentProvisionedResourceArgs']]]]):
        pulumi.set(self, "provisioned_resources", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EnvironmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EnvironmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]]]:
        """
        The user parameters that are used in the environment.
        See User Parameters for more information.
        Changing these values recreates the resource.
        """
        return pulumi.get(self, "user_parameters")

    @user_parameters.setter
    def user_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentUserParameterArgs']]]]):
        pulumi.set(self, "user_parameters", value)


@pulumi.type_token("aws:datazone/environment:Environment")
class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 account_region: Optional[pulumi.Input[_builtins.str]] = None,
                 blueprint_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['EnvironmentTimeoutsArgs', 'EnvironmentTimeoutsArgsDict']]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentUserParameterArgs', 'EnvironmentUserParameterArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DataZone Environment.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datazone.Environment("example",
            name="example",
            blueprint_identifier=test["environmentBlueprintId"],
            profile_identifier=test_aws_datazone_environment_profile["id"],
            project_identifier=test_aws_datazone_project["id"],
            domain_identifier=test_aws_datazone_domain["id"],
            user_parameters=[
                {
                    "name": "consumerGlueDbName",
                    "value": "consumer",
                },
                {
                    "name": "producerGlueDbName",
                    "value": "producer",
                },
                {
                    "name": "workgroupName",
                    "value": "workgroup",
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import DataZone Environment using the `domain_idntifier,id`. For example:

        ```sh
        $ pulumi import aws:datazone/environment:Environment example dzd_d2i7tzk3tnjjf4,5vpywijpwryec0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_identifier: The ID of the Amazon Web Services account where the environment exists
        :param pulumi.Input[_builtins.str] account_region: The Amazon Web Services region where the environment exists.
        :param pulumi.Input[_builtins.str] blueprint_identifier: The blueprint with which the environment is created.
        :param pulumi.Input[_builtins.str] description: The description of the environment.
        :param pulumi.Input[_builtins.str] domain_identifier: The ID of the domain where the environment exists.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] glossary_terms: The business glossary terms that can be used in this environment.
        :param pulumi.Input[_builtins.str] name: The name of the environment.
        :param pulumi.Input[_builtins.str] profile_identifier: The ID of the profile with which the environment is created.
        :param pulumi.Input[_builtins.str] project_identifier: The ID of the project where the environment exists.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentUserParameterArgs', 'EnvironmentUserParameterArgsDict']]]] user_parameters: The user parameters that are used in the environment.
               See User Parameters for more information.
               Changing these values recreates the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DataZone Environment.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datazone.Environment("example",
            name="example",
            blueprint_identifier=test["environmentBlueprintId"],
            profile_identifier=test_aws_datazone_environment_profile["id"],
            project_identifier=test_aws_datazone_project["id"],
            domain_identifier=test_aws_datazone_domain["id"],
            user_parameters=[
                {
                    "name": "consumerGlueDbName",
                    "value": "consumer",
                },
                {
                    "name": "producerGlueDbName",
                    "value": "producer",
                },
                {
                    "name": "workgroupName",
                    "value": "workgroup",
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import DataZone Environment using the `domain_idntifier,id`. For example:

        ```sh
        $ pulumi import aws:datazone/environment:Environment example dzd_d2i7tzk3tnjjf4,5vpywijpwryec0
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 account_region: Optional[pulumi.Input[_builtins.str]] = None,
                 blueprint_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['EnvironmentTimeoutsArgs', 'EnvironmentTimeoutsArgsDict']]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentUserParameterArgs', 'EnvironmentUserParameterArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["account_identifier"] = account_identifier
            __props__.__dict__["account_region"] = account_region
            __props__.__dict__["blueprint_identifier"] = blueprint_identifier
            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["glossary_terms"] = glossary_terms
            __props__.__dict__["name"] = name
            if profile_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'profile_identifier'")
            __props__.__dict__["profile_identifier"] = profile_identifier
            if project_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'project_identifier'")
            __props__.__dict__["project_identifier"] = project_identifier
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["user_parameters"] = user_parameters
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["last_deployments"] = None
            __props__.__dict__["provider_environment"] = None
            __props__.__dict__["provisioned_resources"] = None
        super(Environment, __self__).__init__(
            'aws:datazone/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            account_region: Optional[pulumi.Input[_builtins.str]] = None,
            blueprint_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            last_deployments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentLastDeploymentArgs', 'EnvironmentLastDeploymentArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            profile_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            provider_environment: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentProvisionedResourceArgs', 'EnvironmentProvisionedResourceArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['EnvironmentTimeoutsArgs', 'EnvironmentTimeoutsArgsDict']]] = None,
            user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentUserParameterArgs', 'EnvironmentUserParameterArgsDict']]]]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_identifier: The ID of the Amazon Web Services account where the environment exists
        :param pulumi.Input[_builtins.str] account_region: The Amazon Web Services region where the environment exists.
        :param pulumi.Input[_builtins.str] blueprint_identifier: The blueprint with which the environment is created.
        :param pulumi.Input[_builtins.str] created_at: The time the environment was created.
        :param pulumi.Input[_builtins.str] created_by: The user who created the environment.
        :param pulumi.Input[_builtins.str] description: The description of the environment.
        :param pulumi.Input[_builtins.str] domain_identifier: The ID of the domain where the environment exists.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] glossary_terms: The business glossary terms that can be used in this environment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentLastDeploymentArgs', 'EnvironmentLastDeploymentArgsDict']]]] last_deployments: The details of the last deployment of the environment.
        :param pulumi.Input[_builtins.str] name: The name of the environment.
        :param pulumi.Input[_builtins.str] profile_identifier: The ID of the profile with which the environment is created.
        :param pulumi.Input[_builtins.str] project_identifier: The ID of the project where the environment exists.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] provider_environment: The provider of the environment.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentUserParameterArgs', 'EnvironmentUserParameterArgsDict']]]] user_parameters: The user parameters that are used in the environment.
               See User Parameters for more information.
               Changing these values recreates the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["account_identifier"] = account_identifier
        __props__.__dict__["account_region"] = account_region
        __props__.__dict__["blueprint_identifier"] = blueprint_identifier
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_identifier"] = domain_identifier
        __props__.__dict__["glossary_terms"] = glossary_terms
        __props__.__dict__["last_deployments"] = last_deployments
        __props__.__dict__["name"] = name
        __props__.__dict__["profile_identifier"] = profile_identifier
        __props__.__dict__["project_identifier"] = project_identifier
        __props__.__dict__["provider_environment"] = provider_environment
        __props__.__dict__["provisioned_resources"] = provisioned_resources
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["user_parameters"] = user_parameters
        return Environment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountIdentifier")
    def account_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Amazon Web Services account where the environment exists
        """
        return pulumi.get(self, "account_identifier")

    @_builtins.property
    @pulumi.getter(name="accountRegion")
    def account_region(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Web Services region where the environment exists.
        """
        return pulumi.get(self, "account_region")

    @_builtins.property
    @pulumi.getter(name="blueprintIdentifier")
    def blueprint_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The blueprint with which the environment is created.
        """
        return pulumi.get(self, "blueprint_identifier")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The time the environment was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The user who created the environment.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the environment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the domain where the environment exists.
        """
        return pulumi.get(self, "domain_identifier")

    @_builtins.property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The business glossary terms that can be used in this environment.
        """
        return pulumi.get(self, "glossary_terms")

    @_builtins.property
    @pulumi.getter(name="lastDeployments")
    def last_deployments(self) -> pulumi.Output[Sequence['outputs.EnvironmentLastDeployment']]:
        """
        The details of the last deployment of the environment.
        """
        return pulumi.get(self, "last_deployments")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="profileIdentifier")
    def profile_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the profile with which the environment is created.
        """
        return pulumi.get(self, "profile_identifier")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project where the environment exists.

        The following arguments are optional:
        """
        return pulumi.get(self, "project_identifier")

    @_builtins.property
    @pulumi.getter(name="providerEnvironment")
    def provider_environment(self) -> pulumi.Output[_builtins.str]:
        """
        The provider of the environment.
        """
        return pulumi.get(self, "provider_environment")

    @_builtins.property
    @pulumi.getter(name="provisionedResources")
    def provisioned_resources(self) -> pulumi.Output[Sequence['outputs.EnvironmentProvisionedResource']]:
        return pulumi.get(self, "provisioned_resources")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.EnvironmentTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentUserParameter']]]:
        """
        The user parameters that are used in the environment.
        See User Parameters for more information.
        Changing these values recreates the resource.
        """
        return pulumi.get(self, "user_parameters")

