# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserProfileArgs', 'UserProfile']

@pulumi.input_type
class UserProfileArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[_builtins.str],
                 user_identifier: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['UserProfileTimeoutsArgs']] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserProfile resource.
        :param pulumi.Input[_builtins.str] domain_identifier: The domain identifier.
        :param pulumi.Input[_builtins.str] user_identifier: The user identifier.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The user profile status.
        :param pulumi.Input[_builtins.str] user_type: The user type.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "user_identifier", user_identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The domain identifier.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifier")
    def user_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The user identifier.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_identifier")

    @user_identifier.setter
    def user_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_identifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user profile status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['UserProfileTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['UserProfileTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user type.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.input_type
class _UserProfileState:
    def __init__(__self__, *,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['UserProfileDetailArgs']]]] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['UserProfileTimeoutsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserProfile resources.
        :param pulumi.Input[Sequence[pulumi.Input['UserProfileDetailArgs']]] details: Details about the user profile.
        :param pulumi.Input[_builtins.str] domain_identifier: The domain identifier.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The user profile status.
        :param pulumi.Input[_builtins.str] type: The user profile type.
        :param pulumi.Input[_builtins.str] user_identifier: The user identifier.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] user_type: The user type.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_identifier is not None:
            pulumi.set(__self__, "user_identifier", user_identifier)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserProfileDetailArgs']]]]:
        """
        Details about the user profile.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserProfileDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain identifier.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user profile status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['UserProfileTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['UserProfileTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user profile type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userIdentifier")
    def user_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user identifier.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_identifier")

    @user_identifier.setter
    def user_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_identifier", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user type.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("aws:datazone/userProfile:UserProfile")
class UserProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['UserProfileTimeoutsArgs', 'UserProfileTimeoutsArgsDict']]] = None,
                 user_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DataZone User Profile.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datazone.UserProfile("example",
            user_identifier=example_aws_iam_user["arn"],
            domain_identifier=example_aws_datazone_domain["id"],
            user_type="IAM_USER")
        ```

        ## Import

        Using `pulumi import`, import DataZone User Profile using the `user_identifier,domain_identifier,type`. For example:

        ```sh
        $ pulumi import aws:datazone/userProfile:UserProfile example arn:aws:iam::123456789012:user/example,dzd_54nakfrg9k6suo,IAM
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_identifier: The domain identifier.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The user profile status.
        :param pulumi.Input[_builtins.str] user_identifier: The user identifier.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] user_type: The user type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DataZone User Profile.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datazone.UserProfile("example",
            user_identifier=example_aws_iam_user["arn"],
            domain_identifier=example_aws_datazone_domain["id"],
            user_type="IAM_USER")
        ```

        ## Import

        Using `pulumi import`, import DataZone User Profile using the `user_identifier,domain_identifier,type`. For example:

        ```sh
        $ pulumi import aws:datazone/userProfile:UserProfile example arn:aws:iam::123456789012:user/example,dzd_54nakfrg9k6suo,IAM
        ```

        :param str resource_name: The name of the resource.
        :param UserProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['UserProfileTimeoutsArgs', 'UserProfileTimeoutsArgsDict']]] = None,
                 user_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserProfileArgs.__new__(UserProfileArgs)

            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
            __props__.__dict__["timeouts"] = timeouts
            if user_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'user_identifier'")
            __props__.__dict__["user_identifier"] = user_identifier
            __props__.__dict__["user_type"] = user_type
            __props__.__dict__["details"] = None
            __props__.__dict__["type"] = None
        super(UserProfile, __self__).__init__(
            'aws:datazone/userProfile:UserProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserProfileDetailArgs', 'UserProfileDetailArgsDict']]]]] = None,
            domain_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['UserProfileTimeoutsArgs', 'UserProfileTimeoutsArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserProfile':
        """
        Get an existing UserProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserProfileDetailArgs', 'UserProfileDetailArgsDict']]]] details: Details about the user profile.
        :param pulumi.Input[_builtins.str] domain_identifier: The domain identifier.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The user profile status.
        :param pulumi.Input[_builtins.str] type: The user profile type.
        :param pulumi.Input[_builtins.str] user_identifier: The user identifier.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] user_type: The user type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserProfileState.__new__(_UserProfileState)

        __props__.__dict__["details"] = details
        __props__.__dict__["domain_identifier"] = domain_identifier
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["type"] = type
        __props__.__dict__["user_identifier"] = user_identifier
        __props__.__dict__["user_type"] = user_type
        return UserProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def details(self) -> pulumi.Output[Sequence['outputs.UserProfileDetail']]:
        """
        Details about the user profile.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The domain identifier.
        """
        return pulumi.get(self, "domain_identifier")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The user profile status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.UserProfileTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The user profile type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userIdentifier")
    def user_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The user identifier.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_identifier")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[_builtins.str]:
        """
        The user type.
        """
        return pulumi.get(self, "user_type")

