# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ConditionalForwarderArgs', 'ConditionalForwarder']

@pulumi.input_type
class ConditionalForwarderArgs:
    def __init__(__self__, *,
                 directory_id: pulumi.Input[_builtins.str],
                 dns_ips: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 remote_domain_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConditionalForwarder resource.
        :param pulumi.Input[_builtins.str] directory_id: ID of directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_ips: A list of forwarder IP addresses.
        :param pulumi.Input[_builtins.str] remote_domain_name: The fully qualified domain name of the remote domain for which forwarders will be used.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "remote_domain_name", remote_domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of forwarder IP addresses.
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "dns_ips", value)

    @_builtins.property
    @pulumi.getter(name="remoteDomainName")
    def remote_domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        The fully qualified domain name of the remote domain for which forwarders will be used.
        """
        return pulumi.get(self, "remote_domain_name")

    @remote_domain_name.setter
    def remote_domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_domain_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ConditionalForwarderState:
    def __init__(__self__, *,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConditionalForwarder resources.
        :param pulumi.Input[_builtins.str] directory_id: ID of directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_ips: A list of forwarder IP addresses.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] remote_domain_name: The fully qualified domain name of the remote domain for which forwarders will be used.
        """
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_domain_name is not None:
            pulumi.set(__self__, "remote_domain_name", remote_domain_name)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of forwarder IP addresses.
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_ips", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remoteDomainName")
    def remote_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name of the remote domain for which forwarders will be used.
        """
        return pulumi.get(self, "remote_domain_name")

    @remote_domain_name.setter
    def remote_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_domain_name", value)


@pulumi.type_token("aws:directoryservice/conditionalForwarder:ConditionalForwarder")
class ConditionalForwarder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a conditional forwarder for managed Microsoft AD in AWS Directory Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directoryservice.ConditionalForwarder("example",
            directory_id=ad["id"],
            remote_domain_name="example.com",
            dns_ips=[
                "8.8.8.8",
                "8.8.4.4",
            ])
        ```

        ## Import

        Using `pulumi import`, import conditional forwarders using the directory id and remote_domain_name. For example:

        ```sh
        $ pulumi import aws:directoryservice/conditionalForwarder:ConditionalForwarder example d-1234567890:example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] directory_id: ID of directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_ips: A list of forwarder IP addresses.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] remote_domain_name: The fully qualified domain name of the remote domain for which forwarders will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConditionalForwarderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a conditional forwarder for managed Microsoft AD in AWS Directory Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.directoryservice.ConditionalForwarder("example",
            directory_id=ad["id"],
            remote_domain_name="example.com",
            dns_ips=[
                "8.8.8.8",
                "8.8.4.4",
            ])
        ```

        ## Import

        Using `pulumi import`, import conditional forwarders using the directory id and remote_domain_name. For example:

        ```sh
        $ pulumi import aws:directoryservice/conditionalForwarder:ConditionalForwarder example d-1234567890:example.com
        ```

        :param str resource_name: The name of the resource.
        :param ConditionalForwarderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConditionalForwarderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConditionalForwarderArgs.__new__(ConditionalForwarderArgs)

            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            if dns_ips is None and not opts.urn:
                raise TypeError("Missing required property 'dns_ips'")
            __props__.__dict__["dns_ips"] = dns_ips
            __props__.__dict__["region"] = region
            if remote_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'remote_domain_name'")
            __props__.__dict__["remote_domain_name"] = remote_domain_name
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:directoryservice/conditionalForwader:ConditionalForwader")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ConditionalForwarder, __self__).__init__(
            'aws:directoryservice/conditionalForwarder:ConditionalForwarder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            remote_domain_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConditionalForwarder':
        """
        Get an existing ConditionalForwarder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] directory_id: ID of directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_ips: A list of forwarder IP addresses.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] remote_domain_name: The fully qualified domain name of the remote domain for which forwarders will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConditionalForwarderState.__new__(_ConditionalForwarderState)

        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["dns_ips"] = dns_ips
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_domain_name"] = remote_domain_name
        return ConditionalForwarder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of forwarder IP addresses.
        """
        return pulumi.get(self, "dns_ips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="remoteDomainName")
    def remote_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name of the remote domain for which forwarders will be used.
        """
        return pulumi.get(self, "remote_domain_name")

