# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 endpoint_id: pulumi.Input[_builtins.str],
                 endpoint_type: pulumi.Input[_builtins.str],
                 engine_name: pulumi.Input[_builtins.str],
                 certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearch_settings: Optional[pulumi.Input['EndpointElasticsearchSettingsArgs']] = None,
                 extra_connection_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_settings: Optional[pulumi.Input['EndpointKafkaSettingsArgs']] = None,
                 kinesis_settings: Optional[pulumi.Input['EndpointKinesisSettingsArgs']] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodb_settings: Optional[pulumi.Input['EndpointMongodbSettingsArgs']] = None,
                 mysql_settings: Optional[pulumi.Input['EndpointMysqlSettingsArgs']] = None,
                 oracle_settings: Optional[pulumi.Input['EndpointOracleSettingsArgs']] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_replication_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres_settings: Optional[pulumi.Input['EndpointPostgresSettingsArgs']] = None,
                 redis_settings: Optional[pulumi.Input['EndpointRedisSettingsArgs']] = None,
                 redshift_settings: Optional[pulumi.Input['EndpointRedshiftSettingsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[_builtins.str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[_builtins.str] engine_name: Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `aurora-serverless`, `aurora-postgresql-serverless`,`azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`,`redshift-serverless`, `sqlserver`, `neptune` ,`sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
        :param pulumi.Input[_builtins.str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[_builtins.str] database_name: Name of the endpoint database.
        :param pulumi.Input['EndpointElasticsearchSettingsArgs'] elasticsearch_settings: Configuration block for OpenSearch settings. See below.
        :param pulumi.Input[_builtins.str] extra_connection_attributes: Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.html). For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
        :param pulumi.Input['EndpointKafkaSettingsArgs'] kafka_settings: Configuration block for Kafka settings. See below.
        :param pulumi.Input['EndpointKinesisSettingsArgs'] kinesis_settings: Configuration block for Kinesis settings. See below.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
               
               The following arguments are optional:
        :param pulumi.Input['EndpointMongodbSettingsArgs'] mongodb_settings: Configuration block for MongoDB settings. See below.
        :param pulumi.Input['EndpointMysqlSettingsArgs'] mysql_settings: Configuration block for MySQL settings. See below.
        :param pulumi.Input['EndpointOracleSettingsArgs'] oracle_settings: Configuration block for Oracle settings. See below.
        :param pulumi.Input[_builtins.str] password: Password to be used to login to the endpoint database.
        :param pulumi.Input[_builtins.int] port: Port used by the endpoint database.
        :param pulumi.Input['EndpointPostgresSettingsArgs'] postgres_settings: Configuration block for Postgres settings. See below.
        :param pulumi.Input['EndpointRedshiftSettingsArgs'] redshift_settings: Configuration block for Redshift settings. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] secrets_manager_access_role_arn: ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
               
               > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
        :param pulumi.Input[_builtins.str] secrets_manager_arn: Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
        :param pulumi.Input[_builtins.str] server_name: Host name of the server.
        :param pulumi.Input[_builtins.str] service_access_role: ARN used by the service access IAM role for dynamodb endpoints.
        :param pulumi.Input[_builtins.str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] username: User name to be used to login to the endpoint database.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "engine_name", engine_name)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if elasticsearch_settings is not None:
            pulumi.set(__self__, "elasticsearch_settings", elasticsearch_settings)
        if extra_connection_attributes is not None:
            pulumi.set(__self__, "extra_connection_attributes", extra_connection_attributes)
        if kafka_settings is not None:
            pulumi.set(__self__, "kafka_settings", kafka_settings)
        if kinesis_settings is not None:
            pulumi.set(__self__, "kinesis_settings", kinesis_settings)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if mongodb_settings is not None:
            pulumi.set(__self__, "mongodb_settings", mongodb_settings)
        if mysql_settings is not None:
            pulumi.set(__self__, "mysql_settings", mysql_settings)
        if oracle_settings is not None:
            pulumi.set(__self__, "oracle_settings", oracle_settings)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pause_replication_tasks is not None:
            pulumi.set(__self__, "pause_replication_tasks", pause_replication_tasks)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if postgres_settings is not None:
            pulumi.set(__self__, "postgres_settings", postgres_settings)
        if redis_settings is not None:
            pulumi.set(__self__, "redis_settings", redis_settings)
        if redshift_settings is not None:
            pulumi.set(__self__, "redshift_settings", redshift_settings)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secrets_manager_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_access_role_arn", secrets_manager_access_role_arn)
        if secrets_manager_arn is not None:
            pulumi.set(__self__, "secrets_manager_arn", secrets_manager_arn)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if service_access_role is not None:
            pulumi.set(__self__, "service_access_role", service_access_role)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of endpoint. Valid values are `source`, `target`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_type", value)

    @_builtins.property
    @pulumi.getter(name="engineName")
    def engine_name(self) -> pulumi.Input[_builtins.str]:
        """
        Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `aurora-serverless`, `aurora-postgresql-serverless`,`azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`,`redshift-serverless`, `sqlserver`, `neptune` ,`sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
        """
        return pulumi.get(self, "engine_name")

    @engine_name.setter
    def engine_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_name", value)

    @_builtins.property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the endpoint database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="elasticsearchSettings")
    def elasticsearch_settings(self) -> Optional[pulumi.Input['EndpointElasticsearchSettingsArgs']]:
        """
        Configuration block for OpenSearch settings. See below.
        """
        return pulumi.get(self, "elasticsearch_settings")

    @elasticsearch_settings.setter
    def elasticsearch_settings(self, value: Optional[pulumi.Input['EndpointElasticsearchSettingsArgs']]):
        pulumi.set(self, "elasticsearch_settings", value)

    @_builtins.property
    @pulumi.getter(name="extraConnectionAttributes")
    def extra_connection_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.html). For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
        """
        return pulumi.get(self, "extra_connection_attributes")

    @extra_connection_attributes.setter
    def extra_connection_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extra_connection_attributes", value)

    @_builtins.property
    @pulumi.getter(name="kafkaSettings")
    def kafka_settings(self) -> Optional[pulumi.Input['EndpointKafkaSettingsArgs']]:
        """
        Configuration block for Kafka settings. See below.
        """
        return pulumi.get(self, "kafka_settings")

    @kafka_settings.setter
    def kafka_settings(self, value: Optional[pulumi.Input['EndpointKafkaSettingsArgs']]):
        pulumi.set(self, "kafka_settings", value)

    @_builtins.property
    @pulumi.getter(name="kinesisSettings")
    def kinesis_settings(self) -> Optional[pulumi.Input['EndpointKinesisSettingsArgs']]:
        """
        Configuration block for Kinesis settings. See below.
        """
        return pulumi.get(self, "kinesis_settings")

    @kinesis_settings.setter
    def kinesis_settings(self, value: Optional[pulumi.Input['EndpointKinesisSettingsArgs']]):
        pulumi.set(self, "kinesis_settings", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.

        The following arguments are optional:
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="mongodbSettings")
    def mongodb_settings(self) -> Optional[pulumi.Input['EndpointMongodbSettingsArgs']]:
        """
        Configuration block for MongoDB settings. See below.
        """
        return pulumi.get(self, "mongodb_settings")

    @mongodb_settings.setter
    def mongodb_settings(self, value: Optional[pulumi.Input['EndpointMongodbSettingsArgs']]):
        pulumi.set(self, "mongodb_settings", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSettings")
    def mysql_settings(self) -> Optional[pulumi.Input['EndpointMysqlSettingsArgs']]:
        """
        Configuration block for MySQL settings. See below.
        """
        return pulumi.get(self, "mysql_settings")

    @mysql_settings.setter
    def mysql_settings(self, value: Optional[pulumi.Input['EndpointMysqlSettingsArgs']]):
        pulumi.set(self, "mysql_settings", value)

    @_builtins.property
    @pulumi.getter(name="oracleSettings")
    def oracle_settings(self) -> Optional[pulumi.Input['EndpointOracleSettingsArgs']]:
        """
        Configuration block for Oracle settings. See below.
        """
        return pulumi.get(self, "oracle_settings")

    @oracle_settings.setter
    def oracle_settings(self, value: Optional[pulumi.Input['EndpointOracleSettingsArgs']]):
        pulumi.set(self, "oracle_settings", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to be used to login to the endpoint database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pauseReplicationTasks")
    def pause_replication_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "pause_replication_tasks")

    @pause_replication_tasks.setter
    def pause_replication_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pause_replication_tasks", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port used by the endpoint database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="postgresSettings")
    def postgres_settings(self) -> Optional[pulumi.Input['EndpointPostgresSettingsArgs']]:
        """
        Configuration block for Postgres settings. See below.
        """
        return pulumi.get(self, "postgres_settings")

    @postgres_settings.setter
    def postgres_settings(self, value: Optional[pulumi.Input['EndpointPostgresSettingsArgs']]):
        pulumi.set(self, "postgres_settings", value)

    @_builtins.property
    @pulumi.getter(name="redisSettings")
    def redis_settings(self) -> Optional[pulumi.Input['EndpointRedisSettingsArgs']]:
        return pulumi.get(self, "redis_settings")

    @redis_settings.setter
    def redis_settings(self, value: Optional[pulumi.Input['EndpointRedisSettingsArgs']]):
        pulumi.set(self, "redis_settings", value)

    @_builtins.property
    @pulumi.getter(name="redshiftSettings")
    def redshift_settings(self) -> Optional[pulumi.Input['EndpointRedshiftSettingsArgs']]:
        """
        Configuration block for Redshift settings. See below.
        """
        return pulumi.get(self, "redshift_settings")

    @redshift_settings.setter
    def redshift_settings(self, value: Optional[pulumi.Input['EndpointRedshiftSettingsArgs']]):
        pulumi.set(self, "redshift_settings", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretsManagerAccessRoleArn")
    def secrets_manager_access_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.

        > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
        """
        return pulumi.get(self, "secrets_manager_access_role_arn")

    @secrets_manager_access_role_arn.setter
    def secrets_manager_access_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secrets_manager_access_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @secrets_manager_arn.setter
    def secrets_manager_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secrets_manager_arn", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name of the server.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccessRole")
    def service_access_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN used by the service access IAM role for dynamodb endpoints.
        """
        return pulumi.get(self, "service_access_role")

    @service_access_role.setter
    def service_access_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_access_role", value)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name to be used to login to the endpoint database.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearch_settings: Optional[pulumi.Input['EndpointElasticsearchSettingsArgs']] = None,
                 endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_connection_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_settings: Optional[pulumi.Input['EndpointKafkaSettingsArgs']] = None,
                 kinesis_settings: Optional[pulumi.Input['EndpointKinesisSettingsArgs']] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodb_settings: Optional[pulumi.Input['EndpointMongodbSettingsArgs']] = None,
                 mysql_settings: Optional[pulumi.Input['EndpointMysqlSettingsArgs']] = None,
                 oracle_settings: Optional[pulumi.Input['EndpointOracleSettingsArgs']] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_replication_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres_settings: Optional[pulumi.Input['EndpointPostgresSettingsArgs']] = None,
                 redis_settings: Optional[pulumi.Input['EndpointRedisSettingsArgs']] = None,
                 redshift_settings: Optional[pulumi.Input['EndpointRedshiftSettingsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[_builtins.str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[_builtins.str] database_name: Name of the endpoint database.
        :param pulumi.Input['EndpointElasticsearchSettingsArgs'] elasticsearch_settings: Configuration block for OpenSearch settings. See below.
        :param pulumi.Input[_builtins.str] endpoint_arn: ARN for the endpoint.
        :param pulumi.Input[_builtins.str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[_builtins.str] engine_name: Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `aurora-serverless`, `aurora-postgresql-serverless`,`azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`,`redshift-serverless`, `sqlserver`, `neptune` ,`sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
        :param pulumi.Input[_builtins.str] extra_connection_attributes: Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.html). For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
        :param pulumi.Input['EndpointKafkaSettingsArgs'] kafka_settings: Configuration block for Kafka settings. See below.
        :param pulumi.Input['EndpointKinesisSettingsArgs'] kinesis_settings: Configuration block for Kinesis settings. See below.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
               
               The following arguments are optional:
        :param pulumi.Input['EndpointMongodbSettingsArgs'] mongodb_settings: Configuration block for MongoDB settings. See below.
        :param pulumi.Input['EndpointMysqlSettingsArgs'] mysql_settings: Configuration block for MySQL settings. See below.
        :param pulumi.Input['EndpointOracleSettingsArgs'] oracle_settings: Configuration block for Oracle settings. See below.
        :param pulumi.Input[_builtins.str] password: Password to be used to login to the endpoint database.
        :param pulumi.Input[_builtins.int] port: Port used by the endpoint database.
        :param pulumi.Input['EndpointPostgresSettingsArgs'] postgres_settings: Configuration block for Postgres settings. See below.
        :param pulumi.Input['EndpointRedshiftSettingsArgs'] redshift_settings: Configuration block for Redshift settings. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] secrets_manager_access_role_arn: ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
               
               > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
        :param pulumi.Input[_builtins.str] secrets_manager_arn: Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
        :param pulumi.Input[_builtins.str] server_name: Host name of the server.
        :param pulumi.Input[_builtins.str] service_access_role: ARN used by the service access IAM role for dynamodb endpoints.
        :param pulumi.Input[_builtins.str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] username: User name to be used to login to the endpoint database.
        """
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if elasticsearch_settings is not None:
            pulumi.set(__self__, "elasticsearch_settings", elasticsearch_settings)
        if endpoint_arn is not None:
            pulumi.set(__self__, "endpoint_arn", endpoint_arn)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if engine_name is not None:
            pulumi.set(__self__, "engine_name", engine_name)
        if extra_connection_attributes is not None:
            pulumi.set(__self__, "extra_connection_attributes", extra_connection_attributes)
        if kafka_settings is not None:
            pulumi.set(__self__, "kafka_settings", kafka_settings)
        if kinesis_settings is not None:
            pulumi.set(__self__, "kinesis_settings", kinesis_settings)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if mongodb_settings is not None:
            pulumi.set(__self__, "mongodb_settings", mongodb_settings)
        if mysql_settings is not None:
            pulumi.set(__self__, "mysql_settings", mysql_settings)
        if oracle_settings is not None:
            pulumi.set(__self__, "oracle_settings", oracle_settings)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pause_replication_tasks is not None:
            pulumi.set(__self__, "pause_replication_tasks", pause_replication_tasks)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if postgres_settings is not None:
            pulumi.set(__self__, "postgres_settings", postgres_settings)
        if redis_settings is not None:
            pulumi.set(__self__, "redis_settings", redis_settings)
        if redshift_settings is not None:
            pulumi.set(__self__, "redshift_settings", redshift_settings)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secrets_manager_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_access_role_arn", secrets_manager_access_role_arn)
        if secrets_manager_arn is not None:
            pulumi.set(__self__, "secrets_manager_arn", secrets_manager_arn)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if service_access_role is not None:
            pulumi.set(__self__, "service_access_role", service_access_role)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the endpoint database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="elasticsearchSettings")
    def elasticsearch_settings(self) -> Optional[pulumi.Input['EndpointElasticsearchSettingsArgs']]:
        """
        Configuration block for OpenSearch settings. See below.
        """
        return pulumi.get(self, "elasticsearch_settings")

    @elasticsearch_settings.setter
    def elasticsearch_settings(self, value: Optional[pulumi.Input['EndpointElasticsearchSettingsArgs']]):
        pulumi.set(self, "elasticsearch_settings", value)

    @_builtins.property
    @pulumi.getter(name="endpointArn")
    def endpoint_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the endpoint.
        """
        return pulumi.get(self, "endpoint_arn")

    @endpoint_arn.setter
    def endpoint_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_arn", value)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of endpoint. Valid values are `source`, `target`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @_builtins.property
    @pulumi.getter(name="engineName")
    def engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `aurora-serverless`, `aurora-postgresql-serverless`,`azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`,`redshift-serverless`, `sqlserver`, `neptune` ,`sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
        """
        return pulumi.get(self, "engine_name")

    @engine_name.setter
    def engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_name", value)

    @_builtins.property
    @pulumi.getter(name="extraConnectionAttributes")
    def extra_connection_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.html). For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
        """
        return pulumi.get(self, "extra_connection_attributes")

    @extra_connection_attributes.setter
    def extra_connection_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extra_connection_attributes", value)

    @_builtins.property
    @pulumi.getter(name="kafkaSettings")
    def kafka_settings(self) -> Optional[pulumi.Input['EndpointKafkaSettingsArgs']]:
        """
        Configuration block for Kafka settings. See below.
        """
        return pulumi.get(self, "kafka_settings")

    @kafka_settings.setter
    def kafka_settings(self, value: Optional[pulumi.Input['EndpointKafkaSettingsArgs']]):
        pulumi.set(self, "kafka_settings", value)

    @_builtins.property
    @pulumi.getter(name="kinesisSettings")
    def kinesis_settings(self) -> Optional[pulumi.Input['EndpointKinesisSettingsArgs']]:
        """
        Configuration block for Kinesis settings. See below.
        """
        return pulumi.get(self, "kinesis_settings")

    @kinesis_settings.setter
    def kinesis_settings(self, value: Optional[pulumi.Input['EndpointKinesisSettingsArgs']]):
        pulumi.set(self, "kinesis_settings", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.

        The following arguments are optional:
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="mongodbSettings")
    def mongodb_settings(self) -> Optional[pulumi.Input['EndpointMongodbSettingsArgs']]:
        """
        Configuration block for MongoDB settings. See below.
        """
        return pulumi.get(self, "mongodb_settings")

    @mongodb_settings.setter
    def mongodb_settings(self, value: Optional[pulumi.Input['EndpointMongodbSettingsArgs']]):
        pulumi.set(self, "mongodb_settings", value)

    @_builtins.property
    @pulumi.getter(name="mysqlSettings")
    def mysql_settings(self) -> Optional[pulumi.Input['EndpointMysqlSettingsArgs']]:
        """
        Configuration block for MySQL settings. See below.
        """
        return pulumi.get(self, "mysql_settings")

    @mysql_settings.setter
    def mysql_settings(self, value: Optional[pulumi.Input['EndpointMysqlSettingsArgs']]):
        pulumi.set(self, "mysql_settings", value)

    @_builtins.property
    @pulumi.getter(name="oracleSettings")
    def oracle_settings(self) -> Optional[pulumi.Input['EndpointOracleSettingsArgs']]:
        """
        Configuration block for Oracle settings. See below.
        """
        return pulumi.get(self, "oracle_settings")

    @oracle_settings.setter
    def oracle_settings(self, value: Optional[pulumi.Input['EndpointOracleSettingsArgs']]):
        pulumi.set(self, "oracle_settings", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to be used to login to the endpoint database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pauseReplicationTasks")
    def pause_replication_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "pause_replication_tasks")

    @pause_replication_tasks.setter
    def pause_replication_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pause_replication_tasks", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port used by the endpoint database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="postgresSettings")
    def postgres_settings(self) -> Optional[pulumi.Input['EndpointPostgresSettingsArgs']]:
        """
        Configuration block for Postgres settings. See below.
        """
        return pulumi.get(self, "postgres_settings")

    @postgres_settings.setter
    def postgres_settings(self, value: Optional[pulumi.Input['EndpointPostgresSettingsArgs']]):
        pulumi.set(self, "postgres_settings", value)

    @_builtins.property
    @pulumi.getter(name="redisSettings")
    def redis_settings(self) -> Optional[pulumi.Input['EndpointRedisSettingsArgs']]:
        return pulumi.get(self, "redis_settings")

    @redis_settings.setter
    def redis_settings(self, value: Optional[pulumi.Input['EndpointRedisSettingsArgs']]):
        pulumi.set(self, "redis_settings", value)

    @_builtins.property
    @pulumi.getter(name="redshiftSettings")
    def redshift_settings(self) -> Optional[pulumi.Input['EndpointRedshiftSettingsArgs']]:
        """
        Configuration block for Redshift settings. See below.
        """
        return pulumi.get(self, "redshift_settings")

    @redshift_settings.setter
    def redshift_settings(self, value: Optional[pulumi.Input['EndpointRedshiftSettingsArgs']]):
        pulumi.set(self, "redshift_settings", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretsManagerAccessRoleArn")
    def secrets_manager_access_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.

        > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
        """
        return pulumi.get(self, "secrets_manager_access_role_arn")

    @secrets_manager_access_role_arn.setter
    def secrets_manager_access_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secrets_manager_access_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @secrets_manager_arn.setter
    def secrets_manager_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secrets_manager_arn", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host name of the server.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccessRole")
    def service_access_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN used by the service access IAM role for dynamodb endpoints.
        """
        return pulumi.get(self, "service_access_role")

    @service_access_role.setter
    def service_access_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_access_role", value)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name to be used to login to the endpoint database.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("aws:dms/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearch_settings: Optional[pulumi.Input[Union['EndpointElasticsearchSettingsArgs', 'EndpointElasticsearchSettingsArgsDict']]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_connection_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_settings: Optional[pulumi.Input[Union['EndpointKafkaSettingsArgs', 'EndpointKafkaSettingsArgsDict']]] = None,
                 kinesis_settings: Optional[pulumi.Input[Union['EndpointKinesisSettingsArgs', 'EndpointKinesisSettingsArgsDict']]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodb_settings: Optional[pulumi.Input[Union['EndpointMongodbSettingsArgs', 'EndpointMongodbSettingsArgsDict']]] = None,
                 mysql_settings: Optional[pulumi.Input[Union['EndpointMysqlSettingsArgs', 'EndpointMysqlSettingsArgsDict']]] = None,
                 oracle_settings: Optional[pulumi.Input[Union['EndpointOracleSettingsArgs', 'EndpointOracleSettingsArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_replication_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres_settings: Optional[pulumi.Input[Union['EndpointPostgresSettingsArgs', 'EndpointPostgresSettingsArgsDict']]] = None,
                 redis_settings: Optional[pulumi.Input[Union['EndpointRedisSettingsArgs', 'EndpointRedisSettingsArgsDict']]] = None,
                 redshift_settings: Optional[pulumi.Input[Union['EndpointRedshiftSettingsArgs', 'EndpointRedshiftSettingsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DMS (Data Migration Service) endpoint resource. DMS endpoints can be created, updated, deleted, and imported.

        > **Note:** All arguments including the password will be stored in the raw state as plain-text. ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.dms.Endpoint("test",
            certificate_arn="arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
            database_name="test",
            endpoint_id="test-dms-endpoint-tf",
            endpoint_type="source",
            engine_name="aurora",
            extra_connection_attributes="",
            kms_key_arn="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
            password="test",
            port=3306,
            server_name="test",
            ssl_mode="none",
            tags={
                "Name": "test",
            },
            username="test")
        ```

        ## Import

        Using `pulumi import`, import endpoints using the `endpoint_id`. For example:

        ```sh
        $ pulumi import aws:dms/endpoint:Endpoint test test-dms-endpoint-tf
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[_builtins.str] database_name: Name of the endpoint database.
        :param pulumi.Input[Union['EndpointElasticsearchSettingsArgs', 'EndpointElasticsearchSettingsArgsDict']] elasticsearch_settings: Configuration block for OpenSearch settings. See below.
        :param pulumi.Input[_builtins.str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[_builtins.str] engine_name: Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `aurora-serverless`, `aurora-postgresql-serverless`,`azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`,`redshift-serverless`, `sqlserver`, `neptune` ,`sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
        :param pulumi.Input[_builtins.str] extra_connection_attributes: Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.html). For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
        :param pulumi.Input[Union['EndpointKafkaSettingsArgs', 'EndpointKafkaSettingsArgsDict']] kafka_settings: Configuration block for Kafka settings. See below.
        :param pulumi.Input[Union['EndpointKinesisSettingsArgs', 'EndpointKinesisSettingsArgsDict']] kinesis_settings: Configuration block for Kinesis settings. See below.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
               
               The following arguments are optional:
        :param pulumi.Input[Union['EndpointMongodbSettingsArgs', 'EndpointMongodbSettingsArgsDict']] mongodb_settings: Configuration block for MongoDB settings. See below.
        :param pulumi.Input[Union['EndpointMysqlSettingsArgs', 'EndpointMysqlSettingsArgsDict']] mysql_settings: Configuration block for MySQL settings. See below.
        :param pulumi.Input[Union['EndpointOracleSettingsArgs', 'EndpointOracleSettingsArgsDict']] oracle_settings: Configuration block for Oracle settings. See below.
        :param pulumi.Input[_builtins.str] password: Password to be used to login to the endpoint database.
        :param pulumi.Input[_builtins.int] port: Port used by the endpoint database.
        :param pulumi.Input[Union['EndpointPostgresSettingsArgs', 'EndpointPostgresSettingsArgsDict']] postgres_settings: Configuration block for Postgres settings. See below.
        :param pulumi.Input[Union['EndpointRedshiftSettingsArgs', 'EndpointRedshiftSettingsArgsDict']] redshift_settings: Configuration block for Redshift settings. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] secrets_manager_access_role_arn: ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
               
               > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
        :param pulumi.Input[_builtins.str] secrets_manager_arn: Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
        :param pulumi.Input[_builtins.str] server_name: Host name of the server.
        :param pulumi.Input[_builtins.str] service_access_role: ARN used by the service access IAM role for dynamodb endpoints.
        :param pulumi.Input[_builtins.str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] username: User name to be used to login to the endpoint database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DMS (Data Migration Service) endpoint resource. DMS endpoints can be created, updated, deleted, and imported.

        > **Note:** All arguments including the password will be stored in the raw state as plain-text. ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.dms.Endpoint("test",
            certificate_arn="arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012",
            database_name="test",
            endpoint_id="test-dms-endpoint-tf",
            endpoint_type="source",
            engine_name="aurora",
            extra_connection_attributes="",
            kms_key_arn="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
            password="test",
            port=3306,
            server_name="test",
            ssl_mode="none",
            tags={
                "Name": "test",
            },
            username="test")
        ```

        ## Import

        Using `pulumi import`, import endpoints using the `endpoint_id`. For example:

        ```sh
        $ pulumi import aws:dms/endpoint:Endpoint test test-dms-endpoint-tf
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearch_settings: Optional[pulumi.Input[Union['EndpointElasticsearchSettingsArgs', 'EndpointElasticsearchSettingsArgsDict']]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_connection_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_settings: Optional[pulumi.Input[Union['EndpointKafkaSettingsArgs', 'EndpointKafkaSettingsArgsDict']]] = None,
                 kinesis_settings: Optional[pulumi.Input[Union['EndpointKinesisSettingsArgs', 'EndpointKinesisSettingsArgsDict']]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodb_settings: Optional[pulumi.Input[Union['EndpointMongodbSettingsArgs', 'EndpointMongodbSettingsArgsDict']]] = None,
                 mysql_settings: Optional[pulumi.Input[Union['EndpointMysqlSettingsArgs', 'EndpointMysqlSettingsArgsDict']]] = None,
                 oracle_settings: Optional[pulumi.Input[Union['EndpointOracleSettingsArgs', 'EndpointOracleSettingsArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_replication_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres_settings: Optional[pulumi.Input[Union['EndpointPostgresSettingsArgs', 'EndpointPostgresSettingsArgsDict']]] = None,
                 redis_settings: Optional[pulumi.Input[Union['EndpointRedisSettingsArgs', 'EndpointRedisSettingsArgsDict']]] = None,
                 redshift_settings: Optional[pulumi.Input[Union['EndpointRedshiftSettingsArgs', 'EndpointRedshiftSettingsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets_manager_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            __props__.__dict__["certificate_arn"] = certificate_arn
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["elasticsearch_settings"] = elasticsearch_settings
            if endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_id'")
            __props__.__dict__["endpoint_id"] = endpoint_id
            if endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__.__dict__["endpoint_type"] = endpoint_type
            if engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'engine_name'")
            __props__.__dict__["engine_name"] = engine_name
            __props__.__dict__["extra_connection_attributes"] = extra_connection_attributes
            __props__.__dict__["kafka_settings"] = kafka_settings
            __props__.__dict__["kinesis_settings"] = kinesis_settings
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["mongodb_settings"] = mongodb_settings
            __props__.__dict__["mysql_settings"] = mysql_settings
            __props__.__dict__["oracle_settings"] = oracle_settings
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["pause_replication_tasks"] = pause_replication_tasks
            __props__.__dict__["port"] = port
            __props__.__dict__["postgres_settings"] = postgres_settings
            __props__.__dict__["redis_settings"] = redis_settings
            __props__.__dict__["redshift_settings"] = redshift_settings
            __props__.__dict__["region"] = region
            __props__.__dict__["secrets_manager_access_role_arn"] = secrets_manager_access_role_arn
            __props__.__dict__["secrets_manager_arn"] = secrets_manager_arn
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["service_access_role"] = service_access_role
            __props__.__dict__["ssl_mode"] = ssl_mode
            __props__.__dict__["tags"] = tags
            __props__.__dict__["username"] = username
            __props__.__dict__["endpoint_arn"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Endpoint, __self__).__init__(
            'aws:dms/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            elasticsearch_settings: Optional[pulumi.Input[Union['EndpointElasticsearchSettingsArgs', 'EndpointElasticsearchSettingsArgsDict']]] = None,
            endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
            engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            extra_connection_attributes: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_settings: Optional[pulumi.Input[Union['EndpointKafkaSettingsArgs', 'EndpointKafkaSettingsArgsDict']]] = None,
            kinesis_settings: Optional[pulumi.Input[Union['EndpointKinesisSettingsArgs', 'EndpointKinesisSettingsArgsDict']]] = None,
            kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            mongodb_settings: Optional[pulumi.Input[Union['EndpointMongodbSettingsArgs', 'EndpointMongodbSettingsArgsDict']]] = None,
            mysql_settings: Optional[pulumi.Input[Union['EndpointMysqlSettingsArgs', 'EndpointMysqlSettingsArgsDict']]] = None,
            oracle_settings: Optional[pulumi.Input[Union['EndpointOracleSettingsArgs', 'EndpointOracleSettingsArgsDict']]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            pause_replication_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            postgres_settings: Optional[pulumi.Input[Union['EndpointPostgresSettingsArgs', 'EndpointPostgresSettingsArgsDict']]] = None,
            redis_settings: Optional[pulumi.Input[Union['EndpointRedisSettingsArgs', 'EndpointRedisSettingsArgsDict']]] = None,
            redshift_settings: Optional[pulumi.Input[Union['EndpointRedshiftSettingsArgs', 'EndpointRedshiftSettingsArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secrets_manager_access_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            secrets_manager_arn: Optional[pulumi.Input[_builtins.str]] = None,
            server_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_access_role: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_mode: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[_builtins.str] database_name: Name of the endpoint database.
        :param pulumi.Input[Union['EndpointElasticsearchSettingsArgs', 'EndpointElasticsearchSettingsArgsDict']] elasticsearch_settings: Configuration block for OpenSearch settings. See below.
        :param pulumi.Input[_builtins.str] endpoint_arn: ARN for the endpoint.
        :param pulumi.Input[_builtins.str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[_builtins.str] engine_name: Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `aurora-serverless`, `aurora-postgresql-serverless`,`azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`,`redshift-serverless`, `sqlserver`, `neptune` ,`sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
        :param pulumi.Input[_builtins.str] extra_connection_attributes: Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.html). For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
        :param pulumi.Input[Union['EndpointKafkaSettingsArgs', 'EndpointKafkaSettingsArgsDict']] kafka_settings: Configuration block for Kafka settings. See below.
        :param pulumi.Input[Union['EndpointKinesisSettingsArgs', 'EndpointKinesisSettingsArgsDict']] kinesis_settings: Configuration block for Kinesis settings. See below.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.
               
               The following arguments are optional:
        :param pulumi.Input[Union['EndpointMongodbSettingsArgs', 'EndpointMongodbSettingsArgsDict']] mongodb_settings: Configuration block for MongoDB settings. See below.
        :param pulumi.Input[Union['EndpointMysqlSettingsArgs', 'EndpointMysqlSettingsArgsDict']] mysql_settings: Configuration block for MySQL settings. See below.
        :param pulumi.Input[Union['EndpointOracleSettingsArgs', 'EndpointOracleSettingsArgsDict']] oracle_settings: Configuration block for Oracle settings. See below.
        :param pulumi.Input[_builtins.str] password: Password to be used to login to the endpoint database.
        :param pulumi.Input[_builtins.int] port: Port used by the endpoint database.
        :param pulumi.Input[Union['EndpointPostgresSettingsArgs', 'EndpointPostgresSettingsArgsDict']] postgres_settings: Configuration block for Postgres settings. See below.
        :param pulumi.Input[Union['EndpointRedshiftSettingsArgs', 'EndpointRedshiftSettingsArgsDict']] redshift_settings: Configuration block for Redshift settings. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] secrets_manager_access_role_arn: ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.
               
               > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
        :param pulumi.Input[_builtins.str] secrets_manager_arn: Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
        :param pulumi.Input[_builtins.str] server_name: Host name of the server.
        :param pulumi.Input[_builtins.str] service_access_role: ARN used by the service access IAM role for dynamodb endpoints.
        :param pulumi.Input[_builtins.str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] username: User name to be used to login to the endpoint database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["certificate_arn"] = certificate_arn
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["elasticsearch_settings"] = elasticsearch_settings
        __props__.__dict__["endpoint_arn"] = endpoint_arn
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["engine_name"] = engine_name
        __props__.__dict__["extra_connection_attributes"] = extra_connection_attributes
        __props__.__dict__["kafka_settings"] = kafka_settings
        __props__.__dict__["kinesis_settings"] = kinesis_settings
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["mongodb_settings"] = mongodb_settings
        __props__.__dict__["mysql_settings"] = mysql_settings
        __props__.__dict__["oracle_settings"] = oracle_settings
        __props__.__dict__["password"] = password
        __props__.__dict__["pause_replication_tasks"] = pause_replication_tasks
        __props__.__dict__["port"] = port
        __props__.__dict__["postgres_settings"] = postgres_settings
        __props__.__dict__["redis_settings"] = redis_settings
        __props__.__dict__["redshift_settings"] = redshift_settings
        __props__.__dict__["region"] = region
        __props__.__dict__["secrets_manager_access_role_arn"] = secrets_manager_access_role_arn
        __props__.__dict__["secrets_manager_arn"] = secrets_manager_arn
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["service_access_role"] = service_access_role
        __props__.__dict__["ssl_mode"] = ssl_mode
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["username"] = username
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN for the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the endpoint database.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="elasticsearchSettings")
    def elasticsearch_settings(self) -> pulumi.Output[Optional['outputs.EndpointElasticsearchSettings']]:
        """
        Configuration block for OpenSearch settings. See below.
        """
        return pulumi.get(self, "elasticsearch_settings")

    @_builtins.property
    @pulumi.getter(name="endpointArn")
    def endpoint_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN for the endpoint.
        """
        return pulumi.get(self, "endpoint_arn")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of endpoint. Valid values are `source`, `target`.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter(name="engineName")
    def engine_name(self) -> pulumi.Output[_builtins.str]:
        """
        Type of engine for the endpoint. Valid values are `aurora`, `aurora-postgresql`, `aurora-serverless`, `aurora-postgresql-serverless`,`azuredb`, `azure-sql-managed-instance`, `babelfish`, `db2`, `db2-zos`, `docdb`, `dynamodb`, `elasticsearch`, `kafka`, `kinesis`, `mariadb`, `mongodb`, `mysql`, `opensearch`, `oracle`, `postgres`, `redshift`,`redshift-serverless`, `sqlserver`, `neptune` ,`sybase`. Please note that some of engine names are available only for `target` endpoint type (e.g. `redshift`).
        """
        return pulumi.get(self, "engine_name")

    @_builtins.property
    @pulumi.getter(name="extraConnectionAttributes")
    def extra_connection_attributes(self) -> pulumi.Output[_builtins.str]:
        """
        Additional attributes associated with the connection. For available attributes for a `source` Endpoint, see [Sources for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.html). For available attributes for a `target` Endpoint, see [Targets for data migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.html).
        """
        return pulumi.get(self, "extra_connection_attributes")

    @_builtins.property
    @pulumi.getter(name="kafkaSettings")
    def kafka_settings(self) -> pulumi.Output[Optional['outputs.EndpointKafkaSettings']]:
        """
        Configuration block for Kafka settings. See below.
        """
        return pulumi.get(self, "kafka_settings")

    @_builtins.property
    @pulumi.getter(name="kinesisSettings")
    def kinesis_settings(self) -> pulumi.Output[Optional['outputs.EndpointKinesisSettings']]:
        """
        Configuration block for Kinesis settings. See below.
        """
        return pulumi.get(self, "kinesis_settings")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region. When `engine_name` is `redshift`, `kms_key_arn` is the KMS Key for the Redshift target and the parameter `redshift_settings.server_side_encryption_kms_key_id` encrypts the S3 intermediate storage.

        The following arguments are optional:
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="mongodbSettings")
    def mongodb_settings(self) -> pulumi.Output[Optional['outputs.EndpointMongodbSettings']]:
        """
        Configuration block for MongoDB settings. See below.
        """
        return pulumi.get(self, "mongodb_settings")

    @_builtins.property
    @pulumi.getter(name="mysqlSettings")
    def mysql_settings(self) -> pulumi.Output[Optional['outputs.EndpointMysqlSettings']]:
        """
        Configuration block for MySQL settings. See below.
        """
        return pulumi.get(self, "mysql_settings")

    @_builtins.property
    @pulumi.getter(name="oracleSettings")
    def oracle_settings(self) -> pulumi.Output[Optional['outputs.EndpointOracleSettings']]:
        """
        Configuration block for Oracle settings. See below.
        """
        return pulumi.get(self, "oracle_settings")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password to be used to login to the endpoint database.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="pauseReplicationTasks")
    def pause_replication_tasks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "pause_replication_tasks")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Port used by the endpoint database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="postgresSettings")
    def postgres_settings(self) -> pulumi.Output[Optional['outputs.EndpointPostgresSettings']]:
        """
        Configuration block for Postgres settings. See below.
        """
        return pulumi.get(self, "postgres_settings")

    @_builtins.property
    @pulumi.getter(name="redisSettings")
    def redis_settings(self) -> pulumi.Output[Optional['outputs.EndpointRedisSettings']]:
        return pulumi.get(self, "redis_settings")

    @_builtins.property
    @pulumi.getter(name="redshiftSettings")
    def redshift_settings(self) -> pulumi.Output['outputs.EndpointRedshiftSettings']:
        """
        Configuration block for Redshift settings. See below.
        """
        return pulumi.get(self, "redshift_settings")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretsManagerAccessRoleArn")
    def secrets_manager_access_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the IAM role that specifies AWS DMS as the trusted entity and has the required permissions to access the value in the Secrets Manager secret referred to by `secrets_manager_arn`. The role must allow the `iam:PassRole` action.

        > **Note:** You can specify one of two sets of values for these permissions. You can specify the values for this setting and `secrets_manager_arn`. Or you can specify clear-text values for `username`, `password` , `server_name`, and `port`. You can't specify both.
        """
        return pulumi.get(self, "secrets_manager_access_role_arn")

    @_builtins.property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Full ARN, partial ARN, or friendly name of the Secrets Manager secret that contains the endpoint connection details. Supported only when `engine_name` is `aurora`, `aurora-postgresql`, `mariadb`, `mongodb`, `mysql`, `oracle`, `postgres`, `redshift`, or `sqlserver`.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Host name of the server.
        """
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="serviceAccessRole")
    def service_access_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN used by the service access IAM role for dynamodb endpoints.
        """
        return pulumi.get(self, "service_access_role")

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Output[_builtins.str]:
        """
        SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`
        """
        return pulumi.get(self, "ssl_mode")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User name to be used to login to the endpoint database.
        """
        return pulumi.get(self, "username")

