# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ReplicationTaskArgs', 'ReplicationTask']

@pulumi.input_type
class ReplicationTaskArgs:
    def __init__(__self__, *,
                 migration_type: pulumi.Input[_builtins.str],
                 replication_instance_arn: pulumi.Input[_builtins.str],
                 replication_task_id: pulumi.Input[_builtins.str],
                 source_endpoint_arn: pulumi.Input[_builtins.str],
                 table_mappings: pulumi.Input[_builtins.str],
                 target_endpoint_arn: pulumi.Input[_builtins.str],
                 cdc_start_position: Optional[pulumi.Input[_builtins.str]] = None,
                 cdc_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 start_replication_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ReplicationTask resource.
        :param pulumi.Input[_builtins.str] migration_type: Migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[_builtins.str] replication_instance_arn: ARN of the replication instance.
        :param pulumi.Input[_builtins.str] replication_task_id: Replication task identifier which must contain from 1 to 255 alphanumeric characters or hyphens, first character must be a letter, cannot end with a hyphen, and cannot contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] source_endpoint_arn: ARN that uniquely identifies the source endpoint.
        :param pulumi.Input[_builtins.str] table_mappings: Escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[_builtins.str] target_endpoint_arn: ARN that uniquely identifies the target endpoint.
        :param pulumi.Input[_builtins.str] cdc_start_position: Indicates when you want a change data capture (CDC) operation to start. The value can be a RFC3339 formatted date, a checkpoint, or a LSN/SCN format depending on the source engine. For more information see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
        :param pulumi.Input[_builtins.str] cdc_start_time: RFC3339 formatted date string or UNIX timestamp for the start of the Change Data Capture (CDC) operation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_task_settings: Escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html). Note that `Logging.CloudWatchLogGroup` and `Logging.CloudWatchLogStream` are read only and should not be defined, even as `null`, in the configuration since AWS provides a value for these settings.
        :param pulumi.Input[_builtins.str] resource_identifier: A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object.
        :param pulumi.Input[_builtins.bool] start_replication_task: Whether to run or stop the replication task.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "migration_type", migration_type)
        pulumi.set(__self__, "replication_instance_arn", replication_instance_arn)
        pulumi.set(__self__, "replication_task_id", replication_task_id)
        pulumi.set(__self__, "source_endpoint_arn", source_endpoint_arn)
        pulumi.set(__self__, "table_mappings", table_mappings)
        pulumi.set(__self__, "target_endpoint_arn", target_endpoint_arn)
        if cdc_start_position is not None:
            pulumi.set(__self__, "cdc_start_position", cdc_start_position)
        if cdc_start_time is not None:
            pulumi.set(__self__, "cdc_start_time", cdc_start_time)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_task_settings is not None:
            pulumi.set(__self__, "replication_task_settings", replication_task_settings)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)
        if start_replication_task is not None:
            pulumi.set(__self__, "start_replication_task", start_replication_task)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Input[_builtins.str]:
        """
        Migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter(name="replicationInstanceArn")
    def replication_instance_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the replication instance.
        """
        return pulumi.get(self, "replication_instance_arn")

    @replication_instance_arn.setter
    def replication_instance_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "replication_instance_arn", value)

    @_builtins.property
    @pulumi.getter(name="replicationTaskId")
    def replication_task_id(self) -> pulumi.Input[_builtins.str]:
        """
        Replication task identifier which must contain from 1 to 255 alphanumeric characters or hyphens, first character must be a letter, cannot end with a hyphen, and cannot contain two consecutive hyphens.
        """
        return pulumi.get(self, "replication_task_id")

    @replication_task_id.setter
    def replication_task_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "replication_task_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN that uniquely identifies the source endpoint.
        """
        return pulumi.get(self, "source_endpoint_arn")

    @source_endpoint_arn.setter
    def source_endpoint_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_endpoint_arn", value)

    @_builtins.property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Input[_builtins.str]:
        """
        Escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        """
        return pulumi.get(self, "table_mappings")

    @table_mappings.setter
    def table_mappings(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_mappings", value)

    @_builtins.property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN that uniquely identifies the target endpoint.
        """
        return pulumi.get(self, "target_endpoint_arn")

    @target_endpoint_arn.setter
    def target_endpoint_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_endpoint_arn", value)

    @_builtins.property
    @pulumi.getter(name="cdcStartPosition")
    def cdc_start_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates when you want a change data capture (CDC) operation to start. The value can be a RFC3339 formatted date, a checkpoint, or a LSN/SCN format depending on the source engine. For more information see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
        """
        return pulumi.get(self, "cdc_start_position")

    @cdc_start_position.setter
    def cdc_start_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdc_start_position", value)

    @_builtins.property
    @pulumi.getter(name="cdcStartTime")
    def cdc_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RFC3339 formatted date string or UNIX timestamp for the start of the Change Data Capture (CDC) operation.
        """
        return pulumi.get(self, "cdc_start_time")

    @cdc_start_time.setter
    def cdc_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdc_start_time", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationTaskSettings")
    def replication_task_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html). Note that `Logging.CloudWatchLogGroup` and `Logging.CloudWatchLogStream` are read only and should not be defined, even as `null`, in the configuration since AWS provides a value for these settings.
        """
        return pulumi.get(self, "replication_task_settings")

    @replication_task_settings.setter
    def replication_task_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_task_settings", value)

    @_builtins.property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object.
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_identifier", value)

    @_builtins.property
    @pulumi.getter(name="startReplicationTask")
    def start_replication_task(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to run or stop the replication task.
        """
        return pulumi.get(self, "start_replication_task")

    @start_replication_task.setter
    def start_replication_task(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_replication_task", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ReplicationTaskState:
    def __init__(__self__, *,
                 cdc_start_position: Optional[pulumi.Input[_builtins.str]] = None,
                 cdc_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_instance_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 start_replication_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 table_mappings: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReplicationTask resources.
        :param pulumi.Input[_builtins.str] cdc_start_position: Indicates when you want a change data capture (CDC) operation to start. The value can be a RFC3339 formatted date, a checkpoint, or a LSN/SCN format depending on the source engine. For more information see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
        :param pulumi.Input[_builtins.str] cdc_start_time: RFC3339 formatted date string or UNIX timestamp for the start of the Change Data Capture (CDC) operation.
        :param pulumi.Input[_builtins.str] migration_type: Migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_instance_arn: ARN of the replication instance.
        :param pulumi.Input[_builtins.str] replication_task_arn: ARN for the replication task.
        :param pulumi.Input[_builtins.str] replication_task_id: Replication task identifier which must contain from 1 to 255 alphanumeric characters or hyphens, first character must be a letter, cannot end with a hyphen, and cannot contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] replication_task_settings: Escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html). Note that `Logging.CloudWatchLogGroup` and `Logging.CloudWatchLogStream` are read only and should not be defined, even as `null`, in the configuration since AWS provides a value for these settings.
        :param pulumi.Input[_builtins.str] resource_identifier: A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object.
        :param pulumi.Input[_builtins.str] source_endpoint_arn: ARN that uniquely identifies the source endpoint.
        :param pulumi.Input[_builtins.bool] start_replication_task: Whether to run or stop the replication task.
        :param pulumi.Input[_builtins.str] status: Replication Task status.
        :param pulumi.Input[_builtins.str] table_mappings: Escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target_endpoint_arn: ARN that uniquely identifies the target endpoint.
        """
        if cdc_start_position is not None:
            pulumi.set(__self__, "cdc_start_position", cdc_start_position)
        if cdc_start_time is not None:
            pulumi.set(__self__, "cdc_start_time", cdc_start_time)
        if migration_type is not None:
            pulumi.set(__self__, "migration_type", migration_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_instance_arn is not None:
            pulumi.set(__self__, "replication_instance_arn", replication_instance_arn)
        if replication_task_arn is not None:
            pulumi.set(__self__, "replication_task_arn", replication_task_arn)
        if replication_task_id is not None:
            pulumi.set(__self__, "replication_task_id", replication_task_id)
        if replication_task_settings is not None:
            pulumi.set(__self__, "replication_task_settings", replication_task_settings)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)
        if source_endpoint_arn is not None:
            pulumi.set(__self__, "source_endpoint_arn", source_endpoint_arn)
        if start_replication_task is not None:
            pulumi.set(__self__, "start_replication_task", start_replication_task)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if table_mappings is not None:
            pulumi.set(__self__, "table_mappings", table_mappings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_endpoint_arn is not None:
            pulumi.set(__self__, "target_endpoint_arn", target_endpoint_arn)

    @_builtins.property
    @pulumi.getter(name="cdcStartPosition")
    def cdc_start_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates when you want a change data capture (CDC) operation to start. The value can be a RFC3339 formatted date, a checkpoint, or a LSN/SCN format depending on the source engine. For more information see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
        """
        return pulumi.get(self, "cdc_start_position")

    @cdc_start_position.setter
    def cdc_start_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdc_start_position", value)

    @_builtins.property
    @pulumi.getter(name="cdcStartTime")
    def cdc_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RFC3339 formatted date string or UNIX timestamp for the start of the Change Data Capture (CDC) operation.
        """
        return pulumi.get(self, "cdc_start_time")

    @cdc_start_time.setter
    def cdc_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdc_start_time", value)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationInstanceArn")
    def replication_instance_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the replication instance.
        """
        return pulumi.get(self, "replication_instance_arn")

    @replication_instance_arn.setter
    def replication_instance_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_instance_arn", value)

    @_builtins.property
    @pulumi.getter(name="replicationTaskArn")
    def replication_task_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the replication task.
        """
        return pulumi.get(self, "replication_task_arn")

    @replication_task_arn.setter
    def replication_task_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_task_arn", value)

    @_builtins.property
    @pulumi.getter(name="replicationTaskId")
    def replication_task_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Replication task identifier which must contain from 1 to 255 alphanumeric characters or hyphens, first character must be a letter, cannot end with a hyphen, and cannot contain two consecutive hyphens.
        """
        return pulumi.get(self, "replication_task_id")

    @replication_task_id.setter
    def replication_task_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_task_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationTaskSettings")
    def replication_task_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html). Note that `Logging.CloudWatchLogGroup` and `Logging.CloudWatchLogStream` are read only and should not be defined, even as `null`, in the configuration since AWS provides a value for these settings.
        """
        return pulumi.get(self, "replication_task_settings")

    @replication_task_settings.setter
    def replication_task_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_task_settings", value)

    @_builtins.property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object.
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_identifier", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN that uniquely identifies the source endpoint.
        """
        return pulumi.get(self, "source_endpoint_arn")

    @source_endpoint_arn.setter
    def source_endpoint_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_arn", value)

    @_builtins.property
    @pulumi.getter(name="startReplicationTask")
    def start_replication_task(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to run or stop the replication task.
        """
        return pulumi.get(self, "start_replication_task")

    @start_replication_task.setter
    def start_replication_task(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_replication_task", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Replication Task status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        """
        return pulumi.get(self, "table_mappings")

    @table_mappings.setter
    def table_mappings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_mappings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN that uniquely identifies the target endpoint.
        """
        return pulumi.get(self, "target_endpoint_arn")

    @target_endpoint_arn.setter
    def target_endpoint_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_endpoint_arn", value)


@pulumi.type_token("aws:dms/replicationTask:ReplicationTask")
class ReplicationTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdc_start_position: Optional[pulumi.Input[_builtins.str]] = None,
                 cdc_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_instance_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 start_replication_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 table_mappings: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DMS (Data Migration Service) replication task resource. DMS replication tasks can be created, updated, deleted, and imported.

        > **NOTE:** Changing most arguments will stop the task if it is running. You can set `start_replication_task` to resume the task afterwards.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new replication task
        test = aws.dms.ReplicationTask("test",
            cdc_start_time="1993-05-21T05:50:00Z",
            migration_type="full-load",
            replication_instance_arn=test_dms_replication_instance_tf["replicationInstanceArn"],
            replication_task_id="test-dms-replication-task-tf",
            replication_task_settings="...",
            source_endpoint_arn=test_dms_source_endpoint_tf["endpointArn"],
            table_mappings="{\\"rules\\":[{\\"rule-type\\":\\"selection\\",\\"rule-id\\":\\"1\\",\\"rule-name\\":\\"1\\",\\"object-locator\\":{\\"schema-name\\":\\"%\\",\\"table-name\\":\\"%\\"},\\"rule-action\\":\\"include\\"}]}",
            tags={
                "Name": "test",
            },
            target_endpoint_arn=test_dms_target_endpoint_tf["endpointArn"])
        ```

        ## Import

        Using `pulumi import`, import replication tasks using the `replication_task_id`. For example:

        ```sh
        $ pulumi import aws:dms/replicationTask:ReplicationTask test test-dms-replication-task-tf
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdc_start_position: Indicates when you want a change data capture (CDC) operation to start. The value can be a RFC3339 formatted date, a checkpoint, or a LSN/SCN format depending on the source engine. For more information see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
        :param pulumi.Input[_builtins.str] cdc_start_time: RFC3339 formatted date string or UNIX timestamp for the start of the Change Data Capture (CDC) operation.
        :param pulumi.Input[_builtins.str] migration_type: Migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_instance_arn: ARN of the replication instance.
        :param pulumi.Input[_builtins.str] replication_task_id: Replication task identifier which must contain from 1 to 255 alphanumeric characters or hyphens, first character must be a letter, cannot end with a hyphen, and cannot contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] replication_task_settings: Escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html). Note that `Logging.CloudWatchLogGroup` and `Logging.CloudWatchLogStream` are read only and should not be defined, even as `null`, in the configuration since AWS provides a value for these settings.
        :param pulumi.Input[_builtins.str] resource_identifier: A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object.
        :param pulumi.Input[_builtins.str] source_endpoint_arn: ARN that uniquely identifies the source endpoint.
        :param pulumi.Input[_builtins.bool] start_replication_task: Whether to run or stop the replication task.
        :param pulumi.Input[_builtins.str] table_mappings: Escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] target_endpoint_arn: ARN that uniquely identifies the target endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DMS (Data Migration Service) replication task resource. DMS replication tasks can be created, updated, deleted, and imported.

        > **NOTE:** Changing most arguments will stop the task if it is running. You can set `start_replication_task` to resume the task afterwards.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new replication task
        test = aws.dms.ReplicationTask("test",
            cdc_start_time="1993-05-21T05:50:00Z",
            migration_type="full-load",
            replication_instance_arn=test_dms_replication_instance_tf["replicationInstanceArn"],
            replication_task_id="test-dms-replication-task-tf",
            replication_task_settings="...",
            source_endpoint_arn=test_dms_source_endpoint_tf["endpointArn"],
            table_mappings="{\\"rules\\":[{\\"rule-type\\":\\"selection\\",\\"rule-id\\":\\"1\\",\\"rule-name\\":\\"1\\",\\"object-locator\\":{\\"schema-name\\":\\"%\\",\\"table-name\\":\\"%\\"},\\"rule-action\\":\\"include\\"}]}",
            tags={
                "Name": "test",
            },
            target_endpoint_arn=test_dms_target_endpoint_tf["endpointArn"])
        ```

        ## Import

        Using `pulumi import`, import replication tasks using the `replication_task_id`. For example:

        ```sh
        $ pulumi import aws:dms/replicationTask:ReplicationTask test test-dms-replication-task-tf
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdc_start_position: Optional[pulumi.Input[_builtins.str]] = None,
                 cdc_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_instance_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_task_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 start_replication_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 table_mappings: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationTaskArgs.__new__(ReplicationTaskArgs)

            __props__.__dict__["cdc_start_position"] = cdc_start_position
            __props__.__dict__["cdc_start_time"] = cdc_start_time
            if migration_type is None and not opts.urn:
                raise TypeError("Missing required property 'migration_type'")
            __props__.__dict__["migration_type"] = migration_type
            __props__.__dict__["region"] = region
            if replication_instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'replication_instance_arn'")
            __props__.__dict__["replication_instance_arn"] = replication_instance_arn
            if replication_task_id is None and not opts.urn:
                raise TypeError("Missing required property 'replication_task_id'")
            __props__.__dict__["replication_task_id"] = replication_task_id
            __props__.__dict__["replication_task_settings"] = replication_task_settings
            __props__.__dict__["resource_identifier"] = resource_identifier
            if source_endpoint_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_arn'")
            __props__.__dict__["source_endpoint_arn"] = source_endpoint_arn
            __props__.__dict__["start_replication_task"] = start_replication_task
            if table_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'table_mappings'")
            __props__.__dict__["table_mappings"] = table_mappings
            __props__.__dict__["tags"] = tags
            if target_endpoint_arn is None and not opts.urn:
                raise TypeError("Missing required property 'target_endpoint_arn'")
            __props__.__dict__["target_endpoint_arn"] = target_endpoint_arn
            __props__.__dict__["replication_task_arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(ReplicationTask, __self__).__init__(
            'aws:dms/replicationTask:ReplicationTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdc_start_position: Optional[pulumi.Input[_builtins.str]] = None,
            cdc_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            migration_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication_instance_arn: Optional[pulumi.Input[_builtins.str]] = None,
            replication_task_arn: Optional[pulumi.Input[_builtins.str]] = None,
            replication_task_id: Optional[pulumi.Input[_builtins.str]] = None,
            replication_task_settings: Optional[pulumi.Input[_builtins.str]] = None,
            resource_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
            start_replication_task: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            table_mappings: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReplicationTask':
        """
        Get an existing ReplicationTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdc_start_position: Indicates when you want a change data capture (CDC) operation to start. The value can be a RFC3339 formatted date, a checkpoint, or a LSN/SCN format depending on the source engine. For more information see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
        :param pulumi.Input[_builtins.str] cdc_start_time: RFC3339 formatted date string or UNIX timestamp for the start of the Change Data Capture (CDC) operation.
        :param pulumi.Input[_builtins.str] migration_type: Migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_instance_arn: ARN of the replication instance.
        :param pulumi.Input[_builtins.str] replication_task_arn: ARN for the replication task.
        :param pulumi.Input[_builtins.str] replication_task_id: Replication task identifier which must contain from 1 to 255 alphanumeric characters or hyphens, first character must be a letter, cannot end with a hyphen, and cannot contain two consecutive hyphens.
        :param pulumi.Input[_builtins.str] replication_task_settings: Escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html). Note that `Logging.CloudWatchLogGroup` and `Logging.CloudWatchLogStream` are read only and should not be defined, even as `null`, in the configuration since AWS provides a value for these settings.
        :param pulumi.Input[_builtins.str] resource_identifier: A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object.
        :param pulumi.Input[_builtins.str] source_endpoint_arn: ARN that uniquely identifies the source endpoint.
        :param pulumi.Input[_builtins.bool] start_replication_task: Whether to run or stop the replication task.
        :param pulumi.Input[_builtins.str] status: Replication Task status.
        :param pulumi.Input[_builtins.str] table_mappings: Escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target_endpoint_arn: ARN that uniquely identifies the target endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationTaskState.__new__(_ReplicationTaskState)

        __props__.__dict__["cdc_start_position"] = cdc_start_position
        __props__.__dict__["cdc_start_time"] = cdc_start_time
        __props__.__dict__["migration_type"] = migration_type
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_instance_arn"] = replication_instance_arn
        __props__.__dict__["replication_task_arn"] = replication_task_arn
        __props__.__dict__["replication_task_id"] = replication_task_id
        __props__.__dict__["replication_task_settings"] = replication_task_settings
        __props__.__dict__["resource_identifier"] = resource_identifier
        __props__.__dict__["source_endpoint_arn"] = source_endpoint_arn
        __props__.__dict__["start_replication_task"] = start_replication_task
        __props__.__dict__["status"] = status
        __props__.__dict__["table_mappings"] = table_mappings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_endpoint_arn"] = target_endpoint_arn
        return ReplicationTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cdcStartPosition")
    def cdc_start_position(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates when you want a change data capture (CDC) operation to start. The value can be a RFC3339 formatted date, a checkpoint, or a LSN/SCN format depending on the source engine. For more information see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
        """
        return pulumi.get(self, "cdc_start_position")

    @_builtins.property
    @pulumi.getter(name="cdcStartTime")
    def cdc_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        RFC3339 formatted date string or UNIX timestamp for the start of the Change Data Capture (CDC) operation.
        """
        return pulumi.get(self, "cdc_start_time")

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Output[_builtins.str]:
        """
        Migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        """
        return pulumi.get(self, "migration_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationInstanceArn")
    def replication_instance_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the replication instance.
        """
        return pulumi.get(self, "replication_instance_arn")

    @_builtins.property
    @pulumi.getter(name="replicationTaskArn")
    def replication_task_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN for the replication task.
        """
        return pulumi.get(self, "replication_task_arn")

    @_builtins.property
    @pulumi.getter(name="replicationTaskId")
    def replication_task_id(self) -> pulumi.Output[_builtins.str]:
        """
        Replication task identifier which must contain from 1 to 255 alphanumeric characters or hyphens, first character must be a letter, cannot end with a hyphen, and cannot contain two consecutive hyphens.
        """
        return pulumi.get(self, "replication_task_id")

    @_builtins.property
    @pulumi.getter(name="replicationTaskSettings")
    def replication_task_settings(self) -> pulumi.Output[_builtins.str]:
        """
        Escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html). Note that `Logging.CloudWatchLogGroup` and `Logging.CloudWatchLogStream` are read only and should not be defined, even as `null`, in the configuration since AWS provides a value for these settings.
        """
        return pulumi.get(self, "replication_task_settings")

    @_builtins.property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object.
        """
        return pulumi.get(self, "resource_identifier")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN that uniquely identifies the source endpoint.
        """
        return pulumi.get(self, "source_endpoint_arn")

    @_builtins.property
    @pulumi.getter(name="startReplicationTask")
    def start_replication_task(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to run or stop the replication task.
        """
        return pulumi.get(self, "start_replication_task")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Replication Task status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Output[_builtins.str]:
        """
        Escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        """
        return pulumi.get(self, "table_mappings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN that uniquely identifies the target endpoint.
        """
        return pulumi.get(self, "target_endpoint_arn")

