# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationConfigurationTemplateArgs', 'ReplicationConfigurationTemplate']

@pulumi.input_type
class ReplicationConfigurationTemplateArgs:
    def __init__(__self__, *,
                 associate_default_security_group: pulumi.Input[_builtins.bool],
                 bandwidth_throttling: pulumi.Input[_builtins.int],
                 create_public_ip: pulumi.Input[_builtins.bool],
                 data_plane_routing: pulumi.Input[_builtins.str],
                 default_large_staging_disk_type: pulumi.Input[_builtins.str],
                 ebs_encryption: pulumi.Input[_builtins.str],
                 replication_server_instance_type: pulumi.Input[_builtins.str],
                 replication_servers_security_groups_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 staging_area_subnet_id: pulumi.Input[_builtins.str],
                 staging_area_tags: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 use_dedicated_replication_server: pulumi.Input[_builtins.bool],
                 auto_replicate_new_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 ebs_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 pit_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ReplicationConfigurationTemplateTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ReplicationConfigurationTemplate resource.
        :param pulumi.Input[_builtins.bool] associate_default_security_group: Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
        :param pulumi.Input[_builtins.int] bandwidth_throttling: Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
        :param pulumi.Input[_builtins.bool] create_public_ip: Whether to create a Public IP for the Recovery Instance by default.
        :param pulumi.Input[_builtins.str] data_plane_routing: Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
        :param pulumi.Input[_builtins.str] default_large_staging_disk_type: Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
        :param pulumi.Input[_builtins.str] ebs_encryption: Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[_builtins.str] replication_server_instance_type: Instance type to be used for the replication server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replication_servers_security_groups_ids: Security group IDs that will be used by the replication server.
        :param pulumi.Input[_builtins.str] staging_area_subnet_id: Subnet to be used by the replication staging area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] staging_area_tags: Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
        :param pulumi.Input[_builtins.bool] use_dedicated_replication_server: Whether to use a dedicated Replication Server in the replication staging area.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] auto_replicate_new_disks: Whether to allow the AWS replication agent to automatically replicate newly added disks.
        :param pulumi.Input[_builtins.str] ebs_encryption_key_arn: ARN of the EBS encryption key to be used during replication.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]] pit_policies: Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the Replication Configuration Template resource.
        """
        pulumi.set(__self__, "associate_default_security_group", associate_default_security_group)
        pulumi.set(__self__, "bandwidth_throttling", bandwidth_throttling)
        pulumi.set(__self__, "create_public_ip", create_public_ip)
        pulumi.set(__self__, "data_plane_routing", data_plane_routing)
        pulumi.set(__self__, "default_large_staging_disk_type", default_large_staging_disk_type)
        pulumi.set(__self__, "ebs_encryption", ebs_encryption)
        pulumi.set(__self__, "replication_server_instance_type", replication_server_instance_type)
        pulumi.set(__self__, "replication_servers_security_groups_ids", replication_servers_security_groups_ids)
        pulumi.set(__self__, "staging_area_subnet_id", staging_area_subnet_id)
        pulumi.set(__self__, "staging_area_tags", staging_area_tags)
        pulumi.set(__self__, "use_dedicated_replication_server", use_dedicated_replication_server)
        if auto_replicate_new_disks is not None:
            pulumi.set(__self__, "auto_replicate_new_disks", auto_replicate_new_disks)
        if ebs_encryption_key_arn is not None:
            pulumi.set(__self__, "ebs_encryption_key_arn", ebs_encryption_key_arn)
        if pit_policies is not None:
            pulumi.set(__self__, "pit_policies", pit_policies)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="associateDefaultSecurityGroup")
    def associate_default_security_group(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
        """
        return pulumi.get(self, "associate_default_security_group")

    @associate_default_security_group.setter
    def associate_default_security_group(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "associate_default_security_group", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthThrottling")
    def bandwidth_throttling(self) -> pulumi.Input[_builtins.int]:
        """
        Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
        """
        return pulumi.get(self, "bandwidth_throttling")

    @bandwidth_throttling.setter
    def bandwidth_throttling(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bandwidth_throttling", value)

    @_builtins.property
    @pulumi.getter(name="createPublicIp")
    def create_public_ip(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to create a Public IP for the Recovery Instance by default.
        """
        return pulumi.get(self, "create_public_ip")

    @create_public_ip.setter
    def create_public_ip(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "create_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="dataPlaneRouting")
    def data_plane_routing(self) -> pulumi.Input[_builtins.str]:
        """
        Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
        """
        return pulumi.get(self, "data_plane_routing")

    @data_plane_routing.setter
    def data_plane_routing(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_plane_routing", value)

    @_builtins.property
    @pulumi.getter(name="defaultLargeStagingDiskType")
    def default_large_staging_disk_type(self) -> pulumi.Input[_builtins.str]:
        """
        Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
        """
        return pulumi.get(self, "default_large_staging_disk_type")

    @default_large_staging_disk_type.setter
    def default_large_staging_disk_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_large_staging_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="ebsEncryption")
    def ebs_encryption(self) -> pulumi.Input[_builtins.str]:
        """
        Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
        """
        return pulumi.get(self, "ebs_encryption")

    @ebs_encryption.setter
    def ebs_encryption(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ebs_encryption", value)

    @_builtins.property
    @pulumi.getter(name="replicationServerInstanceType")
    def replication_server_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance type to be used for the replication server.
        """
        return pulumi.get(self, "replication_server_instance_type")

    @replication_server_instance_type.setter
    def replication_server_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "replication_server_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="replicationServersSecurityGroupsIds")
    def replication_servers_security_groups_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Security group IDs that will be used by the replication server.
        """
        return pulumi.get(self, "replication_servers_security_groups_ids")

    @replication_servers_security_groups_ids.setter
    def replication_servers_security_groups_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "replication_servers_security_groups_ids", value)

    @_builtins.property
    @pulumi.getter(name="stagingAreaSubnetId")
    def staging_area_subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Subnet to be used by the replication staging area.
        """
        return pulumi.get(self, "staging_area_subnet_id")

    @staging_area_subnet_id.setter
    def staging_area_subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "staging_area_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="stagingAreaTags")
    def staging_area_tags(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
        """
        return pulumi.get(self, "staging_area_tags")

    @staging_area_tags.setter
    def staging_area_tags(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "staging_area_tags", value)

    @_builtins.property
    @pulumi.getter(name="useDedicatedReplicationServer")
    def use_dedicated_replication_server(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to use a dedicated Replication Server in the replication staging area.

        The following arguments are optional:
        """
        return pulumi.get(self, "use_dedicated_replication_server")

    @use_dedicated_replication_server.setter
    def use_dedicated_replication_server(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "use_dedicated_replication_server", value)

    @_builtins.property
    @pulumi.getter(name="autoReplicateNewDisks")
    def auto_replicate_new_disks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the AWS replication agent to automatically replicate newly added disks.
        """
        return pulumi.get(self, "auto_replicate_new_disks")

    @auto_replicate_new_disks.setter
    def auto_replicate_new_disks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_replicate_new_disks", value)

    @_builtins.property
    @pulumi.getter(name="ebsEncryptionKeyArn")
    def ebs_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the EBS encryption key to be used during replication.
        """
        return pulumi.get(self, "ebs_encryption_key_arn")

    @ebs_encryption_key_arn.setter
    def ebs_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ebs_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="pitPolicies")
    def pit_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]]]:
        """
        Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
        """
        return pulumi.get(self, "pit_policies")

    @pit_policies.setter
    def pit_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]]]):
        pulumi.set(self, "pit_policies", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of tags to be associated with the Replication Configuration Template resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ReplicationConfigurationTemplateTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ReplicationConfigurationTemplateTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ReplicationConfigurationTemplateState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 associate_default_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_replicate_new_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_throttling: Optional[pulumi.Input[_builtins.int]] = None,
                 create_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_plane_routing: Optional[pulumi.Input[_builtins.str]] = None,
                 default_large_staging_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 pit_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_server_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_servers_security_groups_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 staging_area_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 staging_area_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ReplicationConfigurationTemplateTimeoutsArgs']] = None,
                 use_dedicated_replication_server: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ReplicationConfigurationTemplate resources.
        :param pulumi.Input[_builtins.str] arn: Replication configuration template ARN.
        :param pulumi.Input[_builtins.bool] associate_default_security_group: Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
        :param pulumi.Input[_builtins.bool] auto_replicate_new_disks: Whether to allow the AWS replication agent to automatically replicate newly added disks.
        :param pulumi.Input[_builtins.int] bandwidth_throttling: Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
        :param pulumi.Input[_builtins.bool] create_public_ip: Whether to create a Public IP for the Recovery Instance by default.
        :param pulumi.Input[_builtins.str] data_plane_routing: Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
        :param pulumi.Input[_builtins.str] default_large_staging_disk_type: Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
        :param pulumi.Input[_builtins.str] ebs_encryption: Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[_builtins.str] ebs_encryption_key_arn: ARN of the EBS encryption key to be used during replication.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]] pit_policies: Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_server_instance_type: Instance type to be used for the replication server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replication_servers_security_groups_ids: Security group IDs that will be used by the replication server.
        :param pulumi.Input[_builtins.str] staging_area_subnet_id: Subnet to be used by the replication staging area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] staging_area_tags: Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the Replication Configuration Template resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] use_dedicated_replication_server: Whether to use a dedicated Replication Server in the replication staging area.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if associate_default_security_group is not None:
            pulumi.set(__self__, "associate_default_security_group", associate_default_security_group)
        if auto_replicate_new_disks is not None:
            pulumi.set(__self__, "auto_replicate_new_disks", auto_replicate_new_disks)
        if bandwidth_throttling is not None:
            pulumi.set(__self__, "bandwidth_throttling", bandwidth_throttling)
        if create_public_ip is not None:
            pulumi.set(__self__, "create_public_ip", create_public_ip)
        if data_plane_routing is not None:
            pulumi.set(__self__, "data_plane_routing", data_plane_routing)
        if default_large_staging_disk_type is not None:
            pulumi.set(__self__, "default_large_staging_disk_type", default_large_staging_disk_type)
        if ebs_encryption is not None:
            pulumi.set(__self__, "ebs_encryption", ebs_encryption)
        if ebs_encryption_key_arn is not None:
            pulumi.set(__self__, "ebs_encryption_key_arn", ebs_encryption_key_arn)
        if pit_policies is not None:
            pulumi.set(__self__, "pit_policies", pit_policies)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_server_instance_type is not None:
            pulumi.set(__self__, "replication_server_instance_type", replication_server_instance_type)
        if replication_servers_security_groups_ids is not None:
            pulumi.set(__self__, "replication_servers_security_groups_ids", replication_servers_security_groups_ids)
        if staging_area_subnet_id is not None:
            pulumi.set(__self__, "staging_area_subnet_id", staging_area_subnet_id)
        if staging_area_tags is not None:
            pulumi.set(__self__, "staging_area_tags", staging_area_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if use_dedicated_replication_server is not None:
            pulumi.set(__self__, "use_dedicated_replication_server", use_dedicated_replication_server)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Replication configuration template ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="associateDefaultSecurityGroup")
    def associate_default_security_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
        """
        return pulumi.get(self, "associate_default_security_group")

    @associate_default_security_group.setter
    def associate_default_security_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "associate_default_security_group", value)

    @_builtins.property
    @pulumi.getter(name="autoReplicateNewDisks")
    def auto_replicate_new_disks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow the AWS replication agent to automatically replicate newly added disks.
        """
        return pulumi.get(self, "auto_replicate_new_disks")

    @auto_replicate_new_disks.setter
    def auto_replicate_new_disks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_replicate_new_disks", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthThrottling")
    def bandwidth_throttling(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
        """
        return pulumi.get(self, "bandwidth_throttling")

    @bandwidth_throttling.setter
    def bandwidth_throttling(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth_throttling", value)

    @_builtins.property
    @pulumi.getter(name="createPublicIp")
    def create_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a Public IP for the Recovery Instance by default.
        """
        return pulumi.get(self, "create_public_ip")

    @create_public_ip.setter
    def create_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="dataPlaneRouting")
    def data_plane_routing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
        """
        return pulumi.get(self, "data_plane_routing")

    @data_plane_routing.setter
    def data_plane_routing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_plane_routing", value)

    @_builtins.property
    @pulumi.getter(name="defaultLargeStagingDiskType")
    def default_large_staging_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
        """
        return pulumi.get(self, "default_large_staging_disk_type")

    @default_large_staging_disk_type.setter
    def default_large_staging_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_large_staging_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="ebsEncryption")
    def ebs_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
        """
        return pulumi.get(self, "ebs_encryption")

    @ebs_encryption.setter
    def ebs_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ebs_encryption", value)

    @_builtins.property
    @pulumi.getter(name="ebsEncryptionKeyArn")
    def ebs_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the EBS encryption key to be used during replication.
        """
        return pulumi.get(self, "ebs_encryption_key_arn")

    @ebs_encryption_key_arn.setter
    def ebs_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ebs_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="pitPolicies")
    def pit_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]]]:
        """
        Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
        """
        return pulumi.get(self, "pit_policies")

    @pit_policies.setter
    def pit_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationTemplatePitPolicyArgs']]]]):
        pulumi.set(self, "pit_policies", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationServerInstanceType")
    def replication_server_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type to be used for the replication server.
        """
        return pulumi.get(self, "replication_server_instance_type")

    @replication_server_instance_type.setter
    def replication_server_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_server_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="replicationServersSecurityGroupsIds")
    def replication_servers_security_groups_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Security group IDs that will be used by the replication server.
        """
        return pulumi.get(self, "replication_servers_security_groups_ids")

    @replication_servers_security_groups_ids.setter
    def replication_servers_security_groups_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replication_servers_security_groups_ids", value)

    @_builtins.property
    @pulumi.getter(name="stagingAreaSubnetId")
    def staging_area_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet to be used by the replication staging area.
        """
        return pulumi.get(self, "staging_area_subnet_id")

    @staging_area_subnet_id.setter
    def staging_area_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "staging_area_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="stagingAreaTags")
    def staging_area_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
        """
        return pulumi.get(self, "staging_area_tags")

    @staging_area_tags.setter
    def staging_area_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "staging_area_tags", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of tags to be associated with the Replication Configuration Template resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ReplicationConfigurationTemplateTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ReplicationConfigurationTemplateTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="useDedicatedReplicationServer")
    def use_dedicated_replication_server(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use a dedicated Replication Server in the replication staging area.

        The following arguments are optional:
        """
        return pulumi.get(self, "use_dedicated_replication_server")

    @use_dedicated_replication_server.setter
    def use_dedicated_replication_server(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_dedicated_replication_server", value)


@pulumi.type_token("aws:drs/replicationConfigurationTemplate:ReplicationConfigurationTemplate")
class ReplicationConfigurationTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_default_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_replicate_new_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_throttling: Optional[pulumi.Input[_builtins.int]] = None,
                 create_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_plane_routing: Optional[pulumi.Input[_builtins.str]] = None,
                 default_large_staging_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 pit_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationConfigurationTemplatePitPolicyArgs', 'ReplicationConfigurationTemplatePitPolicyArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_server_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_servers_security_groups_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 staging_area_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 staging_area_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ReplicationConfigurationTemplateTimeoutsArgs', 'ReplicationConfigurationTemplateTimeoutsArgsDict']]] = None,
                 use_dedicated_replication_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides an Elastic Disaster Recovery replication configuration template resource. Before using DRS, your account must be [initialized](https://docs.aws.amazon.com/drs/latest/userguide/getting-started-initializing.html).

        > **NOTE:** Your configuration must use the PIT policy shown in the basic configuration due to AWS rules. The only value that you can change is the `retention_duration` of `rule_id` 3.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.drs.ReplicationConfigurationTemplate("example",
            associate_default_security_group=False,
            bandwidth_throttling=12,
            create_public_ip=False,
            data_plane_routing="PRIVATE_IP",
            default_large_staging_disk_type="GP2",
            ebs_encryption="DEFAULT",
            ebs_encryption_key_arn="arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
            replication_server_instance_type="t3.small",
            replication_servers_security_groups_ids=[__item["id"] for __item in example_aws_security_group],
            staging_area_subnet_id=example_aws_subnet["id"],
            use_dedicated_replication_server=False,
            pit_policies=[
                {
                    "enabled": True,
                    "interval": 10,
                    "retention_duration": 60,
                    "units": "MINUTE",
                    "rule_id": 1,
                },
                {
                    "enabled": True,
                    "interval": 1,
                    "retention_duration": 24,
                    "units": "HOUR",
                    "rule_id": 2,
                },
                {
                    "enabled": True,
                    "interval": 1,
                    "retention_duration": 3,
                    "units": "DAY",
                    "rule_id": 3,
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import DRS Replication Configuration Template using the `id`. For example:

        ```sh
        $ pulumi import aws:drs/replicationConfigurationTemplate:ReplicationConfigurationTemplate example templateid
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] associate_default_security_group: Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
        :param pulumi.Input[_builtins.bool] auto_replicate_new_disks: Whether to allow the AWS replication agent to automatically replicate newly added disks.
        :param pulumi.Input[_builtins.int] bandwidth_throttling: Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
        :param pulumi.Input[_builtins.bool] create_public_ip: Whether to create a Public IP for the Recovery Instance by default.
        :param pulumi.Input[_builtins.str] data_plane_routing: Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
        :param pulumi.Input[_builtins.str] default_large_staging_disk_type: Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
        :param pulumi.Input[_builtins.str] ebs_encryption: Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[_builtins.str] ebs_encryption_key_arn: ARN of the EBS encryption key to be used during replication.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationConfigurationTemplatePitPolicyArgs', 'ReplicationConfigurationTemplatePitPolicyArgsDict']]]] pit_policies: Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_server_instance_type: Instance type to be used for the replication server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replication_servers_security_groups_ids: Security group IDs that will be used by the replication server.
        :param pulumi.Input[_builtins.str] staging_area_subnet_id: Subnet to be used by the replication staging area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] staging_area_tags: Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the Replication Configuration Template resource.
        :param pulumi.Input[_builtins.bool] use_dedicated_replication_server: Whether to use a dedicated Replication Server in the replication staging area.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationConfigurationTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic Disaster Recovery replication configuration template resource. Before using DRS, your account must be [initialized](https://docs.aws.amazon.com/drs/latest/userguide/getting-started-initializing.html).

        > **NOTE:** Your configuration must use the PIT policy shown in the basic configuration due to AWS rules. The only value that you can change is the `retention_duration` of `rule_id` 3.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.drs.ReplicationConfigurationTemplate("example",
            associate_default_security_group=False,
            bandwidth_throttling=12,
            create_public_ip=False,
            data_plane_routing="PRIVATE_IP",
            default_large_staging_disk_type="GP2",
            ebs_encryption="DEFAULT",
            ebs_encryption_key_arn="arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab",
            replication_server_instance_type="t3.small",
            replication_servers_security_groups_ids=[__item["id"] for __item in example_aws_security_group],
            staging_area_subnet_id=example_aws_subnet["id"],
            use_dedicated_replication_server=False,
            pit_policies=[
                {
                    "enabled": True,
                    "interval": 10,
                    "retention_duration": 60,
                    "units": "MINUTE",
                    "rule_id": 1,
                },
                {
                    "enabled": True,
                    "interval": 1,
                    "retention_duration": 24,
                    "units": "HOUR",
                    "rule_id": 2,
                },
                {
                    "enabled": True,
                    "interval": 1,
                    "retention_duration": 3,
                    "units": "DAY",
                    "rule_id": 3,
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import DRS Replication Configuration Template using the `id`. For example:

        ```sh
        $ pulumi import aws:drs/replicationConfigurationTemplate:ReplicationConfigurationTemplate example templateid
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationConfigurationTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationConfigurationTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_default_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_replicate_new_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth_throttling: Optional[pulumi.Input[_builtins.int]] = None,
                 create_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_plane_routing: Optional[pulumi.Input[_builtins.str]] = None,
                 default_large_staging_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 ebs_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 pit_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationConfigurationTemplatePitPolicyArgs', 'ReplicationConfigurationTemplatePitPolicyArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_server_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_servers_security_groups_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 staging_area_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 staging_area_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ReplicationConfigurationTemplateTimeoutsArgs', 'ReplicationConfigurationTemplateTimeoutsArgsDict']]] = None,
                 use_dedicated_replication_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationConfigurationTemplateArgs.__new__(ReplicationConfigurationTemplateArgs)

            if associate_default_security_group is None and not opts.urn:
                raise TypeError("Missing required property 'associate_default_security_group'")
            __props__.__dict__["associate_default_security_group"] = associate_default_security_group
            __props__.__dict__["auto_replicate_new_disks"] = auto_replicate_new_disks
            if bandwidth_throttling is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth_throttling'")
            __props__.__dict__["bandwidth_throttling"] = bandwidth_throttling
            if create_public_ip is None and not opts.urn:
                raise TypeError("Missing required property 'create_public_ip'")
            __props__.__dict__["create_public_ip"] = create_public_ip
            if data_plane_routing is None and not opts.urn:
                raise TypeError("Missing required property 'data_plane_routing'")
            __props__.__dict__["data_plane_routing"] = data_plane_routing
            if default_large_staging_disk_type is None and not opts.urn:
                raise TypeError("Missing required property 'default_large_staging_disk_type'")
            __props__.__dict__["default_large_staging_disk_type"] = default_large_staging_disk_type
            if ebs_encryption is None and not opts.urn:
                raise TypeError("Missing required property 'ebs_encryption'")
            __props__.__dict__["ebs_encryption"] = ebs_encryption
            __props__.__dict__["ebs_encryption_key_arn"] = ebs_encryption_key_arn
            __props__.__dict__["pit_policies"] = pit_policies
            __props__.__dict__["region"] = region
            if replication_server_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'replication_server_instance_type'")
            __props__.__dict__["replication_server_instance_type"] = replication_server_instance_type
            if replication_servers_security_groups_ids is None and not opts.urn:
                raise TypeError("Missing required property 'replication_servers_security_groups_ids'")
            __props__.__dict__["replication_servers_security_groups_ids"] = replication_servers_security_groups_ids
            if staging_area_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'staging_area_subnet_id'")
            __props__.__dict__["staging_area_subnet_id"] = staging_area_subnet_id
            if staging_area_tags is None and not opts.urn:
                raise TypeError("Missing required property 'staging_area_tags'")
            __props__.__dict__["staging_area_tags"] = staging_area_tags
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            if use_dedicated_replication_server is None and not opts.urn:
                raise TypeError("Missing required property 'use_dedicated_replication_server'")
            __props__.__dict__["use_dedicated_replication_server"] = use_dedicated_replication_server
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ReplicationConfigurationTemplate, __self__).__init__(
            'aws:drs/replicationConfigurationTemplate:ReplicationConfigurationTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            associate_default_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_replicate_new_disks: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth_throttling: Optional[pulumi.Input[_builtins.int]] = None,
            create_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            data_plane_routing: Optional[pulumi.Input[_builtins.str]] = None,
            default_large_staging_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            ebs_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            ebs_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            pit_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationConfigurationTemplatePitPolicyArgs', 'ReplicationConfigurationTemplatePitPolicyArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication_server_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            replication_servers_security_groups_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            staging_area_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            staging_area_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ReplicationConfigurationTemplateTimeoutsArgs', 'ReplicationConfigurationTemplateTimeoutsArgsDict']]] = None,
            use_dedicated_replication_server: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ReplicationConfigurationTemplate':
        """
        Get an existing ReplicationConfigurationTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Replication configuration template ARN.
        :param pulumi.Input[_builtins.bool] associate_default_security_group: Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
        :param pulumi.Input[_builtins.bool] auto_replicate_new_disks: Whether to allow the AWS replication agent to automatically replicate newly added disks.
        :param pulumi.Input[_builtins.int] bandwidth_throttling: Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
        :param pulumi.Input[_builtins.bool] create_public_ip: Whether to create a Public IP for the Recovery Instance by default.
        :param pulumi.Input[_builtins.str] data_plane_routing: Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
        :param pulumi.Input[_builtins.str] default_large_staging_disk_type: Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
        :param pulumi.Input[_builtins.str] ebs_encryption: Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[_builtins.str] ebs_encryption_key_arn: ARN of the EBS encryption key to be used during replication.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationConfigurationTemplatePitPolicyArgs', 'ReplicationConfigurationTemplatePitPolicyArgsDict']]]] pit_policies: Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] replication_server_instance_type: Instance type to be used for the replication server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replication_servers_security_groups_ids: Security group IDs that will be used by the replication server.
        :param pulumi.Input[_builtins.str] staging_area_subnet_id: Subnet to be used by the replication staging area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] staging_area_tags: Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Set of tags to be associated with the Replication Configuration Template resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] use_dedicated_replication_server: Whether to use a dedicated Replication Server in the replication staging area.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationConfigurationTemplateState.__new__(_ReplicationConfigurationTemplateState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["associate_default_security_group"] = associate_default_security_group
        __props__.__dict__["auto_replicate_new_disks"] = auto_replicate_new_disks
        __props__.__dict__["bandwidth_throttling"] = bandwidth_throttling
        __props__.__dict__["create_public_ip"] = create_public_ip
        __props__.__dict__["data_plane_routing"] = data_plane_routing
        __props__.__dict__["default_large_staging_disk_type"] = default_large_staging_disk_type
        __props__.__dict__["ebs_encryption"] = ebs_encryption
        __props__.__dict__["ebs_encryption_key_arn"] = ebs_encryption_key_arn
        __props__.__dict__["pit_policies"] = pit_policies
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_server_instance_type"] = replication_server_instance_type
        __props__.__dict__["replication_servers_security_groups_ids"] = replication_servers_security_groups_ids
        __props__.__dict__["staging_area_subnet_id"] = staging_area_subnet_id
        __props__.__dict__["staging_area_tags"] = staging_area_tags
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["use_dedicated_replication_server"] = use_dedicated_replication_server
        return ReplicationConfigurationTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Replication configuration template ARN.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="associateDefaultSecurityGroup")
    def associate_default_security_group(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.
        """
        return pulumi.get(self, "associate_default_security_group")

    @_builtins.property
    @pulumi.getter(name="autoReplicateNewDisks")
    def auto_replicate_new_disks(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow the AWS replication agent to automatically replicate newly added disks.
        """
        return pulumi.get(self, "auto_replicate_new_disks")

    @_builtins.property
    @pulumi.getter(name="bandwidthThrottling")
    def bandwidth_throttling(self) -> pulumi.Output[_builtins.int]:
        """
        Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
        """
        return pulumi.get(self, "bandwidth_throttling")

    @_builtins.property
    @pulumi.getter(name="createPublicIp")
    def create_public_ip(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to create a Public IP for the Recovery Instance by default.
        """
        return pulumi.get(self, "create_public_ip")

    @_builtins.property
    @pulumi.getter(name="dataPlaneRouting")
    def data_plane_routing(self) -> pulumi.Output[_builtins.str]:
        """
        Data plane routing mechanism that will be used for replication. Valid values are `PUBLIC_IP` and `PRIVATE_IP`.
        """
        return pulumi.get(self, "data_plane_routing")

    @_builtins.property
    @pulumi.getter(name="defaultLargeStagingDiskType")
    def default_large_staging_disk_type(self) -> pulumi.Output[_builtins.str]:
        """
        Staging Disk EBS volume type to be used during replication. Valid values are `GP2`, `GP3`, `ST1`, or `AUTO`.
        """
        return pulumi.get(self, "default_large_staging_disk_type")

    @_builtins.property
    @pulumi.getter(name="ebsEncryption")
    def ebs_encryption(self) -> pulumi.Output[_builtins.str]:
        """
        Type of EBS encryption to be used during replication. Valid values are `DEFAULT` and `CUSTOM`.
        """
        return pulumi.get(self, "ebs_encryption")

    @_builtins.property
    @pulumi.getter(name="ebsEncryptionKeyArn")
    def ebs_encryption_key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the EBS encryption key to be used during replication.
        """
        return pulumi.get(self, "ebs_encryption_key_arn")

    @_builtins.property
    @pulumi.getter(name="pitPolicies")
    def pit_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ReplicationConfigurationTemplatePitPolicy']]]:
        """
        Configuration block for Point in time (PIT) policy to manage snapshots taken during replication. See below.
        """
        return pulumi.get(self, "pit_policies")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationServerInstanceType")
    def replication_server_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type to be used for the replication server.
        """
        return pulumi.get(self, "replication_server_instance_type")

    @_builtins.property
    @pulumi.getter(name="replicationServersSecurityGroupsIds")
    def replication_servers_security_groups_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Security group IDs that will be used by the replication server.
        """
        return pulumi.get(self, "replication_servers_security_groups_ids")

    @_builtins.property
    @pulumi.getter(name="stagingAreaSubnetId")
    def staging_area_subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Subnet to be used by the replication staging area.
        """
        return pulumi.get(self, "staging_area_subnet_id")

    @_builtins.property
    @pulumi.getter(name="stagingAreaTags")
    def staging_area_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.
        """
        return pulumi.get(self, "staging_area_tags")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of tags to be associated with the Replication Configuration Template resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ReplicationConfigurationTemplateTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="useDedicatedReplicationServer")
    def use_dedicated_replication_server(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to use a dedicated Replication Server in the replication staging area.

        The following arguments are optional:
        """
        return pulumi.get(self, "use_dedicated_replication_server")

