# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterPeeringArgs', 'ClusterPeering']

@pulumi.input_type
class ClusterPeeringArgs:
    def __init__(__self__, *,
                 clusters: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 identifier: pulumi.Input[_builtins.str],
                 witness_region: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ClusterPeeringTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ClusterPeering resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusters: List of DSQL Cluster ARNs to be peered to this cluster.
        :param pulumi.Input[_builtins.str] identifier: DSQL Cluster Identifier.
        :param pulumi.Input[_builtins.str] witness_region: Witness region for a multi-region cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "clusters", clusters)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "witness_region", witness_region)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of DSQL Cluster ARNs to be peered to this cluster.
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        DSQL Cluster Identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="witnessRegion")
    def witness_region(self) -> pulumi.Input[_builtins.str]:
        """
        Witness region for a multi-region cluster.
        """
        return pulumi.get(self, "witness_region")

    @witness_region.setter
    def witness_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "witness_region", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ClusterPeeringTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ClusterPeeringTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ClusterPeeringState:
    def __init__(__self__, *,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ClusterPeeringTimeoutsArgs']] = None,
                 witness_region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterPeering resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusters: List of DSQL Cluster ARNs to be peered to this cluster.
        :param pulumi.Input[_builtins.str] identifier: DSQL Cluster Identifier.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] witness_region: Witness region for a multi-region cluster.
        """
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if witness_region is not None:
            pulumi.set(__self__, "witness_region", witness_region)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DSQL Cluster ARNs to be peered to this cluster.
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "clusters", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DSQL Cluster Identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ClusterPeeringTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ClusterPeeringTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="witnessRegion")
    def witness_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Witness region for a multi-region cluster.
        """
        return pulumi.get(self, "witness_region")

    @witness_region.setter
    def witness_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "witness_region", value)


@pulumi.type_token("aws:dsql/clusterPeering:ClusterPeering")
class ClusterPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ClusterPeeringTimeoutsArgs', 'ClusterPeeringTimeoutsArgsDict']]] = None,
                 witness_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon Aurora DSQL Cluster Peering.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example1 = aws.dsql.Cluster("example_1", multi_region_properties={
            "witness_region": "us-west-2",
        })
        example2 = aws.dsql.Cluster("example_2", multi_region_properties={
            "witness_region": "us-west-2",
        })
        example1_cluster_peering = aws.dsql.ClusterPeering("example_1",
            identifier=example1.identifier,
            clusters=[example2.arn],
            witness_region=example1.multi_region_properties.witness_region)
        example2_cluster_peering = aws.dsql.ClusterPeering("example_2",
            identifier=example2.identifier,
            clusters=[example1.arn],
            witness_region=example2.multi_region_properties.witness_region)
        ```

        ## Import

        Using `pulumi import`, import DSQL Cluster Peering using the `identifier`. For example:

        ```sh
        $ pulumi import aws:dsql/clusterPeering:ClusterPeering example cluster-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusters: List of DSQL Cluster ARNs to be peered to this cluster.
        :param pulumi.Input[_builtins.str] identifier: DSQL Cluster Identifier.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] witness_region: Witness region for a multi-region cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon Aurora DSQL Cluster Peering.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example1 = aws.dsql.Cluster("example_1", multi_region_properties={
            "witness_region": "us-west-2",
        })
        example2 = aws.dsql.Cluster("example_2", multi_region_properties={
            "witness_region": "us-west-2",
        })
        example1_cluster_peering = aws.dsql.ClusterPeering("example_1",
            identifier=example1.identifier,
            clusters=[example2.arn],
            witness_region=example1.multi_region_properties.witness_region)
        example2_cluster_peering = aws.dsql.ClusterPeering("example_2",
            identifier=example2.identifier,
            clusters=[example1.arn],
            witness_region=example2.multi_region_properties.witness_region)
        ```

        ## Import

        Using `pulumi import`, import DSQL Cluster Peering using the `identifier`. For example:

        ```sh
        $ pulumi import aws:dsql/clusterPeering:ClusterPeering example cluster-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param ClusterPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ClusterPeeringTimeoutsArgs', 'ClusterPeeringTimeoutsArgsDict']]] = None,
                 witness_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterPeeringArgs.__new__(ClusterPeeringArgs)

            if clusters is None and not opts.urn:
                raise TypeError("Missing required property 'clusters'")
            __props__.__dict__["clusters"] = clusters
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
            if witness_region is None and not opts.urn:
                raise TypeError("Missing required property 'witness_region'")
            __props__.__dict__["witness_region"] = witness_region
        super(ClusterPeering, __self__).__init__(
            'aws:dsql/clusterPeering:ClusterPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clusters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['ClusterPeeringTimeoutsArgs', 'ClusterPeeringTimeoutsArgsDict']]] = None,
            witness_region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClusterPeering':
        """
        Get an existing ClusterPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusters: List of DSQL Cluster ARNs to be peered to this cluster.
        :param pulumi.Input[_builtins.str] identifier: DSQL Cluster Identifier.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] witness_region: Witness region for a multi-region cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterPeeringState.__new__(_ClusterPeeringState)

        __props__.__dict__["clusters"] = clusters
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["witness_region"] = witness_region
        return ClusterPeering(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of DSQL Cluster ARNs to be peered to this cluster.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        DSQL Cluster Identifier.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ClusterPeeringTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="witnessRegion")
    def witness_region(self) -> pulumi.Output[_builtins.str]:
        """
        Witness region for a multi-region cluster.
        """
        return pulumi.get(self, "witness_region")

