# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterEncryptionDetail',
    'ClusterMultiRegionProperties',
    'ClusterPeeringTimeouts',
    'ClusterTimeouts',
]

@pulumi.output_type
class ClusterEncryptionDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionStatus":
            suggest = "encryption_status"
        elif key == "encryptionType":
            suggest = "encryption_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_status: _builtins.str,
                 encryption_type: _builtins.str):
        """
        :param _builtins.str encryption_status: The status of encryption for the DSQL Cluster.
        :param _builtins.str encryption_type: The type of encryption that protects the data on the DSQL Cluster.
        """
        pulumi.set(__self__, "encryption_status", encryption_status)
        pulumi.set(__self__, "encryption_type", encryption_type)

    @_builtins.property
    @pulumi.getter(name="encryptionStatus")
    def encryption_status(self) -> _builtins.str:
        """
        The status of encryption for the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_status")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> _builtins.str:
        """
        The type of encryption that protects the data on the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_type")


@pulumi.output_type
class ClusterMultiRegionProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "witnessRegion":
            suggest = "witness_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMultiRegionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMultiRegionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMultiRegionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clusters: Optional[Sequence[_builtins.str]] = None,
                 witness_region: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] clusters: List of DSQL Cluster ARNs peered to this cluster.
        :param _builtins.str witness_region: Witness region for the multi-region clusters. Setting this makes this cluster a multi-region cluster. Changing it recreates the resource.
        """
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if witness_region is not None:
            pulumi.set(__self__, "witness_region", witness_region)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of DSQL Cluster ARNs peered to this cluster.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="witnessRegion")
    def witness_region(self) -> Optional[_builtins.str]:
        """
        Witness region for the multi-region clusters. Setting this makes this cluster a multi-region cluster. Changing it recreates the resource.
        """
        return pulumi.get(self, "witness_region")


@pulumi.output_type
class ClusterPeeringTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class ClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


