# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GlobalTableReplica',
    'TableAttribute',
    'TableExportIncrementalExportSpecification',
    'TableGlobalSecondaryIndex',
    'TableGlobalSecondaryIndexOnDemandThroughput',
    'TableGlobalSecondaryIndexWarmThroughput',
    'TableImportTable',
    'TableImportTableInputFormatOptions',
    'TableImportTableInputFormatOptionsCsv',
    'TableImportTableS3BucketSource',
    'TableLocalSecondaryIndex',
    'TableOnDemandThroughput',
    'TablePointInTimeRecovery',
    'TableReplica',
    'TableServerSideEncryption',
    'TableTtl',
    'TableWarmThroughput',
    'GetTableAttributeResult',
    'GetTableGlobalSecondaryIndexResult',
    'GetTableGlobalSecondaryIndexOnDemandThroughputResult',
    'GetTableGlobalSecondaryIndexWarmThroughputResult',
    'GetTableLocalSecondaryIndexResult',
    'GetTableOnDemandThroughputResult',
    'GetTablePointInTimeRecoveryResult',
    'GetTableReplicaResult',
    'GetTableServerSideEncryptionResult',
    'GetTableTtlResult',
    'GetTableWarmThroughputResult',
]

@pulumi.output_type
class GlobalTableReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_name: _builtins.str):
        """
        :param _builtins.str region_name: AWS region name of replica DynamoDB TableE.g., `us-east-1`
        """
        pulumi.set(__self__, "region_name", region_name)

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        AWS region name of replica DynamoDB TableE.g., `us-east-1`
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class TableAttribute(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: Name of the attribute
        :param _builtins.str type: Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the attribute
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableExportIncrementalExportSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportFromTime":
            suggest = "export_from_time"
        elif key == "exportToTime":
            suggest = "export_to_time"
        elif key == "exportViewType":
            suggest = "export_view_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExportIncrementalExportSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExportIncrementalExportSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExportIncrementalExportSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export_from_time: Optional[_builtins.str] = None,
                 export_to_time: Optional[_builtins.str] = None,
                 export_view_type: Optional[_builtins.str] = None):
        if export_from_time is not None:
            pulumi.set(__self__, "export_from_time", export_from_time)
        if export_to_time is not None:
            pulumi.set(__self__, "export_to_time", export_to_time)
        if export_view_type is not None:
            pulumi.set(__self__, "export_view_type", export_view_type)

    @_builtins.property
    @pulumi.getter(name="exportFromTime")
    def export_from_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "export_from_time")

    @_builtins.property
    @pulumi.getter(name="exportToTime")
    def export_to_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "export_to_time")

    @_builtins.property
    @pulumi.getter(name="exportViewType")
    def export_view_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "export_view_type")


@pulumi.output_type
class TableGlobalSecondaryIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hashKey":
            suggest = "hash_key"
        elif key == "projectionType":
            suggest = "projection_type"
        elif key == "nonKeyAttributes":
            suggest = "non_key_attributes"
        elif key == "onDemandThroughput":
            suggest = "on_demand_throughput"
        elif key == "rangeKey":
            suggest = "range_key"
        elif key == "readCapacity":
            suggest = "read_capacity"
        elif key == "warmThroughput":
            suggest = "warm_throughput"
        elif key == "writeCapacity":
            suggest = "write_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableGlobalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableGlobalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableGlobalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hash_key: _builtins.str,
                 name: _builtins.str,
                 projection_type: _builtins.str,
                 non_key_attributes: Optional[Sequence[_builtins.str]] = None,
                 on_demand_throughput: Optional['outputs.TableGlobalSecondaryIndexOnDemandThroughput'] = None,
                 range_key: Optional[_builtins.str] = None,
                 read_capacity: Optional[_builtins.int] = None,
                 warm_throughput: Optional['outputs.TableGlobalSecondaryIndexWarmThroughput'] = None,
                 write_capacity: Optional[_builtins.int] = None):
        """
        :param _builtins.str hash_key: Name of the hash key in the index; must be defined as an attribute in the resource.
        :param _builtins.str name: Name of the index.
        :param _builtins.str projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        :param Sequence[_builtins.str] non_key_attributes: Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        :param 'TableGlobalSecondaryIndexOnDemandThroughputArgs' on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand index. See below.
        :param _builtins.str range_key: Name of the range key; must be defined
        :param _builtins.int read_capacity: Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        :param 'TableGlobalSecondaryIndexWarmThroughputArgs' warm_throughput: Sets the number of warm read and write units for this index. See below.
        :param _builtins.int write_capacity: Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        pulumi.set(__self__, "hash_key", hash_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        if on_demand_throughput is not None:
            pulumi.set(__self__, "on_demand_throughput", on_demand_throughput)
        if range_key is not None:
            pulumi.set(__self__, "range_key", range_key)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if warm_throughput is not None:
            pulumi.set(__self__, "warm_throughput", warm_throughput)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @_builtins.property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> _builtins.str:
        """
        Name of the hash key in the index; must be defined as an attribute in the resource.
        """
        return pulumi.get(self, "hash_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the index.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> _builtins.str:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        return pulumi.get(self, "projection_type")

    @_builtins.property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")

    @_builtins.property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> Optional['outputs.TableGlobalSecondaryIndexOnDemandThroughput']:
        """
        Sets the maximum number of read and write units for the specified on-demand index. See below.
        """
        return pulumi.get(self, "on_demand_throughput")

    @_builtins.property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> Optional[_builtins.str]:
        """
        Name of the range key; must be defined
        """
        return pulumi.get(self, "range_key")

    @_builtins.property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[_builtins.int]:
        """
        Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "read_capacity")

    @_builtins.property
    @pulumi.getter(name="warmThroughput")
    def warm_throughput(self) -> Optional['outputs.TableGlobalSecondaryIndexWarmThroughput']:
        """
        Sets the number of warm read and write units for this index. See below.
        """
        return pulumi.get(self, "warm_throughput")

    @_builtins.property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[_builtins.int]:
        """
        Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "write_capacity")


@pulumi.output_type
class TableGlobalSecondaryIndexOnDemandThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadRequestUnits":
            suggest = "max_read_request_units"
        elif key == "maxWriteRequestUnits":
            suggest = "max_write_request_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableGlobalSecondaryIndexOnDemandThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableGlobalSecondaryIndexOnDemandThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableGlobalSecondaryIndexOnDemandThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_request_units: Optional[_builtins.int] = None,
                 max_write_request_units: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_read_request_units: Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        :param _builtins.int max_write_request_units: Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @_builtins.property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[_builtins.int]:
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_read_request_units")

    @_builtins.property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[_builtins.int]:
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class TableGlobalSecondaryIndexWarmThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readUnitsPerSecond":
            suggest = "read_units_per_second"
        elif key == "writeUnitsPerSecond":
            suggest = "write_units_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableGlobalSecondaryIndexWarmThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableGlobalSecondaryIndexWarmThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableGlobalSecondaryIndexWarmThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_units_per_second: Optional[_builtins.int] = None,
                 write_units_per_second: Optional[_builtins.int] = None):
        """
        :param _builtins.int read_units_per_second: Number of read operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `12000` (default).
        :param _builtins.int write_units_per_second: Number of write operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `4000` (default).
        """
        if read_units_per_second is not None:
            pulumi.set(__self__, "read_units_per_second", read_units_per_second)
        if write_units_per_second is not None:
            pulumi.set(__self__, "write_units_per_second", write_units_per_second)

    @_builtins.property
    @pulumi.getter(name="readUnitsPerSecond")
    def read_units_per_second(self) -> Optional[_builtins.int]:
        """
        Number of read operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `12000` (default).
        """
        return pulumi.get(self, "read_units_per_second")

    @_builtins.property
    @pulumi.getter(name="writeUnitsPerSecond")
    def write_units_per_second(self) -> Optional[_builtins.int]:
        """
        Number of write operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `4000` (default).
        """
        return pulumi.get(self, "write_units_per_second")


@pulumi.output_type
class TableImportTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputFormat":
            suggest = "input_format"
        elif key == "s3BucketSource":
            suggest = "s3_bucket_source"
        elif key == "inputCompressionType":
            suggest = "input_compression_type"
        elif key == "inputFormatOptions":
            suggest = "input_format_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableImportTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableImportTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableImportTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_format: _builtins.str,
                 s3_bucket_source: 'outputs.TableImportTableS3BucketSource',
                 input_compression_type: Optional[_builtins.str] = None,
                 input_format_options: Optional['outputs.TableImportTableInputFormatOptions'] = None):
        """
        :param _builtins.str input_format: The format of the source data.
               Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
        :param 'TableImportTableS3BucketSourceArgs' s3_bucket_source: Values for the S3 bucket the source file is imported from.
               See below.
        :param _builtins.str input_compression_type: Type of compression to be used on the input coming from the imported table.
               Valid values are `GZIP`, `ZSTD` and `NONE`.
        :param 'TableImportTableInputFormatOptionsArgs' input_format_options: Describe the format options for the data that was imported into the target table.
               There is one value, `csv`.
               See below.
        """
        pulumi.set(__self__, "input_format", input_format)
        pulumi.set(__self__, "s3_bucket_source", s3_bucket_source)
        if input_compression_type is not None:
            pulumi.set(__self__, "input_compression_type", input_compression_type)
        if input_format_options is not None:
            pulumi.set(__self__, "input_format_options", input_format_options)

    @_builtins.property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> _builtins.str:
        """
        The format of the source data.
        Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
        """
        return pulumi.get(self, "input_format")

    @_builtins.property
    @pulumi.getter(name="s3BucketSource")
    def s3_bucket_source(self) -> 'outputs.TableImportTableS3BucketSource':
        """
        Values for the S3 bucket the source file is imported from.
        See below.
        """
        return pulumi.get(self, "s3_bucket_source")

    @_builtins.property
    @pulumi.getter(name="inputCompressionType")
    def input_compression_type(self) -> Optional[_builtins.str]:
        """
        Type of compression to be used on the input coming from the imported table.
        Valid values are `GZIP`, `ZSTD` and `NONE`.
        """
        return pulumi.get(self, "input_compression_type")

    @_builtins.property
    @pulumi.getter(name="inputFormatOptions")
    def input_format_options(self) -> Optional['outputs.TableImportTableInputFormatOptions']:
        """
        Describe the format options for the data that was imported into the target table.
        There is one value, `csv`.
        See below.
        """
        return pulumi.get(self, "input_format_options")


@pulumi.output_type
class TableImportTableInputFormatOptions(dict):
    def __init__(__self__, *,
                 csv: Optional['outputs.TableImportTableInputFormatOptionsCsv'] = None):
        """
        :param 'TableImportTableInputFormatOptionsCsvArgs' csv: This block contains the processing options for the CSV file being imported:
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)

    @_builtins.property
    @pulumi.getter
    def csv(self) -> Optional['outputs.TableImportTableInputFormatOptionsCsv']:
        """
        This block contains the processing options for the CSV file being imported:
        """
        return pulumi.get(self, "csv")


@pulumi.output_type
class TableImportTableInputFormatOptionsCsv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerLists":
            suggest = "header_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableImportTableInputFormatOptionsCsv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableImportTableInputFormatOptionsCsv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableImportTableInputFormatOptionsCsv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[_builtins.str] = None,
                 header_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str delimiter: The delimiter used for separating items in the CSV file being imported.
        :param Sequence[_builtins.str] header_lists: List of the headers used to specify a common header for all source CSV files being imported.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if header_lists is not None:
            pulumi.set(__self__, "header_lists", header_lists)

    @_builtins.property
    @pulumi.getter
    def delimiter(self) -> Optional[_builtins.str]:
        """
        The delimiter used for separating items in the CSV file being imported.
        """
        return pulumi.get(self, "delimiter")

    @_builtins.property
    @pulumi.getter(name="headerLists")
    def header_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of the headers used to specify a common header for all source CSV files being imported.
        """
        return pulumi.get(self, "header_lists")


@pulumi.output_type
class TableImportTableS3BucketSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketOwner":
            suggest = "bucket_owner"
        elif key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableImportTableS3BucketSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableImportTableS3BucketSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableImportTableS3BucketSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 bucket_owner: Optional[_builtins.str] = None,
                 key_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: The S3 bucket that is being imported from.
        :param _builtins.str bucket_owner: The account number of the S3 bucket that is being imported from.
        :param _builtins.str key_prefix: The key prefix shared by all S3 Objects that are being imported.
        """
        pulumi.set(__self__, "bucket", bucket)
        if bucket_owner is not None:
            pulumi.set(__self__, "bucket_owner", bucket_owner)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The S3 bucket that is being imported from.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> Optional[_builtins.str]:
        """
        The account number of the S3 bucket that is being imported from.
        """
        return pulumi.get(self, "bucket_owner")

    @_builtins.property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[_builtins.str]:
        """
        The key prefix shared by all S3 Objects that are being imported.
        """
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class TableLocalSecondaryIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectionType":
            suggest = "projection_type"
        elif key == "rangeKey":
            suggest = "range_key"
        elif key == "nonKeyAttributes":
            suggest = "non_key_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableLocalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableLocalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableLocalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 projection_type: _builtins.str,
                 range_key: _builtins.str,
                 non_key_attributes: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: Name of the index
        :param _builtins.str projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        :param _builtins.str range_key: Name of the range key.
        :param Sequence[_builtins.str] non_key_attributes: Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the index
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> _builtins.str:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        return pulumi.get(self, "projection_type")

    @_builtins.property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> _builtins.str:
        """
        Name of the range key.
        """
        return pulumi.get(self, "range_key")

    @_builtins.property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")


@pulumi.output_type
class TableOnDemandThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadRequestUnits":
            suggest = "max_read_request_units"
        elif key == "maxWriteRequestUnits":
            suggest = "max_write_request_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableOnDemandThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableOnDemandThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableOnDemandThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_request_units: Optional[_builtins.int] = None,
                 max_write_request_units: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_read_request_units: Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        :param _builtins.int max_write_request_units: Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @_builtins.property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[_builtins.int]:
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_read_request_units")

    @_builtins.property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[_builtins.int]:
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class TablePointInTimeRecovery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryPeriodInDays":
            suggest = "recovery_period_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TablePointInTimeRecovery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TablePointInTimeRecovery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TablePointInTimeRecovery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 recovery_period_in_days: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
        :param _builtins.int recovery_period_in_days: Number of preceding days for which continuous backups are taken and maintained. Default is 35.
        """
        pulumi.set(__self__, "enabled", enabled)
        if recovery_period_in_days is not None:
            pulumi.set(__self__, "recovery_period_in_days", recovery_period_in_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="recoveryPeriodInDays")
    def recovery_period_in_days(self) -> Optional[_builtins.int]:
        """
        Number of preceding days for which continuous backups are taken and maintained. Default is 35.
        """
        return pulumi.get(self, "recovery_period_in_days")


@pulumi.output_type
class TableReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionName":
            suggest = "region_name"
        elif key == "consistencyMode":
            suggest = "consistency_mode"
        elif key == "deletionProtectionEnabled":
            suggest = "deletion_protection_enabled"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "pointInTimeRecovery":
            suggest = "point_in_time_recovery"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "streamArn":
            suggest = "stream_arn"
        elif key == "streamLabel":
            suggest = "stream_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_name: _builtins.str,
                 arn: Optional[_builtins.str] = None,
                 consistency_mode: Optional[_builtins.str] = None,
                 deletion_protection_enabled: Optional[_builtins.bool] = None,
                 kms_key_arn: Optional[_builtins.str] = None,
                 point_in_time_recovery: Optional[_builtins.bool] = None,
                 propagate_tags: Optional[_builtins.bool] = None,
                 stream_arn: Optional[_builtins.str] = None,
                 stream_label: Optional[_builtins.str] = None):
        """
        :param _builtins.str region_name: Region name of the replica.
        :param _builtins.str arn: ARN of the table
        :param _builtins.str consistency_mode: Whether this global table will be using `STRONG` consistency mode or `EVENTUAL` consistency mode. Default value is `EVENTUAL`.
        :param _builtins.bool deletion_protection_enabled: Whether deletion protection is enabled (true) or disabled (false) on the replica. Default is `false`.
        :param _builtins.str kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption.
               This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`.
               **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
               **Note:** Changing this value will recreate the replica.
        :param _builtins.bool point_in_time_recovery: Whether to enable Point In Time Recovery for the replica. Default is `false`.
        :param _builtins.bool propagate_tags: Whether to propagate the global table's tags to a replica.
               Default is `false`.
               Changes to tags only move in one direction: from global (source) to replica.
               Tag drift on a replica will not trigger an update.
               Tag changes on the global table are propagated to replicas.
               Changing from `true` to `false` on a subsequent `apply` leaves replica tags as-is and no longer manages them.
        :param _builtins.str stream_arn: ARN of the Table Stream. Only available when `stream_enabled = true`
        :param _builtins.str stream_label: Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        pulumi.set(__self__, "region_name", region_name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if consistency_mode is not None:
            pulumi.set(__self__, "consistency_mode", consistency_mode)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if point_in_time_recovery is not None:
            pulumi.set(__self__, "point_in_time_recovery", point_in_time_recovery)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)
        if stream_label is not None:
            pulumi.set(__self__, "stream_label", stream_label)

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        Region name of the replica.
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[_builtins.str]:
        """
        ARN of the table
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="consistencyMode")
    def consistency_mode(self) -> Optional[_builtins.str]:
        """
        Whether this global table will be using `STRONG` consistency mode or `EVENTUAL` consistency mode. Default value is `EVENTUAL`.
        """
        return pulumi.get(self, "consistency_mode")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether deletion protection is enabled (true) or disabled (false) on the replica. Default is `false`.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption.
        This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`.
        **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        **Note:** Changing this value will recreate the replica.
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> Optional[_builtins.bool]:
        """
        Whether to enable Point In Time Recovery for the replica. Default is `false`.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @_builtins.property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[_builtins.bool]:
        """
        Whether to propagate the global table's tags to a replica.
        Default is `false`.
        Changes to tags only move in one direction: from global (source) to replica.
        Tag drift on a replica will not trigger an update.
        Tag changes on the global table are propagated to replicas.
        Changing from `true` to `false` on a subsequent `apply` leaves replica tags as-is and no longer manages them.
        """
        return pulumi.get(self, "propagate_tags")

    @_builtins.property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the Table Stream. Only available when `stream_enabled = true`
        """
        return pulumi.get(self, "stream_arn")

    @_builtins.property
    @pulumi.getter(name="streamLabel")
    def stream_label(self) -> Optional[_builtins.str]:
        """
        Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        return pulumi.get(self, "stream_label")


@pulumi.output_type
class TableServerSideEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableServerSideEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableServerSideEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableServerSideEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 kms_key_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
        :param _builtins.str kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class TableTtl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTtl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTtl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTtl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str attribute_name: Name of the table attribute to store the TTL timestamp in.
               Required if `enabled` is `true`, must not be set otherwise.
        :param _builtins.bool enabled: Whether TTL is enabled.
               Default value is `false`.
        """
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[_builtins.str]:
        """
        Name of the table attribute to store the TTL timestamp in.
        Required if `enabled` is `true`, must not be set otherwise.
        """
        return pulumi.get(self, "attribute_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether TTL is enabled.
        Default value is `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class TableWarmThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readUnitsPerSecond":
            suggest = "read_units_per_second"
        elif key == "writeUnitsPerSecond":
            suggest = "write_units_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableWarmThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableWarmThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableWarmThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_units_per_second: Optional[_builtins.int] = None,
                 write_units_per_second: Optional[_builtins.int] = None):
        """
        :param _builtins.int read_units_per_second: Number of read operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `12000` (default).
        :param _builtins.int write_units_per_second: Number of write operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `4000` (default).
        """
        if read_units_per_second is not None:
            pulumi.set(__self__, "read_units_per_second", read_units_per_second)
        if write_units_per_second is not None:
            pulumi.set(__self__, "write_units_per_second", write_units_per_second)

    @_builtins.property
    @pulumi.getter(name="readUnitsPerSecond")
    def read_units_per_second(self) -> Optional[_builtins.int]:
        """
        Number of read operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `12000` (default).
        """
        return pulumi.get(self, "read_units_per_second")

    @_builtins.property
    @pulumi.getter(name="writeUnitsPerSecond")
    def write_units_per_second(self) -> Optional[_builtins.int]:
        """
        Number of write operations a table or index can instantaneously support. For the base table, decreasing this value will force a new resource. For a global secondary index, this value can be increased or decreased without recreation. Minimum value of `4000` (default).
        """
        return pulumi.get(self, "write_units_per_second")


@pulumi.output_type
class GetTableAttributeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: Name of the DynamoDB table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTableGlobalSecondaryIndexResult(dict):
    def __init__(__self__, *,
                 hash_key: _builtins.str,
                 name: _builtins.str,
                 non_key_attributes: Sequence[_builtins.str],
                 on_demand_throughputs: Sequence['outputs.GetTableGlobalSecondaryIndexOnDemandThroughputResult'],
                 projection_type: _builtins.str,
                 range_key: _builtins.str,
                 read_capacity: _builtins.int,
                 warm_throughputs: Sequence['outputs.GetTableGlobalSecondaryIndexWarmThroughputResult'],
                 write_capacity: _builtins.int):
        """
        :param _builtins.str name: Name of the DynamoDB table.
        """
        pulumi.set(__self__, "hash_key", hash_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        pulumi.set(__self__, "on_demand_throughputs", on_demand_throughputs)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)
        pulumi.set(__self__, "read_capacity", read_capacity)
        pulumi.set(__self__, "warm_throughputs", warm_throughputs)
        pulumi.set(__self__, "write_capacity", write_capacity)

    @_builtins.property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> _builtins.str:
        return pulumi.get(self, "hash_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "non_key_attributes")

    @_builtins.property
    @pulumi.getter(name="onDemandThroughputs")
    def on_demand_throughputs(self) -> Sequence['outputs.GetTableGlobalSecondaryIndexOnDemandThroughputResult']:
        return pulumi.get(self, "on_demand_throughputs")

    @_builtins.property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> _builtins.str:
        return pulumi.get(self, "projection_type")

    @_builtins.property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> _builtins.str:
        return pulumi.get(self, "range_key")

    @_builtins.property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> _builtins.int:
        return pulumi.get(self, "read_capacity")

    @_builtins.property
    @pulumi.getter(name="warmThroughputs")
    def warm_throughputs(self) -> Sequence['outputs.GetTableGlobalSecondaryIndexWarmThroughputResult']:
        return pulumi.get(self, "warm_throughputs")

    @_builtins.property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> _builtins.int:
        return pulumi.get(self, "write_capacity")


@pulumi.output_type
class GetTableGlobalSecondaryIndexOnDemandThroughputResult(dict):
    def __init__(__self__, *,
                 max_read_request_units: _builtins.int,
                 max_write_request_units: _builtins.int):
        pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @_builtins.property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> _builtins.int:
        return pulumi.get(self, "max_read_request_units")

    @_builtins.property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> _builtins.int:
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class GetTableGlobalSecondaryIndexWarmThroughputResult(dict):
    def __init__(__self__, *,
                 read_units_per_second: _builtins.int,
                 write_units_per_second: _builtins.int):
        pulumi.set(__self__, "read_units_per_second", read_units_per_second)
        pulumi.set(__self__, "write_units_per_second", write_units_per_second)

    @_builtins.property
    @pulumi.getter(name="readUnitsPerSecond")
    def read_units_per_second(self) -> _builtins.int:
        return pulumi.get(self, "read_units_per_second")

    @_builtins.property
    @pulumi.getter(name="writeUnitsPerSecond")
    def write_units_per_second(self) -> _builtins.int:
        return pulumi.get(self, "write_units_per_second")


@pulumi.output_type
class GetTableLocalSecondaryIndexResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 non_key_attributes: Sequence[_builtins.str],
                 projection_type: _builtins.str,
                 range_key: _builtins.str):
        """
        :param _builtins.str name: Name of the DynamoDB table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "non_key_attributes")

    @_builtins.property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> _builtins.str:
        return pulumi.get(self, "projection_type")

    @_builtins.property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> _builtins.str:
        return pulumi.get(self, "range_key")


@pulumi.output_type
class GetTableOnDemandThroughputResult(dict):
    def __init__(__self__, *,
                 max_read_request_units: _builtins.int,
                 max_write_request_units: _builtins.int):
        pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @_builtins.property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> _builtins.int:
        return pulumi.get(self, "max_read_request_units")

    @_builtins.property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> _builtins.int:
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class GetTablePointInTimeRecoveryResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 recovery_period_in_days: _builtins.int):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "recovery_period_in_days", recovery_period_in_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="recoveryPeriodInDays")
    def recovery_period_in_days(self) -> _builtins.int:
        return pulumi.get(self, "recovery_period_in_days")


@pulumi.output_type
class GetTableReplicaResult(dict):
    def __init__(__self__, *,
                 kms_key_arn: _builtins.str,
                 region_name: _builtins.str):
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        pulumi.set(__self__, "region_name", region_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> _builtins.str:
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        return pulumi.get(self, "region_name")


@pulumi.output_type
class GetTableServerSideEncryptionResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 kms_key_arn: _builtins.str):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> _builtins.str:
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class GetTableTtlResult(dict):
    def __init__(__self__, *,
                 attribute_name: _builtins.str,
                 enabled: _builtins.bool):
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> _builtins.str:
        return pulumi.get(self, "attribute_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetTableWarmThroughputResult(dict):
    def __init__(__self__, *,
                 read_units_per_second: _builtins.int,
                 write_units_per_second: _builtins.int):
        pulumi.set(__self__, "read_units_per_second", read_units_per_second)
        pulumi.set(__self__, "write_units_per_second", write_units_per_second)

    @_builtins.property
    @pulumi.getter(name="readUnitsPerSecond")
    def read_units_per_second(self) -> _builtins.int:
        return pulumi.get(self, "read_units_per_second")

    @_builtins.property
    @pulumi.getter(name="writeUnitsPerSecond")
    def write_units_per_second(self) -> _builtins.int:
        return pulumi.get(self, "write_units_per_second")


