# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableExportArgs', 'TableExport']

@pulumi.input_type
class TableExportArgs:
    def __init__(__self__, *,
                 s3_bucket: pulumi.Input[_builtins.str],
                 table_arn: pulumi.Input[_builtins.str],
                 export_format: Optional[pulumi.Input[_builtins.str]] = None,
                 export_time: Optional[pulumi.Input[_builtins.str]] = None,
                 export_type: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_export_specification: Optional[pulumi.Input['TableExportIncrementalExportSpecificationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TableExport resource.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
        :param pulumi.Input[_builtins.str] table_arn: ARN associated with the table to export.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] export_format: Format for the exported data. Valid values are: `DYNAMODB_JSON`, `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
        :param pulumi.Input[_builtins.str] export_time: Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
        :param pulumi.Input[_builtins.str] export_type: Whether to execute as a full export or incremental export. Valid values are: `FULL_EXPORT`, `INCREMENTAL_EXPORT`. Defaults to `FULL_EXPORT`. If `INCREMENTAL_EXPORT` is provided, the `incremental_export_specification` argument must also be provided.
               `incremental_export_specification` - (Optional, Forces new resource) Parameters specific to an incremental export. See `incremental_export_specification` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_bucket_owner: ID of the AWS account that owns the bucket the export will be stored in.
        :param pulumi.Input[_builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        :param pulumi.Input[_builtins.str] s3_sse_algorithm: Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
        :param pulumi.Input[_builtins.str] s3_sse_kms_key_id: ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "table_arn", table_arn)
        if export_format is not None:
            pulumi.set(__self__, "export_format", export_format)
        if export_time is not None:
            pulumi.set(__self__, "export_time", export_time)
        if export_type is not None:
            pulumi.set(__self__, "export_type", export_type)
        if incremental_export_specification is not None:
            pulumi.set(__self__, "incremental_export_specification", incremental_export_specification)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_bucket_owner is not None:
            pulumi.set(__self__, "s3_bucket_owner", s3_bucket_owner)
        if s3_prefix is not None:
            pulumi.set(__self__, "s3_prefix", s3_prefix)
        if s3_sse_algorithm is not None:
            pulumi.set(__self__, "s3_sse_algorithm", s3_sse_algorithm)
        if s3_sse_kms_key_id is not None:
            pulumi.set(__self__, "s3_sse_kms_key_id", s3_sse_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "s3_bucket", value)

    @_builtins.property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN associated with the table to export.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_arn")

    @table_arn.setter
    def table_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_arn", value)

    @_builtins.property
    @pulumi.getter(name="exportFormat")
    def export_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Format for the exported data. Valid values are: `DYNAMODB_JSON`, `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
        """
        return pulumi.get(self, "export_format")

    @export_format.setter
    def export_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_format", value)

    @_builtins.property
    @pulumi.getter(name="exportTime")
    def export_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
        """
        return pulumi.get(self, "export_time")

    @export_time.setter
    def export_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_time", value)

    @_builtins.property
    @pulumi.getter(name="exportType")
    def export_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to execute as a full export or incremental export. Valid values are: `FULL_EXPORT`, `INCREMENTAL_EXPORT`. Defaults to `FULL_EXPORT`. If `INCREMENTAL_EXPORT` is provided, the `incremental_export_specification` argument must also be provided.
        `incremental_export_specification` - (Optional, Forces new resource) Parameters specific to an incremental export. See `incremental_export_specification` Block for details.
        """
        return pulumi.get(self, "export_type")

    @export_type.setter
    def export_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_type", value)

    @_builtins.property
    @pulumi.getter(name="incrementalExportSpecification")
    def incremental_export_specification(self) -> Optional[pulumi.Input['TableExportIncrementalExportSpecificationArgs']]:
        return pulumi.get(self, "incremental_export_specification")

    @incremental_export_specification.setter
    def incremental_export_specification(self, value: Optional[pulumi.Input['TableExportIncrementalExportSpecificationArgs']]):
        pulumi.set(self, "incremental_export_specification", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3BucketOwner")
    def s3_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the AWS account that owns the bucket the export will be stored in.
        """
        return pulumi.get(self, "s3_bucket_owner")

    @s3_bucket_owner.setter
    def s3_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_bucket_owner", value)

    @_builtins.property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_prefix", value)

    @_builtins.property
    @pulumi.getter(name="s3SseAlgorithm")
    def s3_sse_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
        """
        return pulumi.get(self, "s3_sse_algorithm")

    @s3_sse_algorithm.setter
    def s3_sse_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_sse_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="s3SseKmsKeyId")
    def s3_sse_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
        """
        return pulumi.get(self, "s3_sse_kms_key_id")

    @s3_sse_kms_key_id.setter
    def s3_sse_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_sse_kms_key_id", value)


@pulumi.input_type
class _TableExportState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 billed_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 export_format: Optional[pulumi.Input[_builtins.str]] = None,
                 export_status: Optional[pulumi.Input[_builtins.str]] = None,
                 export_time: Optional[pulumi.Input[_builtins.str]] = None,
                 export_type: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_export_specification: Optional[pulumi.Input['TableExportIncrementalExportSpecificationArgs']] = None,
                 item_count: Optional[pulumi.Input[_builtins.int]] = None,
                 manifest_files_s3_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 table_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TableExport resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Table Export.
        :param pulumi.Input[_builtins.int] billed_size_in_bytes: Billable size of the table export.
        :param pulumi.Input[_builtins.str] end_time: Time at which the export task completed.
        :param pulumi.Input[_builtins.str] export_format: Format for the exported data. Valid values are: `DYNAMODB_JSON`, `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
        :param pulumi.Input[_builtins.str] export_status: Status of the export - export can be in one of the following states `IN_PROGRESS`, `COMPLETED`, or `FAILED`.
        :param pulumi.Input[_builtins.str] export_time: Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
        :param pulumi.Input[_builtins.str] export_type: Whether to execute as a full export or incremental export. Valid values are: `FULL_EXPORT`, `INCREMENTAL_EXPORT`. Defaults to `FULL_EXPORT`. If `INCREMENTAL_EXPORT` is provided, the `incremental_export_specification` argument must also be provided.
               `incremental_export_specification` - (Optional, Forces new resource) Parameters specific to an incremental export. See `incremental_export_specification` Block for details.
        :param pulumi.Input[_builtins.int] item_count: Number of items exported.
        :param pulumi.Input[_builtins.str] manifest_files_s3_key: Name of the manifest file for the export task. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Manifest) for more information on this manifest file.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
        :param pulumi.Input[_builtins.str] s3_bucket_owner: ID of the AWS account that owns the bucket the export will be stored in.
        :param pulumi.Input[_builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        :param pulumi.Input[_builtins.str] s3_sse_algorithm: Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
        :param pulumi.Input[_builtins.str] s3_sse_kms_key_id: ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
        :param pulumi.Input[_builtins.str] start_time: Time at which the export task began.
        :param pulumi.Input[_builtins.str] table_arn: ARN associated with the table to export.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if billed_size_in_bytes is not None:
            pulumi.set(__self__, "billed_size_in_bytes", billed_size_in_bytes)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if export_format is not None:
            pulumi.set(__self__, "export_format", export_format)
        if export_status is not None:
            pulumi.set(__self__, "export_status", export_status)
        if export_time is not None:
            pulumi.set(__self__, "export_time", export_time)
        if export_type is not None:
            pulumi.set(__self__, "export_type", export_type)
        if incremental_export_specification is not None:
            pulumi.set(__self__, "incremental_export_specification", incremental_export_specification)
        if item_count is not None:
            pulumi.set(__self__, "item_count", item_count)
        if manifest_files_s3_key is not None:
            pulumi.set(__self__, "manifest_files_s3_key", manifest_files_s3_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_bucket_owner is not None:
            pulumi.set(__self__, "s3_bucket_owner", s3_bucket_owner)
        if s3_prefix is not None:
            pulumi.set(__self__, "s3_prefix", s3_prefix)
        if s3_sse_algorithm is not None:
            pulumi.set(__self__, "s3_sse_algorithm", s3_sse_algorithm)
        if s3_sse_kms_key_id is not None:
            pulumi.set(__self__, "s3_sse_kms_key_id", s3_sse_kms_key_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if table_arn is not None:
            pulumi.set(__self__, "table_arn", table_arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Table Export.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="billedSizeInBytes")
    def billed_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Billable size of the table export.
        """
        return pulumi.get(self, "billed_size_in_bytes")

    @billed_size_in_bytes.setter
    def billed_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "billed_size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the export task completed.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="exportFormat")
    def export_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Format for the exported data. Valid values are: `DYNAMODB_JSON`, `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
        """
        return pulumi.get(self, "export_format")

    @export_format.setter
    def export_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_format", value)

    @_builtins.property
    @pulumi.getter(name="exportStatus")
    def export_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the export - export can be in one of the following states `IN_PROGRESS`, `COMPLETED`, or `FAILED`.
        """
        return pulumi.get(self, "export_status")

    @export_status.setter
    def export_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_status", value)

    @_builtins.property
    @pulumi.getter(name="exportTime")
    def export_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
        """
        return pulumi.get(self, "export_time")

    @export_time.setter
    def export_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_time", value)

    @_builtins.property
    @pulumi.getter(name="exportType")
    def export_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to execute as a full export or incremental export. Valid values are: `FULL_EXPORT`, `INCREMENTAL_EXPORT`. Defaults to `FULL_EXPORT`. If `INCREMENTAL_EXPORT` is provided, the `incremental_export_specification` argument must also be provided.
        `incremental_export_specification` - (Optional, Forces new resource) Parameters specific to an incremental export. See `incremental_export_specification` Block for details.
        """
        return pulumi.get(self, "export_type")

    @export_type.setter
    def export_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_type", value)

    @_builtins.property
    @pulumi.getter(name="incrementalExportSpecification")
    def incremental_export_specification(self) -> Optional[pulumi.Input['TableExportIncrementalExportSpecificationArgs']]:
        return pulumi.get(self, "incremental_export_specification")

    @incremental_export_specification.setter
    def incremental_export_specification(self, value: Optional[pulumi.Input['TableExportIncrementalExportSpecificationArgs']]):
        pulumi.set(self, "incremental_export_specification", value)

    @_builtins.property
    @pulumi.getter(name="itemCount")
    def item_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of items exported.
        """
        return pulumi.get(self, "item_count")

    @item_count.setter
    def item_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "item_count", value)

    @_builtins.property
    @pulumi.getter(name="manifestFilesS3Key")
    def manifest_files_s3_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the manifest file for the export task. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Manifest) for more information on this manifest file.
        """
        return pulumi.get(self, "manifest_files_s3_key")

    @manifest_files_s3_key.setter
    def manifest_files_s3_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manifest_files_s3_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @_builtins.property
    @pulumi.getter(name="s3BucketOwner")
    def s3_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the AWS account that owns the bucket the export will be stored in.
        """
        return pulumi.get(self, "s3_bucket_owner")

    @s3_bucket_owner.setter
    def s3_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_bucket_owner", value)

    @_builtins.property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_prefix", value)

    @_builtins.property
    @pulumi.getter(name="s3SseAlgorithm")
    def s3_sse_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
        """
        return pulumi.get(self, "s3_sse_algorithm")

    @s3_sse_algorithm.setter
    def s3_sse_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_sse_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="s3SseKmsKeyId")
    def s3_sse_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
        """
        return pulumi.get(self, "s3_sse_kms_key_id")

    @s3_sse_kms_key_id.setter
    def s3_sse_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_sse_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the export task began.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN associated with the table to export.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_arn")

    @table_arn.setter
    def table_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_arn", value)


@pulumi.type_token("aws:dynamodb/tableExport:TableExport")
class TableExport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export_format: Optional[pulumi.Input[_builtins.str]] = None,
                 export_time: Optional[pulumi.Input[_builtins.str]] = None,
                 export_type: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_export_specification: Optional[pulumi.Input[Union['TableExportIncrementalExportSpecificationArgs', 'TableExportIncrementalExportSpecificationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example",
            bucket_prefix="example",
            force_destroy=True)
        example_table = aws.dynamodb.Table("example",
            name="example-table-1",
            billing_mode="PAY_PER_REQUEST",
            hash_key="user_id",
            attributes=[{
                "name": "user_id",
                "type": "S",
            }],
            point_in_time_recovery={
                "enabled": True,
            })
        example_table_export = aws.dynamodb.TableExport("example",
            table_arn=example_table.arn,
            s3_bucket=example.id)
        ```

        ### Example with export time

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.TableExport("example",
            export_time="2023-04-02T11:30:13+01:00",
            s3_bucket=example_aws_s3_bucket["id"],
            table_arn=example_aws_dynamodb_table["arn"])
        ```

        ### Incremental export

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.TableExport("example",
            export_type="INCREMENTAL_EXPORT",
            s3_bucket=example_aws_s3_bucket["id"],
            table_arn=example_aws_dynamodb_table["arn"],
            incremental_export_specification={
                "export_from_time": "2025-02-09T12:00:00+01:00",
                "export_to_time": "2025-02-09T13:00:00+01:00",
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the DynamoDB table export.

        Using `pulumi import`, import DynamoDB table exports using the `arn`. For example:

        console

        % pulumi import aws_dynamodb_table_export.example arn:aws:dynamodb:us-west-2:12345678911:table/my-table-1/export/01580735656614-2c2f422e

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] export_format: Format for the exported data. Valid values are: `DYNAMODB_JSON`, `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
        :param pulumi.Input[_builtins.str] export_time: Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
        :param pulumi.Input[_builtins.str] export_type: Whether to execute as a full export or incremental export. Valid values are: `FULL_EXPORT`, `INCREMENTAL_EXPORT`. Defaults to `FULL_EXPORT`. If `INCREMENTAL_EXPORT` is provided, the `incremental_export_specification` argument must also be provided.
               `incremental_export_specification` - (Optional, Forces new resource) Parameters specific to an incremental export. See `incremental_export_specification` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
        :param pulumi.Input[_builtins.str] s3_bucket_owner: ID of the AWS account that owns the bucket the export will be stored in.
        :param pulumi.Input[_builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        :param pulumi.Input[_builtins.str] s3_sse_algorithm: Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
        :param pulumi.Input[_builtins.str] s3_sse_kms_key_id: ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
        :param pulumi.Input[_builtins.str] table_arn: ARN associated with the table to export.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableExportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example",
            bucket_prefix="example",
            force_destroy=True)
        example_table = aws.dynamodb.Table("example",
            name="example-table-1",
            billing_mode="PAY_PER_REQUEST",
            hash_key="user_id",
            attributes=[{
                "name": "user_id",
                "type": "S",
            }],
            point_in_time_recovery={
                "enabled": True,
            })
        example_table_export = aws.dynamodb.TableExport("example",
            table_arn=example_table.arn,
            s3_bucket=example.id)
        ```

        ### Example with export time

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.TableExport("example",
            export_time="2023-04-02T11:30:13+01:00",
            s3_bucket=example_aws_s3_bucket["id"],
            table_arn=example_aws_dynamodb_table["arn"])
        ```

        ### Incremental export

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dynamodb.TableExport("example",
            export_type="INCREMENTAL_EXPORT",
            s3_bucket=example_aws_s3_bucket["id"],
            table_arn=example_aws_dynamodb_table["arn"],
            incremental_export_specification={
                "export_from_time": "2025-02-09T12:00:00+01:00",
                "export_to_time": "2025-02-09T13:00:00+01:00",
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the DynamoDB table export.

        Using `pulumi import`, import DynamoDB table exports using the `arn`. For example:

        console

        % pulumi import aws_dynamodb_table_export.example arn:aws:dynamodb:us-west-2:12345678911:table/my-table-1/export/01580735656614-2c2f422e

        :param str resource_name: The name of the resource.
        :param TableExportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableExportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export_format: Optional[pulumi.Input[_builtins.str]] = None,
                 export_time: Optional[pulumi.Input[_builtins.str]] = None,
                 export_type: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental_export_specification: Optional[pulumi.Input[Union['TableExportIncrementalExportSpecificationArgs', 'TableExportIncrementalExportSpecificationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_sse_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableExportArgs.__new__(TableExportArgs)

            __props__.__dict__["export_format"] = export_format
            __props__.__dict__["export_time"] = export_time
            __props__.__dict__["export_type"] = export_type
            __props__.__dict__["incremental_export_specification"] = incremental_export_specification
            __props__.__dict__["region"] = region
            if s3_bucket is None and not opts.urn:
                raise TypeError("Missing required property 's3_bucket'")
            __props__.__dict__["s3_bucket"] = s3_bucket
            __props__.__dict__["s3_bucket_owner"] = s3_bucket_owner
            __props__.__dict__["s3_prefix"] = s3_prefix
            __props__.__dict__["s3_sse_algorithm"] = s3_sse_algorithm
            __props__.__dict__["s3_sse_kms_key_id"] = s3_sse_kms_key_id
            if table_arn is None and not opts.urn:
                raise TypeError("Missing required property 'table_arn'")
            __props__.__dict__["table_arn"] = table_arn
            __props__.__dict__["arn"] = None
            __props__.__dict__["billed_size_in_bytes"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["export_status"] = None
            __props__.__dict__["item_count"] = None
            __props__.__dict__["manifest_files_s3_key"] = None
            __props__.__dict__["start_time"] = None
        super(TableExport, __self__).__init__(
            'aws:dynamodb/tableExport:TableExport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            billed_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            export_format: Optional[pulumi.Input[_builtins.str]] = None,
            export_status: Optional[pulumi.Input[_builtins.str]] = None,
            export_time: Optional[pulumi.Input[_builtins.str]] = None,
            export_type: Optional[pulumi.Input[_builtins.str]] = None,
            incremental_export_specification: Optional[pulumi.Input[Union['TableExportIncrementalExportSpecificationArgs', 'TableExportIncrementalExportSpecificationArgsDict']]] = None,
            item_count: Optional[pulumi.Input[_builtins.int]] = None,
            manifest_files_s3_key: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            s3_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            s3_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
            s3_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            s3_sse_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            s3_sse_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            table_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'TableExport':
        """
        Get an existing TableExport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Table Export.
        :param pulumi.Input[_builtins.int] billed_size_in_bytes: Billable size of the table export.
        :param pulumi.Input[_builtins.str] end_time: Time at which the export task completed.
        :param pulumi.Input[_builtins.str] export_format: Format for the exported data. Valid values are: `DYNAMODB_JSON`, `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
        :param pulumi.Input[_builtins.str] export_status: Status of the export - export can be in one of the following states `IN_PROGRESS`, `COMPLETED`, or `FAILED`.
        :param pulumi.Input[_builtins.str] export_time: Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
        :param pulumi.Input[_builtins.str] export_type: Whether to execute as a full export or incremental export. Valid values are: `FULL_EXPORT`, `INCREMENTAL_EXPORT`. Defaults to `FULL_EXPORT`. If `INCREMENTAL_EXPORT` is provided, the `incremental_export_specification` argument must also be provided.
               `incremental_export_specification` - (Optional, Forces new resource) Parameters specific to an incremental export. See `incremental_export_specification` Block for details.
        :param pulumi.Input[_builtins.int] item_count: Number of items exported.
        :param pulumi.Input[_builtins.str] manifest_files_s3_key: Name of the manifest file for the export task. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Manifest) for more information on this manifest file.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_bucket: Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
        :param pulumi.Input[_builtins.str] s3_bucket_owner: ID of the AWS account that owns the bucket the export will be stored in.
        :param pulumi.Input[_builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        :param pulumi.Input[_builtins.str] s3_sse_algorithm: Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
        :param pulumi.Input[_builtins.str] s3_sse_kms_key_id: ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
        :param pulumi.Input[_builtins.str] start_time: Time at which the export task began.
        :param pulumi.Input[_builtins.str] table_arn: ARN associated with the table to export.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableExportState.__new__(_TableExportState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["billed_size_in_bytes"] = billed_size_in_bytes
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["export_format"] = export_format
        __props__.__dict__["export_status"] = export_status
        __props__.__dict__["export_time"] = export_time
        __props__.__dict__["export_type"] = export_type
        __props__.__dict__["incremental_export_specification"] = incremental_export_specification
        __props__.__dict__["item_count"] = item_count
        __props__.__dict__["manifest_files_s3_key"] = manifest_files_s3_key
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_bucket"] = s3_bucket
        __props__.__dict__["s3_bucket_owner"] = s3_bucket_owner
        __props__.__dict__["s3_prefix"] = s3_prefix
        __props__.__dict__["s3_sse_algorithm"] = s3_sse_algorithm
        __props__.__dict__["s3_sse_kms_key_id"] = s3_sse_kms_key_id
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["table_arn"] = table_arn
        return TableExport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Table Export.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="billedSizeInBytes")
    def billed_size_in_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        Billable size of the table export.
        """
        return pulumi.get(self, "billed_size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the export task completed.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="exportFormat")
    def export_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Format for the exported data. Valid values are: `DYNAMODB_JSON`, `ION`. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Data) for more information on these export formats. Default is `DYNAMODB_JSON`.
        """
        return pulumi.get(self, "export_format")

    @_builtins.property
    @pulumi.getter(name="exportStatus")
    def export_status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the export - export can be in one of the following states `IN_PROGRESS`, `COMPLETED`, or `FAILED`.
        """
        return pulumi.get(self, "export_status")

    @_builtins.property
    @pulumi.getter(name="exportTime")
    def export_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time in RFC3339 format from which to export table data. The table export will be a snapshot of the table's state at this point in time. Omitting this value will result in a snapshot from the current time.
        """
        return pulumi.get(self, "export_time")

    @_builtins.property
    @pulumi.getter(name="exportType")
    def export_type(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to execute as a full export or incremental export. Valid values are: `FULL_EXPORT`, `INCREMENTAL_EXPORT`. Defaults to `FULL_EXPORT`. If `INCREMENTAL_EXPORT` is provided, the `incremental_export_specification` argument must also be provided.
        `incremental_export_specification` - (Optional, Forces new resource) Parameters specific to an incremental export. See `incremental_export_specification` Block for details.
        """
        return pulumi.get(self, "export_type")

    @_builtins.property
    @pulumi.getter(name="incrementalExportSpecification")
    def incremental_export_specification(self) -> pulumi.Output[Optional['outputs.TableExportIncrementalExportSpecification']]:
        return pulumi.get(self, "incremental_export_specification")

    @_builtins.property
    @pulumi.getter(name="itemCount")
    def item_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of items exported.
        """
        return pulumi.get(self, "item_count")

    @_builtins.property
    @pulumi.getter(name="manifestFilesS3Key")
    def manifest_files_s3_key(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the manifest file for the export task. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport.Output.html#S3DataExport.Output_Manifest) for more information on this manifest file.
        """
        return pulumi.get(self, "manifest_files_s3_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Amazon S3 bucket to export the snapshot to. See the [AWS Documentation](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/S3DataExport_Requesting.html#S3DataExport_Requesting_Permissions) for information on how configure this S3 bucket.
        """
        return pulumi.get(self, "s3_bucket")

    @_builtins.property
    @pulumi.getter(name="s3BucketOwner")
    def s3_bucket_owner(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the AWS account that owns the bucket the export will be stored in.
        """
        return pulumi.get(self, "s3_bucket_owner")

    @_builtins.property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        """
        return pulumi.get(self, "s3_prefix")

    @_builtins.property
    @pulumi.getter(name="s3SseAlgorithm")
    def s3_sse_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Type of encryption used on the bucket where export data will be stored. Valid values are: `AES256`, `KMS`.
        """
        return pulumi.get(self, "s3_sse_algorithm")

    @_builtins.property
    @pulumi.getter(name="s3SseKmsKeyId")
    def s3_sse_kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
        """
        return pulumi.get(self, "s3_sse_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the export task began.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN associated with the table to export.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_arn")

