# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipAssociationArgs', 'EipAssociation']

@pulumi.input_type
class EipAssociationArgs:
    def __init__(__self__, *,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_reassociation: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EipAssociation resource.
        :param pulumi.Input[_builtins.str] allocation_id: ID of the associated Elastic IP.
               This argument is required despite being optional at the resource level due to legacy support for EC2-Classic networking.
        :param pulumi.Input[_builtins.bool] allow_reassociation: Whether to allow an Elastic IP address to be re-associated.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] instance_id: ID of the instance.
               The instance must have exactly one attached network interface.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] network_interface_id: ID of the network interface.
               If the instance has more than one network interface, you must specify a network interface ID.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] private_ip_address: Primary or secondary private IP address to associate with the Elastic IP address.
               If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[_builtins.str] public_ip: ) Address of the associated Elastic IP.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if allow_reassociation is not None:
            pulumi.set(__self__, "allow_reassociation", allow_reassociation)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the associated Elastic IP.
        This argument is required despite being optional at the resource level due to legacy support for EC2-Classic networking.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter(name="allowReassociation")
    def allow_reassociation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow an Elastic IP address to be re-associated.
        Defaults to `true`.
        """
        return pulumi.get(self, "allow_reassociation")

    @allow_reassociation.setter
    def allow_reassociation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_reassociation", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the instance.
        The instance must have exactly one attached network interface.
        You can specify either the instance ID or the network interface ID, but not both.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the network interface.
        If the instance has more than one network interface, you must specify a network interface ID.
        You can specify either the instance ID or the network interface ID, but not both.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary or secondary private IP address to associate with the Elastic IP address.
        If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) Address of the associated Elastic IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EipAssociationState:
    def __init__(__self__, *,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_reassociation: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EipAssociation resources.
        :param pulumi.Input[_builtins.str] allocation_id: ID of the associated Elastic IP.
               This argument is required despite being optional at the resource level due to legacy support for EC2-Classic networking.
        :param pulumi.Input[_builtins.bool] allow_reassociation: Whether to allow an Elastic IP address to be re-associated.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] instance_id: ID of the instance.
               The instance must have exactly one attached network interface.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] network_interface_id: ID of the network interface.
               If the instance has more than one network interface, you must specify a network interface ID.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] private_ip_address: Primary or secondary private IP address to associate with the Elastic IP address.
               If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[_builtins.str] public_ip: ) Address of the associated Elastic IP.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if allow_reassociation is not None:
            pulumi.set(__self__, "allow_reassociation", allow_reassociation)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the associated Elastic IP.
        This argument is required despite being optional at the resource level due to legacy support for EC2-Classic networking.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter(name="allowReassociation")
    def allow_reassociation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow an Elastic IP address to be re-associated.
        Defaults to `true`.
        """
        return pulumi.get(self, "allow_reassociation")

    @allow_reassociation.setter
    def allow_reassociation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_reassociation", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the instance.
        The instance must have exactly one attached network interface.
        You can specify either the instance ID or the network interface ID, but not both.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the network interface.
        If the instance has more than one network interface, you must specify a network interface ID.
        You can specify either the instance ID or the network interface ID, but not both.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary or secondary private IP address to associate with the Elastic IP address.
        If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) Address of the associated Elastic IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:ec2/eipAssociation:EipAssociation")
class EipAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_reassociation: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an AWS EIP Association as a top level resource, to associate and disassociate Elastic IPs from AWS Instances and Network Interfaces.

        > **NOTE:** Do not use this resource to associate an EIP to `lb.LoadBalancer` or `ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.

        > **NOTE:** `ec2.EipAssociation` is useful in scenarios where EIPs are either pre-existing or distributed to customers or users and therefore cannot be changed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        web = aws.ec2.Instance("web",
            ami="ami-21f78e11",
            availability_zone="us-west-2a",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            tags={
                "Name": "HelloWorld",
            })
        example = aws.ec2.Eip("example", domain="vpc")
        eip_assoc = aws.ec2.EipAssociation("eip_assoc",
            instance_id=web.id,
            allocation_id=example.id)
        ```

        ## Import

        Using `pulumi import`, import EIP Assocations using their association IDs. For example:

        ```sh
        $ pulumi import aws:ec2/eipAssociation:EipAssociation test eipassoc-ab12c345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allocation_id: ID of the associated Elastic IP.
               This argument is required despite being optional at the resource level due to legacy support for EC2-Classic networking.
        :param pulumi.Input[_builtins.bool] allow_reassociation: Whether to allow an Elastic IP address to be re-associated.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] instance_id: ID of the instance.
               The instance must have exactly one attached network interface.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] network_interface_id: ID of the network interface.
               If the instance has more than one network interface, you must specify a network interface ID.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] private_ip_address: Primary or secondary private IP address to associate with the Elastic IP address.
               If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[_builtins.str] public_ip: ) Address of the associated Elastic IP.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EipAssociationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS EIP Association as a top level resource, to associate and disassociate Elastic IPs from AWS Instances and Network Interfaces.

        > **NOTE:** Do not use this resource to associate an EIP to `lb.LoadBalancer` or `ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.

        > **NOTE:** `ec2.EipAssociation` is useful in scenarios where EIPs are either pre-existing or distributed to customers or users and therefore cannot be changed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        web = aws.ec2.Instance("web",
            ami="ami-21f78e11",
            availability_zone="us-west-2a",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            tags={
                "Name": "HelloWorld",
            })
        example = aws.ec2.Eip("example", domain="vpc")
        eip_assoc = aws.ec2.EipAssociation("eip_assoc",
            instance_id=web.id,
            allocation_id=example.id)
        ```

        ## Import

        Using `pulumi import`, import EIP Assocations using their association IDs. For example:

        ```sh
        $ pulumi import aws:ec2/eipAssociation:EipAssociation test eipassoc-ab12c345
        ```

        :param str resource_name: The name of the resource.
        :param EipAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_reassociation: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipAssociationArgs.__new__(EipAssociationArgs)

            __props__.__dict__["allocation_id"] = allocation_id
            __props__.__dict__["allow_reassociation"] = allow_reassociation
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["network_interface_id"] = network_interface_id
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
        super(EipAssociation, __self__).__init__(
            'aws:ec2/eipAssociation:EipAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
            allow_reassociation: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'EipAssociation':
        """
        Get an existing EipAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allocation_id: ID of the associated Elastic IP.
               This argument is required despite being optional at the resource level due to legacy support for EC2-Classic networking.
        :param pulumi.Input[_builtins.bool] allow_reassociation: Whether to allow an Elastic IP address to be re-associated.
               Defaults to `true`.
        :param pulumi.Input[_builtins.str] instance_id: ID of the instance.
               The instance must have exactly one attached network interface.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] network_interface_id: ID of the network interface.
               If the instance has more than one network interface, you must specify a network interface ID.
               You can specify either the instance ID or the network interface ID, but not both.
        :param pulumi.Input[_builtins.str] private_ip_address: Primary or secondary private IP address to associate with the Elastic IP address.
               If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[_builtins.str] public_ip: ) Address of the associated Elastic IP.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipAssociationState.__new__(_EipAssociationState)

        __props__.__dict__["allocation_id"] = allocation_id
        __props__.__dict__["allow_reassociation"] = allow_reassociation
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        return EipAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the associated Elastic IP.
        This argument is required despite being optional at the resource level due to legacy support for EC2-Classic networking.
        """
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="allowReassociation")
    def allow_reassociation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow an Elastic IP address to be re-associated.
        Defaults to `true`.
        """
        return pulumi.get(self, "allow_reassociation")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the instance.
        The instance must have exactly one attached network interface.
        You can specify either the instance ID or the network interface ID, but not both.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the network interface.
        If the instance has more than one network interface, you must specify a network interface ID.
        You can specify either the instance ID or the network interface ID, but not both.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        Primary or secondary private IP address to associate with the Elastic IP address.
        If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        ) Address of the associated Elastic IP.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

