# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetElasticIpResult',
    'AwaitableGetElasticIpResult',
    'get_elastic_ip',
    'get_elastic_ip_output',
]

@pulumi.output_type
class GetElasticIpResult:
    """
    A collection of values returned by getElasticIp.
    """
    def __init__(__self__, arn=None, association_id=None, carrier_ip=None, customer_owned_ip=None, customer_owned_ipv4_pool=None, domain=None, filters=None, id=None, instance_id=None, ipam_pool_id=None, network_interface_id=None, network_interface_owner_id=None, private_dns=None, private_ip=None, ptr_record=None, public_dns=None, public_ip=None, public_ipv4_pool=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if carrier_ip and not isinstance(carrier_ip, str):
            raise TypeError("Expected argument 'carrier_ip' to be a str")
        pulumi.set(__self__, "carrier_ip", carrier_ip)
        if customer_owned_ip and not isinstance(customer_owned_ip, str):
            raise TypeError("Expected argument 'customer_owned_ip' to be a str")
        pulumi.set(__self__, "customer_owned_ip", customer_owned_ip)
        if customer_owned_ipv4_pool and not isinstance(customer_owned_ipv4_pool, str):
            raise TypeError("Expected argument 'customer_owned_ipv4_pool' to be a str")
        pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if ipam_pool_id and not isinstance(ipam_pool_id, str):
            raise TypeError("Expected argument 'ipam_pool_id' to be a str")
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if network_interface_id and not isinstance(network_interface_id, str):
            raise TypeError("Expected argument 'network_interface_id' to be a str")
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if network_interface_owner_id and not isinstance(network_interface_owner_id, str):
            raise TypeError("Expected argument 'network_interface_owner_id' to be a str")
        pulumi.set(__self__, "network_interface_owner_id", network_interface_owner_id)
        if private_dns and not isinstance(private_dns, str):
            raise TypeError("Expected argument 'private_dns' to be a str")
        pulumi.set(__self__, "private_dns", private_dns)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if ptr_record and not isinstance(ptr_record, str):
            raise TypeError("Expected argument 'ptr_record' to be a str")
        pulumi.set(__self__, "ptr_record", ptr_record)
        if public_dns and not isinstance(public_dns, str):
            raise TypeError("Expected argument 'public_dns' to be a str")
        pulumi.set(__self__, "public_dns", public_dns)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if public_ipv4_pool and not isinstance(public_ipv4_pool, str):
            raise TypeError("Expected argument 'public_ipv4_pool' to be a str")
        pulumi.set(__self__, "public_ipv4_pool", public_ipv4_pool)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="associationId")
    def association_id(self) -> _builtins.str:
        """
        ID representing the association of the address with an instance in a VPC.
        """
        return pulumi.get(self, "association_id")

    @_builtins.property
    @pulumi.getter(name="carrierIp")
    def carrier_ip(self) -> _builtins.str:
        """
        Carrier IP address.
        """
        return pulumi.get(self, "carrier_ip")

    @_builtins.property
    @pulumi.getter(name="customerOwnedIp")
    def customer_owned_ip(self) -> _builtins.str:
        """
        Customer Owned IP.
        """
        return pulumi.get(self, "customer_owned_ip")

    @_builtins.property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> _builtins.str:
        """
        The ID of a Customer Owned IP Pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing)
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Whether the address is for use in EC2-Classic (standard) or in a VPC (vpc).
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetElasticIpFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        If VPC Elastic IP, the allocation identifier. If EC2-Classic Elastic IP, the public IP address.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the instance that the address is associated with (if any).
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> _builtins.str:
        """
        The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> _builtins.str:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceOwnerId")
    def network_interface_owner_id(self) -> _builtins.str:
        """
        The ID of the AWS account that owns the network interface.
        """
        return pulumi.get(self, "network_interface_owner_id")

    @_builtins.property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> _builtins.str:
        """
        Private DNS associated with the Elastic IP address.
        """
        return pulumi.get(self, "private_dns")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        Private IP address associated with the Elastic IP address.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="ptrRecord")
    def ptr_record(self) -> _builtins.str:
        """
        The DNS pointer (PTR) record for the IP address.
        """
        return pulumi.get(self, "ptr_record")

    @_builtins.property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> _builtins.str:
        """
        Public DNS associated with the Elastic IP address.
        """
        return pulumi.get(self, "public_dns")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        Public IP address of Elastic IP.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpv4Pool")
    def public_ipv4_pool(self) -> _builtins.str:
        """
        ID of an address pool.
        """
        return pulumi.get(self, "public_ipv4_pool")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of tags associated with Elastic IP.
        """
        return pulumi.get(self, "tags")


class AwaitableGetElasticIpResult(GetElasticIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetElasticIpResult(
            arn=self.arn,
            association_id=self.association_id,
            carrier_ip=self.carrier_ip,
            customer_owned_ip=self.customer_owned_ip,
            customer_owned_ipv4_pool=self.customer_owned_ipv4_pool,
            domain=self.domain,
            filters=self.filters,
            id=self.id,
            instance_id=self.instance_id,
            ipam_pool_id=self.ipam_pool_id,
            network_interface_id=self.network_interface_id,
            network_interface_owner_id=self.network_interface_owner_id,
            private_dns=self.private_dns,
            private_ip=self.private_ip,
            ptr_record=self.ptr_record,
            public_dns=self.public_dns,
            public_ip=self.public_ip,
            public_ipv4_pool=self.public_ipv4_pool,
            region=self.region,
            tags=self.tags)


def get_elastic_ip(filters: Optional[Sequence[Union['GetElasticIpFilterArgs', 'GetElasticIpFilterArgsDict']]] = None,
                   id: Optional[_builtins.str] = None,
                   public_ip: Optional[_builtins.str] = None,
                   region: Optional[_builtins.str] = None,
                   tags: Optional[Mapping[str, _builtins.str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetElasticIpResult:
    """
    `ec2.Eip` provides details about a specific Elastic IP.

    ## Example Usage

    ### Search By Allocation ID (VPC only)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_allocation_id = aws.ec2.get_elastic_ip(id="eipalloc-12345678")
    ```

    ### Search By Filters (EC2-Classic or VPC)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_filter = aws.ec2.get_elastic_ip(filters=[{
        "name": "tag:Name",
        "values": ["exampleNameTagValue"],
    }])
    ```

    ### Search By Public IP (EC2-Classic or VPC)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_public_ip = aws.ec2.get_elastic_ip(public_ip="1.2.3.4")
    ```

    ### Search By Tags (EC2-Classic or VPC)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_tags = aws.ec2.get_elastic_ip(tags={
        "Name": "exampleNameTagValue",
    })
    ```


    :param Sequence[Union['GetElasticIpFilterArgs', 'GetElasticIpFilterArgsDict']] filters: One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
    :param _builtins.str id: Allocation ID of the specific VPC EIP to retrieve. If a classic EIP is required, do NOT set `id`, only set `public_ip`
    :param _builtins.str public_ip: Public IP of the specific EIP to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired Elastic IP.
           
           The arguments of this data source act as filters for querying the available
           Elastic IPs in the current region. The given filters must match exactly one
           Elastic IP whose data will be exported as attributes.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['publicIp'] = public_ip
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getElasticIp:getElasticIp', __args__, opts=opts, typ=GetElasticIpResult).value

    return AwaitableGetElasticIpResult(
        arn=pulumi.get(__ret__, 'arn'),
        association_id=pulumi.get(__ret__, 'association_id'),
        carrier_ip=pulumi.get(__ret__, 'carrier_ip'),
        customer_owned_ip=pulumi.get(__ret__, 'customer_owned_ip'),
        customer_owned_ipv4_pool=pulumi.get(__ret__, 'customer_owned_ipv4_pool'),
        domain=pulumi.get(__ret__, 'domain'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        ipam_pool_id=pulumi.get(__ret__, 'ipam_pool_id'),
        network_interface_id=pulumi.get(__ret__, 'network_interface_id'),
        network_interface_owner_id=pulumi.get(__ret__, 'network_interface_owner_id'),
        private_dns=pulumi.get(__ret__, 'private_dns'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        ptr_record=pulumi.get(__ret__, 'ptr_record'),
        public_dns=pulumi.get(__ret__, 'public_dns'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        public_ipv4_pool=pulumi.get(__ret__, 'public_ipv4_pool'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_elastic_ip_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetElasticIpFilterArgs', 'GetElasticIpFilterArgsDict']]]]] = None,
                          id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          public_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetElasticIpResult]:
    """
    `ec2.Eip` provides details about a specific Elastic IP.

    ## Example Usage

    ### Search By Allocation ID (VPC only)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_allocation_id = aws.ec2.get_elastic_ip(id="eipalloc-12345678")
    ```

    ### Search By Filters (EC2-Classic or VPC)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_filter = aws.ec2.get_elastic_ip(filters=[{
        "name": "tag:Name",
        "values": ["exampleNameTagValue"],
    }])
    ```

    ### Search By Public IP (EC2-Classic or VPC)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_public_ip = aws.ec2.get_elastic_ip(public_ip="1.2.3.4")
    ```

    ### Search By Tags (EC2-Classic or VPC)

    ```python
    import pulumi
    import pulumi_aws as aws

    by_tags = aws.ec2.get_elastic_ip(tags={
        "Name": "exampleNameTagValue",
    })
    ```


    :param Sequence[Union['GetElasticIpFilterArgs', 'GetElasticIpFilterArgsDict']] filters: One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
    :param _builtins.str id: Allocation ID of the specific VPC EIP to retrieve. If a classic EIP is required, do NOT set `id`, only set `public_ip`
    :param _builtins.str public_ip: Public IP of the specific EIP to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired Elastic IP.
           
           The arguments of this data source act as filters for querying the available
           Elastic IPs in the current region. The given filters must match exactly one
           Elastic IP whose data will be exported as attributes.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['publicIp'] = public_ip
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getElasticIp:getElasticIp', __args__, opts=opts, typ=GetElasticIpResult)
    return __ret__.apply(lambda __response__: GetElasticIpResult(
        arn=pulumi.get(__response__, 'arn'),
        association_id=pulumi.get(__response__, 'association_id'),
        carrier_ip=pulumi.get(__response__, 'carrier_ip'),
        customer_owned_ip=pulumi.get(__response__, 'customer_owned_ip'),
        customer_owned_ipv4_pool=pulumi.get(__response__, 'customer_owned_ipv4_pool'),
        domain=pulumi.get(__response__, 'domain'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        ipam_pool_id=pulumi.get(__response__, 'ipam_pool_id'),
        network_interface_id=pulumi.get(__response__, 'network_interface_id'),
        network_interface_owner_id=pulumi.get(__response__, 'network_interface_owner_id'),
        private_dns=pulumi.get(__response__, 'private_dns'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        ptr_record=pulumi.get(__response__, 'ptr_record'),
        public_dns=pulumi.get(__response__, 'public_dns'),
        public_ip=pulumi.get(__response__, 'public_ip'),
        public_ipv4_pool=pulumi.get(__response__, 'public_ipv4_pool'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
