# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPublicIpv4PoolResult',
    'AwaitableGetPublicIpv4PoolResult',
    'get_public_ipv4_pool',
    'get_public_ipv4_pool_output',
]

@pulumi.output_type
class GetPublicIpv4PoolResult:
    """
    A collection of values returned by getPublicIpv4Pool.
    """
    def __init__(__self__, description=None, id=None, network_border_group=None, pool_address_ranges=None, pool_id=None, region=None, tags=None, total_address_count=None, total_available_address_count=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_border_group and not isinstance(network_border_group, str):
            raise TypeError("Expected argument 'network_border_group' to be a str")
        pulumi.set(__self__, "network_border_group", network_border_group)
        if pool_address_ranges and not isinstance(pool_address_ranges, list):
            raise TypeError("Expected argument 'pool_address_ranges' to be a list")
        pulumi.set(__self__, "pool_address_ranges", pool_address_ranges)
        if pool_id and not isinstance(pool_id, str):
            raise TypeError("Expected argument 'pool_id' to be a str")
        pulumi.set(__self__, "pool_id", pool_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_address_count and not isinstance(total_address_count, int):
            raise TypeError("Expected argument 'total_address_count' to be a int")
        pulumi.set(__self__, "total_address_count", total_address_count)
        if total_available_address_count and not isinstance(total_available_address_count, int):
            raise TypeError("Expected argument 'total_available_address_count' to be a int")
        pulumi.set(__self__, "total_available_address_count", total_available_address_count)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the pool, if any.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkBorderGroup")
    def network_border_group(self) -> _builtins.str:
        """
        Name of the location from which the address pool is advertised.
        * pool_address_ranges` - List of Address Ranges in the Pool; each address range record contains:
        """
        return pulumi.get(self, "network_border_group")

    @_builtins.property
    @pulumi.getter(name="poolAddressRanges")
    def pool_address_ranges(self) -> Sequence['outputs.GetPublicIpv4PoolPoolAddressRangeResult']:
        return pulumi.get(self, "pool_address_ranges")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Any tags for the address pool.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalAddressCount")
    def total_address_count(self) -> _builtins.int:
        """
        Total number of addresses in the pool.
        """
        return pulumi.get(self, "total_address_count")

    @_builtins.property
    @pulumi.getter(name="totalAvailableAddressCount")
    def total_available_address_count(self) -> _builtins.int:
        """
        Total number of available addresses in the pool.
        """
        return pulumi.get(self, "total_available_address_count")


class AwaitableGetPublicIpv4PoolResult(GetPublicIpv4PoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicIpv4PoolResult(
            description=self.description,
            id=self.id,
            network_border_group=self.network_border_group,
            pool_address_ranges=self.pool_address_ranges,
            pool_id=self.pool_id,
            region=self.region,
            tags=self.tags,
            total_address_count=self.total_address_count,
            total_available_address_count=self.total_available_address_count)


def get_public_ipv4_pool(pool_id: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         tags: Optional[Mapping[str, _builtins.str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicIpv4PoolResult:
    """
    Provides details about a specific AWS EC2 Public IPv4 Pool.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_public_ipv4_pool(pool_id="ipv4pool-ec2-000df99cff0c1ec10")
    ```


    :param _builtins.str pool_id: AWS resource IDs of a public IPv4 pool (as a string) for which this data source will fetch detailed information.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Any tags for the address pool.
    """
    __args__ = dict()
    __args__['poolId'] = pool_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getPublicIpv4Pool:getPublicIpv4Pool', __args__, opts=opts, typ=GetPublicIpv4PoolResult).value

    return AwaitableGetPublicIpv4PoolResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        network_border_group=pulumi.get(__ret__, 'network_border_group'),
        pool_address_ranges=pulumi.get(__ret__, 'pool_address_ranges'),
        pool_id=pulumi.get(__ret__, 'pool_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        total_address_count=pulumi.get(__ret__, 'total_address_count'),
        total_available_address_count=pulumi.get(__ret__, 'total_available_address_count'))
def get_public_ipv4_pool_output(pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPublicIpv4PoolResult]:
    """
    Provides details about a specific AWS EC2 Public IPv4 Pool.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_public_ipv4_pool(pool_id="ipv4pool-ec2-000df99cff0c1ec10")
    ```


    :param _builtins.str pool_id: AWS resource IDs of a public IPv4 pool (as a string) for which this data source will fetch detailed information.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Any tags for the address pool.
    """
    __args__ = dict()
    __args__['poolId'] = pool_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getPublicIpv4Pool:getPublicIpv4Pool', __args__, opts=opts, typ=GetPublicIpv4PoolResult)
    return __ret__.apply(lambda __response__: GetPublicIpv4PoolResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        network_border_group=pulumi.get(__response__, 'network_border_group'),
        pool_address_ranges=pulumi.get(__response__, 'pool_address_ranges'),
        pool_id=pulumi.get(__response__, 'pool_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        total_address_count=pulumi.get(__response__, 'total_address_count'),
        total_available_address_count=pulumi.get(__response__, 'total_available_address_count')))
