# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSerialConsoleAccessResult',
    'AwaitableGetSerialConsoleAccessResult',
    'get_serial_console_access',
    'get_serial_console_access_output',
]

@pulumi.output_type
class GetSerialConsoleAccessResult:
    """
    A collection of values returned by getSerialConsoleAccess.
    """
    def __init__(__self__, enabled=None, id=None, region=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether or not serial console access is enabled. Returns as `true` or `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetSerialConsoleAccessResult(GetSerialConsoleAccessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSerialConsoleAccessResult(
            enabled=self.enabled,
            id=self.id,
            region=self.region)


def get_serial_console_access(region: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSerialConsoleAccessResult:
    """
    Provides a way to check whether serial console access is enabled for your AWS account in the current AWS region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.ec2.get_serial_console_access()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getSerialConsoleAccess:getSerialConsoleAccess', __args__, opts=opts, typ=GetSerialConsoleAccessResult).value

    return AwaitableGetSerialConsoleAccessResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_serial_console_access_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSerialConsoleAccessResult]:
    """
    Provides a way to check whether serial console access is enabled for your AWS account in the current AWS region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.ec2.get_serial_console_access()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getSerialConsoleAccess:getSerialConsoleAccess', __args__, opts=opts, typ=GetSerialConsoleAccessResult)
    return __ret__.apply(lambda __response__: GetSerialConsoleAccessResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
