# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSpotDatafeedSubscriptionResult',
    'AwaitableGetSpotDatafeedSubscriptionResult',
    'get_spot_datafeed_subscription',
    'get_spot_datafeed_subscription_output',
]

@pulumi.output_type
class GetSpotDatafeedSubscriptionResult:
    """
    A collection of values returned by getSpotDatafeedSubscription.
    """
    def __init__(__self__, bucket=None, id=None, prefix=None, region=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the Amazon S3 bucket where the spot instance data feed is located.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The prefix for the data feed files.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetSpotDatafeedSubscriptionResult(GetSpotDatafeedSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpotDatafeedSubscriptionResult(
            bucket=self.bucket,
            id=self.id,
            prefix=self.prefix,
            region=self.region)


def get_spot_datafeed_subscription(region: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpotDatafeedSubscriptionResult:
    """
    > There is only a single spot data feed subscription per account.

    Data source for accessing an AWS EC2 (Elastic Compute Cloud) spot data feed subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_spot_datafeed_subscription()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getSpotDatafeedSubscription:getSpotDatafeedSubscription', __args__, opts=opts, typ=GetSpotDatafeedSubscriptionResult).value

    return AwaitableGetSpotDatafeedSubscriptionResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        id=pulumi.get(__ret__, 'id'),
        prefix=pulumi.get(__ret__, 'prefix'),
        region=pulumi.get(__ret__, 'region'))
def get_spot_datafeed_subscription_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSpotDatafeedSubscriptionResult]:
    """
    > There is only a single spot data feed subscription per account.

    Data source for accessing an AWS EC2 (Elastic Compute Cloud) spot data feed subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.ec2.get_spot_datafeed_subscription()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getSpotDatafeedSubscription:getSpotDatafeedSubscription', __args__, opts=opts, typ=GetSpotDatafeedSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSpotDatafeedSubscriptionResult(
        bucket=pulumi.get(__response__, 'bucket'),
        id=pulumi.get(__response__, 'id'),
        prefix=pulumi.get(__response__, 'prefix'),
        region=pulumi.get(__response__, 'region')))
