# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpnConnectionResult',
    'AwaitableGetVpnConnectionResult',
    'get_vpn_connection',
    'get_vpn_connection_output',
]

@pulumi.output_type
class GetVpnConnectionResult:
    """
    A collection of values returned by getVpnConnection.
    """
    def __init__(__self__, category=None, core_network_arn=None, core_network_attachment_arn=None, customer_gateway_configuration=None, customer_gateway_id=None, filters=None, gateway_association_state=None, id=None, pre_shared_key_arn=None, region=None, routes=None, state=None, tags=None, transit_gateway_id=None, type=None, vgw_telemetries=None, vpn_connection_id=None, vpn_gateway_id=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if core_network_arn and not isinstance(core_network_arn, str):
            raise TypeError("Expected argument 'core_network_arn' to be a str")
        pulumi.set(__self__, "core_network_arn", core_network_arn)
        if core_network_attachment_arn and not isinstance(core_network_attachment_arn, str):
            raise TypeError("Expected argument 'core_network_attachment_arn' to be a str")
        pulumi.set(__self__, "core_network_attachment_arn", core_network_attachment_arn)
        if customer_gateway_configuration and not isinstance(customer_gateway_configuration, str):
            raise TypeError("Expected argument 'customer_gateway_configuration' to be a str")
        pulumi.set(__self__, "customer_gateway_configuration", customer_gateway_configuration)
        if customer_gateway_id and not isinstance(customer_gateway_id, str):
            raise TypeError("Expected argument 'customer_gateway_id' to be a str")
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gateway_association_state and not isinstance(gateway_association_state, str):
            raise TypeError("Expected argument 'gateway_association_state' to be a str")
        pulumi.set(__self__, "gateway_association_state", gateway_association_state)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pre_shared_key_arn and not isinstance(pre_shared_key_arn, str):
            raise TypeError("Expected argument 'pre_shared_key_arn' to be a str")
        pulumi.set(__self__, "pre_shared_key_arn", pre_shared_key_arn)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if transit_gateway_id and not isinstance(transit_gateway_id, str):
            raise TypeError("Expected argument 'transit_gateway_id' to be a str")
        pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vgw_telemetries and not isinstance(vgw_telemetries, list):
            raise TypeError("Expected argument 'vgw_telemetries' to be a list")
        pulumi.set(__self__, "vgw_telemetries", vgw_telemetries)
        if vpn_connection_id and not isinstance(vpn_connection_id, str):
            raise TypeError("Expected argument 'vpn_connection_id' to be a str")
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        if vpn_gateway_id and not isinstance(vpn_gateway_id, str):
            raise TypeError("Expected argument 'vpn_gateway_id' to be a str")
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        Category of the VPN connection. A value of VPN indicates an AWS VPN connection. A value of VPN-Classic indicates an AWS Classic VPN connection.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> _builtins.str:
        """
        ARN of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @_builtins.property
    @pulumi.getter(name="coreNetworkAttachmentArn")
    def core_network_attachment_arn(self) -> _builtins.str:
        """
        ARN of the core network attachment.
        """
        return pulumi.get(self, "core_network_attachment_arn")

    @_builtins.property
    @pulumi.getter(name="customerGatewayConfiguration")
    def customer_gateway_configuration(self) -> _builtins.str:
        """
        Configuration information for the VPN connection's customer gateway (in the native XML format).
        """
        return pulumi.get(self, "customer_gateway_configuration")

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> _builtins.str:
        """
        ID of the customer gateway at your end of the VPN connection.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpnConnectionFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="gatewayAssociationState")
    def gateway_association_state(self) -> _builtins.str:
        """
        Current state of the gateway association.
        """
        return pulumi.get(self, "gateway_association_state")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="preSharedKeyArn")
    def pre_shared_key_arn(self) -> _builtins.str:
        """
        (ARN) of the Secrets Manager secret storing the pre-shared key(s) for the VPN connection.
        """
        return pulumi.get(self, "pre_shared_key_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetVpnConnectionRouteResult']:
        """
        List of static routes associated with the VPN connection.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Current state of the VPN connection.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags associated to the VPN Connection.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> _builtins.str:
        """
        ID of a transit gateway associated with the VPN connection.
        """
        return pulumi.get(self, "transit_gateway_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of VPN connection. Currently the only supported type is ipsec.1.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vgwTelemetries")
    def vgw_telemetries(self) -> Sequence['outputs.GetVpnConnectionVgwTelemetryResult']:
        """
        List of objects containing information about the VPN tunnel.
        """
        return pulumi.get(self, "vgw_telemetries")

    @_builtins.property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> _builtins.str:
        return pulumi.get(self, "vpn_connection_id")

    @_builtins.property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> _builtins.str:
        """
        ID of a virtual private gateway associated with the VPN connection.
        """
        return pulumi.get(self, "vpn_gateway_id")


class AwaitableGetVpnConnectionResult(GetVpnConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpnConnectionResult(
            category=self.category,
            core_network_arn=self.core_network_arn,
            core_network_attachment_arn=self.core_network_attachment_arn,
            customer_gateway_configuration=self.customer_gateway_configuration,
            customer_gateway_id=self.customer_gateway_id,
            filters=self.filters,
            gateway_association_state=self.gateway_association_state,
            id=self.id,
            pre_shared_key_arn=self.pre_shared_key_arn,
            region=self.region,
            routes=self.routes,
            state=self.state,
            tags=self.tags,
            transit_gateway_id=self.transit_gateway_id,
            type=self.type,
            vgw_telemetries=self.vgw_telemetries,
            vpn_connection_id=self.vpn_connection_id,
            vpn_gateway_id=self.vpn_gateway_id)


def get_vpn_connection(filters: Optional[Sequence[Union['GetVpnConnectionFilterArgs', 'GetVpnConnectionFilterArgsDict']]] = None,
                       region: Optional[_builtins.str] = None,
                       vpn_connection_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpnConnectionResult:
    """
    Fetches details of a Site-to-Site VPN connection. A Site-to-Site VPN connection is an Internet Protocol security (IPsec) VPN connection between a VPC and an on-premises network.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpn_connection(filters=[{
        "name": "customer-gateway-id",
        "values": ["cgw-1234567890"],
    }])
    pulumi.export("vpnConnectionId", example.vpn_connection_id)
    ```

    ### Find by VPN Connection ID

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpn_connection(vpn_connection_id="vpn-abcd1234567890")
    pulumi.export("gatewayAssociationState", example.gateway_association_state)
    ```


    :param Sequence[Union['GetVpnConnectionFilterArgs', 'GetVpnConnectionFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str vpn_connection_id: Identifier of the EC2 VPN Connection.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['vpnConnectionId'] = vpn_connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getVpnConnection:getVpnConnection', __args__, opts=opts, typ=GetVpnConnectionResult).value

    return AwaitableGetVpnConnectionResult(
        category=pulumi.get(__ret__, 'category'),
        core_network_arn=pulumi.get(__ret__, 'core_network_arn'),
        core_network_attachment_arn=pulumi.get(__ret__, 'core_network_attachment_arn'),
        customer_gateway_configuration=pulumi.get(__ret__, 'customer_gateway_configuration'),
        customer_gateway_id=pulumi.get(__ret__, 'customer_gateway_id'),
        filters=pulumi.get(__ret__, 'filters'),
        gateway_association_state=pulumi.get(__ret__, 'gateway_association_state'),
        id=pulumi.get(__ret__, 'id'),
        pre_shared_key_arn=pulumi.get(__ret__, 'pre_shared_key_arn'),
        region=pulumi.get(__ret__, 'region'),
        routes=pulumi.get(__ret__, 'routes'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'),
        transit_gateway_id=pulumi.get(__ret__, 'transit_gateway_id'),
        type=pulumi.get(__ret__, 'type'),
        vgw_telemetries=pulumi.get(__ret__, 'vgw_telemetries'),
        vpn_connection_id=pulumi.get(__ret__, 'vpn_connection_id'),
        vpn_gateway_id=pulumi.get(__ret__, 'vpn_gateway_id'))
def get_vpn_connection_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpnConnectionFilterArgs', 'GetVpnConnectionFilterArgsDict']]]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              vpn_connection_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpnConnectionResult]:
    """
    Fetches details of a Site-to-Site VPN connection. A Site-to-Site VPN connection is an Internet Protocol security (IPsec) VPN connection between a VPC and an on-premises network.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpn_connection(filters=[{
        "name": "customer-gateway-id",
        "values": ["cgw-1234567890"],
    }])
    pulumi.export("vpnConnectionId", example.vpn_connection_id)
    ```

    ### Find by VPN Connection ID

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpn_connection(vpn_connection_id="vpn-abcd1234567890")
    pulumi.export("gatewayAssociationState", example.gateway_association_state)
    ```


    :param Sequence[Union['GetVpnConnectionFilterArgs', 'GetVpnConnectionFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str vpn_connection_id: Identifier of the EC2 VPN Connection.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['vpnConnectionId'] = vpn_connection_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getVpnConnection:getVpnConnection', __args__, opts=opts, typ=GetVpnConnectionResult)
    return __ret__.apply(lambda __response__: GetVpnConnectionResult(
        category=pulumi.get(__response__, 'category'),
        core_network_arn=pulumi.get(__response__, 'core_network_arn'),
        core_network_attachment_arn=pulumi.get(__response__, 'core_network_attachment_arn'),
        customer_gateway_configuration=pulumi.get(__response__, 'customer_gateway_configuration'),
        customer_gateway_id=pulumi.get(__response__, 'customer_gateway_id'),
        filters=pulumi.get(__response__, 'filters'),
        gateway_association_state=pulumi.get(__response__, 'gateway_association_state'),
        id=pulumi.get(__response__, 'id'),
        pre_shared_key_arn=pulumi.get(__response__, 'pre_shared_key_arn'),
        region=pulumi.get(__response__, 'region'),
        routes=pulumi.get(__response__, 'routes'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags'),
        transit_gateway_id=pulumi.get(__response__, 'transit_gateway_id'),
        type=pulumi.get(__response__, 'type'),
        vgw_telemetries=pulumi.get(__response__, 'vgw_telemetries'),
        vpn_connection_id=pulumi.get(__response__, 'vpn_connection_id'),
        vpn_gateway_id=pulumi.get(__response__, 'vpn_gateway_id')))
