# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkInterfaceAttachmentInitArgs', 'NetworkInterfaceAttachment']

@pulumi.input_type
class NetworkInterfaceAttachmentInitArgs:
    def __init__(__self__, *,
                 device_index: pulumi.Input[_builtins.int],
                 instance_id: pulumi.Input[_builtins.str],
                 network_interface_id: pulumi.Input[_builtins.str],
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkInterfaceAttachment resource.
        :param pulumi.Input[_builtins.int] device_index: Network interface index (int).
        :param pulumi.Input[_builtins.str] instance_id: Instance ID to attach.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID to attach.
        :param pulumi.Input[_builtins.int] network_card_index: Index of the network card. Specify a value greater than 0 when using multiple network cards, which are supported by [some instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#network-cards). The default is 0.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "device_index", device_index)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if network_card_index is not None:
            pulumi.set(__self__, "network_card_index", network_card_index)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="deviceIndex")
    def device_index(self) -> pulumi.Input[_builtins.int]:
        """
        Network interface index (int).
        """
        return pulumi.get(self, "device_index")

    @device_index.setter
    def device_index(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "device_index", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID to attach.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        ENI ID to attach.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Index of the network card. Specify a value greater than 0 when using multiple network cards, which are supported by [some instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#network-cards). The default is 0.
        """
        return pulumi.get(self, "network_card_index")

    @network_card_index.setter
    def network_card_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_card_index", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkInterfaceAttachmentState:
    def __init__(__self__, *,
                 attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 device_index: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkInterfaceAttachment resources.
        :param pulumi.Input[_builtins.str] attachment_id: The ENI Attachment ID.
        :param pulumi.Input[_builtins.int] device_index: Network interface index (int).
        :param pulumi.Input[_builtins.str] instance_id: Instance ID to attach.
        :param pulumi.Input[_builtins.int] network_card_index: Index of the network card. Specify a value greater than 0 when using multiple network cards, which are supported by [some instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#network-cards). The default is 0.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID to attach.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The status of the Network Interface Attachment.
        """
        if attachment_id is not None:
            pulumi.set(__self__, "attachment_id", attachment_id)
        if device_index is not None:
            pulumi.set(__self__, "device_index", device_index)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if network_card_index is not None:
            pulumi.set(__self__, "network_card_index", network_card_index)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ENI Attachment ID.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="deviceIndex")
    def device_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Network interface index (int).
        """
        return pulumi.get(self, "device_index")

    @device_index.setter
    def device_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "device_index", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID to attach.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Index of the network card. Specify a value greater than 0 when using multiple network cards, which are supported by [some instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#network-cards). The default is 0.
        """
        return pulumi.get(self, "network_card_index")

    @network_card_index.setter
    def network_card_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_card_index", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ENI ID to attach.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Network Interface Attachment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment")
class NetworkInterfaceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_index: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Attach an Elastic network interface (ENI) resource with EC2 instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ec2.NetworkInterfaceAttachment("test",
            instance_id=test_aws_instance["id"],
            network_interface_id=test_aws_network_interface["id"],
            device_index=0)
        ```

        ## Import

        Using `pulumi import`, import Elastic network interface (ENI) Attachments using its Attachment ID. For example:

        ```sh
        $ pulumi import aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment secondary_nic eni-attach-0a33842b4ec347c4c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] device_index: Network interface index (int).
        :param pulumi.Input[_builtins.str] instance_id: Instance ID to attach.
        :param pulumi.Input[_builtins.int] network_card_index: Index of the network card. Specify a value greater than 0 when using multiple network cards, which are supported by [some instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#network-cards). The default is 0.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID to attach.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfaceAttachmentInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attach an Elastic network interface (ENI) resource with EC2 instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ec2.NetworkInterfaceAttachment("test",
            instance_id=test_aws_instance["id"],
            network_interface_id=test_aws_network_interface["id"],
            device_index=0)
        ```

        ## Import

        Using `pulumi import`, import Elastic network interface (ENI) Attachments using its Attachment ID. For example:

        ```sh
        $ pulumi import aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment secondary_nic eni-attach-0a33842b4ec347c4c
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInterfaceAttachmentInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfaceAttachmentInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_index: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfaceAttachmentInitArgs.__new__(NetworkInterfaceAttachmentInitArgs)

            if device_index is None and not opts.urn:
                raise TypeError("Missing required property 'device_index'")
            __props__.__dict__["device_index"] = device_index
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["network_card_index"] = network_card_index
            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            __props__.__dict__["region"] = region
            __props__.__dict__["attachment_id"] = None
            __props__.__dict__["status"] = None
        super(NetworkInterfaceAttachment, __self__).__init__(
            'aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            device_index: Optional[pulumi.Input[_builtins.int]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkInterfaceAttachment':
        """
        Get an existing NetworkInterfaceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attachment_id: The ENI Attachment ID.
        :param pulumi.Input[_builtins.int] device_index: Network interface index (int).
        :param pulumi.Input[_builtins.str] instance_id: Instance ID to attach.
        :param pulumi.Input[_builtins.int] network_card_index: Index of the network card. Specify a value greater than 0 when using multiple network cards, which are supported by [some instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#network-cards). The default is 0.
        :param pulumi.Input[_builtins.str] network_interface_id: ENI ID to attach.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The status of the Network Interface Attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInterfaceAttachmentState.__new__(_NetworkInterfaceAttachmentState)

        __props__.__dict__["attachment_id"] = attachment_id
        __props__.__dict__["device_index"] = device_index
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["network_card_index"] = network_card_index
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return NetworkInterfaceAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ENI Attachment ID.
        """
        return pulumi.get(self, "attachment_id")

    @_builtins.property
    @pulumi.getter(name="deviceIndex")
    def device_index(self) -> pulumi.Output[_builtins.int]:
        """
        Network interface index (int).
        """
        return pulumi.get(self, "device_index")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID to attach.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> pulumi.Output[_builtins.int]:
        """
        Index of the network card. Specify a value greater than 0 when using multiple network cards, which are supported by [some instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#network-cards). The default is 0.
        """
        return pulumi.get(self, "network_card_index")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        ENI ID to attach.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Network Interface Attachment.
        """
        return pulumi.get(self, "status")

