# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrafficMirrorFilterRuleArgs', 'TrafficMirrorFilterRule']

@pulumi.input_type
class TrafficMirrorFilterRuleArgs:
    def __init__(__self__, *,
                 destination_cidr_block: pulumi.Input[_builtins.str],
                 rule_action: pulumi.Input[_builtins.str],
                 rule_number: pulumi.Input[_builtins.int],
                 source_cidr_block: pulumi.Input[_builtins.str],
                 traffic_direction: pulumi.Input[_builtins.str],
                 traffic_mirror_filter_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs']] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs']] = None):
        """
        The set of arguments for constructing a TrafficMirrorFilterRule resource.
        :param pulumi.Input[_builtins.str] destination_cidr_block: Destination CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input[_builtins.str] rule_action: Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
        :param pulumi.Input[_builtins.int] rule_number: Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        :param pulumi.Input[_builtins.str] source_cidr_block: Source CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input[_builtins.str] traffic_direction: Direction of traffic to be captured. Valid values are `ingress` and `egress`
               
               Traffic mirror port range support following attributes:
        :param pulumi.Input[_builtins.str] traffic_mirror_filter_id: ID of the traffic mirror filter to which this rule should be added
        :param pulumi.Input[_builtins.str] description: Description of the traffic mirror filter rule.
        :param pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs'] destination_port_range: Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        :param pulumi.Input[_builtins.int] protocol: Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs'] source_port_range: Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        """
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "rule_action", rule_action)
        pulumi.set(__self__, "rule_number", rule_number)
        pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        pulumi.set(__self__, "traffic_direction", traffic_direction)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Input[_builtins.str]:
        """
        Destination CIDR block to assign to the Traffic Mirror rule.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Input[_builtins.str]:
        """
        Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_action", value)

    @_builtins.property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> pulumi.Input[_builtins.int]:
        """
        Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        """
        return pulumi.get(self, "rule_number")

    @rule_number.setter
    def rule_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "rule_number", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> pulumi.Input[_builtins.str]:
        """
        Source CIDR block to assign to the Traffic Mirror rule.
        """
        return pulumi.get(self, "source_cidr_block")

    @source_cidr_block.setter
    def source_cidr_block(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="trafficDirection")
    def traffic_direction(self) -> pulumi.Input[_builtins.str]:
        """
        Direction of traffic to be captured. Valid values are `ingress` and `egress`

        Traffic mirror port range support following attributes:
        """
        return pulumi.get(self, "traffic_direction")

    @traffic_direction.setter
    def traffic_direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "traffic_direction", value)

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the traffic mirror filter to which this rule should be added
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @traffic_mirror_filter_id.setter
    def traffic_mirror_filter_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "traffic_mirror_filter_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the traffic mirror filter rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs']]:
        """
        Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs']]):
        pulumi.set(self, "destination_port_range", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs']]:
        """
        Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs']]):
        pulumi.set(self, "source_port_range", value)


@pulumi.input_type
class _TrafficMirrorFilterRuleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs']] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_number: Optional[pulumi.Input[_builtins.int]] = None,
                 source_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs']] = None,
                 traffic_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_mirror_filter_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrafficMirrorFilterRule resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the traffic mirror filter rule.
        :param pulumi.Input[_builtins.str] description: Description of the traffic mirror filter rule.
        :param pulumi.Input[_builtins.str] destination_cidr_block: Destination CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs'] destination_port_range: Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        :param pulumi.Input[_builtins.int] protocol: Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] rule_action: Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
        :param pulumi.Input[_builtins.int] rule_number: Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        :param pulumi.Input[_builtins.str] source_cidr_block: Source CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs'] source_port_range: Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        :param pulumi.Input[_builtins.str] traffic_direction: Direction of traffic to be captured. Valid values are `ingress` and `egress`
               
               Traffic mirror port range support following attributes:
        :param pulumi.Input[_builtins.str] traffic_mirror_filter_id: ID of the traffic mirror filter to which this rule should be added
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_action is not None:
            pulumi.set(__self__, "rule_action", rule_action)
        if rule_number is not None:
            pulumi.set(__self__, "rule_number", rule_number)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_direction is not None:
            pulumi.set(__self__, "traffic_direction", traffic_direction)
        if traffic_mirror_filter_id is not None:
            pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the traffic mirror filter rule.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the traffic mirror filter rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination CIDR block to assign to the Traffic Mirror rule.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs']]:
        """
        Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input['TrafficMirrorFilterRuleDestinationPortRangeArgs']]):
        pulumi.set(self, "destination_port_range", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_action", value)

    @_builtins.property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        """
        return pulumi.get(self, "rule_number")

    @rule_number.setter
    def rule_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_number", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source CIDR block to assign to the Traffic Mirror rule.
        """
        return pulumi.get(self, "source_cidr_block")

    @source_cidr_block.setter
    def source_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs']]:
        """
        Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input['TrafficMirrorFilterRuleSourcePortRangeArgs']]):
        pulumi.set(self, "source_port_range", value)

    @_builtins.property
    @pulumi.getter(name="trafficDirection")
    def traffic_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Direction of traffic to be captured. Valid values are `ingress` and `egress`

        Traffic mirror port range support following attributes:
        """
        return pulumi.get(self, "traffic_direction")

    @traffic_direction.setter
    def traffic_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_direction", value)

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the traffic mirror filter to which this rule should be added
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @traffic_mirror_filter_id.setter
    def traffic_mirror_filter_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_mirror_filter_id", value)


@pulumi.type_token("aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule")
class TrafficMirrorFilterRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[Union['TrafficMirrorFilterRuleDestinationPortRangeArgs', 'TrafficMirrorFilterRuleDestinationPortRangeArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_number: Optional[pulumi.Input[_builtins.int]] = None,
                 source_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[Union['TrafficMirrorFilterRuleSourcePortRangeArgs', 'TrafficMirrorFilterRuleSourcePortRangeArgsDict']]] = None,
                 traffic_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_mirror_filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Traffic mirror filter rule.\\
        Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring

        ## Example Usage

        To create a basic traffic mirror session

        ```python
        import pulumi
        import pulumi_aws as aws

        filter = aws.ec2.TrafficMirrorFilter("filter",
            description="traffic mirror filter - example",
            network_services=["amazon-dns"])
        ruleout = aws.ec2.TrafficMirrorFilterRule("ruleout",
            description="test rule",
            traffic_mirror_filter_id=filter.id,
            destination_cidr_block="10.0.0.0/8",
            source_cidr_block="10.0.0.0/8",
            rule_number=1,
            rule_action="accept",
            traffic_direction="egress")
        rulein = aws.ec2.TrafficMirrorFilterRule("rulein",
            description="test rule",
            traffic_mirror_filter_id=filter.id,
            destination_cidr_block="10.0.0.0/8",
            source_cidr_block="10.0.0.0/8",
            rule_number=1,
            rule_action="accept",
            traffic_direction="ingress",
            protocol=6,
            destination_port_range={
                "from_port": 22,
                "to_port": 53,
            },
            source_port_range={
                "from_port": 0,
                "to_port": 10,
            })
        ```

        ## Import

        Using `pulumi import`, import traffic mirror rules using the `traffic_mirror_filter_id` and `id` separated by `:`. For example:

        ```sh
        $ pulumi import aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule rule tmf-0fbb93ddf38198f64:tmfr-05a458f06445d0aee
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the traffic mirror filter rule.
        :param pulumi.Input[_builtins.str] destination_cidr_block: Destination CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input[Union['TrafficMirrorFilterRuleDestinationPortRangeArgs', 'TrafficMirrorFilterRuleDestinationPortRangeArgsDict']] destination_port_range: Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        :param pulumi.Input[_builtins.int] protocol: Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] rule_action: Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
        :param pulumi.Input[_builtins.int] rule_number: Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        :param pulumi.Input[_builtins.str] source_cidr_block: Source CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input[Union['TrafficMirrorFilterRuleSourcePortRangeArgs', 'TrafficMirrorFilterRuleSourcePortRangeArgsDict']] source_port_range: Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        :param pulumi.Input[_builtins.str] traffic_direction: Direction of traffic to be captured. Valid values are `ingress` and `egress`
               
               Traffic mirror port range support following attributes:
        :param pulumi.Input[_builtins.str] traffic_mirror_filter_id: ID of the traffic mirror filter to which this rule should be added
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficMirrorFilterRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Traffic mirror filter rule.\\
        Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring

        ## Example Usage

        To create a basic traffic mirror session

        ```python
        import pulumi
        import pulumi_aws as aws

        filter = aws.ec2.TrafficMirrorFilter("filter",
            description="traffic mirror filter - example",
            network_services=["amazon-dns"])
        ruleout = aws.ec2.TrafficMirrorFilterRule("ruleout",
            description="test rule",
            traffic_mirror_filter_id=filter.id,
            destination_cidr_block="10.0.0.0/8",
            source_cidr_block="10.0.0.0/8",
            rule_number=1,
            rule_action="accept",
            traffic_direction="egress")
        rulein = aws.ec2.TrafficMirrorFilterRule("rulein",
            description="test rule",
            traffic_mirror_filter_id=filter.id,
            destination_cidr_block="10.0.0.0/8",
            source_cidr_block="10.0.0.0/8",
            rule_number=1,
            rule_action="accept",
            traffic_direction="ingress",
            protocol=6,
            destination_port_range={
                "from_port": 22,
                "to_port": 53,
            },
            source_port_range={
                "from_port": 0,
                "to_port": 10,
            })
        ```

        ## Import

        Using `pulumi import`, import traffic mirror rules using the `traffic_mirror_filter_id` and `id` separated by `:`. For example:

        ```sh
        $ pulumi import aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule rule tmf-0fbb93ddf38198f64:tmfr-05a458f06445d0aee
        ```

        :param str resource_name: The name of the resource.
        :param TrafficMirrorFilterRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficMirrorFilterRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port_range: Optional[pulumi.Input[Union['TrafficMirrorFilterRuleDestinationPortRangeArgs', 'TrafficMirrorFilterRuleDestinationPortRangeArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_action: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_number: Optional[pulumi.Input[_builtins.int]] = None,
                 source_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port_range: Optional[pulumi.Input[Union['TrafficMirrorFilterRuleSourcePortRangeArgs', 'TrafficMirrorFilterRuleSourcePortRangeArgsDict']]] = None,
                 traffic_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 traffic_mirror_filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficMirrorFilterRuleArgs.__new__(TrafficMirrorFilterRuleArgs)

            __props__.__dict__["description"] = description
            if destination_cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'destination_cidr_block'")
            __props__.__dict__["destination_cidr_block"] = destination_cidr_block
            __props__.__dict__["destination_port_range"] = destination_port_range
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            if rule_action is None and not opts.urn:
                raise TypeError("Missing required property 'rule_action'")
            __props__.__dict__["rule_action"] = rule_action
            if rule_number is None and not opts.urn:
                raise TypeError("Missing required property 'rule_number'")
            __props__.__dict__["rule_number"] = rule_number
            if source_cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'source_cidr_block'")
            __props__.__dict__["source_cidr_block"] = source_cidr_block
            __props__.__dict__["source_port_range"] = source_port_range
            if traffic_direction is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_direction'")
            __props__.__dict__["traffic_direction"] = traffic_direction
            if traffic_mirror_filter_id is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_mirror_filter_id'")
            __props__.__dict__["traffic_mirror_filter_id"] = traffic_mirror_filter_id
            __props__.__dict__["arn"] = None
        super(TrafficMirrorFilterRule, __self__).__init__(
            'aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            destination_port_range: Optional[pulumi.Input[Union['TrafficMirrorFilterRuleDestinationPortRangeArgs', 'TrafficMirrorFilterRuleDestinationPortRangeArgsDict']]] = None,
            protocol: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rule_action: Optional[pulumi.Input[_builtins.str]] = None,
            rule_number: Optional[pulumi.Input[_builtins.int]] = None,
            source_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            source_port_range: Optional[pulumi.Input[Union['TrafficMirrorFilterRuleSourcePortRangeArgs', 'TrafficMirrorFilterRuleSourcePortRangeArgsDict']]] = None,
            traffic_direction: Optional[pulumi.Input[_builtins.str]] = None,
            traffic_mirror_filter_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrafficMirrorFilterRule':
        """
        Get an existing TrafficMirrorFilterRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the traffic mirror filter rule.
        :param pulumi.Input[_builtins.str] description: Description of the traffic mirror filter rule.
        :param pulumi.Input[_builtins.str] destination_cidr_block: Destination CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input[Union['TrafficMirrorFilterRuleDestinationPortRangeArgs', 'TrafficMirrorFilterRuleDestinationPortRangeArgsDict']] destination_port_range: Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        :param pulumi.Input[_builtins.int] protocol: Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] rule_action: Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
        :param pulumi.Input[_builtins.int] rule_number: Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        :param pulumi.Input[_builtins.str] source_cidr_block: Source CIDR block to assign to the Traffic Mirror rule.
        :param pulumi.Input[Union['TrafficMirrorFilterRuleSourcePortRangeArgs', 'TrafficMirrorFilterRuleSourcePortRangeArgsDict']] source_port_range: Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        :param pulumi.Input[_builtins.str] traffic_direction: Direction of traffic to be captured. Valid values are `ingress` and `egress`
               
               Traffic mirror port range support following attributes:
        :param pulumi.Input[_builtins.str] traffic_mirror_filter_id: ID of the traffic mirror filter to which this rule should be added
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficMirrorFilterRuleState.__new__(_TrafficMirrorFilterRuleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_cidr_block"] = destination_cidr_block
        __props__.__dict__["destination_port_range"] = destination_port_range
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["rule_action"] = rule_action
        __props__.__dict__["rule_number"] = rule_number
        __props__.__dict__["source_cidr_block"] = source_cidr_block
        __props__.__dict__["source_port_range"] = source_port_range
        __props__.__dict__["traffic_direction"] = traffic_direction
        __props__.__dict__["traffic_mirror_filter_id"] = traffic_mirror_filter_id
        return TrafficMirrorFilterRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the traffic mirror filter rule.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the traffic mirror filter rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        Destination CIDR block to assign to the Traffic Mirror rule.
        """
        return pulumi.get(self, "destination_cidr_block")

    @_builtins.property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> pulumi.Output[Optional['outputs.TrafficMirrorFilterRuleDestinationPortRange']]:
        """
        Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        """
        return pulumi.get(self, "destination_port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Output[_builtins.str]:
        """
        Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
        """
        return pulumi.get(self, "rule_action")

    @_builtins.property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> pulumi.Output[_builtins.int]:
        """
        Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        """
        return pulumi.get(self, "rule_number")

    @_builtins.property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        Source CIDR block to assign to the Traffic Mirror rule.
        """
        return pulumi.get(self, "source_cidr_block")

    @_builtins.property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> pulumi.Output[Optional['outputs.TrafficMirrorFilterRuleSourcePortRange']]:
        """
        Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
        """
        return pulumi.get(self, "source_port_range")

    @_builtins.property
    @pulumi.getter(name="trafficDirection")
    def traffic_direction(self) -> pulumi.Output[_builtins.str]:
        """
        Direction of traffic to be captured. Valid values are `ingress` and `egress`

        Traffic mirror port range support following attributes:
        """
        return pulumi.get(self, "traffic_direction")

    @_builtins.property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the traffic mirror filter to which this rule should be added
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

