# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 authentication_options: pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]],
                 connection_log_options: pulumi.Input['EndpointConnectionLogOptionsArgs'],
                 server_certificate_arn: pulumi.Input[_builtins.str],
                 client_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connect_options: Optional[pulumi.Input['EndpointClientConnectOptionsArgs']] = None,
                 client_login_banner_options: Optional[pulumi.Input['EndpointClientLoginBannerOptionsArgs']] = None,
                 client_route_enforcement_options: Optional[pulumi.Input['EndpointClientRouteEnforcementOptionsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_on_session_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 endpoint_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 self_service_portal: Optional[pulumi.Input[_builtins.str]] = None,
                 session_timeout_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 split_tunnel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transport_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]] authentication_options: Information about the authentication method to be used to authenticate clients.
        :param pulumi.Input['EndpointConnectionLogOptionsArgs'] connection_log_options: Information about the client connection logging options.
        :param pulumi.Input[_builtins.str] server_certificate_arn: The ARN of the ACM server certificate.
        :param pulumi.Input[_builtins.str] client_cidr_block: The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater. When `traffic_ip_address_type` is set to `ipv6`, it must not be specified. Otherwise, it is required.
        :param pulumi.Input['EndpointClientConnectOptionsArgs'] client_connect_options: The options for managing connection authorization for new client connections.
        :param pulumi.Input['EndpointClientLoginBannerOptionsArgs'] client_login_banner_options: Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        :param pulumi.Input['EndpointClientRouteEnforcementOptionsArgs'] client_route_enforcement_options: Options for enforce administrator defined routes on devices connected through the VPN.
        :param pulumi.Input[_builtins.str] description: A brief description of the Client VPN endpoint.
        :param pulumi.Input[_builtins.bool] disconnect_on_session_timeout: Indicates whether the client VPN session is disconnected after the maximum `session_timeout_hours` is reached. If `true`, users are prompted to reconnect client VPN. If `false`, client VPN attempts to reconnect automatically. The default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
        :param pulumi.Input[_builtins.str] endpoint_ip_address_type: IP address type for the Client VPN endpoint. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
        :param pulumi.Input[_builtins.str] self_service_portal: Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
        :param pulumi.Input[_builtins.int] session_timeout_hours: The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
        :param pulumi.Input[_builtins.bool] split_tunnel: Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] traffic_ip_address_type: IP address type for traffic within the Client VPN tunnel. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`. When it is set to `ipv6`, `client_cidr_block` must not be specified.
        :param pulumi.Input[_builtins.str] transport_protocol: The transport protocol to be used by the VPN session. Default value is `udp`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
        :param pulumi.Input[_builtins.int] vpn_port: The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
        """
        pulumi.set(__self__, "authentication_options", authentication_options)
        pulumi.set(__self__, "connection_log_options", connection_log_options)
        pulumi.set(__self__, "server_certificate_arn", server_certificate_arn)
        if client_cidr_block is not None:
            pulumi.set(__self__, "client_cidr_block", client_cidr_block)
        if client_connect_options is not None:
            pulumi.set(__self__, "client_connect_options", client_connect_options)
        if client_login_banner_options is not None:
            pulumi.set(__self__, "client_login_banner_options", client_login_banner_options)
        if client_route_enforcement_options is not None:
            pulumi.set(__self__, "client_route_enforcement_options", client_route_enforcement_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disconnect_on_session_timeout is not None:
            pulumi.set(__self__, "disconnect_on_session_timeout", disconnect_on_session_timeout)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if endpoint_ip_address_type is not None:
            pulumi.set(__self__, "endpoint_ip_address_type", endpoint_ip_address_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if self_service_portal is not None:
            pulumi.set(__self__, "self_service_portal", self_service_portal)
        if session_timeout_hours is not None:
            pulumi.set(__self__, "session_timeout_hours", session_timeout_hours)
        if split_tunnel is not None:
            pulumi.set(__self__, "split_tunnel", split_tunnel)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_ip_address_type is not None:
            pulumi.set(__self__, "traffic_ip_address_type", traffic_ip_address_type)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpn_port is not None:
            pulumi.set(__self__, "vpn_port", vpn_port)

    @_builtins.property
    @pulumi.getter(name="authenticationOptions")
    def authentication_options(self) -> pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]]:
        """
        Information about the authentication method to be used to authenticate clients.
        """
        return pulumi.get(self, "authentication_options")

    @authentication_options.setter
    def authentication_options(self, value: pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]]):
        pulumi.set(self, "authentication_options", value)

    @_builtins.property
    @pulumi.getter(name="connectionLogOptions")
    def connection_log_options(self) -> pulumi.Input['EndpointConnectionLogOptionsArgs']:
        """
        Information about the client connection logging options.
        """
        return pulumi.get(self, "connection_log_options")

    @connection_log_options.setter
    def connection_log_options(self, value: pulumi.Input['EndpointConnectionLogOptionsArgs']):
        pulumi.set(self, "connection_log_options", value)

    @_builtins.property
    @pulumi.getter(name="serverCertificateArn")
    def server_certificate_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the ACM server certificate.
        """
        return pulumi.get(self, "server_certificate_arn")

    @server_certificate_arn.setter
    def server_certificate_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="clientCidrBlock")
    def client_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater. When `traffic_ip_address_type` is set to `ipv6`, it must not be specified. Otherwise, it is required.
        """
        return pulumi.get(self, "client_cidr_block")

    @client_cidr_block.setter
    def client_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="clientConnectOptions")
    def client_connect_options(self) -> Optional[pulumi.Input['EndpointClientConnectOptionsArgs']]:
        """
        The options for managing connection authorization for new client connections.
        """
        return pulumi.get(self, "client_connect_options")

    @client_connect_options.setter
    def client_connect_options(self, value: Optional[pulumi.Input['EndpointClientConnectOptionsArgs']]):
        pulumi.set(self, "client_connect_options", value)

    @_builtins.property
    @pulumi.getter(name="clientLoginBannerOptions")
    def client_login_banner_options(self) -> Optional[pulumi.Input['EndpointClientLoginBannerOptionsArgs']]:
        """
        Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        """
        return pulumi.get(self, "client_login_banner_options")

    @client_login_banner_options.setter
    def client_login_banner_options(self, value: Optional[pulumi.Input['EndpointClientLoginBannerOptionsArgs']]):
        pulumi.set(self, "client_login_banner_options", value)

    @_builtins.property
    @pulumi.getter(name="clientRouteEnforcementOptions")
    def client_route_enforcement_options(self) -> Optional[pulumi.Input['EndpointClientRouteEnforcementOptionsArgs']]:
        """
        Options for enforce administrator defined routes on devices connected through the VPN.
        """
        return pulumi.get(self, "client_route_enforcement_options")

    @client_route_enforcement_options.setter
    def client_route_enforcement_options(self, value: Optional[pulumi.Input['EndpointClientRouteEnforcementOptionsArgs']]):
        pulumi.set(self, "client_route_enforcement_options", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description of the Client VPN endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disconnectOnSessionTimeout")
    def disconnect_on_session_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the client VPN session is disconnected after the maximum `session_timeout_hours` is reached. If `true`, users are prompted to reconnect client VPN. If `false`, client VPN attempts to reconnect automatically. The default value is `false`.
        """
        return pulumi.get(self, "disconnect_on_session_timeout")

    @disconnect_on_session_timeout.setter
    def disconnect_on_session_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disconnect_on_session_timeout", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="endpointIpAddressType")
    def endpoint_ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address type for the Client VPN endpoint. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`.
        """
        return pulumi.get(self, "endpoint_ip_address_type")

    @endpoint_ip_address_type.setter
    def endpoint_ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_ip_address_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="selfServicePortal")
    def self_service_portal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
        """
        return pulumi.get(self, "self_service_portal")

    @self_service_portal.setter
    def self_service_portal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_service_portal", value)

    @_builtins.property
    @pulumi.getter(name="sessionTimeoutHours")
    def session_timeout_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
        """
        return pulumi.get(self, "session_timeout_hours")

    @session_timeout_hours.setter
    def session_timeout_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_timeout_hours", value)

    @_builtins.property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
        """
        return pulumi.get(self, "split_tunnel")

    @split_tunnel.setter
    def split_tunnel(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "split_tunnel", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trafficIpAddressType")
    def traffic_ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address type for traffic within the Client VPN tunnel. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`. When it is set to `ipv6`, `client_cidr_block` must not be specified.
        """
        return pulumi.get(self, "traffic_ip_address_type")

    @traffic_ip_address_type.setter
    def traffic_ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The transport protocol to be used by the VPN session. Default value is `udp`.
        """
        return pulumi.get(self, "transport_protocol")

    @transport_protocol.setter
    def transport_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transport_protocol", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnPort")
    def vpn_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
        """
        return pulumi.get(self, "vpn_port")

    @vpn_port.setter
    def vpn_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpn_port", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_options: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]]] = None,
                 client_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connect_options: Optional[pulumi.Input['EndpointClientConnectOptionsArgs']] = None,
                 client_login_banner_options: Optional[pulumi.Input['EndpointClientLoginBannerOptionsArgs']] = None,
                 client_route_enforcement_options: Optional[pulumi.Input['EndpointClientRouteEnforcementOptionsArgs']] = None,
                 connection_log_options: Optional[pulumi.Input['EndpointConnectionLogOptionsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_on_session_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 endpoint_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 self_service_portal: Optional[pulumi.Input[_builtins.str]] = None,
                 self_service_portal_url: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 session_timeout_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 split_tunnel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transport_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the Client VPN endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]] authentication_options: Information about the authentication method to be used to authenticate clients.
        :param pulumi.Input[_builtins.str] client_cidr_block: The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater. When `traffic_ip_address_type` is set to `ipv6`, it must not be specified. Otherwise, it is required.
        :param pulumi.Input['EndpointClientConnectOptionsArgs'] client_connect_options: The options for managing connection authorization for new client connections.
        :param pulumi.Input['EndpointClientLoginBannerOptionsArgs'] client_login_banner_options: Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        :param pulumi.Input['EndpointClientRouteEnforcementOptionsArgs'] client_route_enforcement_options: Options for enforce administrator defined routes on devices connected through the VPN.
        :param pulumi.Input['EndpointConnectionLogOptionsArgs'] connection_log_options: Information about the client connection logging options.
        :param pulumi.Input[_builtins.str] description: A brief description of the Client VPN endpoint.
        :param pulumi.Input[_builtins.bool] disconnect_on_session_timeout: Indicates whether the client VPN session is disconnected after the maximum `session_timeout_hours` is reached. If `true`, users are prompted to reconnect client VPN. If `false`, client VPN attempts to reconnect automatically. The default value is `false`.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name to be used by clients when establishing their VPN session.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
        :param pulumi.Input[_builtins.str] endpoint_ip_address_type: IP address type for the Client VPN endpoint. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
        :param pulumi.Input[_builtins.str] self_service_portal: Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
        :param pulumi.Input[_builtins.str] self_service_portal_url: The URL of the self-service portal.
        :param pulumi.Input[_builtins.str] server_certificate_arn: The ARN of the ACM server certificate.
        :param pulumi.Input[_builtins.int] session_timeout_hours: The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
        :param pulumi.Input[_builtins.bool] split_tunnel: Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] traffic_ip_address_type: IP address type for traffic within the Client VPN tunnel. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`. When it is set to `ipv6`, `client_cidr_block` must not be specified.
        :param pulumi.Input[_builtins.str] transport_protocol: The transport protocol to be used by the VPN session. Default value is `udp`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
        :param pulumi.Input[_builtins.int] vpn_port: The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if authentication_options is not None:
            pulumi.set(__self__, "authentication_options", authentication_options)
        if client_cidr_block is not None:
            pulumi.set(__self__, "client_cidr_block", client_cidr_block)
        if client_connect_options is not None:
            pulumi.set(__self__, "client_connect_options", client_connect_options)
        if client_login_banner_options is not None:
            pulumi.set(__self__, "client_login_banner_options", client_login_banner_options)
        if client_route_enforcement_options is not None:
            pulumi.set(__self__, "client_route_enforcement_options", client_route_enforcement_options)
        if connection_log_options is not None:
            pulumi.set(__self__, "connection_log_options", connection_log_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disconnect_on_session_timeout is not None:
            pulumi.set(__self__, "disconnect_on_session_timeout", disconnect_on_session_timeout)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if endpoint_ip_address_type is not None:
            pulumi.set(__self__, "endpoint_ip_address_type", endpoint_ip_address_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if self_service_portal is not None:
            pulumi.set(__self__, "self_service_portal", self_service_portal)
        if self_service_portal_url is not None:
            pulumi.set(__self__, "self_service_portal_url", self_service_portal_url)
        if server_certificate_arn is not None:
            pulumi.set(__self__, "server_certificate_arn", server_certificate_arn)
        if session_timeout_hours is not None:
            pulumi.set(__self__, "session_timeout_hours", session_timeout_hours)
        if split_tunnel is not None:
            pulumi.set(__self__, "split_tunnel", split_tunnel)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if traffic_ip_address_type is not None:
            pulumi.set(__self__, "traffic_ip_address_type", traffic_ip_address_type)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpn_port is not None:
            pulumi.set(__self__, "vpn_port", vpn_port)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the Client VPN endpoint.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="authenticationOptions")
    def authentication_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]]]:
        """
        Information about the authentication method to be used to authenticate clients.
        """
        return pulumi.get(self, "authentication_options")

    @authentication_options.setter
    def authentication_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAuthenticationOptionArgs']]]]):
        pulumi.set(self, "authentication_options", value)

    @_builtins.property
    @pulumi.getter(name="clientCidrBlock")
    def client_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater. When `traffic_ip_address_type` is set to `ipv6`, it must not be specified. Otherwise, it is required.
        """
        return pulumi.get(self, "client_cidr_block")

    @client_cidr_block.setter
    def client_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="clientConnectOptions")
    def client_connect_options(self) -> Optional[pulumi.Input['EndpointClientConnectOptionsArgs']]:
        """
        The options for managing connection authorization for new client connections.
        """
        return pulumi.get(self, "client_connect_options")

    @client_connect_options.setter
    def client_connect_options(self, value: Optional[pulumi.Input['EndpointClientConnectOptionsArgs']]):
        pulumi.set(self, "client_connect_options", value)

    @_builtins.property
    @pulumi.getter(name="clientLoginBannerOptions")
    def client_login_banner_options(self) -> Optional[pulumi.Input['EndpointClientLoginBannerOptionsArgs']]:
        """
        Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        """
        return pulumi.get(self, "client_login_banner_options")

    @client_login_banner_options.setter
    def client_login_banner_options(self, value: Optional[pulumi.Input['EndpointClientLoginBannerOptionsArgs']]):
        pulumi.set(self, "client_login_banner_options", value)

    @_builtins.property
    @pulumi.getter(name="clientRouteEnforcementOptions")
    def client_route_enforcement_options(self) -> Optional[pulumi.Input['EndpointClientRouteEnforcementOptionsArgs']]:
        """
        Options for enforce administrator defined routes on devices connected through the VPN.
        """
        return pulumi.get(self, "client_route_enforcement_options")

    @client_route_enforcement_options.setter
    def client_route_enforcement_options(self, value: Optional[pulumi.Input['EndpointClientRouteEnforcementOptionsArgs']]):
        pulumi.set(self, "client_route_enforcement_options", value)

    @_builtins.property
    @pulumi.getter(name="connectionLogOptions")
    def connection_log_options(self) -> Optional[pulumi.Input['EndpointConnectionLogOptionsArgs']]:
        """
        Information about the client connection logging options.
        """
        return pulumi.get(self, "connection_log_options")

    @connection_log_options.setter
    def connection_log_options(self, value: Optional[pulumi.Input['EndpointConnectionLogOptionsArgs']]):
        pulumi.set(self, "connection_log_options", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description of the Client VPN endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disconnectOnSessionTimeout")
    def disconnect_on_session_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the client VPN session is disconnected after the maximum `session_timeout_hours` is reached. If `true`, users are prompted to reconnect client VPN. If `false`, client VPN attempts to reconnect automatically. The default value is `false`.
        """
        return pulumi.get(self, "disconnect_on_session_timeout")

    @disconnect_on_session_timeout.setter
    def disconnect_on_session_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disconnect_on_session_timeout", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS name to be used by clients when establishing their VPN session.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="endpointIpAddressType")
    def endpoint_ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address type for the Client VPN endpoint. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`.
        """
        return pulumi.get(self, "endpoint_ip_address_type")

    @endpoint_ip_address_type.setter
    def endpoint_ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_ip_address_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="selfServicePortal")
    def self_service_portal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
        """
        return pulumi.get(self, "self_service_portal")

    @self_service_portal.setter
    def self_service_portal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_service_portal", value)

    @_builtins.property
    @pulumi.getter(name="selfServicePortalUrl")
    def self_service_portal_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the self-service portal.
        """
        return pulumi.get(self, "self_service_portal_url")

    @self_service_portal_url.setter
    def self_service_portal_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_service_portal_url", value)

    @_builtins.property
    @pulumi.getter(name="serverCertificateArn")
    def server_certificate_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the ACM server certificate.
        """
        return pulumi.get(self, "server_certificate_arn")

    @server_certificate_arn.setter
    def server_certificate_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="sessionTimeoutHours")
    def session_timeout_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
        """
        return pulumi.get(self, "session_timeout_hours")

    @session_timeout_hours.setter
    def session_timeout_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_timeout_hours", value)

    @_builtins.property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
        """
        return pulumi.get(self, "split_tunnel")

    @split_tunnel.setter
    def split_tunnel(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "split_tunnel", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="trafficIpAddressType")
    def traffic_ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address type for traffic within the Client VPN tunnel. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`. When it is set to `ipv6`, `client_cidr_block` must not be specified.
        """
        return pulumi.get(self, "traffic_ip_address_type")

    @traffic_ip_address_type.setter
    def traffic_ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "traffic_ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The transport protocol to be used by the VPN session. Default value is `udp`.
        """
        return pulumi.get(self, "transport_protocol")

    @transport_protocol.setter
    def transport_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transport_protocol", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnPort")
    def vpn_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
        """
        return pulumi.get(self, "vpn_port")

    @vpn_port.setter
    def vpn_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpn_port", value)


@pulumi.type_token("aws:ec2clientvpn/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointAuthenticationOptionArgs', 'EndpointAuthenticationOptionArgsDict']]]]] = None,
                 client_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connect_options: Optional[pulumi.Input[Union['EndpointClientConnectOptionsArgs', 'EndpointClientConnectOptionsArgsDict']]] = None,
                 client_login_banner_options: Optional[pulumi.Input[Union['EndpointClientLoginBannerOptionsArgs', 'EndpointClientLoginBannerOptionsArgsDict']]] = None,
                 client_route_enforcement_options: Optional[pulumi.Input[Union['EndpointClientRouteEnforcementOptionsArgs', 'EndpointClientRouteEnforcementOptionsArgsDict']]] = None,
                 connection_log_options: Optional[pulumi.Input[Union['EndpointConnectionLogOptionsArgs', 'EndpointConnectionLogOptionsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_on_session_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 endpoint_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 self_service_portal: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 session_timeout_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 split_tunnel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transport_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides an AWS Client VPN endpoint for OpenVPN clients. For more information on usage, please see the
        [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2clientvpn.Endpoint("example",
            description="clientvpn-example",
            server_certificate_arn=cert["arn"],
            client_cidr_block="10.0.0.0/16",
            authentication_options=[{
                "type": "certificate-authentication",
                "root_certificate_chain_arn": root_cert["arn"],
            }],
            connection_log_options={
                "enabled": True,
                "cloudwatch_log_group": lg["name"],
                "cloudwatch_log_stream": ls["name"],
            })
        ```

        ## Import

        Using `pulumi import`, import AWS Client VPN endpoints using the `id` value found via `aws ec2 describe-client-vpn-endpoints`. For example:

        ```sh
        $ pulumi import aws:ec2clientvpn/endpoint:Endpoint example cvpn-endpoint-0ac3a1abbccddd666
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointAuthenticationOptionArgs', 'EndpointAuthenticationOptionArgsDict']]]] authentication_options: Information about the authentication method to be used to authenticate clients.
        :param pulumi.Input[_builtins.str] client_cidr_block: The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater. When `traffic_ip_address_type` is set to `ipv6`, it must not be specified. Otherwise, it is required.
        :param pulumi.Input[Union['EndpointClientConnectOptionsArgs', 'EndpointClientConnectOptionsArgsDict']] client_connect_options: The options for managing connection authorization for new client connections.
        :param pulumi.Input[Union['EndpointClientLoginBannerOptionsArgs', 'EndpointClientLoginBannerOptionsArgsDict']] client_login_banner_options: Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        :param pulumi.Input[Union['EndpointClientRouteEnforcementOptionsArgs', 'EndpointClientRouteEnforcementOptionsArgsDict']] client_route_enforcement_options: Options for enforce administrator defined routes on devices connected through the VPN.
        :param pulumi.Input[Union['EndpointConnectionLogOptionsArgs', 'EndpointConnectionLogOptionsArgsDict']] connection_log_options: Information about the client connection logging options.
        :param pulumi.Input[_builtins.str] description: A brief description of the Client VPN endpoint.
        :param pulumi.Input[_builtins.bool] disconnect_on_session_timeout: Indicates whether the client VPN session is disconnected after the maximum `session_timeout_hours` is reached. If `true`, users are prompted to reconnect client VPN. If `false`, client VPN attempts to reconnect automatically. The default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
        :param pulumi.Input[_builtins.str] endpoint_ip_address_type: IP address type for the Client VPN endpoint. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
        :param pulumi.Input[_builtins.str] self_service_portal: Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
        :param pulumi.Input[_builtins.str] server_certificate_arn: The ARN of the ACM server certificate.
        :param pulumi.Input[_builtins.int] session_timeout_hours: The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
        :param pulumi.Input[_builtins.bool] split_tunnel: Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] traffic_ip_address_type: IP address type for traffic within the Client VPN tunnel. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`. When it is set to `ipv6`, `client_cidr_block` must not be specified.
        :param pulumi.Input[_builtins.str] transport_protocol: The transport protocol to be used by the VPN session. Default value is `udp`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
        :param pulumi.Input[_builtins.int] vpn_port: The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Client VPN endpoint for OpenVPN clients. For more information on usage, please see the
        [AWS Client VPN Administrator's Guide](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2clientvpn.Endpoint("example",
            description="clientvpn-example",
            server_certificate_arn=cert["arn"],
            client_cidr_block="10.0.0.0/16",
            authentication_options=[{
                "type": "certificate-authentication",
                "root_certificate_chain_arn": root_cert["arn"],
            }],
            connection_log_options={
                "enabled": True,
                "cloudwatch_log_group": lg["name"],
                "cloudwatch_log_stream": ls["name"],
            })
        ```

        ## Import

        Using `pulumi import`, import AWS Client VPN endpoints using the `id` value found via `aws ec2 describe-client-vpn-endpoints`. For example:

        ```sh
        $ pulumi import aws:ec2clientvpn/endpoint:Endpoint example cvpn-endpoint-0ac3a1abbccddd666
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointAuthenticationOptionArgs', 'EndpointAuthenticationOptionArgsDict']]]]] = None,
                 client_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connect_options: Optional[pulumi.Input[Union['EndpointClientConnectOptionsArgs', 'EndpointClientConnectOptionsArgsDict']]] = None,
                 client_login_banner_options: Optional[pulumi.Input[Union['EndpointClientLoginBannerOptionsArgs', 'EndpointClientLoginBannerOptionsArgsDict']]] = None,
                 client_route_enforcement_options: Optional[pulumi.Input[Union['EndpointClientRouteEnforcementOptionsArgs', 'EndpointClientRouteEnforcementOptionsArgsDict']]] = None,
                 connection_log_options: Optional[pulumi.Input[Union['EndpointConnectionLogOptionsArgs', 'EndpointConnectionLogOptionsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_on_session_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 endpoint_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 self_service_portal: Optional[pulumi.Input[_builtins.str]] = None,
                 server_certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 session_timeout_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 split_tunnel: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transport_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_port: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            if authentication_options is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_options'")
            __props__.__dict__["authentication_options"] = authentication_options
            __props__.__dict__["client_cidr_block"] = client_cidr_block
            __props__.__dict__["client_connect_options"] = client_connect_options
            __props__.__dict__["client_login_banner_options"] = client_login_banner_options
            __props__.__dict__["client_route_enforcement_options"] = client_route_enforcement_options
            if connection_log_options is None and not opts.urn:
                raise TypeError("Missing required property 'connection_log_options'")
            __props__.__dict__["connection_log_options"] = connection_log_options
            __props__.__dict__["description"] = description
            __props__.__dict__["disconnect_on_session_timeout"] = disconnect_on_session_timeout
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["endpoint_ip_address_type"] = endpoint_ip_address_type
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["self_service_portal"] = self_service_portal
            if server_certificate_arn is None and not opts.urn:
                raise TypeError("Missing required property 'server_certificate_arn'")
            __props__.__dict__["server_certificate_arn"] = server_certificate_arn
            __props__.__dict__["session_timeout_hours"] = session_timeout_hours
            __props__.__dict__["split_tunnel"] = split_tunnel
            __props__.__dict__["tags"] = tags
            __props__.__dict__["traffic_ip_address_type"] = traffic_ip_address_type
            __props__.__dict__["transport_protocol"] = transport_protocol
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpn_port"] = vpn_port
            __props__.__dict__["arn"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["self_service_portal_url"] = None
            __props__.__dict__["tags_all"] = None
        super(Endpoint, __self__).__init__(
            'aws:ec2clientvpn/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointAuthenticationOptionArgs', 'EndpointAuthenticationOptionArgsDict']]]]] = None,
            client_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            client_connect_options: Optional[pulumi.Input[Union['EndpointClientConnectOptionsArgs', 'EndpointClientConnectOptionsArgsDict']]] = None,
            client_login_banner_options: Optional[pulumi.Input[Union['EndpointClientLoginBannerOptionsArgs', 'EndpointClientLoginBannerOptionsArgsDict']]] = None,
            client_route_enforcement_options: Optional[pulumi.Input[Union['EndpointClientRouteEnforcementOptionsArgs', 'EndpointClientRouteEnforcementOptionsArgsDict']]] = None,
            connection_log_options: Optional[pulumi.Input[Union['EndpointConnectionLogOptionsArgs', 'EndpointConnectionLogOptionsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disconnect_on_session_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            endpoint_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            self_service_portal: Optional[pulumi.Input[_builtins.str]] = None,
            self_service_portal_url: Optional[pulumi.Input[_builtins.str]] = None,
            server_certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
            session_timeout_hours: Optional[pulumi.Input[_builtins.int]] = None,
            split_tunnel: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            traffic_ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
            transport_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_port: Optional[pulumi.Input[_builtins.int]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the Client VPN endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointAuthenticationOptionArgs', 'EndpointAuthenticationOptionArgsDict']]]] authentication_options: Information about the authentication method to be used to authenticate clients.
        :param pulumi.Input[_builtins.str] client_cidr_block: The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater. When `traffic_ip_address_type` is set to `ipv6`, it must not be specified. Otherwise, it is required.
        :param pulumi.Input[Union['EndpointClientConnectOptionsArgs', 'EndpointClientConnectOptionsArgsDict']] client_connect_options: The options for managing connection authorization for new client connections.
        :param pulumi.Input[Union['EndpointClientLoginBannerOptionsArgs', 'EndpointClientLoginBannerOptionsArgsDict']] client_login_banner_options: Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        :param pulumi.Input[Union['EndpointClientRouteEnforcementOptionsArgs', 'EndpointClientRouteEnforcementOptionsArgsDict']] client_route_enforcement_options: Options for enforce administrator defined routes on devices connected through the VPN.
        :param pulumi.Input[Union['EndpointConnectionLogOptionsArgs', 'EndpointConnectionLogOptionsArgsDict']] connection_log_options: Information about the client connection logging options.
        :param pulumi.Input[_builtins.str] description: A brief description of the Client VPN endpoint.
        :param pulumi.Input[_builtins.bool] disconnect_on_session_timeout: Indicates whether the client VPN session is disconnected after the maximum `session_timeout_hours` is reached. If `true`, users are prompted to reconnect client VPN. If `false`, client VPN attempts to reconnect automatically. The default value is `false`.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name to be used by clients when establishing their VPN session.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
        :param pulumi.Input[_builtins.str] endpoint_ip_address_type: IP address type for the Client VPN endpoint. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
        :param pulumi.Input[_builtins.str] self_service_portal: Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
        :param pulumi.Input[_builtins.str] self_service_portal_url: The URL of the self-service portal.
        :param pulumi.Input[_builtins.str] server_certificate_arn: The ARN of the ACM server certificate.
        :param pulumi.Input[_builtins.int] session_timeout_hours: The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
        :param pulumi.Input[_builtins.bool] split_tunnel: Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] traffic_ip_address_type: IP address type for traffic within the Client VPN tunnel. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`. When it is set to `ipv6`, `client_cidr_block` must not be specified.
        :param pulumi.Input[_builtins.str] transport_protocol: The transport protocol to be used by the VPN session. Default value is `udp`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
        :param pulumi.Input[_builtins.int] vpn_port: The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["authentication_options"] = authentication_options
        __props__.__dict__["client_cidr_block"] = client_cidr_block
        __props__.__dict__["client_connect_options"] = client_connect_options
        __props__.__dict__["client_login_banner_options"] = client_login_banner_options
        __props__.__dict__["client_route_enforcement_options"] = client_route_enforcement_options
        __props__.__dict__["connection_log_options"] = connection_log_options
        __props__.__dict__["description"] = description
        __props__.__dict__["disconnect_on_session_timeout"] = disconnect_on_session_timeout
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["endpoint_ip_address_type"] = endpoint_ip_address_type
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["self_service_portal"] = self_service_portal
        __props__.__dict__["self_service_portal_url"] = self_service_portal_url
        __props__.__dict__["server_certificate_arn"] = server_certificate_arn
        __props__.__dict__["session_timeout_hours"] = session_timeout_hours
        __props__.__dict__["split_tunnel"] = split_tunnel
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["traffic_ip_address_type"] = traffic_ip_address_type
        __props__.__dict__["transport_protocol"] = transport_protocol
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpn_port"] = vpn_port
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the Client VPN endpoint.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authenticationOptions")
    def authentication_options(self) -> pulumi.Output[Sequence['outputs.EndpointAuthenticationOption']]:
        """
        Information about the authentication method to be used to authenticate clients.
        """
        return pulumi.get(self, "authentication_options")

    @_builtins.property
    @pulumi.getter(name="clientCidrBlock")
    def client_cidr_block(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater. When `traffic_ip_address_type` is set to `ipv6`, it must not be specified. Otherwise, it is required.
        """
        return pulumi.get(self, "client_cidr_block")

    @_builtins.property
    @pulumi.getter(name="clientConnectOptions")
    def client_connect_options(self) -> pulumi.Output['outputs.EndpointClientConnectOptions']:
        """
        The options for managing connection authorization for new client connections.
        """
        return pulumi.get(self, "client_connect_options")

    @_builtins.property
    @pulumi.getter(name="clientLoginBannerOptions")
    def client_login_banner_options(self) -> pulumi.Output['outputs.EndpointClientLoginBannerOptions']:
        """
        Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
        """
        return pulumi.get(self, "client_login_banner_options")

    @_builtins.property
    @pulumi.getter(name="clientRouteEnforcementOptions")
    def client_route_enforcement_options(self) -> pulumi.Output['outputs.EndpointClientRouteEnforcementOptions']:
        """
        Options for enforce administrator defined routes on devices connected through the VPN.
        """
        return pulumi.get(self, "client_route_enforcement_options")

    @_builtins.property
    @pulumi.getter(name="connectionLogOptions")
    def connection_log_options(self) -> pulumi.Output['outputs.EndpointConnectionLogOptions']:
        """
        Information about the client connection logging options.
        """
        return pulumi.get(self, "connection_log_options")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A brief description of the Client VPN endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disconnectOnSessionTimeout")
    def disconnect_on_session_timeout(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the client VPN session is disconnected after the maximum `session_timeout_hours` is reached. If `true`, users are prompted to reconnect client VPN. If `false`, client VPN attempts to reconnect automatically. The default value is `false`.
        """
        return pulumi.get(self, "disconnect_on_session_timeout")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS name to be used by clients when establishing their VPN session.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="endpointIpAddressType")
    def endpoint_ip_address_type(self) -> pulumi.Output[_builtins.str]:
        """
        IP address type for the Client VPN endpoint. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`.
        """
        return pulumi.get(self, "endpoint_ip_address_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="selfServicePortal")
    def self_service_portal(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
        """
        return pulumi.get(self, "self_service_portal")

    @_builtins.property
    @pulumi.getter(name="selfServicePortalUrl")
    def self_service_portal_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the self-service portal.
        """
        return pulumi.get(self, "self_service_portal_url")

    @_builtins.property
    @pulumi.getter(name="serverCertificateArn")
    def server_certificate_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the ACM server certificate.
        """
        return pulumi.get(self, "server_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="sessionTimeoutHours")
    def session_timeout_hours(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
        """
        return pulumi.get(self, "session_timeout_hours")

    @_builtins.property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
        """
        return pulumi.get(self, "split_tunnel")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="trafficIpAddressType")
    def traffic_ip_address_type(self) -> pulumi.Output[_builtins.str]:
        """
        IP address type for traffic within the Client VPN tunnel. Valid values are `ipv4`, `ipv6`, or `dual-stack`. Defaults to `ipv4`. When it is set to `ipv6`, `client_cidr_block` must not be specified.
        """
        return pulumi.get(self, "traffic_ip_address_type")

    @_builtins.property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The transport protocol to be used by the VPN session. Default value is `udp`.
        """
        return pulumi.get(self, "transport_protocol")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpnPort")
    def vpn_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
        """
        return pulumi.get(self, "vpn_port")

