# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EndpointAuthenticationOption',
    'EndpointClientConnectOptions',
    'EndpointClientLoginBannerOptions',
    'EndpointClientRouteEnforcementOptions',
    'EndpointConnectionLogOptions',
    'GetEndpointAuthenticationOptionResult',
    'GetEndpointClientConnectOptionResult',
    'GetEndpointClientLoginBannerOptionResult',
    'GetEndpointClientRouteEnforcementOptionResult',
    'GetEndpointConnectionLogOptionResult',
    'GetEndpointFilterResult',
]

@pulumi.output_type
class EndpointAuthenticationOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryId":
            suggest = "active_directory_id"
        elif key == "rootCertificateChainArn":
            suggest = "root_certificate_chain_arn"
        elif key == "samlProviderArn":
            suggest = "saml_provider_arn"
        elif key == "selfServiceSamlProviderArn":
            suggest = "self_service_saml_provider_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointAuthenticationOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointAuthenticationOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointAuthenticationOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 active_directory_id: Optional[_builtins.str] = None,
                 root_certificate_chain_arn: Optional[_builtins.str] = None,
                 saml_provider_arn: Optional[_builtins.str] = None,
                 self_service_saml_provider_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
        :param _builtins.str active_directory_id: The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
        :param _builtins.str root_certificate_chain_arn: The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
        :param _builtins.str saml_provider_arn: The ARN of the IAM SAML identity provider if type is `federated-authentication`.
        :param _builtins.str self_service_saml_provider_arn: The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
        """
        pulumi.set(__self__, "type", type)
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if root_certificate_chain_arn is not None:
            pulumi.set(__self__, "root_certificate_chain_arn", root_certificate_chain_arn)
        if saml_provider_arn is not None:
            pulumi.set(__self__, "saml_provider_arn", saml_provider_arn)
        if self_service_saml_provider_arn is not None:
            pulumi.set(__self__, "self_service_saml_provider_arn", self_service_saml_provider_arn)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
        """
        return pulumi.get(self, "active_directory_id")

    @_builtins.property
    @pulumi.getter(name="rootCertificateChainArn")
    def root_certificate_chain_arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
        """
        return pulumi.get(self, "root_certificate_chain_arn")

    @_builtins.property
    @pulumi.getter(name="samlProviderArn")
    def saml_provider_arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the IAM SAML identity provider if type is `federated-authentication`.
        """
        return pulumi.get(self, "saml_provider_arn")

    @_builtins.property
    @pulumi.getter(name="selfServiceSamlProviderArn")
    def self_service_saml_provider_arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
        """
        return pulumi.get(self, "self_service_saml_provider_arn")


@pulumi.output_type
class EndpointClientConnectOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaFunctionArn":
            suggest = "lambda_function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointClientConnectOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointClientConnectOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointClientConnectOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 lambda_function_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Indicates whether client connect options are enabled. The default is `false` (not enabled).
        :param _builtins.str lambda_function_arn: The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether client connect options are enabled. The default is `false` (not enabled).
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
        """
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class EndpointClientLoginBannerOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bannerText":
            suggest = "banner_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointClientLoginBannerOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointClientLoginBannerOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointClientLoginBannerOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 banner_text: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str banner_text: Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
        :param _builtins.bool enabled: Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
        """
        if banner_text is not None:
            pulumi.set(__self__, "banner_text", banner_text)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="bannerText")
    def banner_text(self) -> Optional[_builtins.str]:
        """
        Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
        """
        return pulumi.get(self, "banner_text")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EndpointClientRouteEnforcementOptions(dict):
    def __init__(__self__, *,
                 enforced: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enforced: Enable or disable Client Route Enforcement. The default is `false` (not enabled).
        """
        if enforced is not None:
            pulumi.set(__self__, "enforced", enforced)

    @_builtins.property
    @pulumi.getter
    def enforced(self) -> Optional[_builtins.bool]:
        """
        Enable or disable Client Route Enforcement. The default is `false` (not enabled).
        """
        return pulumi.get(self, "enforced")


@pulumi.output_type
class EndpointConnectionLogOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogGroup":
            suggest = "cloudwatch_log_group"
        elif key == "cloudwatchLogStream":
            suggest = "cloudwatch_log_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConnectionLogOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConnectionLogOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConnectionLogOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 cloudwatch_log_group: Optional[_builtins.str] = None,
                 cloudwatch_log_stream: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Indicates whether connection logging is enabled.
        :param _builtins.str cloudwatch_log_group: The name of the CloudWatch Logs log group.
        :param _builtins.str cloudwatch_log_stream: The name of the CloudWatch Logs log stream to which the connection data is published.
        """
        pulumi.set(__self__, "enabled", enabled)
        if cloudwatch_log_group is not None:
            pulumi.set(__self__, "cloudwatch_log_group", cloudwatch_log_group)
        if cloudwatch_log_stream is not None:
            pulumi.set(__self__, "cloudwatch_log_stream", cloudwatch_log_stream)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Indicates whether connection logging is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogGroup")
    def cloudwatch_log_group(self) -> Optional[_builtins.str]:
        """
        The name of the CloudWatch Logs log group.
        """
        return pulumi.get(self, "cloudwatch_log_group")

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogStream")
    def cloudwatch_log_stream(self) -> Optional[_builtins.str]:
        """
        The name of the CloudWatch Logs log stream to which the connection data is published.
        """
        return pulumi.get(self, "cloudwatch_log_stream")


@pulumi.output_type
class GetEndpointAuthenticationOptionResult(dict):
    def __init__(__self__, *,
                 active_directory_id: _builtins.str,
                 root_certificate_chain_arn: _builtins.str,
                 saml_provider_arn: _builtins.str,
                 self_service_saml_provider_arn: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "active_directory_id", active_directory_id)
        pulumi.set(__self__, "root_certificate_chain_arn", root_certificate_chain_arn)
        pulumi.set(__self__, "saml_provider_arn", saml_provider_arn)
        pulumi.set(__self__, "self_service_saml_provider_arn", self_service_saml_provider_arn)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> _builtins.str:
        return pulumi.get(self, "active_directory_id")

    @_builtins.property
    @pulumi.getter(name="rootCertificateChainArn")
    def root_certificate_chain_arn(self) -> _builtins.str:
        return pulumi.get(self, "root_certificate_chain_arn")

    @_builtins.property
    @pulumi.getter(name="samlProviderArn")
    def saml_provider_arn(self) -> _builtins.str:
        return pulumi.get(self, "saml_provider_arn")

    @_builtins.property
    @pulumi.getter(name="selfServiceSamlProviderArn")
    def self_service_saml_provider_arn(self) -> _builtins.str:
        return pulumi.get(self, "self_service_saml_provider_arn")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEndpointClientConnectOptionResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 lambda_function_arn: _builtins.str):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> _builtins.str:
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class GetEndpointClientLoginBannerOptionResult(dict):
    def __init__(__self__, *,
                 banner_text: _builtins.str,
                 enabled: _builtins.bool):
        pulumi.set(__self__, "banner_text", banner_text)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="bannerText")
    def banner_text(self) -> _builtins.str:
        return pulumi.get(self, "banner_text")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetEndpointClientRouteEnforcementOptionResult(dict):
    def __init__(__self__, *,
                 enforced: _builtins.bool):
        pulumi.set(__self__, "enforced", enforced)

    @_builtins.property
    @pulumi.getter
    def enforced(self) -> _builtins.bool:
        return pulumi.get(self, "enforced")


@pulumi.output_type
class GetEndpointConnectionLogOptionResult(dict):
    def __init__(__self__, *,
                 cloudwatch_log_group: _builtins.str,
                 cloudwatch_log_stream: _builtins.str,
                 enabled: _builtins.bool):
        pulumi.set(__self__, "cloudwatch_log_group", cloudwatch_log_group)
        pulumi.set(__self__, "cloudwatch_log_stream", cloudwatch_log_stream)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogGroup")
    def cloudwatch_log_group(self) -> _builtins.str:
        return pulumi.get(self, "cloudwatch_log_group")

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogStream")
    def cloudwatch_log_stream(self) -> _builtins.str:
        return pulumi.get(self, "cloudwatch_log_stream")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetEndpointFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnEndpoints.html).
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given field. An endpoint will be selected if any one of the given values matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnEndpoints.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Set of values that are accepted for the given field. An endpoint will be selected if any one of the given values matches.
        """
        return pulumi.get(self, "values")


