# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectResult',
    'AwaitableGetConnectResult',
    'get_connect',
    'get_connect_output',
]

@pulumi.output_type
class GetConnectResult:
    """
    A collection of values returned by getConnect.
    """
    def __init__(__self__, filters=None, id=None, protocol=None, region=None, tags=None, transit_gateway_connect_id=None, transit_gateway_id=None, transport_attachment_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if transit_gateway_connect_id and not isinstance(transit_gateway_connect_id, str):
            raise TypeError("Expected argument 'transit_gateway_connect_id' to be a str")
        pulumi.set(__self__, "transit_gateway_connect_id", transit_gateway_connect_id)
        if transit_gateway_id and not isinstance(transit_gateway_id, str):
            raise TypeError("Expected argument 'transit_gateway_id' to be a str")
        pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if transport_attachment_id and not isinstance(transport_attachment_id, str):
            raise TypeError("Expected argument 'transport_attachment_id' to be a str")
        pulumi.set(__self__, "transport_attachment_id", transport_attachment_id)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConnectFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Tunnel protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value tags for the EC2 Transit Gateway Connect
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitGatewayConnectId")
    def transit_gateway_connect_id(self) -> _builtins.str:
        return pulumi.get(self, "transit_gateway_connect_id")

    @_builtins.property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> _builtins.str:
        """
        EC2 Transit Gateway identifier
        """
        return pulumi.get(self, "transit_gateway_id")

    @_builtins.property
    @pulumi.getter(name="transportAttachmentId")
    def transport_attachment_id(self) -> _builtins.str:
        """
        The underlaying VPC attachment
        """
        return pulumi.get(self, "transport_attachment_id")


class AwaitableGetConnectResult(GetConnectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectResult(
            filters=self.filters,
            id=self.id,
            protocol=self.protocol,
            region=self.region,
            tags=self.tags,
            transit_gateway_connect_id=self.transit_gateway_connect_id,
            transit_gateway_id=self.transit_gateway_id,
            transport_attachment_id=self.transport_attachment_id)


def get_connect(filters: Optional[Sequence[Union['GetConnectFilterArgs', 'GetConnectFilterArgsDict']]] = None,
                region: Optional[_builtins.str] = None,
                tags: Optional[Mapping[str, _builtins.str]] = None,
                transit_gateway_connect_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectResult:
    """
    Get information on an EC2 Transit Gateway Connect.

    ## Example Usage

    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect(filters=[{
        "name": "transport-transit-gateway-attachment-id",
        "values": ["tgw-attach-12345678"],
    }])
    ```

    ### By Identifier

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect(transit_gateway_connect_id="tgw-attach-12345678")
    ```


    :param Sequence[Union['GetConnectFilterArgs', 'GetConnectFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value tags for the EC2 Transit Gateway Connect
    :param _builtins.str transit_gateway_connect_id: Identifier of the EC2 Transit Gateway Connect.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['transitGatewayConnectId'] = transit_gateway_connect_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2transitgateway/getConnect:getConnect', __args__, opts=opts, typ=GetConnectResult).value

    return AwaitableGetConnectResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        transit_gateway_connect_id=pulumi.get(__ret__, 'transit_gateway_connect_id'),
        transit_gateway_id=pulumi.get(__ret__, 'transit_gateway_id'),
        transport_attachment_id=pulumi.get(__ret__, 'transport_attachment_id'))
def get_connect_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetConnectFilterArgs', 'GetConnectFilterArgsDict']]]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                       transit_gateway_connect_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectResult]:
    """
    Get information on an EC2 Transit Gateway Connect.

    ## Example Usage

    ### By Filter

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect(filters=[{
        "name": "transport-transit-gateway-attachment-id",
        "values": ["tgw-attach-12345678"],
    }])
    ```

    ### By Identifier

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_connect(transit_gateway_connect_id="tgw-attach-12345678")
    ```


    :param Sequence[Union['GetConnectFilterArgs', 'GetConnectFilterArgsDict']] filters: One or more configuration blocks containing name-values filters. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value tags for the EC2 Transit Gateway Connect
    :param _builtins.str transit_gateway_connect_id: Identifier of the EC2 Transit Gateway Connect.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['transitGatewayConnectId'] = transit_gateway_connect_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2transitgateway/getConnect:getConnect', __args__, opts=opts, typ=GetConnectResult)
    return __ret__.apply(lambda __response__: GetConnectResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        protocol=pulumi.get(__response__, 'protocol'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        transit_gateway_connect_id=pulumi.get(__response__, 'transit_gateway_connect_id'),
        transit_gateway_id=pulumi.get(__response__, 'transit_gateway_id'),
        transport_attachment_id=pulumi.get(__response__, 'transport_attachment_id')))
