# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDirectConnectGatewayAttachmentResult',
    'AwaitableGetDirectConnectGatewayAttachmentResult',
    'get_direct_connect_gateway_attachment',
    'get_direct_connect_gateway_attachment_output',
]

@pulumi.output_type
class GetDirectConnectGatewayAttachmentResult:
    """
    A collection of values returned by getDirectConnectGatewayAttachment.
    """
    def __init__(__self__, arn=None, dx_gateway_id=None, filters=None, id=None, region=None, tags=None, transit_gateway_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if dx_gateway_id and not isinstance(dx_gateway_id, str):
            raise TypeError("Expected argument 'dx_gateway_id' to be a str")
        pulumi.set(__self__, "dx_gateway_id", dx_gateway_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if transit_gateway_id and not isinstance(transit_gateway_id, str):
            raise TypeError("Expected argument 'transit_gateway_id' to be a str")
        pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the attachment.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dxGatewayId")
    def dx_gateway_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dx_gateway_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDirectConnectGatewayAttachmentFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value tags for the EC2 Transit Gateway Attachment.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "transit_gateway_id")


class AwaitableGetDirectConnectGatewayAttachmentResult(GetDirectConnectGatewayAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDirectConnectGatewayAttachmentResult(
            arn=self.arn,
            dx_gateway_id=self.dx_gateway_id,
            filters=self.filters,
            id=self.id,
            region=self.region,
            tags=self.tags,
            transit_gateway_id=self.transit_gateway_id)


def get_direct_connect_gateway_attachment(dx_gateway_id: Optional[_builtins.str] = None,
                                          filters: Optional[Sequence[Union['GetDirectConnectGatewayAttachmentFilterArgs', 'GetDirectConnectGatewayAttachmentFilterArgsDict']]] = None,
                                          region: Optional[_builtins.str] = None,
                                          tags: Optional[Mapping[str, _builtins.str]] = None,
                                          transit_gateway_id: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDirectConnectGatewayAttachmentResult:
    """
    Get information on an EC2 Transit Gateway's attachment to a Direct Connect Gateway.

    !> **Warning:** Using the `ec2transitgateway_get_direct_connect_gateway_attachment` data source in combination with  `ec2transitgateway.RouteTablePropagation` or `ec2transitgateway.RouteTableAssociation` may result in lost connectivity due to unnecessary resource re-creation. To avoid this, use the `transit_gateway_attachment_id` attribute directly from the `directconnect.GatewayAssociation` resource. For example, `transit_gateway_attachment_id  = aws_dx_gateway_association.example.transit_gateway_attachment_id`.

    ## Example Usage

    ### By Transit Gateway and Direct Connect Gateway Identifiers

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_direct_connect_gateway_attachment(transit_gateway_id=example_aws_ec2_transit_gateway["id"],
        dx_gateway_id=example_aws_dx_gateway["id"])
    ```


    :param _builtins.str dx_gateway_id: Identifier of the Direct Connect Gateway.
    :param Sequence[Union['GetDirectConnectGatewayAttachmentFilterArgs', 'GetDirectConnectGatewayAttachmentFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway Direct Connect Gateway Attachment.
    :param _builtins.str transit_gateway_id: Identifier of the EC2 Transit Gateway.
    """
    __args__ = dict()
    __args__['dxGatewayId'] = dx_gateway_id
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['transitGatewayId'] = transit_gateway_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2transitgateway/getDirectConnectGatewayAttachment:getDirectConnectGatewayAttachment', __args__, opts=opts, typ=GetDirectConnectGatewayAttachmentResult).value

    return AwaitableGetDirectConnectGatewayAttachmentResult(
        arn=pulumi.get(__ret__, 'arn'),
        dx_gateway_id=pulumi.get(__ret__, 'dx_gateway_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        transit_gateway_id=pulumi.get(__ret__, 'transit_gateway_id'))
def get_direct_connect_gateway_attachment_output(dx_gateway_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDirectConnectGatewayAttachmentFilterArgs', 'GetDirectConnectGatewayAttachmentFilterArgsDict']]]]] = None,
                                                 region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                                 transit_gateway_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDirectConnectGatewayAttachmentResult]:
    """
    Get information on an EC2 Transit Gateway's attachment to a Direct Connect Gateway.

    !> **Warning:** Using the `ec2transitgateway_get_direct_connect_gateway_attachment` data source in combination with  `ec2transitgateway.RouteTablePropagation` or `ec2transitgateway.RouteTableAssociation` may result in lost connectivity due to unnecessary resource re-creation. To avoid this, use the `transit_gateway_attachment_id` attribute directly from the `directconnect.GatewayAssociation` resource. For example, `transit_gateway_attachment_id  = aws_dx_gateway_association.example.transit_gateway_attachment_id`.

    ## Example Usage

    ### By Transit Gateway and Direct Connect Gateway Identifiers

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2transitgateway.get_direct_connect_gateway_attachment(transit_gateway_id=example_aws_ec2_transit_gateway["id"],
        dx_gateway_id=example_aws_dx_gateway["id"])
    ```


    :param _builtins.str dx_gateway_id: Identifier of the Direct Connect Gateway.
    :param Sequence[Union['GetDirectConnectGatewayAttachmentFilterArgs', 'GetDirectConnectGatewayAttachmentFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway Direct Connect Gateway Attachment.
    :param _builtins.str transit_gateway_id: Identifier of the EC2 Transit Gateway.
    """
    __args__ = dict()
    __args__['dxGatewayId'] = dx_gateway_id
    __args__['filters'] = filters
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['transitGatewayId'] = transit_gateway_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2transitgateway/getDirectConnectGatewayAttachment:getDirectConnectGatewayAttachment', __args__, opts=opts, typ=GetDirectConnectGatewayAttachmentResult)
    return __ret__.apply(lambda __response__: GetDirectConnectGatewayAttachmentResult(
        arn=pulumi.get(__response__, 'arn'),
        dx_gateway_id=pulumi.get(__response__, 'dx_gateway_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        transit_gateway_id=pulumi.get(__response__, 'transit_gateway_id')))
