# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import iam
from .. import iam as _iam
from ._enums import *

__all__ = [
    'LifecyclePolicyActionArgs',
    'LifecyclePolicyActionArgsDict',
    'LifecyclePolicyDocumentArgs',
    'LifecyclePolicyDocumentArgsDict',
    'LifecyclePolicyRuleArgs',
    'LifecyclePolicyRuleArgsDict',
    'LifecyclePolicySelectionArgs',
    'LifecyclePolicySelectionArgsDict',
    'PolicyDocumentArgs',
    'PolicyDocumentArgsDict',
    'RegistryScanningConfigurationRuleArgs',
    'RegistryScanningConfigurationRuleArgsDict',
    'RegistryScanningConfigurationRuleRepositoryFilterArgs',
    'RegistryScanningConfigurationRuleRepositoryFilterArgsDict',
    'ReplicationConfigurationReplicationConfigurationArgs',
    'ReplicationConfigurationReplicationConfigurationArgsDict',
    'ReplicationConfigurationReplicationConfigurationRuleArgs',
    'ReplicationConfigurationReplicationConfigurationRuleArgsDict',
    'ReplicationConfigurationReplicationConfigurationRuleDestinationArgs',
    'ReplicationConfigurationReplicationConfigurationRuleDestinationArgsDict',
    'ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs',
    'ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsDict',
    'RepositoryCreationTemplateEncryptionConfigurationArgs',
    'RepositoryCreationTemplateEncryptionConfigurationArgsDict',
    'RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs',
    'RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict',
    'RepositoryEncryptionConfigurationArgs',
    'RepositoryEncryptionConfigurationArgsDict',
    'RepositoryImageScanningConfigurationArgs',
    'RepositoryImageScanningConfigurationArgsDict',
    'RepositoryImageTagMutabilityExclusionFilterArgs',
    'RepositoryImageTagMutabilityExclusionFilterArgsDict',
    'GetLifecyclePolicyDocumentRuleArgs',
    'GetLifecyclePolicyDocumentRuleArgsDict',
    'GetLifecyclePolicyDocumentRuleActionArgs',
    'GetLifecyclePolicyDocumentRuleActionArgsDict',
    'GetLifecyclePolicyDocumentRuleSelectionArgs',
    'GetLifecyclePolicyDocumentRuleSelectionArgsDict',
]

MYPY = False

if not MYPY:
    class LifecyclePolicyActionArgsDict(TypedDict):
        type: pulumi.Input['LifecyclePolicyActionType']
        """
        The type of action to take. Currently only 'expire' is supported.
        """
elif False:
    LifecyclePolicyActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LifecyclePolicyActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['LifecyclePolicyActionType']):
        """
        :param pulumi.Input['LifecyclePolicyActionType'] type: The type of action to take. Currently only 'expire' is supported.
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input['LifecyclePolicyActionType']:
        """
        The type of action to take. Currently only 'expire' is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['LifecyclePolicyActionType']):
        pulumi.set(self, "type", value)


if not MYPY:
    class LifecyclePolicyDocumentArgsDict(TypedDict):
        """
        Represents an ECR lifecycle policy document.
        """
        rules: pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyRuleArgsDict']]]
        """
        The rules that comprise the lifecycle policy.
        """
elif False:
    LifecyclePolicyDocumentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LifecyclePolicyDocumentArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyRuleArgs']]]):
        """
        Represents an ECR lifecycle policy document.
        :param pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyRuleArgs']]] rules: The rules that comprise the lifecycle policy.
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyRuleArgs']]]:
        """
        The rules that comprise the lifecycle policy.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class LifecyclePolicyRuleArgsDict(TypedDict):
        """
        Represents a rule in an ECR lifecycle policy.
        """
        action: pulumi.Input['LifecyclePolicyActionArgsDict']
        """
        The action to take when the rule is triggered.
        """
        rule_priority: pulumi.Input[_builtins.int]
        """
        The priority of the rule, must be unique within the policy.
        """
        selection: pulumi.Input['LifecyclePolicySelectionArgsDict']
        """
        The selection criteria for the rule.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A description of the rule.
        """
elif False:
    LifecyclePolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LifecyclePolicyRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['LifecyclePolicyActionArgs'],
                 rule_priority: pulumi.Input[_builtins.int],
                 selection: pulumi.Input['LifecyclePolicySelectionArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Represents a rule in an ECR lifecycle policy.
        :param pulumi.Input['LifecyclePolicyActionArgs'] action: The action to take when the rule is triggered.
        :param pulumi.Input[_builtins.int] rule_priority: The priority of the rule, must be unique within the policy.
        :param pulumi.Input['LifecyclePolicySelectionArgs'] selection: The selection criteria for the rule.
        :param pulumi.Input[_builtins.str] description: A description of the rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "rule_priority", rule_priority)
        pulumi.set(__self__, "selection", selection)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['LifecyclePolicyActionArgs']:
        """
        The action to take when the rule is triggered.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['LifecyclePolicyActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="rulePriority")
    def rule_priority(self) -> pulumi.Input[_builtins.int]:
        """
        The priority of the rule, must be unique within the policy.
        """
        return pulumi.get(self, "rule_priority")

    @rule_priority.setter
    def rule_priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "rule_priority", value)

    @_builtins.property
    @pulumi.getter
    def selection(self) -> pulumi.Input['LifecyclePolicySelectionArgs']:
        """
        The selection criteria for the rule.
        """
        return pulumi.get(self, "selection")

    @selection.setter
    def selection(self, value: pulumi.Input['LifecyclePolicySelectionArgs']):
        pulumi.set(self, "selection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class LifecyclePolicySelectionArgsDict(TypedDict):
        """
        Represents selection criteria for an ECR lifecycle policy rule.
        """
        count_number: pulumi.Input[_builtins.int]
        """
        The count number to use with the count type.
        """
        count_type: pulumi.Input['LifecyclePolicyCountType']
        """
        The type of count to perform. Either 'imageCountMoreThan' or 'sinceImagePushed'.
        """
        tag_status: pulumi.Input['LifecyclePolicyTagStatus']
        """
        The tag status of the image. Either 'tagged', 'untagged', or 'any'.
        """
        count_unit: NotRequired[pulumi.Input[_builtins.str]]
        """
        The unit of time for sinceImagePushed. Either 'days'.
        """
        tag_prefix_list: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of image tag prefixes on which to take action.
        """
elif False:
    LifecyclePolicySelectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LifecyclePolicySelectionArgs:
    def __init__(__self__, *,
                 count_number: pulumi.Input[_builtins.int],
                 count_type: pulumi.Input['LifecyclePolicyCountType'],
                 tag_status: pulumi.Input['LifecyclePolicyTagStatus'],
                 count_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_prefix_list: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Represents selection criteria for an ECR lifecycle policy rule.
        :param pulumi.Input[_builtins.int] count_number: The count number to use with the count type.
        :param pulumi.Input['LifecyclePolicyCountType'] count_type: The type of count to perform. Either 'imageCountMoreThan' or 'sinceImagePushed'.
        :param pulumi.Input['LifecyclePolicyTagStatus'] tag_status: The tag status of the image. Either 'tagged', 'untagged', or 'any'.
        :param pulumi.Input[_builtins.str] count_unit: The unit of time for sinceImagePushed. Either 'days'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_prefix_list: A list of image tag prefixes on which to take action.
        """
        pulumi.set(__self__, "count_number", count_number)
        pulumi.set(__self__, "count_type", count_type)
        pulumi.set(__self__, "tag_status", tag_status)
        if count_unit is not None:
            pulumi.set(__self__, "count_unit", count_unit)
        if tag_prefix_list is not None:
            pulumi.set(__self__, "tag_prefix_list", tag_prefix_list)

    @_builtins.property
    @pulumi.getter(name="countNumber")
    def count_number(self) -> pulumi.Input[_builtins.int]:
        """
        The count number to use with the count type.
        """
        return pulumi.get(self, "count_number")

    @count_number.setter
    def count_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "count_number", value)

    @_builtins.property
    @pulumi.getter(name="countType")
    def count_type(self) -> pulumi.Input['LifecyclePolicyCountType']:
        """
        The type of count to perform. Either 'imageCountMoreThan' or 'sinceImagePushed'.
        """
        return pulumi.get(self, "count_type")

    @count_type.setter
    def count_type(self, value: pulumi.Input['LifecyclePolicyCountType']):
        pulumi.set(self, "count_type", value)

    @_builtins.property
    @pulumi.getter(name="tagStatus")
    def tag_status(self) -> pulumi.Input['LifecyclePolicyTagStatus']:
        """
        The tag status of the image. Either 'tagged', 'untagged', or 'any'.
        """
        return pulumi.get(self, "tag_status")

    @tag_status.setter
    def tag_status(self, value: pulumi.Input['LifecyclePolicyTagStatus']):
        pulumi.set(self, "tag_status", value)

    @_builtins.property
    @pulumi.getter(name="countUnit")
    def count_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of time for sinceImagePushed. Either 'days'.
        """
        return pulumi.get(self, "count_unit")

    @count_unit.setter
    def count_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "count_unit", value)

    @_builtins.property
    @pulumi.getter(name="tagPrefixList")
    def tag_prefix_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of image tag prefixes on which to take action.
        """
        return pulumi.get(self, "tag_prefix_list")

    @tag_prefix_list.setter
    def tag_prefix_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_prefix_list", value)


if not MYPY:
    class PolicyDocumentArgsDict(TypedDict):
        """
        Represents an AWS IAM policy document that defines permissions for AWS resources and actions.
        """
        statement: pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgsDict']]]
        version: pulumi.Input['iam.PolicyDocumentVersion']
        id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    PolicyDocumentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyDocumentArgs:
    def __init__(__self__, *,
                 statement: pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgs']]],
                 version: pulumi.Input['iam.PolicyDocumentVersion'],
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Represents an AWS IAM policy document that defines permissions for AWS resources and actions.
        """
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "version", version)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="Statement")
    def statement(self) -> pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgs']]]:
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgs']]]):
        pulumi.set(self, "statement", value)

    @_builtins.property
    @pulumi.getter(name="Version")
    def version(self) -> pulumi.Input['iam.PolicyDocumentVersion']:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input['iam.PolicyDocumentVersion']):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="Id")
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class RegistryScanningConfigurationRuleArgsDict(TypedDict):
        repository_filters: pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRuleRepositoryFilterArgsDict']]]
        """
        One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
        """
        scan_frequency: pulumi.Input[_builtins.str]
        """
        The frequency that scans are performed at for a private registry. Can be `SCAN_ON_PUSH`, `CONTINUOUS_SCAN`, or `MANUAL`.
        """
elif False:
    RegistryScanningConfigurationRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RegistryScanningConfigurationRuleArgs:
    def __init__(__self__, *,
                 repository_filters: pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRuleRepositoryFilterArgs']]],
                 scan_frequency: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRuleRepositoryFilterArgs']]] repository_filters: One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
        :param pulumi.Input[_builtins.str] scan_frequency: The frequency that scans are performed at for a private registry. Can be `SCAN_ON_PUSH`, `CONTINUOUS_SCAN`, or `MANUAL`.
        """
        pulumi.set(__self__, "repository_filters", repository_filters)
        pulumi.set(__self__, "scan_frequency", scan_frequency)

    @_builtins.property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRuleRepositoryFilterArgs']]]:
        """
        One or more repository filter blocks, containing a `filter` (required string filtering repositories, see pattern regex [here](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_ScanningRepositoryFilter.html)) and a `filter_type` (required string, currently only `WILDCARD` is supported).
        """
        return pulumi.get(self, "repository_filters")

    @repository_filters.setter
    def repository_filters(self, value: pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRuleRepositoryFilterArgs']]]):
        pulumi.set(self, "repository_filters", value)

    @_builtins.property
    @pulumi.getter(name="scanFrequency")
    def scan_frequency(self) -> pulumi.Input[_builtins.str]:
        """
        The frequency that scans are performed at for a private registry. Can be `SCAN_ON_PUSH`, `CONTINUOUS_SCAN`, or `MANUAL`.
        """
        return pulumi.get(self, "scan_frequency")

    @scan_frequency.setter
    def scan_frequency(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scan_frequency", value)


if not MYPY:
    class RegistryScanningConfigurationRuleRepositoryFilterArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        filter_type: pulumi.Input[_builtins.str]
elif False:
    RegistryScanningConfigurationRuleRepositoryFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RegistryScanningConfigurationRuleRepositoryFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 filter_type: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_type", value)


if not MYPY:
    class ReplicationConfigurationReplicationConfigurationArgsDict(TypedDict):
        rules: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleArgsDict']]]
        """
        The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
        """
elif False:
    ReplicationConfigurationReplicationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationConfigurationArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleArgs']]] rules: The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleArgs']]]:
        """
        The replication rules for a replication configuration. A maximum of 10 are allowed per `replication_configuration`. See Rule
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class ReplicationConfigurationReplicationConfigurationRuleArgsDict(TypedDict):
        destinations: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleDestinationArgsDict']]]
        """
        the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
        """
        repository_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsDict']]]]
        """
        filters for a replication rule. See Repository Filter.
        """
elif False:
    ReplicationConfigurationReplicationConfigurationRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationConfigurationRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleDestinationArgs']]],
                 repository_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleDestinationArgs']]] destinations: the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs']]] repository_filters: filters for a replication rule. See Repository Filter.
        """
        pulumi.set(__self__, "destinations", destinations)
        if repository_filters is not None:
            pulumi.set(__self__, "repository_filters", repository_filters)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleDestinationArgs']]]:
        """
        the details of a replication destination. A maximum of 25 are allowed per `rule`. See Destination.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs']]]]:
        """
        filters for a replication rule. See Repository Filter.
        """
        return pulumi.get(self, "repository_filters")

    @repository_filters.setter
    def repository_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs']]]]):
        pulumi.set(self, "repository_filters", value)


if not MYPY:
    class ReplicationConfigurationReplicationConfigurationRuleDestinationArgsDict(TypedDict):
        region: pulumi.Input[_builtins.str]
        """
        A Region to replicate to.
        """
        registry_id: pulumi.Input[_builtins.str]
        """
        The account ID of the destination registry to replicate to.
        """
elif False:
    ReplicationConfigurationReplicationConfigurationRuleDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationConfigurationRuleDestinationArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 registry_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] region: A Region to replicate to.
        :param pulumi.Input[_builtins.str] registry_id: The account ID of the destination registry to replicate to.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "registry_id", registry_id)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        A Region to replicate to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Input[_builtins.str]:
        """
        The account ID of the destination registry to replicate to.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "registry_id", value)


if not MYPY:
    class ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        """
        The repository filter details.
        """
        filter_type: pulumi.Input[_builtins.str]
        """
        The repository filter type. The only supported value is `PREFIX_MATCH`, which is a repository name prefix specified with the filter parameter.
        """
elif False:
    ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 filter_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] filter: The repository filter details.
        :param pulumi.Input[_builtins.str] filter_type: The repository filter type. The only supported value is `PREFIX_MATCH`, which is a repository name prefix specified with the filter parameter.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        """
        The repository filter details.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[_builtins.str]:
        """
        The repository filter type. The only supported value is `PREFIX_MATCH`, which is a repository name prefix specified with the filter parameter.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_type", value)


if not MYPY:
    class RepositoryCreationTemplateEncryptionConfigurationArgsDict(TypedDict):
        encryption_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption type to use for any created repositories. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        """
        kms_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
elif False:
    RepositoryCreationTemplateEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryCreationTemplateEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] encryption_type: The encryption type to use for any created repositories. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        :param pulumi.Input[_builtins.str] kms_key: The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption type to use for any created repositories. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        """
        The filter pattern to use for excluding image tags from the mutability setting. Must contain only letters, numbers, and special characters (._*-). Each filter can be up to 128 characters long and can contain a maximum of 2 wildcards (*).
        """
        filter_type: pulumi.Input[_builtins.str]
        """
        The type of filter to use. Must be `WILDCARD`.
        """
elif False:
    RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryCreationTemplateImageTagMutabilityExclusionFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 filter_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] filter: The filter pattern to use for excluding image tags from the mutability setting. Must contain only letters, numbers, and special characters (._*-). Each filter can be up to 128 characters long and can contain a maximum of 2 wildcards (*).
        :param pulumi.Input[_builtins.str] filter_type: The type of filter to use. Must be `WILDCARD`.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        """
        The filter pattern to use for excluding image tags from the mutability setting. Must contain only letters, numbers, and special characters (._*-). Each filter can be up to 128 characters long and can contain a maximum of 2 wildcards (*).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of filter to use. Must be `WILDCARD`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_type", value)


if not MYPY:
    class RepositoryEncryptionConfigurationArgsDict(TypedDict):
        encryption_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        """
        kms_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
elif False:
    RepositoryEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] encryption_type: The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        :param pulumi.Input[_builtins.str] kms_key: The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption type to use for the repository. Valid values are `AES256` or `KMS`. Defaults to `AES256`.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the KMS key to use when `encryption_type` is `KMS`. If not specified, uses the default AWS managed key for ECR.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class RepositoryImageScanningConfigurationArgsDict(TypedDict):
        scan_on_push: pulumi.Input[_builtins.bool]
        """
        Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
        """
elif False:
    RepositoryImageScanningConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryImageScanningConfigurationArgs:
    def __init__(__self__, *,
                 scan_on_push: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[_builtins.bool] scan_on_push: Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
        """
        pulumi.set(__self__, "scan_on_push", scan_on_push)

    @_builtins.property
    @pulumi.getter(name="scanOnPush")
    def scan_on_push(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).
        """
        return pulumi.get(self, "scan_on_push")

    @scan_on_push.setter
    def scan_on_push(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "scan_on_push", value)


if not MYPY:
    class RepositoryImageTagMutabilityExclusionFilterArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        """
        The filter pattern to use for excluding image tags from the mutability setting. Must contain only letters, numbers, and special characters (._*-). Each filter can be up to 128 characters long and can contain a maximum of 2 wildcards (*).
        """
        filter_type: pulumi.Input[_builtins.str]
        """
        The type of filter to use. Must be `WILDCARD`.
        """
elif False:
    RepositoryImageTagMutabilityExclusionFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryImageTagMutabilityExclusionFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 filter_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] filter: The filter pattern to use for excluding image tags from the mutability setting. Must contain only letters, numbers, and special characters (._*-). Each filter can be up to 128 characters long and can contain a maximum of 2 wildcards (*).
        :param pulumi.Input[_builtins.str] filter_type: The type of filter to use. Must be `WILDCARD`.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        """
        The filter pattern to use for excluding image tags from the mutability setting. Must contain only letters, numbers, and special characters (._*-). Each filter can be up to 128 characters long and can contain a maximum of 2 wildcards (*).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of filter to use. Must be `WILDCARD`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter_type", value)


if not MYPY:
    class GetLifecyclePolicyDocumentRuleArgsDict(TypedDict):
        priority: _builtins.int
        """
        Sets the order in which rules are evaluated, lowest to highest. When you add rules to a lifecycle policy, you must give them each a unique value for `priority`. Values do not need to be sequential across rules in a policy. A rule with a `tag_status` value of "any" must have the highest value for `priority` and be evaluated last.
        """
        action: NotRequired['GetLifecyclePolicyDocumentRuleActionArgsDict']
        """
        Specifies the action type.
        """
        description: NotRequired[_builtins.str]
        """
        Describes the purpose of a rule within a lifecycle policy.
        """
        selection: NotRequired['GetLifecyclePolicyDocumentRuleSelectionArgsDict']
        """
        Collects parameters describing the selection criteria for the ECR lifecycle policy:
        """
elif False:
    GetLifecyclePolicyDocumentRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetLifecyclePolicyDocumentRuleArgs:
    def __init__(__self__, *,
                 priority: _builtins.int,
                 action: Optional['GetLifecyclePolicyDocumentRuleActionArgs'] = None,
                 description: Optional[_builtins.str] = None,
                 selection: Optional['GetLifecyclePolicyDocumentRuleSelectionArgs'] = None):
        """
        :param _builtins.int priority: Sets the order in which rules are evaluated, lowest to highest. When you add rules to a lifecycle policy, you must give them each a unique value for `priority`. Values do not need to be sequential across rules in a policy. A rule with a `tag_status` value of "any" must have the highest value for `priority` and be evaluated last.
        :param 'GetLifecyclePolicyDocumentRuleActionArgs' action: Specifies the action type.
        :param _builtins.str description: Describes the purpose of a rule within a lifecycle policy.
        :param 'GetLifecyclePolicyDocumentRuleSelectionArgs' selection: Collects parameters describing the selection criteria for the ECR lifecycle policy:
        """
        pulumi.set(__self__, "priority", priority)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if selection is not None:
            pulumi.set(__self__, "selection", selection)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Sets the order in which rules are evaluated, lowest to highest. When you add rules to a lifecycle policy, you must give them each a unique value for `priority`. Values do not need to be sequential across rules in a policy. A rule with a `tag_status` value of "any" must have the highest value for `priority` and be evaluated last.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: _builtins.int):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional['GetLifecyclePolicyDocumentRuleActionArgs']:
        """
        Specifies the action type.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional['GetLifecyclePolicyDocumentRuleActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Describes the purpose of a rule within a lifecycle policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def selection(self) -> Optional['GetLifecyclePolicyDocumentRuleSelectionArgs']:
        """
        Collects parameters describing the selection criteria for the ECR lifecycle policy:
        """
        return pulumi.get(self, "selection")

    @selection.setter
    def selection(self, value: Optional['GetLifecyclePolicyDocumentRuleSelectionArgs']):
        pulumi.set(self, "selection", value)


if not MYPY:
    class GetLifecyclePolicyDocumentRuleActionArgsDict(TypedDict):
        type: _builtins.str
        """
        The supported value is `expire`.
        """
elif False:
    GetLifecyclePolicyDocumentRuleActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetLifecyclePolicyDocumentRuleActionArgs:
    def __init__(__self__, *,
                 type: _builtins.str):
        """
        :param _builtins.str type: The supported value is `expire`.
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The supported value is `expire`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: _builtins.str):
        pulumi.set(self, "type", value)


if not MYPY:
    class GetLifecyclePolicyDocumentRuleSelectionArgsDict(TypedDict):
        count_number: _builtins.int
        """
        Specify a count number. If the `count_type` used is "imageCountMoreThan", then the value is the maximum number of images that you want to retain in your repository. If the `count_type` used is "sinceImagePushed", then the value is the maximum age limit for your images.
        """
        count_type: _builtins.str
        """
        Specify a count type to apply to the images. If `count_type` is set to "imageCountMoreThan", you also specify `count_number` to create a rule that sets a limit on the number of images that exist in your repository. If `count_type` is set to "sinceImagePushed", you also specify `count_unit` and `count_number` to specify a time limit on the images that exist in your repository.
        """
        tag_status: _builtins.str
        """
        Determines whether the lifecycle policy rule that you are adding specifies a tag for an image. Acceptable options are "tagged", "untagged", or "any". If you specify "any", then all images have the rule applied to them. If you specify "tagged", then you must also specify a `tag_prefix_list` value. If you specify "untagged", then you must omit `tag_prefix_list`.
        """
        count_unit: NotRequired[_builtins.str]
        """
        Specify a count unit of days to indicate that as the unit of time, in addition to `count_number`, which is the number of days.
        """
        tag_pattern_lists: NotRequired[Sequence[_builtins.str]]
        """
        You must specify a comma-separated list of image tag patterns that may contain wildcards (\\*) on which to take action with your lifecycle policy. For example, if your images are tagged as `prod`, `prod1`, `prod2`, and so on, you would use the tag pattern list `["prod\\*"]` to specify all of them. If you specify multiple tags, only the images with all specified tags are selected. There is a maximum limit of four wildcards (\\*) per string. For example, `["*test*1*2*3", "test*1*2*3*"]` is valid but `["test*1*2*3*4*5*6"]` is invalid.
        """
        tag_prefix_lists: NotRequired[Sequence[_builtins.str]]
        """
        You must specify a comma-separated list of image tag prefixes on which to take action with your lifecycle policy. For example, if your images are tagged as `prod`, `prod1`, `prod2`, and so on, you would use the tag prefix "prod" to specify all of them. If you specify multiple tags, only images with all specified tags are selected.
        """
elif False:
    GetLifecyclePolicyDocumentRuleSelectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetLifecyclePolicyDocumentRuleSelectionArgs:
    def __init__(__self__, *,
                 count_number: _builtins.int,
                 count_type: _builtins.str,
                 tag_status: _builtins.str,
                 count_unit: Optional[_builtins.str] = None,
                 tag_pattern_lists: Optional[Sequence[_builtins.str]] = None,
                 tag_prefix_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int count_number: Specify a count number. If the `count_type` used is "imageCountMoreThan", then the value is the maximum number of images that you want to retain in your repository. If the `count_type` used is "sinceImagePushed", then the value is the maximum age limit for your images.
        :param _builtins.str count_type: Specify a count type to apply to the images. If `count_type` is set to "imageCountMoreThan", you also specify `count_number` to create a rule that sets a limit on the number of images that exist in your repository. If `count_type` is set to "sinceImagePushed", you also specify `count_unit` and `count_number` to specify a time limit on the images that exist in your repository.
        :param _builtins.str tag_status: Determines whether the lifecycle policy rule that you are adding specifies a tag for an image. Acceptable options are "tagged", "untagged", or "any". If you specify "any", then all images have the rule applied to them. If you specify "tagged", then you must also specify a `tag_prefix_list` value. If you specify "untagged", then you must omit `tag_prefix_list`.
        :param _builtins.str count_unit: Specify a count unit of days to indicate that as the unit of time, in addition to `count_number`, which is the number of days.
        :param Sequence[_builtins.str] tag_pattern_lists: You must specify a comma-separated list of image tag patterns that may contain wildcards (\\*) on which to take action with your lifecycle policy. For example, if your images are tagged as `prod`, `prod1`, `prod2`, and so on, you would use the tag pattern list `["prod\\*"]` to specify all of them. If you specify multiple tags, only the images with all specified tags are selected. There is a maximum limit of four wildcards (\\*) per string. For example, `["*test*1*2*3", "test*1*2*3*"]` is valid but `["test*1*2*3*4*5*6"]` is invalid.
        :param Sequence[_builtins.str] tag_prefix_lists: You must specify a comma-separated list of image tag prefixes on which to take action with your lifecycle policy. For example, if your images are tagged as `prod`, `prod1`, `prod2`, and so on, you would use the tag prefix "prod" to specify all of them. If you specify multiple tags, only images with all specified tags are selected.
        """
        pulumi.set(__self__, "count_number", count_number)
        pulumi.set(__self__, "count_type", count_type)
        pulumi.set(__self__, "tag_status", tag_status)
        if count_unit is not None:
            pulumi.set(__self__, "count_unit", count_unit)
        if tag_pattern_lists is not None:
            pulumi.set(__self__, "tag_pattern_lists", tag_pattern_lists)
        if tag_prefix_lists is not None:
            pulumi.set(__self__, "tag_prefix_lists", tag_prefix_lists)

    @_builtins.property
    @pulumi.getter(name="countNumber")
    def count_number(self) -> _builtins.int:
        """
        Specify a count number. If the `count_type` used is "imageCountMoreThan", then the value is the maximum number of images that you want to retain in your repository. If the `count_type` used is "sinceImagePushed", then the value is the maximum age limit for your images.
        """
        return pulumi.get(self, "count_number")

    @count_number.setter
    def count_number(self, value: _builtins.int):
        pulumi.set(self, "count_number", value)

    @_builtins.property
    @pulumi.getter(name="countType")
    def count_type(self) -> _builtins.str:
        """
        Specify a count type to apply to the images. If `count_type` is set to "imageCountMoreThan", you also specify `count_number` to create a rule that sets a limit on the number of images that exist in your repository. If `count_type` is set to "sinceImagePushed", you also specify `count_unit` and `count_number` to specify a time limit on the images that exist in your repository.
        """
        return pulumi.get(self, "count_type")

    @count_type.setter
    def count_type(self, value: _builtins.str):
        pulumi.set(self, "count_type", value)

    @_builtins.property
    @pulumi.getter(name="tagStatus")
    def tag_status(self) -> _builtins.str:
        """
        Determines whether the lifecycle policy rule that you are adding specifies a tag for an image. Acceptable options are "tagged", "untagged", or "any". If you specify "any", then all images have the rule applied to them. If you specify "tagged", then you must also specify a `tag_prefix_list` value. If you specify "untagged", then you must omit `tag_prefix_list`.
        """
        return pulumi.get(self, "tag_status")

    @tag_status.setter
    def tag_status(self, value: _builtins.str):
        pulumi.set(self, "tag_status", value)

    @_builtins.property
    @pulumi.getter(name="countUnit")
    def count_unit(self) -> Optional[_builtins.str]:
        """
        Specify a count unit of days to indicate that as the unit of time, in addition to `count_number`, which is the number of days.
        """
        return pulumi.get(self, "count_unit")

    @count_unit.setter
    def count_unit(self, value: Optional[_builtins.str]):
        pulumi.set(self, "count_unit", value)

    @_builtins.property
    @pulumi.getter(name="tagPatternLists")
    def tag_pattern_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        You must specify a comma-separated list of image tag patterns that may contain wildcards (\\*) on which to take action with your lifecycle policy. For example, if your images are tagged as `prod`, `prod1`, `prod2`, and so on, you would use the tag pattern list `["prod\\*"]` to specify all of them. If you specify multiple tags, only the images with all specified tags are selected. There is a maximum limit of four wildcards (\\*) per string. For example, `["*test*1*2*3", "test*1*2*3*"]` is valid but `["test*1*2*3*4*5*6"]` is invalid.
        """
        return pulumi.get(self, "tag_pattern_lists")

    @tag_pattern_lists.setter
    def tag_pattern_lists(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "tag_pattern_lists", value)

    @_builtins.property
    @pulumi.getter(name="tagPrefixLists")
    def tag_prefix_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        You must specify a comma-separated list of image tag prefixes on which to take action with your lifecycle policy. For example, if your images are tagged as `prod`, `prod1`, `prod2`, and so on, you would use the tag prefix "prod" to specify all of them. If you specify multiple tags, only images with all specified tags are selected.
        """
        return pulumi.get(self, "tag_prefix_lists")

    @tag_prefix_lists.setter
    def tag_prefix_lists(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "tag_prefix_lists", value)


