# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPullThroughCacheRuleResult',
    'AwaitableGetPullThroughCacheRuleResult',
    'get_pull_through_cache_rule',
    'get_pull_through_cache_rule_output',
]

@pulumi.output_type
class GetPullThroughCacheRuleResult:
    """
    A collection of values returned by getPullThroughCacheRule.
    """
    def __init__(__self__, credential_arn=None, custom_role_arn=None, ecr_repository_prefix=None, id=None, region=None, registry_id=None, upstream_registry_url=None, upstream_repository_prefix=None):
        if credential_arn and not isinstance(credential_arn, str):
            raise TypeError("Expected argument 'credential_arn' to be a str")
        pulumi.set(__self__, "credential_arn", credential_arn)
        if custom_role_arn and not isinstance(custom_role_arn, str):
            raise TypeError("Expected argument 'custom_role_arn' to be a str")
        pulumi.set(__self__, "custom_role_arn", custom_role_arn)
        if ecr_repository_prefix and not isinstance(ecr_repository_prefix, str):
            raise TypeError("Expected argument 'ecr_repository_prefix' to be a str")
        pulumi.set(__self__, "ecr_repository_prefix", ecr_repository_prefix)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if upstream_registry_url and not isinstance(upstream_registry_url, str):
            raise TypeError("Expected argument 'upstream_registry_url' to be a str")
        pulumi.set(__self__, "upstream_registry_url", upstream_registry_url)
        if upstream_repository_prefix and not isinstance(upstream_repository_prefix, str):
            raise TypeError("Expected argument 'upstream_repository_prefix' to be a str")
        pulumi.set(__self__, "upstream_repository_prefix", upstream_repository_prefix)

    @_builtins.property
    @pulumi.getter(name="credentialArn")
    def credential_arn(self) -> _builtins.str:
        """
        ARN of the Secret which will be used to authenticate against the registry.
        """
        return pulumi.get(self, "credential_arn")

    @_builtins.property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> _builtins.str:
        """
        The ARN of the IAM role associated with the pull through cache rule. Used if the upstream registry is a cross-account ECR private registry.
        """
        return pulumi.get(self, "custom_role_arn")

    @_builtins.property
    @pulumi.getter(name="ecrRepositoryPrefix")
    def ecr_repository_prefix(self) -> _builtins.str:
        return pulumi.get(self, "ecr_repository_prefix")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> _builtins.str:
        """
        The registry ID where the repository was created.
        """
        return pulumi.get(self, "registry_id")

    @_builtins.property
    @pulumi.getter(name="upstreamRegistryUrl")
    def upstream_registry_url(self) -> _builtins.str:
        """
        The registry URL of the upstream registry to use as the source.
        """
        return pulumi.get(self, "upstream_registry_url")

    @_builtins.property
    @pulumi.getter(name="upstreamRepositoryPrefix")
    def upstream_repository_prefix(self) -> _builtins.str:
        """
        The upstream repository prefix associated with the pull through cache rule.
        """
        return pulumi.get(self, "upstream_repository_prefix")


class AwaitableGetPullThroughCacheRuleResult(GetPullThroughCacheRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPullThroughCacheRuleResult(
            credential_arn=self.credential_arn,
            custom_role_arn=self.custom_role_arn,
            ecr_repository_prefix=self.ecr_repository_prefix,
            id=self.id,
            region=self.region,
            registry_id=self.registry_id,
            upstream_registry_url=self.upstream_registry_url,
            upstream_repository_prefix=self.upstream_repository_prefix)


def get_pull_through_cache_rule(ecr_repository_prefix: Optional[_builtins.str] = None,
                                region: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPullThroughCacheRuleResult:
    """
    The ECR Pull Through Cache Rule data source allows the upstream registry URL and registry ID to be retrieved for a Pull Through Cache Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ecr_public = aws.ecr.get_pull_through_cache_rule(ecr_repository_prefix="ecr-public")
    ```


    :param _builtins.str ecr_repository_prefix: The repository name prefix to use when caching images from the source registry.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['ecrRepositoryPrefix'] = ecr_repository_prefix
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ecr/getPullThroughCacheRule:getPullThroughCacheRule', __args__, opts=opts, typ=GetPullThroughCacheRuleResult).value

    return AwaitableGetPullThroughCacheRuleResult(
        credential_arn=pulumi.get(__ret__, 'credential_arn'),
        custom_role_arn=pulumi.get(__ret__, 'custom_role_arn'),
        ecr_repository_prefix=pulumi.get(__ret__, 'ecr_repository_prefix'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        upstream_registry_url=pulumi.get(__ret__, 'upstream_registry_url'),
        upstream_repository_prefix=pulumi.get(__ret__, 'upstream_repository_prefix'))
def get_pull_through_cache_rule_output(ecr_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPullThroughCacheRuleResult]:
    """
    The ECR Pull Through Cache Rule data source allows the upstream registry URL and registry ID to be retrieved for a Pull Through Cache Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ecr_public = aws.ecr.get_pull_through_cache_rule(ecr_repository_prefix="ecr-public")
    ```


    :param _builtins.str ecr_repository_prefix: The repository name prefix to use when caching images from the source registry.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['ecrRepositoryPrefix'] = ecr_repository_prefix
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ecr/getPullThroughCacheRule:getPullThroughCacheRule', __args__, opts=opts, typ=GetPullThroughCacheRuleResult)
    return __ret__.apply(lambda __response__: GetPullThroughCacheRuleResult(
        credential_arn=pulumi.get(__response__, 'credential_arn'),
        custom_role_arn=pulumi.get(__response__, 'custom_role_arn'),
        ecr_repository_prefix=pulumi.get(__response__, 'ecr_repository_prefix'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        upstream_registry_url=pulumi.get(__response__, 'upstream_registry_url'),
        upstream_repository_prefix=pulumi.get(__response__, 'upstream_repository_prefix')))
